/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.app.data;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.ApplicationObject;
import com.sygate.scm.console.logicobject.LearnedApplicationObject;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;

public class AppTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private final String[] columnNames = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AppTableModel.label.name"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AppTableModel.label.description"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AppTableModel.label.size"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AppTableModel.label.lastModified"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AppTableModel.label.checksum")};
    private static final int FILE_NAME = 0;
    private static final int FILE_DESCRIPTION = 1;
    private static final int SIZE = 2;
    private static final int LAST_MODIFIED = 3;
    private static final int CHECKSUM = 4;
    private static final int CHECKSUM_SHA2 = 5;
    private ArrayList<ApplicationObject> rowList = null;

    public AppTableModel(ArrayList<ApplicationObject> rowList) {
        this.rowList = rowList;
    }

    public AppTableModel(ApplicationObject[] objArray) {
        this.rowList = new ArrayList<ApplicationObject>(Arrays.asList(objArray));
    }

    @Override
    public int getRowCount() {
        return this.rowList != null ? this.rowList.size() : 0;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ApplicationObject appObj = this.rowList != null && this.rowList.size() > rowIndex ? this.rowList.get(rowIndex) : null;
        return appObj != null ? this.getObjectAt(appObj, columnIndex) : "";
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public Object getObjectAt(ApplicationObject appObj, int col) {
        String value = "";
        switch (col) {
            case 0: {
                value = appObj.getFileName();
                break;
            }
            case 1: {
                value = appObj.getFileDescription();
                break;
            }
            case 2: {
                long size = appObj.getSize();
                value = size >= 0L ? String.valueOf(size) : "";
                break;
            }
            case 3: {
                value = appObj.getModifyDate();
                break;
            }
            case 4: {
                value = appObj.getMd5Checksum();
                break;
            }
            case 5: {
                value = appObj.getSHA2Checksum();
                break;
            }
        }
        return value;
    }

    public void addAppObject(ApplicationObject appObj) {
        this.rowList.add(appObj);
        this.fireTableRowsInserted(this.rowList.size(), this.rowList.size());
    }

    public void deleteApplicationObjectAtRow(int row) {
        this.rowList.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void updateApplicationObjectAtRow(int row) {
        this.fireTableRowsUpdated(row, row);
    }

    public ApplicationObject getApplicationObjectAt(int row) {
        ApplicationObject appObj = null;
        if (row < this.getRowCount()) {
            appObj = this.rowList.get(row);
        }
        return appObj;
    }

    public void addLearnedApplications(LearnedApplicationObject[] allApps) {
        for (int i = 0; i < allApps.length; ++i) {
            ApplicationObject appObj = new ApplicationObject();
            appObj.setFileName(allApps[i].getValueAt(0).toString());
            appObj.setFileDescription(allApps[i].getValueAt(2).toString());
            Long sz = (Long)allApps[i].getValueAt(4);
            appObj.setSize(sz);
            appObj.setModifyDate(allApps[i].getValueAt(5).toString());
            appObj.setMd5Checksum(allApps[i].getValueAt(6).toString());
            appObj.setSHA2Checksum(allApps[i].getValueAt(7).toString());
            this.addAppObject(appObj);
        }
    }

    public ApplicationObject[] getAllApplications() {
        return this.rowList != null ? this.rowList.toArray(new ApplicationObject[this.rowList.size()]) : null;
    }
}

