/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.app;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.ExcludedAppArray;
import com.sygate.scm.common.configobject.schema.Executable;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AppAuthenticationObject;
import com.sygate.scm.console.logicobject.ApplicationObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.policy.explorer.app.AllowingAppPanel;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class AllowingAppHandler {
    private static AllowingAppPanel appPanel = null;
    private static AllowingAppHandler instance = null;

    private AllowingAppHandler() {
    }

    public static AllowingAppHandler getInstance() {
        if (null == instance) {
            instance = new AllowingAppHandler();
        }
        return instance;
    }

    public static JPanel getComponent(TreeItem treeItem) {
        if (treeItem.getItemType() == 59 && appPanel == null) {
            appPanel = new AllowingAppPanel();
        }
        return appPanel;
    }

    public void applyAllowingList(TreeModel treeModel, ApplicationObject[] appArray, int type) {
        GroupObject[] grpObjects = this.getApplyGroupList(treeModel);
        if (null == appArray || null == grpObjects) {
            return;
        }
        try {
            for (int i = 0; i < grpObjects.length; ++i) {
                GroupPolicyObject groupPolicyObj = PolicyHandler.getGroupPolicyByGroup(grpObjects[i]);
                GroupPolicyObject newObj = groupPolicyObj.getClone();
                AppAuthenticationObject authObj = newObj.getAppAuthenticationObject();
                if (type == 0) {
                    this.addApplications(authObj, appArray);
                } else if (type == 1) {
                    this.deleteApplications(authObj, appArray);
                }
                groupPolicyObj.setAppAuthentication(authObj);
                PolicyHandler.updateGroupPolicy(groupPolicyObj);
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AllowingAppHandler.consoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void addApplications(AppAuthenticationObject authObj, ApplicationObject[] appArray) {
        boolean exists = false;
        for (int i = 0; i < appArray.length; ++i) {
            exists = false;
            ExcludedAppArray array = authObj.getAppAuthenticationProtection().getExcludedAppArray();
            Executable executable = appArray[i].getExecutable();
            for (Executable exe : array.getExecutable()) {
                if (!this.compareExecs(executable, exe)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            authObj.addApplication(appArray[i]);
        }
    }

    private void deleteApplications(AppAuthenticationObject appAuth, ApplicationObject[] appArray) {
        ExcludedAppArray array = appAuth.getAppAuthenticationProtection().getExcludedAppArray();
        for (int i = 0; i < appArray.length; ++i) {
            Executable executable = appArray[i].getExecutable();
            for (Executable exe : array.getExecutable()) {
                if (!this.compareExecs(executable, exe)) continue;
                exe.getParent().removeChild((AbstractSchema)exe);
            }
        }
    }

    private boolean compareExecs(Executable executable1, Executable executable2) {
        return this.compareFileNames(executable1, executable2) && this.compareFileDescription(executable1, executable2) && this.compareVersions(executable1, executable2) && this.compareSize(executable1, executable2) && this.compareLastModifyDate(executable1, executable2) && this.compareChecksum(executable1, executable2);
    }

    private boolean compareFileNames(Executable executable1, Executable executable2) {
        String fileName1 = executable1.getOptFileName();
        String fileName2 = executable2.getOptFileName();
        boolean condition = fileName1 == null && fileName2 == null || fileName1 != null && fileName2 != null && fileName1.equals(fileName2);
        return condition;
    }

    private boolean compareFileDescription(Executable executable1, Executable executable2) {
        String fileDscr1 = executable1.getOptFileDescription();
        String fileDscr2 = executable2.getOptFileDescription();
        boolean condition = fileDscr1 == null && fileDscr2 == null || fileDscr1 != null && fileDscr2 != null && fileDscr1.equals(fileDscr2);
        return condition;
    }

    private boolean compareVersions(Executable executable1, Executable executable2) {
        String version1 = executable1.getOptVersion();
        String version2 = executable2.getOptVersion();
        boolean condition = version1 == null && version2 == null || version1 != null && version2 != null && version1.equals(version2);
        return condition;
    }

    private boolean compareSize(Executable executable1, Executable executable2) {
        Long sz1 = executable1.getOptFileSize();
        Long sz2 = executable2.getOptFileSize();
        boolean condition = sz1 == null && sz2 == null || sz1 != null && sz2 != null && sz1.equals(sz2);
        return condition;
    }

    private boolean compareLastModifyDate(Executable executable1, Executable executable2) {
        String dt1 = executable1.getOptFileLastModifiedDate();
        String dt2 = executable2.getOptFileLastModifiedDate();
        boolean condition = dt1 == null && dt2 == null || dt1 != null && dt2 != null && dt1.equals(dt2);
        return condition;
    }

    private boolean compareChecksum(Executable executable1, Executable executable2) {
        String chksum1 = executable1.getOptFileMd5Checksum();
        String chksum2 = executable2.getOptFileMd5Checksum();
        boolean condition = chksum1 == null && chksum2 == null || chksum1 != null && chksum2 != null && chksum1.equals(chksum2);
        return condition;
    }

    private GroupObject[] getApplyGroupList(TreeModel model) {
        HashMap<String, GroupObject> grpMap = new HashMap<String, GroupObject>();
        GroupObject[] grpArray = null;
        try {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)((DefaultTreeModel)model).getRoot();
            if (parentNode == null) {
                return grpArray;
            }
            Enumeration nodeEnumeration = (Enumeration)Cast.cast(parentNode.breadthFirstEnumeration());
            DefaultMutableTreeNode node = null;
            while (nodeEnumeration.hasMoreElements()) {
                GroupObject grpObj;
                node = (DefaultMutableTreeNode)nodeEnumeration.nextElement();
                Object userObj = node.getUserObject();
                if (!(userObj instanceof GroupObject) || !(grpObj = (GroupObject)userObj).isSelected() || grpMap.containsKey(grpObj.getId())) continue;
                grpMap.put(grpObj.getId(), grpObj);
            }
            grpArray = grpMap.values().toArray(new GroupObject[grpMap.size()]);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return grpArray;
    }
}

