/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.adaptive;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.AdaptivePolicy;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.adaptive.AdaptivePolicyDialog;
import com.sygate.scm.console.ui.policy.adaptive.logicobject.AdaptivePolicyObject;
import com.sygate.scm.console.ui.policy.adaptive.logicobject.AdaptivePolicyPoolObject;
import com.sygate.scm.console.ui.policy.explorer.adaptive.AdaptivePolicyPoolPane;
import com.sygate.scm.console.ui.policy.explorer.common.BasePolicyHandler;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import java.util.Arrays;
import java.util.List;

public class AdaptivePolicyHandler
extends BasePolicyHandler {
    private static AdaptivePolicyHandler handler;

    private AdaptivePolicyHandler() {
        this.policyPoolPane = new AdaptivePolicyPoolPane();
    }

    public static synchronized AdaptivePolicyHandler getInstance() {
        if (handler == null) {
            handler = new AdaptivePolicyHandler();
        }
        return handler;
    }

    public static synchronized void clearInstance() {
        handler = null;
    }

    @Override
    public boolean hasLicense(boolean justCheckLicense) {
        return true;
    }

    @Override
    protected BasePolicyDialog getNewPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return new AdaptivePolicyDialog(pool);
    }

    @Override
    protected BasePolicyDialog getEditPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return new AdaptivePolicyDialog(pool, true);
    }

    @Override
    protected List<Class<? extends PolicyObjectBase>> getPolicyObjectClass() {
        return Arrays.asList(AdaptivePolicyObject.class);
    }

    @Override
    protected int getPolicyNameLength() {
        return 512;
    }

    @Override
    protected boolean isCorrectPolicyType(PolicyObjectBase policyObj) {
        return policyObj instanceof AdaptivePolicyObject;
    }

    @Override
    protected String getApplyPolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AdaptivePolicyHandler.applyPolicy");
    }

    @Override
    protected String getReplacePolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AdaptivePolicyHandler.replacePolicy");
    }

    @Override
    protected String getReplacePolicyMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AdaptivePolicyHandler.thisIsTheOnlyPolicyIn");
    }

    @Override
    protected String getWithdrawPolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AdaptivePolicyHandler.withdrawPolicy");
    }

    @Override
    protected String getImportFailMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AdaptivePolicyHandler.failedToImportThePolicy");
    }

    @Override
    protected PolicyObjectBase createPolicyObject(ConfigObject obj) {
        if (obj instanceof AdaptivePolicy) {
            return new AdaptivePolicyObject((TopLevelObject)((AdaptivePolicy)obj));
        }
        return null;
    }

    @Override
    protected PolicyObjectBase getPolicyObject(ObjInfoObject infoObj) throws ConsoleException {
        return new AdaptivePolicyObject((TopLevelObject)DataobjectManager.getInstance().getAdaptivePolicy(infoObj.getId()));
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject() throws ConsoleException {
        return AdaptivePolicyPoolObject.getPolicyPool();
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject(SemDomain domain) throws ConsoleException {
        return new AdaptivePolicyPoolObject(domain);
    }

    @Override
    protected String getPolicyPoolPaneTitle(String name) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AdaptivePolicyPoolPane.title.adaptivePolicies");
    }
}

