/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.adapter;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.FwInterfaceContainer;
import com.sygate.scm.common.configobject.schema.FwNetworkInterface;
import com.sygate.scm.common.configobject.schema.FwNetworkInterfaceGroup;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.common.util.ConfigObjectUtils;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.NetworkAdapterHandler;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.explorer.common.NonAppliablePolicyPanelBase;
import com.sygate.scm.console.ui.policy.explorer.common.PolicyApplyHelper;
import com.sygate.scm.console.ui.policy.firewall.NetworkInterfaceHandler;
import com.sygate.scm.console.ui.policy.firewall.dialog.CustomAdapterDialog;
import com.sygate.scm.console.ui.policy.firewall.logicobject.FwNetworkInterfaceObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.NetworkInterfaceGroupObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.HTMLUtilities;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JOptionPane;

public class NetworkAdapterPoolPanel
extends NonAppliablePolicyPanelBase {
    private static final long serialVersionUID = 1L;
    private static final String[] TABLE_COLUMN_NAME = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NetworkAdapterPoolPanel.adapterName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NetworkAdapterPoolPanel.networkInterfaceIndentification")};
    private static final int[] TABLE_COLUMN_MAP = new int[]{1, 2};
    private static final float[] TABLE_COLUMN_WIDTHS = new float[]{0.5f, 0.5f};
    private static String[] str = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NetworkAdapterPoolPanel..html.networkAdapters"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NetworkAdapterPoolPanel..html.aListOfNetworkAdapterIsStored")};
    private static final String TITLE_DESCRIPTION = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><HTML>  <HEAD>    <style type=\"text/css\">" + HTMLUtilities.getStyleSheet() + "    </style>  </HEAD>  <BODY>      <P class=\"headline\">" + str[0] + "      </P>      <TABLE width=100% border='0' cellspacing='1' align='left' valign='top'>        <TR>\t         <TD>" + str[1] + "          </TD>        </TR>      </TABLE>  </BODY></HTML>";

    public NetworkAdapterPoolPanel() {
        this.initialize();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_pane_policy_components";
    }

    @Override
    protected void refreshModel(SortableTableModel model) throws ConsoleException {
        ArrayList<NetworkInterfaceGroupObject> adaptersPool = NetworkAdapterHandler.getAdaptersPool();
        model.setDataVector(new Vector<TableRow>((Collection)Cast.cast(adaptersPool)));
        model.fireTableDataChanged();
    }

    @Override
    protected String getHTMLName() {
        return "networkadapters_temp.htm";
    }

    @Override
    protected String getTitleAndDescription() {
        return TITLE_DESCRIPTION;
    }

    @Override
    protected String[] getTableColumnName() {
        return TABLE_COLUMN_NAME;
    }

    @Override
    protected int[] getTableColumnMapping() {
        return TABLE_COLUMN_MAP;
    }

    @Override
    protected float[] getTableColumnWidths() {
        return TABLE_COLUMN_WIDTHS;
    }

    @Override
    protected int getItemType() {
        return this.isActionEnabled() ? 132 : 100;
    }

    @Override
    protected boolean isActionEnabled() {
        int selIndex = this.jTTable.getSelectedRow();
        if (selIndex == -1) {
            return false;
        }
        SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
        return !((NetworkInterfaceGroupObject)model.getRow(selIndex)).isSystemObject();
    }

    @Override
    protected void doAdd() {
        FwNetworkInterfaceObject netObj = new FwNetworkInterfaceObject();
        netObj.setInclude(true);
        CustomAdapterDialog dlg = new CustomAdapterDialog(netObj, this.formNameArray(), true);
        try {
            if (dlg.isOk()) {
                netObj = dlg.getNetworkInterfaceObject();
                FwNetworkInterfaceGroup adapterGroup = new FwNetworkInterfaceGroup();
                FwInterfaceContainer adapterContainer = new FwInterfaceContainer();
                adapterContainer.addFwNetworkInterface(netObj.getFwNetworkInterface());
                adapterGroup.setFwInterfaceContainer(adapterContainer);
                adapterGroup.setId(new GUIDGenerator().getGUIDString());
                adapterGroup.setName(netObj.getOptName());
                NetworkInterfaceGroupObject adapterGroupObj = new NetworkInterfaceGroupObject(adapterGroup);
                adapterGroupObj.setDescription(netObj.getOptNetworkInterfaceDescString());
                NetworkInterfaceHandler.getInstance().addGroup(adapterGroupObj);
                NetworkInterfaceHandler.getInstance().saveGroups();
                String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NetworkAdapterPoolPanel.Add.Description");
                Object[] obj = new Object[]{adapterGroup.getName()};
                desc = MessageFormat.format(desc, obj);
                ConsoleLogger.logPolicyEvent(0, adapterGroup.getId(), desc, null);
            }
            dlg.dispose();
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NetworkAdapterPoolPanel.saveFailed"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    @Override
    protected void doEdit() {
        if (!this.isActionEnabled()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NetworkAdapterPoolPanel.cantEditNetworkAdapter"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NetworkAdapterPoolPanel.editNetworkAdapter"), -1);
            return;
        }
        SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
        NetworkInterfaceGroupObject naObj = (NetworkInterfaceGroupObject)model.getRow(this.jTTable.getSelectedRow());
        if (naObj == null || naObj.getFwInterfaceGroup() == null || naObj.getFwInterfaceGroup().getFwInterfaceContainer() == null || naObj.getFwInterfaceGroup().getFwInterfaceContainer().getFwNetworkInterface(0) == null) {
            return;
        }
        FwInterfaceContainer interfaceCon = naObj.getFwInterfaceGroup().getFwInterfaceContainer();
        FwNetworkInterface oldNetInterface = naObj.getFwInterfaceGroup().getFwInterfaceContainer().getFwNetworkInterface(0);
        try {
            FwNetworkInterfaceObject netObj = new FwNetworkInterfaceObject((FwNetworkInterface)PolicyHandler.getCopyOfObj((ConfigObject)oldNetInterface));
            netObj.setOptName(naObj.getName());
            CustomAdapterDialog dlg = new CustomAdapterDialog(netObj, this.formNameArray(), true, true);
            if (dlg.isOk()) {
                String newName;
                netObj = dlg.getNetworkInterfaceObject();
                String oldName = naObj.getName();
                if (!oldName.equals(newName = netObj.getOptName()) || !ConfigObjectUtils.isEqualObj((Object)netObj.getFwNetworkInterface(), (Object)oldNetInterface)) {
                    naObj.setName(newName);
                    interfaceCon.setFwNetworkInterface(0, netObj.getFwNetworkInterface());
                    NetworkInterfaceHandler.getInstance().saveGroups();
                    String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NetworkAdapterPoolPanel.Edit.Description");
                    Object[] obj = new Object[]{naObj.getName()};
                    desc = MessageFormat.format(desc, obj);
                    ConsoleLogger.logPolicyEvent(2, naObj.getId(), desc, null);
                }
            }
            dlg.dispose();
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NetworkAdapterPoolPanel.saveFailed"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    @Override
    protected void doDelete() {
        if (!this.isActionEnabled()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NetworkAdapterPoolPanel.cantDeleteNetworkAdapter"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NetworkAdapterPoolPanel.deleteAdapter"), -1);
            return;
        }
        int ret = UIUtilities.confirmYesNoOptionDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NetworkAdapterPoolPanel.youAreAboutToDeleteOneAdapter"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NetworkAdapterPoolPanel.deleteAdapter"));
        if (ret != 0) {
            return;
        }
        SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
        NetworkInterfaceGroupObject naObj = (NetworkInterfaceGroupObject)model.getRow(this.jTTable.getSelectedRow());
        if (PolicyApplyHelper.isNetworkAdapterInUse(naObj)) {
            return;
        }
        try {
            NetworkInterfaceHandler.getInstance().deleteGroup(naObj);
            NetworkInterfaceHandler.getInstance().saveGroups();
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NetworkAdapterPoolPanel.Delete.Description");
            Object[] obj = new Object[]{naObj.getName()};
            desc = MessageFormat.format(desc, obj);
            ConsoleLogger.logPolicyEvent(1, naObj.getId(), desc, null);
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.frame, ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NetworkAdapterPoolPanel.saveFailed"), 0);
            Manager.frame.showLoginPanel();
        }
    }

    @Override
    protected String getPolicyTypeName() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NetworkAdapterPoolPanel.title");
    }

    private ArrayList<String> formNameArray() {
        ArrayList<String> nameArr = new ArrayList<String>();
        for (int i = 0; i < this.jTTable.getRowCount(); ++i) {
            nameArr.add(((String)this.jTTable.getValueAt(i, 0)).trim());
        }
        return nameArr;
    }

    @Override
    protected void retrieveTableSelection(TableRow selectedRow) {
        if (selectedRow == null) {
            return;
        }
        NetworkInterfaceGroupObject selAdapter = (NetworkInterfaceGroupObject)selectedRow;
        SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            NetworkInterfaceGroupObject adapter = (NetworkInterfaceGroupObject)model.getRow(i);
            if (!selAdapter.getFwInterfaceGroup().getId().equals(adapter.getFwInterfaceGroup().getId())) continue;
            this.jTTable.setRowSelectionInterval(i, i);
            break;
        }
    }
}

