/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.schema.NotificationMessage;
import com.sygate.scm.common.configobject.schema.TamperProtection;
import com.sygate.scm.common.configobject.schema.TamperProtectionPolicy;
import com.sygate.scm.common.configobject.schema.TamperProtectionSettings;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.NotificationConverter;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class TamperProtectionPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = -2986880472894834406L;
    private JCheckBox lockEnableTP;
    private JCheckBox enableTP;
    private JCheckBox lockProtectionType;
    private DescriptionTextArea descTextArea;
    private JComboBox<ActionItem> actionList;
    private JCheckBox lockDisplayNotification;
    private JCheckBox enableDisplayNotification;
    private JTextArea notificationMessageControl;
    private TamperProtection tamperProtection;

    TamperProtectionPanel() {
        this.setLayout(new VerticalFlowLayout());
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.insets.top = 10;
        constraints.gridwidth = 3;
        JLabel platformSpecificIndicationMessageLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "TamperProtectionPanel.platformRestrictionLabel"));
        settingsPanel.add((Component)platformSpecificIndicationMessageLabel, constraints);
        constraints.gridy = 1;
        this.lockEnableTP = new JCheckBox(ConsoleMain.unLockIcon);
        this.lockEnableTP.setSelectedIcon(ConsoleMain.lockIcon);
        this.enableTP = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "TamperProtectionPanel.enableTP"));
        settingsPanel.add((Component)this.lockEnableTP, constraints);
        constraints.gridx = 2;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        constraints.weightx = 1.0;
        settingsPanel.add((Component)this.enableTP, constraints);
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.anchor = 18;
        this.lockProtectionType = new JCheckBox(ConsoleMain.unLockIcon);
        this.lockProtectionType.setSelectedIcon(ConsoleMain.lockIcon);
        settingsPanel.add((Component)this.lockProtectionType, constraints);
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        this.descTextArea = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "TamperProtectionPanel.actionDesc"));
        settingsPanel.add((Component)this.descTextArea, constraints);
        constraints.insets.top = 0;
        constraints.fill = 0;
        constraints.gridx = 2;
        constraints.gridy = 3;
        constraints.weightx = 0.0;
        String blockAcion = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "TamperProtectionPanel.actionBlock");
        String logAction = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "TamperProtectionPanel.actionLog");
        String blockWithoutLogAcion = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "TamperProtectionPanel.actionBlockWithoutLog");
        ActionItem blockItem = new ActionItem(blockAcion, TamperProtectionSettings.BLOCK);
        ActionItem logItem = new ActionItem(logAction, TamperProtectionSettings.LOG_ONLY);
        ActionItem blockWithoutLogItem = new ActionItem(blockWithoutLogAcion, TamperProtectionSettings.BLOCK_WITHOUT_LOG);
        this.actionList = new JComboBox<ActionItem>(new ActionItem[]{logItem, blockWithoutLogItem, blockItem});
        ActionItem defaultItem = blockWithoutLogItem;
        TamperProtectionSettings tmp = new TamperProtectionSettings();
        if (tmp.getDefAction().intValue() == logItem.getValue().intValue()) {
            defaultItem = logItem;
        } else if (tmp.getDefAction().intValue() == blockItem.getValue().intValue()) {
            defaultItem = blockItem;
        }
        this.actionList.setSelectedItem(defaultItem);
        settingsPanel.add(this.actionList, constraints);
        constraints.insets.top = 20;
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.insets.right = 0;
        this.lockDisplayNotification = new JCheckBox(ConsoleMain.unLockIcon);
        this.lockDisplayNotification.setSelectedIcon(ConsoleMain.lockIcon);
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        this.enableDisplayNotification = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "TamperProtectionPanel.displayNotification"));
        constraints.gridy = 5;
        constraints.weighty = 1.0;
        constraints.insets.top = 0;
        this.notificationMessageControl = new JTextArea();
        this.notificationMessageControl.setCaretPosition(0);
        JScrollPane notificationScroll = new JScrollPane(this.notificationMessageControl);
        notificationScroll.setPreferredSize(new Dimension(350, 125));
        this.notificationMessageControl.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "TamperProtectionPanel.defaultNotificationMsg"));
        Border outterBorder = BorderFactory.createLineBorder(UIColorUtilities.CONTROL_BACKGROUND);
        Border innerBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        notificationScroll.setBorder(BorderFactory.createCompoundBorder(outterBorder, innerBorder));
        this.enableTP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TamperProtectionPanel.this.updateEnabledState();
            }
        });
        this.enableDisplayNotification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TamperProtectionPanel.this.notificationMessageControl.setEnabled(TamperProtectionPanel.this.enableDisplayNotification.isSelected());
            }
        });
        this.add((Component)settingsPanel, "North");
    }

    void setData(Object newData) {
        if (newData == null) {
            return;
        }
        TamperProtectionPolicy tamperProtectionPolicy = (TamperProtectionPolicy)newData;
        this.tamperProtection = tamperProtectionPolicy.getOptTamperProtection();
        this.refreshData();
    }

    boolean isDataValid() {
        String displayFormat = this.notificationMessageControl.getText().trim();
        if (displayFormat.length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "TamperProtectionPanel.noNotificationMessageFormat"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "TamperProtectionPanel.invalidNotificationDisplayFormat"), 2);
            return false;
        }
        int index = displayFormat.indexOf("~");
        if (index != -1) {
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "TamperProtectionPanel.notificatiobMsgHasAgentPrefix");
            msg = MessageFormat.format(msg, "~");
            JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "TamperProtectionPanel.invalidNotificationDisplayFormat"), 2);
            return false;
        }
        return NotificationConverter.isConvertedAgentMessageLengthValid(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "TamperProtectionPanel.notification.label"), 1, displayFormat, true, this);
    }

    void saveData() {
        this.tamperProtection.setOptLockEnableTP(Boolean.valueOf(this.lockEnableTP.isSelected()));
        this.tamperProtection.setOptEnableTP(Boolean.valueOf(this.enableTP.isSelected()));
        TamperProtectionSettings tamperProtectionSettings = this.tamperProtection.getOptTamperProcessSettings().getOptTamperProtectionSettings();
        tamperProtectionSettings.setOptLockEnabled(Boolean.valueOf(this.lockProtectionType.isSelected()));
        tamperProtectionSettings.setOptAction(((ActionItem)this.actionList.getSelectedItem()).getValue());
        this.tamperProtection.setOptLockDisplayNotificationMessage(Boolean.valueOf(this.lockDisplayNotification.isSelected()));
        this.tamperProtection.setOptDisplayNotificationMessage(Boolean.valueOf(this.enableDisplayNotification.isSelected()));
        String message = this.notificationMessageControl.getText().trim();
        NotificationConverter converter = new NotificationConverter(1);
        message = converter.convertNotificationFormat(0, message);
        this.tamperProtection.getOptNotificationMessage().setOptContent(message);
    }

    boolean isTamperProtectionEnabled() {
        return this.enableTP.isSelected();
    }

    private void refreshData() {
        String content;
        this.lockEnableTP.setSelected(this.tamperProtection.getOptLockEnableTP() != null ? this.tamperProtection.getOptLockEnableTP().booleanValue() : this.tamperProtection.getDefLockEnableTP().booleanValue());
        this.enableTP.setSelected(this.tamperProtection.getOptEnableTP() != null ? this.tamperProtection.getOptEnableTP().booleanValue() : this.tamperProtection.getDefEnableTP().booleanValue());
        TamperProtectionSettings tamperProtectionSettings = this.tamperProtection.getOptTamperProcessSettings().getOptTamperProtectionSettings();
        this.lockProtectionType.setSelected(tamperProtectionSettings.getOptLockEnabled() != null ? tamperProtectionSettings.getOptLockEnabled().booleanValue() : tamperProtectionSettings.getDefLockEnabled().booleanValue());
        int action = tamperProtectionSettings.getOptAction() != null ? tamperProtectionSettings.getOptAction().intValue() : tamperProtectionSettings.getDefAction().intValue();
        for (int i = 0; i < this.actionList.getItemCount(); ++i) {
            ActionItem item = this.actionList.getItemAt(i);
            if (item.getValue() != action) continue;
            this.actionList.setSelectedItem(item);
            break;
        }
        this.lockDisplayNotification.setSelected(this.tamperProtection.getOptLockDisplayNotificationMessage() != null ? this.tamperProtection.getOptLockDisplayNotificationMessage().booleanValue() : this.tamperProtection.getDefLockDisplayNotificationMessage().booleanValue());
        this.enableDisplayNotification.setSelected(this.tamperProtection.getOptDisplayNotificationMessage() != null ? this.tamperProtection.getOptDisplayNotificationMessage().booleanValue() : this.tamperProtection.getDefDisplayNotificationMessage().booleanValue());
        String messageFormat = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "TamperProtectionPanel.defaultNotificationMsg");
        NotificationMessage notificationMessage = this.tamperProtection.getOptNotificationMessage();
        if (notificationMessage != null && (content = notificationMessage.getOptContent()) != null && content.trim().length() != 0) {
            NotificationConverter converter = new NotificationConverter(1);
            messageFormat = converter.convertNotificationFormat(1, content);
        }
        this.notificationMessageControl.setText(messageFormat);
        this.updateEnabledState();
    }

    private void setEnableStatus(boolean enable) {
        this.lockProtectionType.setEnabled(enable);
        this.descTextArea.setEnabled(enable);
        this.actionList.setEnabled(enable);
        this.lockDisplayNotification.setEnabled(enable);
        this.enableDisplayNotification.setEnabled(enable);
        this.notificationMessageControl.setEnabled(enable ? this.enableDisplayNotification.isSelected() : enable);
    }

    private void updateEnabledState() {
        boolean enable = this.enableTP.isSelected() && this.enableTP.isEnabled();
        this.setEnableStatus(enable);
    }

    public void setReadOnly() {
        this.setEnableStatus(false);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_clients_policies_general_setting_tamper_protection";
    }

    static class ActionItem {
        private String label = "";
        private Integer value = null;

        public ActionItem(String label, Integer value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return this.getLabel();
        }
    }
}

