/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.DescriptionTextArea;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.ExternalCommunicationObject;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.dialog.SubmissionOptionsDialog;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.URLUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class SubmissionPanel
extends AvTemplatePane
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private ExternalCommunicationObject extCommObj;
    private JCheckBox enableSubmissionEnabledChk;
    private JCheckBox lockEnableSubmissionChk;
    private JCheckBox enableReputationEnabledChk;
    private JCheckBox lockEnableReputationChk;
    private JCheckBox enableClientDataSubmissionChk;
    private JButton moreButton;
    private final ImageIcon redAlertIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("yellow_alert_24.png")));
    private static final String TITLE = SubmissionPanel.getString("SubmissionPanel.submissionTitle");
    private static final String DESC = SubmissionPanel.getString("SubmissionPanel.submissionDesc");

    public SubmissionPanel() {
        super(TITLE, DESC);
        this.initialize();
    }

    private void initialize() {
        this.lockEnableSubmissionChk = new LockCheckBox(Boolean.FALSE);
        this.lockEnableSubmissionChk.setSelectedIcon(AvConstants.lockIcon);
        this.enableSubmissionEnabledChk = new JCheckBox(SubmissionPanel.getString("SubmissionPanel.submissionsSettings"));
        this.enableSubmissionEnabledChk.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ex) {
                if (ex.getStateChange() == 1) {
                    SubmissionPanel.this.enableSubmissionsOptions(true);
                } else {
                    SubmissionPanel.this.enableSubmissionsOptions(false);
                }
            }
        });
        JLabel submissionBenefitsDesc = new JLabel(this.getHTMLString("SubmissionPanel.submissionsBenefitsDesc"));
        this.moreButton = new JButton(SubmissionPanel.getString("SubmissionPanel.moreOptions"));
        this.moreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                SubmissionOptionsDialog hDialog = new SubmissionOptionsDialog(SubmissionPanel.this.extCommObj);
                hDialog.setVisible(true);
            }
        });
        this.enableClientDataSubmissionChk = new JCheckBox(SubmissionPanel.getString("SubmissionPanel.clientDataSubmission"));
        this.enableClientDataSubmissionChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                if (SubmissionPanel.this.enableClientDataSubmissionChk.isSelected()) {
                    SubmissionPanel.this.extCommObj.setEnableClientDataSubmissions(true);
                } else {
                    SubmissionPanel.this.extCommObj.setEnableClientDataSubmissions(false);
                }
            }
        });
        JLabel clientDataBenefitsDesc = new JLabel(this.getHTMLString("SubmissionPanel.clientDataSubmissionDesc"));
        JLabel clientDataBenefitsDesc2 = new JLabel(this.getHTMLString("SubmissionPanel.clientDataSubmissionDesc2"));
        this.lockEnableReputationChk = new LockCheckBox(Boolean.FALSE);
        this.lockEnableReputationChk.setSelectedIcon(AvConstants.lockIcon);
        this.enableReputationEnabledChk = new JCheckBox(SubmissionPanel.getString("SubmissionPanel.reputation"));
        this.enableReputationEnabledChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SubmissionPanel.this.enableReputationEnabledChk.isSelected()) {
                    SubmissionPanel.this.extCommObj.setReputationSetting(true);
                } else if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), SubmissionPanel.getString("SubmissionPanel.reputation.warningMessage"), SubmissionPanel.getString("SubmissionPanel.reputation.warningTitleText"), 0)) {
                    SubmissionPanel.this.enableReputationEnabledChk.setSelected(true);
                    SubmissionPanel.this.extCommObj.setReputationSetting(true);
                } else {
                    SubmissionPanel.this.enableReputationEnabledChk.setSelected(false);
                    SubmissionPanel.this.extCommObj.setReputationSetting(false);
                }
            }
        });
        JPanel mainPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        mainPanel.setLayout(gridbag);
        int gridy = 0;
        mainPanel.add((Component)this.lockEnableSubmissionChk, new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        mainPanel.add((Component)this.enableSubmissionEnabledChk, new GridBagConstraints(1, gridy++, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 5, 10), 0, 0));
        mainPanel.add((Component)submissionBenefitsDesc, new GridBagConstraints(1, gridy++, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 30, 5, 10), 0, 0));
        mainPanel.add((Component)this.moreButton, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 30, 5, 10), 0, 0));
        mainPanel.add((Component)this.enableClientDataSubmissionChk, new GridBagConstraints(1, gridy++, 2, 1, 0.0, 0.0, 18, 2, new Insets(20, 0, 5, 10), 0, 0));
        mainPanel.add((Component)clientDataBenefitsDesc, new GridBagConstraints(1, gridy++, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 30, 5, 10), 0, 0));
        mainPanel.add((Component)clientDataBenefitsDesc2, new GridBagConstraints(1, gridy++, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 30, 5, 10), 0, 0));
        mainPanel.add((Component)this.getSubmissionsHelpLinkLabel(), new GridBagConstraints(1, gridy++, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 10), 0, 0));
        mainPanel.add((Component)this.getClientDataPrivacyStatementLinkLabel(), new GridBagConstraints(1, gridy++, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 25, 5, 20), 0, 0));
        DescriptionTextArea telemetryEnabled = new DescriptionTextArea(SubmissionPanel.getString("SubmissionPanel.telemetryEnabled"), 68);
        JPanel telemetryPanel = new JPanel(new BorderLayout());
        telemetryPanel.add((Component)telemetryEnabled, "North");
        mainPanel.add((Component)telemetryPanel, new GridBagConstraints(1, gridy++, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.lockEnableReputationChk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.enableReputationEnabledChk, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 5, 10), 0, 0));
        JLabel reputationTextIcon = new JLabel();
        reputationTextIcon.setIcon(this.redAlertIcon);
        panel.add((Component)reputationTextIcon, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 30, 10, 5), 0, 0));
        panel.add((Component)this.getJTextArea(SubmissionPanel.getString("SubmissionPanel.reputationDesc")), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 65, 10, 10), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.add((Component)new AvTemplatePane(SubmissionPanel.getString("SubmissionPanel.clientQueries"), null), "North");
        wrapPanel.add((Component)panel, "Before");
        JPanel submissionPanel = new JPanel(new GridBagLayout());
        submissionPanel.add((Component)mainPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 23, new Insets(5, 0, 0, 0), 0, 0));
        JPanel submissionWrapPanel = new JPanel(new BorderLayout());
        submissionWrapPanel.add((Component)submissionPanel, "Before");
        this.setLayout(new VerticalFlowLayout(0, 15));
        this.add(submissionWrapPanel);
        this.add(wrapPanel);
    }

    private String getHTMLString(String propertyKey) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html><body>");
        buffer.append(SubmissionPanel.getString(propertyKey));
        buffer.append("</body></html>");
        return buffer.toString();
    }

    private JTextArea getJTextArea(String text) {
        JTextArea jTextArea = new JTextArea(text);
        jTextArea.setEditable(false);
        jTextArea.setColumns(60);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setOpaque(false);
        jTextArea.setAlignmentX(0.0f);
        return jTextArea;
    }

    private HtmlEnabledJLabel getClientDataPrivacyStatementLinkLabel() {
        HtmlEnabledJLabel clientDataHelpLinkLabel = new HtmlEnabledJLabel(SubmissionPanel.getString("SubmissionPanel.clientDataSubmissionPrivacyStatement"), true);
        clientDataHelpLinkLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SubmissionPanel.this.openHelpLink("SubmissionPanel.clientDataSubmissionPrivacyStatementLink");
            }
        });
        return clientDataHelpLinkLabel;
    }

    private HtmlEnabledJLabel getSubmissionsHelpLinkLabel() {
        HtmlEnabledJLabel helpLinkLabel = new HtmlEnabledJLabel(SubmissionPanel.getString("SubmissionPanel.submissionsMore"), true);
        helpLinkLabel.setIcon((Icon)ConsoleMain.whatsThisIcon);
        helpLinkLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HelpUtil.showHelpOrErrDlg("sesm_admin_servers_dialog_site_properties_dc_telemetry");
            }
        });
        return helpLinkLabel;
    }

    private void openHelpLink(String helpLinkURL) {
        try {
            String urlLink = URLUtility.getVersionLanguageErrorUpdatedUrl((String)"com.sygate.scm.console.ui.policy.dialog.policydialog", (String)helpLinkURL, null);
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                ClientAgent.getCurrentInstance().openInNewTab(urlLink);
                return;
            }
            URLUtility.showURL((String)urlLink);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private void enableSubmissionsOptions(boolean val) {
        this.enableClientDataSubmissionChk.setSelected(this.extCommObj.isClientDataSubmissionsEnable());
        this.moreButton.setEnabled(val);
    }

    public void setObject(ExternalCommunicationObject extComObj) {
        this.extCommObj = extComObj;
        this.enableSubmissionEnabledChk.setSelected(this.extCommObj.isSubmissionsEnabled());
        this.enableReputationEnabledChk.setSelected(this.extCommObj.isReputationEnabled());
        this.enableSubmissionsOptions(this.extCommObj.isSubmissionsEnabled());
        this.lockEnableSubmissionChk.setSelected(this.extCommObj.getLockEnableSubmissions());
        this.lockEnableReputationChk.setSelected(this.extCommObj.getLockEnableReputation());
    }

    public void save() {
        this.extCommObj.setLockEnableSubmissions(this.lockEnableSubmissionChk.isSelected());
        this.extCommObj.setLockEnableReputation(this.lockEnableReputationChk.isSelected());
        this.extCommObj.setSubmissionsSetting(this.enableSubmissionEnabledChk.isSelected());
        this.extCommObj.setEnableClientDataSubmissions(this.enableClientDataSubmissionChk.isSelected());
    }

    private static String getString(String propertyKey) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", propertyKey);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_submission";
    }

    public void setReadOnly() {
        this.enableSubmissionsOptions(false);
        this.enableSubmissionEnabledChk.setEnabled(false);
        this.enableReputationEnabledChk.setEnabled(false);
    }
}

