/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.ExternalCommunicationObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SubmissionOptionsDialog
extends DialogBase {
    private ExternalCommunicationObject extCommObj;
    private JPanel jPanel;
    private JPanel jOptionsPanel;
    private static final long serialVersionUID = 1L;
    private JCheckBox enableMrCleanSubmissionChk;
    private JCheckBox enableAvSonarAdvancedHeuristicSubmissionChk;
    private JCheckBox enableIntrusionPreventionSubmissionChk;
    private JCheckBox enableStatPingsSubmissionChk;
    private JCheckBox enableFileSubmissionChk;

    public SubmissionOptionsDialog(ExternalCommunicationObject commObj) {
        super(Manager.getFrame(), SubmissionOptionsDialog.getString("SubmissionPanel.moreOptionsDialogTitle"), true, false);
        this.extCommObj = commObj;
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getJPanel());
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    @Override
    protected void commit() {
        if (this.extCommObj == null) {
            return;
        }
        this.extCommObj.setMrCleanSubmissionSetting(this.enableMrCleanSubmissionChk.isSelected());
        this.extCommObj.setEnableSONARAdvGoodSubmissions(this.enableAvSonarAdvancedHeuristicSubmissionChk.isSelected());
        this.extCommObj.setEnableIntrusionPrevSubmissions(this.enableIntrusionPreventionSubmissionChk.isSelected());
        this.extCommObj.setEnableStatPingsSubmission(this.enableStatPingsSubmissionChk.isSelected());
        this.extCommObj.setEnableFileSubmissions(this.enableFileSubmissionChk.isSelected());
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getOptionsPanel(), "North");
            this.jPanel.add((Component)this.getButtonPanel(), "South");
        }
        return this.jPanel;
    }

    private JPanel getOptionsPanel() {
        if (this.jOptionsPanel == null) {
            this.jOptionsPanel = new MainPanel();
            JPanel jInnerPanel = new JPanel();
            jInnerPanel.setLayout(new VerticalFlowLayout());
            jInnerPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 10));
            JLabel label = new JLabel(SubmissionOptionsDialog.getString("SubmissionPanel.moreOptionsLabel"));
            label.setBorder(BorderFactory.createEmptyBorder(20, 10, 0, 10));
            this.enableMrCleanSubmissionChk = new JCheckBox(SubmissionOptionsDialog.getString("SubmissionPanel.mrCleanSubmission"));
            this.enableAvSonarAdvancedHeuristicSubmissionChk = new JCheckBox(SubmissionOptionsDialog.getString("SubmissionPanel.avSonarAdvancedHeuristicSubmission"));
            this.enableIntrusionPreventionSubmissionChk = new JCheckBox(SubmissionOptionsDialog.getString("SubmissionPanel.intrusionPreventionSubmission"));
            this.enableStatPingsSubmissionChk = new JCheckBox(SubmissionOptionsDialog.getString("SubmissionPanel.statpingsSubmission"));
            this.enableFileSubmissionChk = new JCheckBox(SubmissionOptionsDialog.getString("SubmissionPanel.fileSubmission"));
            jInnerPanel.add(this.enableMrCleanSubmissionChk);
            jInnerPanel.add(this.enableAvSonarAdvancedHeuristicSubmissionChk);
            jInnerPanel.add(this.enableIntrusionPreventionSubmissionChk);
            jInnerPanel.add(this.enableStatPingsSubmissionChk);
            jInnerPanel.add(this.enableFileSubmissionChk);
            this.jOptionsPanel.add(label);
            this.jOptionsPanel.add(jInnerPanel);
            if (this.extCommObj != null) {
                this.enableMrCleanSubmissionChk.setSelected(this.extCommObj.isMrCleanSubmissionsEnabled());
                this.enableAvSonarAdvancedHeuristicSubmissionChk.setSelected(this.extCommObj.isSONARAdvGoodSubmissionsEnable());
                this.enableIntrusionPreventionSubmissionChk.setSelected(this.extCommObj.isIntrusionPrevSubmissionsEnable());
                this.enableStatPingsSubmissionChk.setSelected(this.extCommObj.isStatPingsSubmissionsEnable());
                this.enableFileSubmissionChk.setSelected(this.extCommObj.isEnableFileSubmissions());
            }
        }
        return this.jOptionsPanel;
    }

    private static String getString(String propertyKey) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", propertyKey);
    }

    private static class MainPanel
    extends AvTemplatePane {
        private static final long serialVersionUID = 1L;

        public MainPanel() {
            super(SubmissionOptionsDialog.getString("SubmissionPanel.moreOptionsTitle"), SubmissionOptionsDialog.getString("SubmissionPanel.moreOptionsDesc"));
        }
    }
}

