/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.DeletableObjInt;
import com.sygate.scm.console.logicobject.HostAddressObject;
import com.sygate.scm.console.logicobject.ServerBlockObject;
import com.sygate.scm.console.logicobject.ServerListObject;
import com.sygate.scm.console.logicobject.ServerListPool;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.dialog.HostAddressDlg;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.validator.routines.InetAddressValidator;

public class ServerListEditorDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    public static final int MAX_PRIORITY_BLOCKS = 32;
    public static final int MAX_SERVERS_IN_BLOCK = 32;
    private ServerListObject serverObj;
    private ServerListPool pool;
    private JPanel jContentPane = null;
    private JPanel jPanel = null;
    private JTextArea jTextArea = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JTextField nameField = null;
    private JScrollPane jScrollPane = null;
    private JTextArea descArea = null;
    private JPanel jPanel1 = null;
    private JPanel jPanel2 = null;
    private JTextArea jTextArea2 = null;
    private JScrollPane jScrollPane1 = null;
    private JTree serverListTree = null;
    private JButton addBtn = null;
    private JButton deleteBtn = null;
    private JButton editBtn = null;
    private JButton moveUpBtn = null;
    private JButton moveDownBtn = null;
    private JPanel treePanel = null;
    private Action addPriority;
    private Action addServer;
    private Action editServer;
    private Action delete;
    private Action moveUp;
    private Action moveDown;
    private Action copy;
    private Action paste;
    private JPopupMenu fullMenu = new JPopupMenu();
    private JPopupMenu addMenu = new JPopupMenu();
    private DefaultMutableTreeNode root;
    private DefaultTreeModel serverListModel;
    private boolean readOnly = false;
    private JCheckBox httpsChkBox = null;
    private JCheckBox verifyNameChkBox = null;
    private JRadioButton httpRdBtn = null;
    private JRadioButton httpsRdBtn = null;
    private static InetAddressValidator inetAddressValidator = InetAddressValidator.getInstance();

    public ServerListEditorDlg() {
        this(false);
    }

    public ServerListEditorDlg(boolean isCheckPolicyEnforcement) {
        super(Manager.getFrame(), "", true);
        this.setTitle(this.createTitle(isCheckPolicyEnforcement));
        this.initialize(isCheckPolicyEnforcement);
    }

    protected void pasteNode() {
        try {
            if (PolicyHandler.hasCopiedObject(ServerBlockObject.class)) {
                ServerBlockObject newBlock = (ServerBlockObject)PolicyHandler.getPastedObject();
                int children = this.root.getChildCount();
                newBlock.setIndex(children);
                this.serverObj.addServerBlock(newBlock);
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(newBlock);
                this.serverListModel.insertNodeInto(node, this.root, children);
                this.createHostsForOneLevel(node, newBlock);
                TreePath newPath = new TreePath(node.getPath());
                this.serverListTree.setSelectionPath(newPath);
            } else if (PolicyHandler.hasCopiedObject(HostAddressObject.class)) {
                TreePath path = this.serverListTree.getSelectionPath();
                if (path == null) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.selectTheMode"));
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                if (parent == this.root) {
                    parent = node;
                }
                int childrean = parent.getChildCount();
                HostAddressObject newObj = (HostAddressObject)PolicyHandler.getPastedObject();
                ServerBlockObject bObj = (ServerBlockObject)parent.getUserObject();
                if (ServerListEditorDlg.duplicateHostExists(bObj, newObj)) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.dupeHostInBlock"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.error"), 0);
                    return;
                }
                bObj.addHostAddress(newObj);
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(newObj);
                this.serverListModel.insertNodeInto(newNode, parent, childrean);
                TreePath newPath = new TreePath(newNode.getPath());
                this.serverListTree.setSelectionPath(newPath);
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.error"), 0);
            this.dispose();
            Manager.getFrame().showLoginPanel();
        }
    }

    protected void copyNode() {
        TreePath path = this.serverListTree.getSelectionPath();
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            CopitableObject obj = (CopitableObject)node.getUserObject();
            PolicyHandler.copyObject(obj);
        }
    }

    protected void moveDownServer() {
        TreePath path = this.serverListTree.getSelectionPath();
        if (path == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.pleaseSelectAModeToMove"));
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object nodeObj = node.getUserObject();
        if (nodeObj instanceof HostAddressObject) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            DefaultMutableTreeNode nextNode = parentNode.getNextSibling();
            if (nextNode != null) {
                HostAddressObject hObj;
                ServerBlockObject thisBObj = (ServerBlockObject)parentNode.getUserObject();
                ServerBlockObject nextBObj = (ServerBlockObject)nextNode.getUserObject();
                if (ServerListEditorDlg.duplicateHostExists(nextBObj, hObj = (HostAddressObject)node.getUserObject())) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.dupeHostInBlock"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.error"), 0);
                    return;
                }
                this.serverListModel.removeNodeFromParent(node);
                this.serverListModel.insertNodeInto(node, nextNode, 0);
                TreePath newPath = new TreePath(node.getPath());
                this.serverListTree.setSelectionPath(newPath);
                thisBObj.removeHostAddress(hObj);
                nextBObj.addHostAddress(hObj, 0);
            }
        } else {
            int total;
            int index = this.root.getIndex(node);
            if (index < (total = this.root.getChildCount()) - 1) {
                ServerBlockObject bObj = (ServerBlockObject)node.getUserObject();
                this.serverObj.moveDownOnePosition(bObj);
                DefaultMutableTreeNode nextNode = (DefaultMutableTreeNode)this.root.getChildAt(index + 1);
                ServerBlockObject nBObj = (ServerBlockObject)nextNode.getUserObject();
                nBObj.decreaseIndex();
                this.serverListModel.removeNodeFromParent(node);
                this.serverListModel.insertNodeInto(node, this.root, index + 1);
                this.serverListModel.nodeChanged(nextNode);
                TreePath newPath = new TreePath(node.getPath());
                this.serverListTree.setSelectionPath(newPath);
                this.serverListTree.expandPath(newPath);
            }
        }
    }

    protected void moveUpServer() {
        TreePath path = this.serverListTree.getSelectionPath();
        if (path == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.pleaseSelectAModeToMove"));
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object nodeObj = node.getUserObject();
        if (nodeObj instanceof HostAddressObject) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            DefaultMutableTreeNode preNode = parentNode.getPreviousSibling();
            if (preNode != null) {
                HostAddressObject hObj;
                ServerBlockObject thisBObj = (ServerBlockObject)parentNode.getUserObject();
                ServerBlockObject preBObj = (ServerBlockObject)preNode.getUserObject();
                if (ServerListEditorDlg.duplicateHostExists(preBObj, hObj = (HostAddressObject)node.getUserObject())) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.dupeHostInBlock"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.error"), 0);
                    return;
                }
                this.serverListModel.removeNodeFromParent(node);
                int children = preNode.getChildCount();
                this.serverListModel.insertNodeInto(node, preNode, children);
                TreePath newPath = new TreePath(node.getPath());
                this.serverListTree.setSelectionPath(newPath);
                thisBObj.removeHostAddress(hObj);
                preBObj.addHostAddress(hObj);
            }
        } else {
            int index = this.root.getIndex(node);
            if (index > 0) {
                ServerBlockObject bObj = (ServerBlockObject)node.getUserObject();
                this.serverObj.moveUpOnePosition(bObj);
                DefaultMutableTreeNode preNode = (DefaultMutableTreeNode)this.root.getChildAt(index - 1);
                ServerBlockObject nBObj = (ServerBlockObject)preNode.getUserObject();
                nBObj.increaseIndex();
                this.serverListModel.removeNodeFromParent(node);
                this.serverListModel.insertNodeInto(node, this.root, index - 1);
                this.serverListModel.nodeChanged(preNode);
                TreePath newPath = new TreePath(node.getPath());
                this.serverListTree.setSelectionPath(newPath);
                this.serverListTree.expandPath(newPath);
            }
        }
    }

    protected void deleteNode() {
        TreePath path = this.serverListTree.getSelectionPath();
        if (path == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.selectANodeToDelete"));
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object nodeObj = node.getUserObject();
        if (nodeObj instanceof DeletableObjInt) {
            Object[] choice = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.label.yes"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.label.no")};
            int result = JOptionPane.showOptionDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.areYouSureYouWantToDelete"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.deletNode"), 0, 3, null, choice, choice[1]);
            if (result == 0) {
                DeletableObjInt delObj = (DeletableObjInt)nodeObj;
                delObj.delete();
                if (delObj instanceof ServerBlockObject) {
                    this.adjustPriorityOfNextNodes(node);
                }
                this.serverListModel.removeNodeFromParent(node);
            }
        }
    }

    protected void editServer() {
        try {
            TreePath path = this.serverListTree.getSelectionPath();
            if (path == null) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.pleaseSelectANodeToEdit"));
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object nodeObj = node.getUserObject();
            if (!(nodeObj instanceof HostAddressObject)) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.onlyServerAddressesCanBeEdited"));
                return;
            }
            ServerBlockObject bObj = (ServerBlockObject)((DefaultMutableTreeNode)node.getParent()).getUserObject();
            HostAddressObject aObj = (HostAddressObject)nodeObj;
            HostAddressObject newObj = aObj.getClone();
            HostAddressDlg dlg = new HostAddressDlg((JFrame)Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.editHostAddress"), true, bObj);
            dlg.setObject(newObj);
            dlg.setVisible(true);
            if (dlg.isOk()) {
                HostAddressObject[] allHosts = bObj.getAllHosts();
                int index = -1;
                for (int i = 0; i < allHosts.length; ++i) {
                    if (!allHosts[i].getAddress().equals(aObj.getAddress())) continue;
                    index = i;
                    break;
                }
                boolean isHttps = this.getHttpsRdBtn().isSelected();
                newObj.setHttps(isHttps);
                aObj.setHostAddress(newObj);
                this.serverListModel.nodeChanged(node);
                bObj.setHostAddress(index, newObj.getHostAddress());
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.error"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    protected void addNewServer() {
        int children;
        TreePath path = this.serverListTree.getSelectionPath();
        if (path == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.pleaseSelectANodeToAddTo"));
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object nodeObj = node.getUserObject();
        if (nodeObj instanceof HostAddressObject) {
            node = (DefaultMutableTreeNode)node.getParent();
            nodeObj = node.getUserObject();
        }
        if ((children = node.getChildCount()) >= 32) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.maxServers"));
            return;
        }
        ServerBlockObject bObj = (ServerBlockObject)nodeObj;
        HostAddressDlg dlg = new HostAddressDlg((JFrame)Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.addHostAddress"), true, bObj);
        HostAddressObject hObj = new HostAddressObject();
        if (!this.getHttpsRdBtn().isSelected()) {
            hObj.setHttpPort(ScmProperties.getWebServerPort());
        } else {
            hObj.setHttpsPort(ScmProperties.getWebServerPortHttps());
        }
        dlg.setObject(hObj);
        dlg.setVisible(true);
        if (dlg.isOk()) {
            boolean isHttps = this.getHttpsRdBtn().isSelected();
            hObj.setHttps(isHttps);
            bObj.addHostAddress(hObj);
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(hObj);
            this.serverListModel.insertNodeInto(newNode, node, children);
            TreePath newPath = new TreePath(newNode.getPath());
            this.serverListTree.setSelectionPath(newPath);
        }
    }

    protected void addNewPriority() {
        int index = this.root.getChildCount();
        if (index >= 32) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.maxBlocks"));
            return;
        }
        ServerBlockObject blockObj = new ServerBlockObject(index);
        this.serverObj.addServerBlock(blockObj);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(blockObj);
        this.serverListModel.insertNodeInto(node, this.root, index);
        TreePath pathToIt = new TreePath(node.getPath());
        this.serverListTree.scrollPathToVisible(pathToIt);
        this.serverListTree.setSelectionPath(pathToIt);
    }

    protected void setActionStatus() {
        this.addServer.setEnabled(false);
        this.editServer.setEnabled(false);
        this.delete.setEnabled(false);
        this.moveUp.setEnabled(false);
        this.moveDown.setEnabled(false);
        this.copy.setEnabled(false);
        this.paste.setEnabled(false);
        if (this.readOnly) {
            return;
        }
        TreePath path = this.serverListTree.getSelectionPath();
        if (path != null && path.getLastPathComponent() != this.root) {
            this.delete.setEnabled(true);
            this.addServer.setEnabled(true);
            this.copy.setEnabled(true);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object nodeObj = node.getUserObject();
            if (nodeObj instanceof HostAddressObject) {
                this.editServer.setEnabled(true);
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
                if (parentNode.getPreviousSibling() != null) {
                    this.moveUp.setEnabled(true);
                }
                if (parentNode.getNextSibling() != null) {
                    this.moveDown.setEnabled(true);
                }
            } else {
                int indexOfParent = this.root.getIndex(node);
                if (indexOfParent > 0) {
                    this.moveUp.setEnabled(true);
                }
                if (indexOfParent < this.root.getChildCount() - 1) {
                    this.moveDown.setEnabled(true);
                }
            }
        }
    }

    protected void showPopupMenu(MouseEvent e) {
        if (this.readOnly) {
            return;
        }
        if (e.isPopupTrigger()) {
            TreePath path = this.serverListTree.getPathForLocation(e.getX(), e.getY());
            this.serverListTree.setSelectionPath(path);
            if (PolicyHandler.hasCopiedObject(ServerBlockObject.class)) {
                this.paste.setEnabled(true);
            }
            if (PolicyHandler.hasCopiedObject(HostAddressObject.class) && path != null) {
                this.paste.setEnabled(true);
            }
            this.serverListTree.add(this.fullMenu);
            this.fullMenu.show(this.serverListTree, e.getX(), e.getY());
        }
    }

    protected void addBtnIsClicked(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        button.add(this.addMenu);
        int x = button.getWidth();
        this.addMenu.show(button, x, 0);
    }

    protected void httpStatusChanged() {
        boolean isHttps = this.getHttpsRdBtn().isSelected();
        this.getVerifyNameChkBox().setEnabled(this.getHttpsRdBtn().isEnabled() && isHttps);
        Enumeration<TreeNode> en = this.root.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            Object obj = node.getUserObject();
            if (!(obj instanceof HostAddressObject)) continue;
            HostAddressObject hObj = (HostAddressObject)obj;
            hObj.setHttps(isHttps);
            this.serverListModel.reload(node);
        }
    }

    @Override
    protected boolean isValidate() {
        return this.isValidData();
    }

    @Override
    protected void commit() {
        this.serverObj.setVerifyName(this.verifyNameChkBox.isSelected());
        this.serverObj.setOnlyHttps(this.getHttpsRdBtn().isSelected());
        this.serverObj.setName(this.nameField.getText().trim());
        this.serverObj.setDescription(this.descArea.getText());
    }

    private void initialize(boolean isCheckPolicyEnforcement) {
        this.initializeAction();
        this.initializeMenu();
        this.setDefaultCloseOperation(2);
        this.getContentPane().add(this.getJContentPane());
        this.pack();
        UiUtilities.centerComponent((Component)this);
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (isCheckPolicyEnforcement && AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            this.setReadOnly();
        }
    }

    private void initializeMenu() {
        JMenuItem addPriMenu = new JMenuItem(this.addPriority);
        JMenuItem addServerMenu = new JMenuItem(this.addServer);
        JMenuItem editMenu = new JMenuItem(this.editServer);
        JMenuItem deleteMenu = new JMenuItem(this.delete);
        JMenuItem moveUpMenu = new JMenuItem(this.moveUp);
        JMenuItem moveDownMenu = new JMenuItem(this.moveDown);
        JMenuItem copyMenu = new JMenuItem(this.copy);
        JMenuItem pasteMenu = new JMenuItem(this.paste);
        JMenu addSubMenu = new JMenu(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.add"));
        addSubMenu.add(addPriMenu);
        addSubMenu.add(addServerMenu);
        this.fullMenu.add(addSubMenu);
        this.fullMenu.add(deleteMenu);
        this.fullMenu.add(editMenu);
        this.fullMenu.add(moveUpMenu);
        this.fullMenu.add(moveDownMenu);
        this.fullMenu.addSeparator();
        this.fullMenu.add(copyMenu);
        this.fullMenu.add(pasteMenu);
        addPriMenu = new JMenuItem(this.addPriority);
        addServerMenu = new JMenuItem(this.addServer);
        this.addMenu.add(addPriMenu);
        this.addMenu.add(addServerMenu);
    }

    private void initializeAction() {
        this.addPriority = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.label.newPriority")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AjaxSwingCommonUtil.beginOperation();
                ServerListEditorDlg.this.addNewPriority();
                AjaxSwingCommonUtil.endOperation();
            }
        };
        this.addServer = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.label.newServer")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AjaxSwingCommonUtil.beginOperation();
                ServerListEditorDlg.this.addNewServer();
                AjaxSwingCommonUtil.endOperation();
            }
        };
        this.editServer = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.label.Edit")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerListEditorDlg.this.editServer();
            }
        };
        this.delete = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.label.Delete")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerListEditorDlg.this.deleteNode();
            }
        };
        this.moveUp = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.label.moveUp")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerListEditorDlg.this.moveUpServer();
            }
        };
        this.moveDown = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.label.moveDown")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerListEditorDlg.this.moveDownServer();
            }
        };
        this.copy = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.label.copy")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerListEditorDlg.this.copyNode();
            }
        };
        this.paste = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.label.paste")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerListEditorDlg.this.pasteNode();
            }
        };
    }

    private void adjustPriorityOfNextNodes(DefaultMutableTreeNode node) {
        for (DefaultMutableTreeNode nextOne = node.getNextSibling(); nextOne != null; nextOne = nextOne.getNextSibling()) {
            ServerBlockObject sbObj = (ServerBlockObject)nextOne.getUserObject();
            sbObj.decreaseIndex();
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel(), "Center");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getJTextArea(), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
            this.jPanel.add((Component)this.getJLabel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
            this.jPanel.add((Component)this.getJLabel1(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
            this.jPanel.add((Component)this.getNameField(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 10), 0, 0));
            this.jPanel.add((Component)this.getScrollPanel(), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.3, 18, 1, new Insets(10, 5, 0, 10), 0, 0));
            this.jPanel.add((Component)this.getJPanel1(), new GridBagConstraints(0, 5, 2, 1, 1.0, 0.7, 18, 1, new Insets(10, 10, 0, 10), 0, 0));
            this.jPanel.add((Component)this.getHttpRdBtn(), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
            Box b = Box.createHorizontalBox();
            b.add(this.getHttpsRdBtn());
            b.add(Box.createHorizontalStrut(20));
            b.add(this.getVerifyNameChkBox());
            this.jPanel.add((Component)b, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
            this.jPanel.setMinimumSize(new Dimension(458, 588));
            ButtonGroup bGroup = new ButtonGroup();
            bGroup.add(this.getHttpRdBtn());
            bGroup.add(this.getHttpsRdBtn());
        }
        return this.jPanel;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new DescriptionTextArea();
            this.jTextArea.setBounds(9, 14, 435, 22);
            this.jTextArea.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.policyManagerListsAreAListOf"));
        }
        return this.jTextArea;
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setBounds(9, 38, 88, 23);
            this.jLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.label.name"));
            this.jLabel.setHorizontalAlignment(2);
        }
        return this.jLabel;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setBounds(9, 69, 88, 23);
            this.jLabel1.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.label.description"));
            this.jLabel1.setHorizontalAlignment(2);
        }
        return this.jLabel1;
    }

    private JTextField getNameField() {
        if (this.nameField == null) {
            this.nameField = new JTextField();
            this.nameField.setBounds(104, 38, 334, 23);
            RestrictedPlainDocument doc = new RestrictedPlainDocument(255);
            doc.setValidator("\"/\\*?<>|:", false);
            this.nameField.setDocument(doc);
        }
        return this.nameField;
    }

    private JPanel getScrollPanel() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)this.jScrollPane, (JTextArea)this.getDescArea());
        }
        JPanel scrollPanel = new JPanel();
        scrollPanel.setLayout(new BorderLayout());
        scrollPanel.add((Component)this.jScrollPane, "Center");
        scrollPanel.setMinimumSize(new Dimension(104, 55));
        return scrollPanel;
    }

    private JTextArea getDescArea() {
        if (this.descArea == null) {
            this.descArea = new JTextArea();
            this.descArea.setLineWrap(true);
            this.descArea.setWrapStyleWord(true);
            this.descArea.setRows(3);
            RestrictedPlainDocument doc = new RestrictedPlainDocument(1023);
            this.descArea.setDocument(doc);
        }
        return this.descArea;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.add((Component)this.getJTextArea2(), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
            this.jPanel1.add((Component)this.getScrollPanel1(), new GridBagConstraints(0, 1, 1, 5, 1.0, 1.0, 18, 1, new Insets(10, 5, 10, 5), 0, 0));
            this.jPanel1.add((Component)this.getAddBtn(), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 10), 0, 0));
            this.jPanel1.add((Component)this.getEditBtn(), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 10), 0, 0));
            this.jPanel1.add((Component)this.getDeleteBtn(), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 10), 0, 0));
            this.jPanel1.add((Component)this.getMoveUpBtn(), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 10), 0, 0));
            this.jPanel1.add((Component)this.getMoveDownBtn(), new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 10), 0, 0));
            this.jPanel1.setMinimumSize(new Dimension(431, 379));
            if (this.jPanel2 == null) {
                this.jPanel2 = new JPanel();
            }
            this.jPanel2.setLayout(new BorderLayout());
            this.jPanel2.add((Component)this.jPanel1, "Center");
            this.jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.policyManagerServers"), 0, 0, null, null));
        }
        return this.jPanel2;
    }

    private JTextArea getJTextArea2() {
        if (this.jTextArea2 == null) {
            this.jTextArea2 = new DescriptionTextArea();
            this.jTextArea2.setBounds(6, 20, 421, 35);
            this.jTextArea2.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.theAgentsFirstTryToConnect"));
        }
        return this.jTextArea2;
    }

    private JPanel getScrollPanel1() {
        JScrollPane scrollPane = this.getTreeScrollPane();
        JPanel scrollPanel = new JPanel(new BorderLayout());
        scrollPanel.add((Component)scrollPane, "Center");
        return scrollPanel;
    }

    private JScrollPane getTreeScrollPane() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)this.jScrollPane1, (JTree)this.getServerListTree());
        }
        return this.jScrollPane1;
    }

    private JTree getServerListTree() {
        if (this.serverListTree == null) {
            this.serverListTree = new JTree();
            this.serverListTree.setRootVisible(false);
            this.serverListTree.setShowsRootHandles(true);
            DefaultTreeCellRenderer treeRender = (DefaultTreeCellRenderer)this.serverListTree.getCellRenderer();
            ServerListEditorDlg.setIconsInDefaultTreeCellRenderer(treeRender);
            this.serverListTree.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ServerListEditorDlg.this.showPopupMenu(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    ServerListEditorDlg.this.showPopupMenu(e);
                }
            });
            this.serverListTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    ServerListEditorDlg.this.setActionStatus();
                }
            });
            this.root = new DefaultMutableTreeNode();
            this.serverListModel = new DefaultTreeModel(this.root);
            this.serverListTree.setModel(this.serverListModel);
        }
        return this.serverListTree;
    }

    private static void setIconsInDefaultTreeCellRenderer(DefaultTreeCellRenderer treeRender) {
        treeRender.setLeafIcon(null);
        treeRender.setClosedIcon(null);
        treeRender.setOpenIcon(null);
    }

    private JButton getAddBtn() {
        if (this.addBtn == null) {
            this.addBtn = new JButton();
            this.addBtn.setBounds(282, 64, 109, 22);
            this.addBtn.setText(UIText.get(8));
            this.addBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AjaxSwingCommonUtil.beginOperation();
                    ServerListEditorDlg.this.addBtnIsClicked(e);
                    AjaxSwingCommonUtil.endOperation();
                }
            });
        }
        return this.addBtn;
    }

    private JButton getDeleteBtn() {
        if (this.deleteBtn == null) {
            this.deleteBtn = new JButton();
            this.deleteBtn.setBounds(282, 97, 109, 22);
            this.deleteBtn.setText(UIText.get(769));
            this.deleteBtn.setAction(this.delete);
        }
        return this.deleteBtn;
    }

    private JButton getEditBtn() {
        if (this.editBtn == null) {
            this.editBtn = new JButton();
            this.editBtn.setBounds(282, 132, 109, 22);
            this.editBtn.setText(UIText.get(1024));
            this.editBtn.setAction(this.editServer);
        }
        return this.editBtn;
    }

    private JButton getMoveUpBtn() {
        if (this.moveUpBtn == null) {
            this.moveUpBtn = new JButton();
            this.moveUpBtn.setBounds(282, 161, 109, 22);
            this.moveUpBtn.setText(UIText.get(3075));
            this.moveUpBtn.setAction(this.moveUp);
        }
        return this.moveUpBtn;
    }

    private JButton getMoveDownBtn() {
        if (this.moveDownBtn == null) {
            this.moveDownBtn = new JButton();
            this.moveDownBtn.setBounds(282, 192, 109, 22);
            this.moveDownBtn.setText(UIText.get(3074));
            this.moveDownBtn.setAction(this.moveDown);
        }
        return this.moveDownBtn;
    }

    private void updatePanel() {
        this.nameField.setText(this.serverObj.getName());
        this.descArea.setText(this.serverObj.getDescription());
        this.descArea.setCaretPosition(0);
        boolean onlyHttps = this.serverObj.getOnlyHttps();
        if (onlyHttps) {
            this.getHttpsRdBtn().setSelected(true);
        } else {
            boolean preferredComSecuirtyUsesHttps = this.serverObj.isPreferredComSecuirtyUsesHttps();
            System.out.println("ServerListEditorDlg> updatePanel>> preferredCommSecuirtyPortocolUseHttps:" + preferredComSecuirtyUsesHttps);
            if (this.serverObj.isDefaultList() && preferredComSecuirtyUsesHttps) {
                this.getHttpsRdBtn().setSelected(true);
            } else {
                this.getHttpRdBtn().setSelected(true);
            }
        }
        this.httpStatusChanged();
        boolean verifyName = this.serverObj.getVerifyName();
        this.verifyNameChkBox.setSelected(verifyName);
        this.createServerTree();
        this.setActionStatus();
        this.nameField.requestFocusInWindow();
        if (this.serverObj.isDefaultList()) {
            this.setReadOnly();
            IPv6TreeCellRenderer treeRender = new IPv6TreeCellRenderer();
            this.serverListTree.setCellRenderer(treeRender);
            ServerListEditorDlg.setIconsInDefaultTreeCellRenderer(treeRender);
        } else if (this.serverListModel != null && this.root != null && this.serverListModel.getChildCount(this.root) < 1) {
            this.addNewPriority();
        }
    }

    private void createServerTree() {
        ServerBlockObject[] allServer = this.serverObj.getAllServers();
        for (int i = 0; i < allServer.length; ++i) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(allServer[i]);
            this.serverListModel.insertNodeInto(node, this.root, i);
            this.createHostsForOneLevel(node, allServer[i]);
        }
        UIUtilities.expandTreeByDepth(this.serverListTree, this.root, 2);
    }

    private void createHostsForOneLevel(DefaultMutableTreeNode parent, ServerBlockObject server) {
        boolean isHttps = this.getHttpsRdBtn().isSelected();
        HostAddressObject[] hosts = server.getAllHosts();
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i].setHttps(isHttps);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(hosts[i]);
            this.serverListModel.insertNodeInto(node, parent, i);
        }
    }

    private JCheckBox getHttpsChkBox() {
        if (this.httpsChkBox == null) {
            this.httpsChkBox = new JCheckBox();
            this.httpsChkBox.setBounds(17, 134, 410, 20);
            this.httpsChkBox.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.label.onlyUseHTTPSToCommunicate"));
        }
        return this.httpsChkBox;
    }

    private JRadioButton getHttpRdBtn() {
        if (this.httpRdBtn == null) {
            this.httpRdBtn = new JRadioButton();
            this.httpRdBtn.setBounds(17, 134, 150, 20);
            this.httpRdBtn.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.label.useHTTPProtocol"));
            this.httpRdBtn.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServerListEditorDlg.this.httpStatusChanged();
                }
            });
        }
        return this.httpRdBtn;
    }

    private JRadioButton getHttpsRdBtn() {
        if (this.httpsRdBtn == null) {
            this.httpsRdBtn = new JRadioButton();
            this.httpsRdBtn.setBounds(17, 155, 150, 20);
            this.httpsRdBtn.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.label.useHTTPSProtocol"));
            this.httpsRdBtn.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServerListEditorDlg.this.httpStatusChanged();
                }
            });
        }
        return this.httpsRdBtn;
    }

    private JCheckBox getVerifyNameChkBox() {
        if (this.verifyNameChkBox == null) {
            this.verifyNameChkBox = new JCheckBox();
            this.verifyNameChkBox.setBounds(177, 155, 412, 23);
            this.verifyNameChkBox.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.label.verifyCertificate"));
        }
        return this.verifyNameChkBox;
    }

    private String createTitle(boolean isCheckPolicyEnforcement) {
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (isCheckPolicyEnforcement && AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.readOnlyTitle");
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.title");
    }

    private boolean isValidData() {
        try {
            int[] pos;
            String name = this.nameField.getText().trim();
            if (name.length() == 0) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.nameFieldCannotBeEmpty"), this.nameField);
            }
            if (!this.pool.checkNewName(this.serverObj, name)) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.theNameHasAlreadyBeenUsed"), this.nameField);
            }
            if (!this.serverObj.hasServer()) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.aPolicyManagerListMustInclude"), null);
            }
            boolean onlyHttps = this.getHttpsRdBtn().isSelected();
            boolean verifyName = this.verifyNameChkBox.isSelected();
            if (onlyHttps && verifyName && (pos = this.serverObj.getFirstIpPos())[0] != -1 && pos[1] != -1) {
                DefaultMutableTreeNode blockNode = (DefaultMutableTreeNode)this.root.getChildAt(pos[0]);
                DefaultMutableTreeNode serverNode = (DefaultMutableTreeNode)blockNode.getChildAt(pos[1]);
                TreePath path = new TreePath(serverNode.getPath());
                this.serverListTree.setSelectionPath(path);
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.hostNamesMustBeUsed"), this.serverListTree);
            }
            return true;
        }
        catch (GUICheckException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.error"), 0);
            if (ex.getErrorComponent() != null) {
                ex.getErrorComponent().requestFocus();
            }
            return false;
        }
    }

    public static boolean duplicateHostExists(ServerBlockObject block, HostAddressObject host) {
        HostAddressObject[] allHosts = block.getAllHosts();
        for (int i = 0; i < allHosts.length; ++i) {
            if (!allHosts[i].getAddress().equals(host.getAddress())) continue;
            return true;
        }
        return false;
    }

    public JPanel getOutServerListPanel() {
        if (this.treePanel == null) {
            this.treePanel = new JPanel();
            this.treePanel.setLayout(new BorderLayout());
            this.treePanel.add((Component)this.getTreeScrollPane(), "Center");
        }
        this.setReadOnly();
        return this.treePanel;
    }

    public void setObject(ServerListObject sObj, ServerListPool pool) {
        this.serverObj = sObj;
        this.pool = pool;
        this.updatePanel();
    }

    public void setObject(ServerListObject sObj) {
        this.serverObj = sObj;
        this.updatePanel();
    }

    public void setReadOnly() {
        this.readOnly = true;
        this.getNameField().setEnabled(false);
        this.getDescArea().setEnabled(false);
        this.getHttpRdBtn().setEnabled(false);
        this.getHttpsRdBtn().setEnabled(false);
        this.getHttpsChkBox().setEnabled(false);
        this.getVerifyNameChkBox().setEnabled(false);
        this.getAddBtn().setEnabled(false);
        this.getDeleteBtn().setEnabled(false);
        this.getEditBtn().setEnabled(false);
        this.getMoveUpBtn().setEnabled(false);
        this.getMoveDownBtn().setEnabled(false);
        this.jBOk.setEnabled(false);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_endpoint_security_manager_list_edit";
    }

    static class IPv6TreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        IPv6TreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String ipAddress;
            HostAddressObject hostaddress;
            DefaultMutableTreeNode node;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode && (node = (DefaultMutableTreeNode)value).getUserObject() instanceof HostAddressObject && (hostaddress = (HostAddressObject)node.getUserObject()) != null && (ipAddress = hostaddress.getAddress()) != null && inetAddressValidator.isValidInet6Address(ipAddress)) {
                ipAddress = Utilities.shortenIpv6Address(ipAddress);
                Integer httpsPort = hostaddress.getHttpsPort();
                this.setText("[" + ipAddress + "]:" + (httpsPort == null ? hostaddress.getHttpPort() : httpsPort));
            }
            return this;
        }
    }
}

