/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public abstract class SelectDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final String MSG_KEY_ERROR = "SelectDlg.error";
    private static final String SELECT_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "SelectDlg.selectOneOfName");
    protected AbstractUIObject selectedServerList;
    private JPanel jContentPane = null;
    protected JPanel jPanel = null;
    private DescriptionTextArea jTextArea = null;
    private JScrollPane jScrollPane = null;
    protected JList<AbstractUIObject> serverList = null;
    protected DefaultListModel<AbstractUIObject> serverModel = new DefaultListModel();
    protected DefaultComboBoxModel<ObjInfoObject> policyModel = new DefaultComboBoxModel();
    protected JComboBox<ObjInfoObject> policyList = null;

    protected SelectDlg(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.initialize();
        this.setData();
    }

    protected SelectDlg() {
        super(Manager.getFrame(), "", true);
        this.initialize();
        this.setData();
    }

    protected SelectDlg(String title) {
        super(Manager.getFrame(), title, true);
    }

    private void initialize() {
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getJContentPane());
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel(), "Center");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getJTextArea(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 5, 10), 0, 0));
            this.jPanel.add((Component)this.getJScrollPane(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 2, 10), 0, 0));
            this.jPanel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "SelectDlg.policyManagerLists")));
        }
        return this.jPanel;
    }

    protected DescriptionTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "SelectDlg.selectOneOfThePolicyManagerList"));
        }
        return this.jTextArea;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getServerList());
            this.jScrollPane.setBounds(18, 65, 324, 207);
        }
        return this.jScrollPane;
    }

    private JList<AbstractUIObject> getServerList() {
        if (this.serverList == null) {
            this.serverList = new JList();
            this.serverList.setModel(this.serverModel);
            this.serverList.getSelectionModel().setSelectionMode(0);
        }
        return this.serverList;
    }

    protected abstract AbstractUIObject getUIObject() throws ConsoleException;

    @Override
    protected boolean isValidate() {
        try {
            int index = this.serverList.getSelectedIndex();
            if (index == -1) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "SelectDlg.youMustSelectOneElement"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", MSG_KEY_ERROR), 0);
                return false;
            }
        }
        catch (HeadlessException e1) {
            LoggerUtilities.logException((Throwable)e1);
            JOptionPane.showMessageDialog(Manager.getFrame(), e1.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", MSG_KEY_ERROR), 0);
            Manager.getFrame().showLoginPanel();
        }
        return true;
    }

    @Override
    protected void commit() {
        try {
            this.selectedServerList = this.getUIObject();
        }
        catch (HeadlessException e1) {
            LoggerUtilities.logException((Throwable)e1);
            JOptionPane.showMessageDialog(Manager.getFrame(), e1.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", MSG_KEY_ERROR), 0);
            Manager.getFrame().showLoginPanel();
        }
        catch (ConsoleException e1) {
            LoggerUtilities.logException((Throwable)e1);
            JOptionPane.showMessageDialog(Manager.getFrame(), e1.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", MSG_KEY_ERROR), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    protected abstract void setData();

    public AbstractUIObject getSelectedObject() {
        return this.selectedServerList;
    }

    protected void setTitleName(String name) {
        TitledBorder tBorder = (TitledBorder)this.jPanel.getBorder();
        tBorder.setTitle(name);
        this.jTextArea.setText(SELECT_DESC);
    }

    public void setDescription(String name) {
        this.jTextArea.setText(name);
    }

    @Override
    protected boolean isHelpButtonShown() {
        return false;
    }
}

