/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.RegistryData;
import com.sygate.scm.common.configobject.schema.RegistryKey;
import com.sygate.scm.common.configobject.schema.RegistryValue;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.RegistryDataObject;
import com.sygate.scm.console.logicobject.RegistryKeyObject;
import com.sygate.scm.console.logicobject.RegistryObject;
import com.sygate.scm.console.logicobject.RegistryValueObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class RegistryPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String[] SCRIPT_FILTER_PARAMS = new String[]{"<script", "/script", "&lt;script", "%3cscript"};
    private static final String[] HTML_FILTER_PARAMS = new String[]{"<html", "/html", "&lt;html", "%3chtml"};
    private static final String DLG = "com.sygate.scm.console.ui.policy.dialog.policydialog";
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private RegistryObject myObj;
    private JTextField regKeyField = new JTextField(30);
    private JTextField regValueField = new JTextField(30);
    private RestrictedPlainDocument keyDoc = new RestrictedPlainDocument(1024);
    private RestrictedPlainDocument stringDoc = new RestrictedPlainDocument(256);
    private RestrictedPlainDocument binaryDoc = new RestrictedPlainDocument(256);
    private static long MAX_REGISTRY_DWORD_VALUE = 0xFFFFFFFFL;
    private NumberPlainDocument dwordDoc = new NumberPlainDocument(MAX_REGISTRY_DWORD_VALUE);
    JRadioButton existRdBtn = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "RegistryPanel.exists"));
    JRadioButton notExistRdBtn = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "RegistryPanel.doesNotExist"));
    private JLabel regKeyLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "RegistryPanel.key"));
    private JLabel regValueTypeLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "RegistryPanel.valueType"));
    private JLabel regValueLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "RegistryPanel.value"));
    private DescriptionTextArea regNoteArea = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "RegistryPanel.nameEndsWithMeansChecking"));
    private JLabel regNoteLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "RegistryPanel.note"));
    private Dimension labelSize = new Dimension(1, 1);
    private static final String[] registryType = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "RegistryPanel.registryKey"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "RegistryPanel.registryKeyName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "RegistryPanel.registryValue")};
    private static final String[] regValueType = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "RegistryPanel.string"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "RegistryPanel.dword"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "RegistryPanel.binary")};
    private JComboBox<String> registryCmbBox = new JComboBox<String>(registryType);
    private JComboBox<String> regValueTypeCmbBox = new JComboBox<String>(regValueType);
    private boolean showAll = true;

    public Dimension getLabelSize() {
        return this.labelSize;
    }

    public RegistryPanel(JFrame parent, String title, boolean modal) {
        this(parent, title, modal, true);
    }

    public RegistryPanel(JFrame parent, String title, boolean modal, boolean showAll) {
        this.showAll = showAll;
        try {
            this.jbInit();
            this.changeStatus();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private void jbInit() {
        JPanel outpanel = new JPanel(new GridBagLayout());
        BoxLayout boxLayout = new BoxLayout(this, 1);
        this.setLayout(boxLayout);
        JLabel checkLbl = new JLabel(MessageResources.getInstance().getString(DLG, "RegistryPanel.check"));
        this.labelSize = this.getMaxSize(checkLbl);
        checkLbl.setPreferredSize(this.labelSize);
        outpanel.add((Component)checkLbl, this.getRegistryGridBagConstaint(0, 0));
        outpanel.add(this.registryCmbBox, this.getRegistryGridBagConstaint(1, 0));
        this.registryCmbBox.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistryPanel.this.registryTypeChanged();
            }
        });
        ButtonGroup buttonGrp = new ButtonGroup();
        buttonGrp.add(this.existRdBtn);
        buttonGrp.add(this.notExistRdBtn);
        this.existRdBtn.setSelected(true);
        JPanel panel1 = new JPanel(new FlowLayout(3));
        panel1.add(this.existRdBtn);
        panel1.add(Box.createRigidArea(new Dimension(10, 0)));
        panel1.add(this.notExistRdBtn);
        outpanel.add(Box.createRigidArea(new Dimension(1, 0)), this.getRegistryGridBagConstaint(0, 1));
        outpanel.add((Component)panel1, this.getRegistryGridBagConstaint(1, 1));
        this.regKeyField.setDocument(this.keyDoc);
        this.regValueField.setDocument(this.stringDoc);
        this.regKeyLbl.setPreferredSize(this.labelSize);
        outpanel.add((Component)this.regKeyLbl, this.getRegistryGridBagConstaint(0, 2));
        if (this.showAll) {
            JPanel panel2 = new JPanel(new FlowLayout(3));
            JLabel HKEYLbl = new JLabel("HKEY_LOCAL_MACHINE\\");
            panel2.add(HKEYLbl);
            panel2.add(this.regKeyField);
            outpanel.add((Component)panel2, this.getRegistryGridBagConstaint(1, 2));
        } else {
            outpanel.add((Component)this.regKeyField, this.getRegistryGridBagConstaint(1, 2));
        }
        outpanel.add((Component)this.regValueTypeLbl, this.getRegistryGridBagConstaint(0, 3));
        outpanel.add(this.regValueTypeCmbBox, this.getRegistryGridBagConstaint(1, 3));
        outpanel.add((Component)this.regValueLbl, this.getRegistryGridBagConstaint(0, 4));
        outpanel.add((Component)this.regValueField, this.getRegistryGridBagConstaint(1, 4));
        outpanel.add((Component)this.regNoteLbl, this.getRegistryGridBagConstaint(0, 5));
        outpanel.add((Component)this.regNoteArea, this.getRegistryGridBagConstaint(1, 5));
        outpanel.add((Component)new JLabel(""), this.getRegistryGridBagConstaint(0, 6));
        this.add(outpanel);
        this.regValueTypeCmbBox.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistryPanel.this.regValueTypeChanged();
            }
        });
    }

    private Dimension getMaxSize(JLabel checkLbl) {
        Dimension d = checkLbl.getPreferredSize();
        int maxWidth = d.width;
        if (maxWidth < this.regKeyLbl.getPreferredSize().width) {
            d = this.regKeyLbl.getPreferredSize();
            maxWidth = d.width;
        }
        if (maxWidth < this.regValueTypeLbl.getPreferredSize().width) {
            d = this.regValueTypeLbl.getPreferredSize();
            maxWidth = d.width;
        }
        if (maxWidth < this.regValueLbl.getPreferredSize().width) {
            d = this.regValueLbl.getPreferredSize();
            maxWidth = d.width;
        }
        if (maxWidth < this.regNoteLbl.getPreferredSize().width) {
            d = this.regNoteLbl.getPreferredSize();
            maxWidth = d.width;
        }
        return d;
    }

    private void changeStatus() {
        this.regValueTypeLbl.setVisible(false);
        this.regValueTypeCmbBox.setVisible(false);
        this.regValueLbl.setVisible(false);
        this.regValueField.setVisible(false);
        this.regNoteLbl.setVisible(false);
        this.regNoteArea.setVisible(false);
    }

    protected void regValueTypeChanged() {
        int index = this.regValueTypeCmbBox.getSelectedIndex();
        if (index == 0) {
            this.regValueField.setDocument(this.stringDoc);
        } else if (index == 1) {
            this.regValueField.setDocument(this.dwordDoc);
        } else {
            this.regValueField.setDocument(this.binaryDoc);
            this.binaryDoc.setValidator("01", true);
        }
    }

    protected void registryTypeChanged() {
        int index = this.registryCmbBox.getSelectedIndex();
        if (index == 0) {
            this.regKeyLbl.setText(MessageResources.getInstance().getString(DLG, "RegistryPanel.key"));
            this.existRdBtn.setText(MessageResources.getInstance().getString(DLG, "RegistryPanel.exists"));
            this.notExistRdBtn.setText(MessageResources.getInstance().getString(DLG, "RegistryPanel.doesNotExist"));
            this.regValueTypeLbl.setVisible(false);
            this.regValueTypeCmbBox.setVisible(false);
            this.regValueLbl.setVisible(false);
            this.regValueField.setVisible(false);
            this.regNoteLbl.setVisible(false);
            this.regNoteArea.setVisible(false);
        } else if (index == 1) {
            this.regKeyLbl.setText(MessageResources.getInstance().getString(DLG, "RegistryPanel.name_"));
            this.existRdBtn.setText(MessageResources.getInstance().getString(DLG, "RegistryPanel.exists"));
            this.notExistRdBtn.setText(MessageResources.getInstance().getString(DLG, "RegistryPanel.doesNotExist"));
            this.regValueTypeLbl.setVisible(false);
            this.regValueTypeCmbBox.setVisible(false);
            this.regValueLbl.setVisible(false);
            this.regValueField.setVisible(false);
            this.regNoteLbl.setVisible(false);
            this.regNoteArea.setVisible(false);
        } else if (index == 2) {
            this.regKeyLbl.setText(MessageResources.getInstance().getString(DLG, "RegistryPanel.name_"));
            this.existRdBtn.setText(MessageResources.getInstance().getString(DLG, "RegistryPanel.equalTo"));
            this.notExistRdBtn.setText(MessageResources.getInstance().getString(DLG, "RegistryPanel.notEqualTo"));
            this.regValueTypeLbl.setVisible(true);
            this.regValueTypeCmbBox.setVisible(true);
            this.regValueLbl.setVisible(true);
            this.regValueField.setVisible(true);
            this.regNoteLbl.setVisible(true);
            this.regNoteArea.setVisible(true);
        }
    }

    protected String getContentSensitiveHelpToken() {
        return "sesm_computersnusers_policies_gup_rule_set_add_edit_registries";
    }

    private GridBagConstraints getRegistryGridBagConstaint(int x, int y) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = x;
        cons.gridy = y;
        cons.anchor = 17;
        int left = 2;
        int right = 2;
        int top = 2;
        int bottom = 2;
        if (x > 0 && y > 0) {
            cons.gridwidth = 2;
        }
        if (y == 2 && x == 1 || y > 0 && x > 0) {
            cons.weightx = 0.5;
        }
        if (x == 1 && y == 3) {
            cons.ipadx = 50;
        }
        if (x == 0 && y == 5) {
            cons.anchor = 12;
        }
        if (x == 1 && y == 5) {
            cons.weightx = 1.0;
            cons.fill = 1;
        }
        if (y == 6) {
            cons.weighty = 1.0;
        }
        if (x == 0) {
            left = 10;
        }
        if (y == 5) {
            top = 5;
        }
        cons.insets = new Insets(top, left, bottom, right);
        return cons;
    }

    public void setObject(RegistryObject newObj) {
        this.myObj = newObj;
        this.updatePanel();
    }

    public void setObject(Object[] regData) {
        Integer regType = (Integer)regData[0];
        this.registryCmbBox.setSelectedIndex(regType);
        Integer retOperator = (Integer)regData[1];
        if (retOperator == 0) {
            this.existRdBtn.setSelected(true);
        } else {
            this.notExistRdBtn.setSelected(true);
        }
        String key = (String)regData[2];
        this.regKeyField.setText(key);
        if (regData[3] != null) {
            Integer regValueType = (Integer)regData[3];
            this.regValueTypeCmbBox.setSelectedIndex(regValueType);
        }
        if (regData[4] != null) {
            String value = (String)regData[4];
            this.regValueField.setText(value);
        }
    }

    private void updatePanel() {
        if (this.myObj != null) {
            if (this.myObj instanceof RegistryDataObject) {
                RegistryDataObject data = (RegistryDataObject)this.myObj;
                this.regValueTypeCmbBox.setSelectedIndex(data.getType());
                if (data.getOptOperator() == 0) {
                    this.existRdBtn.setSelected(true);
                } else {
                    this.notExistRdBtn.setSelected(true);
                }
                this.regKeyField.setText(data.getName() == null ? "" : data.getName());
                this.regValueField.setText(data.getValue() == null ? "" : data.getValue());
                this.registryCmbBox.setSelectedIndex(2);
            } else if (this.myObj instanceof RegistryKeyObject) {
                RegistryKeyObject data = (RegistryKeyObject)this.myObj;
                if (data.getOptOperator() == 0) {
                    this.existRdBtn.setSelected(true);
                } else {
                    this.notExistRdBtn.setSelected(true);
                }
                this.existRdBtn.setSelected(data.getOptOperator() == 0);
                this.regKeyField.setText(data.getKeyName());
                this.registryCmbBox.setSelectedIndex(0);
            } else if (this.myObj instanceof RegistryValueObject) {
                RegistryValueObject data = (RegistryValueObject)this.myObj;
                if (data.getOptOperator() == 0) {
                    this.existRdBtn.setSelected(true);
                } else {
                    this.notExistRdBtn.setSelected(true);
                }
                this.existRdBtn.setSelected(data.getOptOperator() == 0);
                this.regKeyField.setText(data.getValueName());
                this.registryCmbBox.setSelectedIndex(1);
            }
        }
    }

    public Object[] getCommitResult() {
        String keyName = this.regKeyField.getText().trim();
        int regType = this.registryCmbBox.getSelectedIndex();
        String regValue = this.regValueField.getText().trim();
        int regValueType = this.regValueTypeCmbBox.getSelectedIndex();
        Object[] regData = new Object[5];
        regData[0] = regType;
        regData[1] = this.existRdBtn.isSelected() ? Integer.valueOf(0) : Integer.valueOf(1);
        regData[2] = keyName;
        if (regType > 1) {
            regData[3] = regValueType;
            regData[4] = regValue;
        }
        return regData;
    }

    public RegistryObject getRegistryData() {
        int regType = this.registryCmbBox.getSelectedIndex();
        RegistryObject obj = null;
        switch (regType) {
            case 0: {
                RegistryKey key = new RegistryKey();
                key.setOptOperator(this.existRdBtn.isSelected() ? Integer.valueOf(0) : Integer.valueOf(1));
                key.setKeyName(this.regKeyField.getText().trim());
                obj = new RegistryKeyObject((ConfigObject)key);
                break;
            }
            case 1: {
                RegistryValue value = new RegistryValue();
                value.setOptOperator(this.existRdBtn.isSelected() ? Integer.valueOf(0) : Integer.valueOf(1));
                value.setValueName(this.regKeyField.getText().trim());
                obj = new RegistryValueObject((ConfigObject)value);
                break;
            }
            case 2: {
                RegistryData data = new RegistryData();
                data.setOptOperator(this.existRdBtn.isSelected() ? Integer.valueOf(0) : Integer.valueOf(1));
                data.setDataName(this.regKeyField.getText().trim());
                data.setDataValue(this.regValueField.getText().trim());
                data.setDataType(Integer.valueOf(this.regValueTypeCmbBox.getSelectedIndex()));
                obj = new RegistryDataObject((ConfigObject)data);
                break;
            }
        }
        return obj;
    }

    public boolean isValidate() {
        String keyName = this.regKeyField.getText().trim();
        int regType = this.registryCmbBox.getSelectedIndex();
        String msgName = MSGRES.getString(DLG, "RegistryPanel.registryKey");
        Object[] obj = new Object[]{msgName};
        if (keyName.length() == 0) {
            String str = MSGRES.getString(DLG, "RegistryPanel.cannotBeEmpty");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(this, fm, MSGRES.getString(DLG, "RegistryPanel.error"), 0);
            this.regKeyField.requestFocusInWindow();
            return false;
        }
        if (keyName.startsWith("\\")) {
            String str = MSGRES.getString(DLG, "RegistryPanel.cannotStartWith");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(this, fm, MSGRES.getString(DLG, "RegistryPanel.error"), 0);
            this.regKeyField.requestFocusInWindow();
            return false;
        }
        if (keyName.indexOf("\\\\") != -1) {
            String str = MSGRES.getString(DLG, "RegistryPanel.cannotContain");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(this, fm, MSGRES.getString(DLG, "RegistryPanel.error"), 0);
            this.regKeyField.requestFocusInWindow();
            return false;
        }
        if (!RegistryPanel.validateNoScriptParams(keyName) || !RegistryPanel.validateNoHtmlParams(keyName)) {
            String str = MSGRES.getString(DLG, "RegistryPanel.noScriptOrHtmlParams");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(this, fm, MSGRES.getString(DLG, "RegistryPanel.error"), 0);
            this.regKeyField.requestFocusInWindow();
            return false;
        }
        String regValue = this.regValueField.getText().trim();
        if (regType == 2 && regValue.length() == 0) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(DLG, "RegistryPanel.registryValueCannotBeEmpty"), MSGRES.getString(DLG, "RegistryPanel.error"), 0);
            this.regValueField.requestFocusInWindow();
            return false;
        }
        if (!RegistryPanel.validateNoScriptParams(regValue) || !RegistryPanel.validateNoHtmlParams(regValue)) {
            String str = MSGRES.getString(DLG, "RegistryPanel.noScriptOrHtmlParams");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(this, fm, MSGRES.getString(DLG, "RegistryPanel.error"), 0);
            this.regValueField.requestFocusInWindow();
            return false;
        }
        int regValueType = this.regValueTypeCmbBox.getSelectedIndex();
        if (regType == 2 && regValueType != 0 && keyName.endsWith("\\")) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(DLG, "RegistryPanel.defaultValueOnlySupports"), MSGRES.getString(DLG, "RegistryPanel.error"), 0);
            this.regValueTypeCmbBox.requestFocusInWindow();
            return false;
        }
        return true;
    }

    private static boolean validateNoScriptParams(String val) {
        if (val != null) {
            val = val.toLowerCase();
            for (int i = 0; i < SCRIPT_FILTER_PARAMS.length; ++i) {
                if (val.indexOf(SCRIPT_FILTER_PARAMS[i]) <= -1) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean validateNoHtmlParams(String val) {
        if (val != null) {
            val = val.toLowerCase();
            for (int i = 0; i < HTML_FILTER_PARAMS.length; ++i) {
                if (val.indexOf(HTML_FILTER_PARAMS[i]) <= -1) continue;
                return false;
            }
        }
        return true;
    }
}

