/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.schema.RebootOptions;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.MultiLineLabel;
import com.sygate.scm.common.ui.RestrictedPathDocument;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.util.TimeSpinner1;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.i18n.ConsoleMessageResourcesFile;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;

public class RebootOptionsPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JCheckBox lock = new JCheckBox(AvConstants.unlockIcon);
    private final JLabel jLblRestartMethodDesc;
    private final TimeSpinner1 timeSpinner;
    private boolean hasHour;
    private boolean hasMinute;
    private boolean hasAmpm;
    private String hourPattern;
    private final String timePattern = MessageResources.getInstance().getString("com.sygate.scm.util.util", "timePattern");
    private static final MessageResourcesFile MSGRES = new ConsoleMessageResourcesFile("com.sygate.scm.console.ui.policy.dialog.policydialog");
    private static final String[] COMBO_CHOICES_DAYS = new String[]{MSGRES.getString("GlobalSettingDlg.choiceDaily"), MSGRES.getString("GlobalSettingDlg.choiceMonday"), MSGRES.getString("GlobalSettingDlg.choiceTuesday"), MSGRES.getString("GlobalSettingDlg.choiceWednesday"), MSGRES.getString("GlobalSettingDlg.choiceThursday"), MSGRES.getString("GlobalSettingDlg.choiceFriday"), MSGRES.getString("GlobalSettingDlg.choiceSaturday"), MSGRES.getString("GlobalSettingDlg.choiceSunday")};
    public JComboBox<String> jCBRebootDay = new JComboBox<String>(COMBO_CHOICES_DAYS);
    JPanel cardPanelForSnooze;
    static final String SNOOZEMINUTEPANEL = "SNOOZEMINUTEPANEL";
    static final String SNOOZETEXTPANEL = "SNOOZETEXTPANEL";
    static final String SNOOZENAPANEL = "SNOOZENAPANEL";
    private static final int SNOOZE_COUNT_MIN = 1;
    private static final int SNOOZE_COUNT_MAX = 99;
    private static final int SNOOZE_COUNT_DEF = 5;
    private static final int SNOOZE_INTERVAL_MIN = 1;
    private static final int SNOOZE_INTERVAL_MAX = 240;
    private static final int SNOOZE_INTERVAL_DEF = 60;
    private static final int RANDOMIZE_HOURS_MIN = 1;
    private static final int RANDOMIZE_HOURS_MAX = 8;
    private static final int RANDOMIZE_HOURS_DEF = 2;
    private static final int COUNTDOWN_INTERVAL_DEF = 5;
    private static final int COUNTDOWN_INTERVAL_MAX = 60;
    private static final int COUNTDOWN_INTERVAL_MIN = 1;
    public static final int NORMAL_MODE = 0;
    public static final int COMMAND_MODE = 1;
    public static final int INSTALL_MODE = 2;
    public static final int SMR_MODE = 3;
    private final JSpinner jSPMaxNumber = new JSpinner(new SpinnerNumberModel(5, 1, 99, 1));
    private final JSpinner jSPSnoozeInterval = new JSpinner(new SpinnerNumberModel(60, 1, 240, 1));
    private final JSpinner jSPCountdown = new JSpinner(new SpinnerNumberModel(5, 1, 60, 1));
    private final JCheckBox jChkRandomize;
    RebootOptions options;
    public String hardRestartStr;
    public String autoRestartStr;
    public String hardRestartTitle;
    public String autoRestartTitle;
    public String noPromptStr;
    public String promptCountdownStr;
    public String promptSnoozeStr;
    public String promptSnoozeStrScheduled;
    private static final String RESTART_METHOD_DESCRIPTION = MSGRES.getString("GlobalSettingDlg.restartMethodDesc");
    String clientRestartOptionsTitle;
    String serverRestartOptionsTitle;
    String noRestartOptionsTitle;
    String customRestartOptionsTitle;
    String clientLabelStr1;
    String serverLabelStr1;
    String noLabelStr1;
    String customLabelStr1;
    MultiLineLabel descLabel1;
    JLabel jLblCountdownMinutes;
    JLabel jLblMinutes;
    String restartImmediatelyStr;
    String restartAtThisTimeStr;
    String restartUpToThisTimeStr;
    private static final String REBOOT_DEFAULT_MSG = MSGRES.getString("GlobalSettingDlg.rebootDefaultMessage");
    private static final String REBOOT_WINDOWS_INSTALL_MSG = MSGRES.getString("GlobalSettingDlg.rebootInstallMessage");
    private static final String REBOOT_MAC_INSTALL_MSG = MSGRES.getString("GlobalSettingDlg.rebootMacInstallMessage");
    private static final String REBOOT_COMMAND_MSG = MSGRES.getString("GlobalSettingDlg.rebootCommandMessage");
    public JRadioButton jRBNoPrompt;
    public JRadioButton jRBPromptCountdown;
    public JRadioButton jRBPromptSnooze;
    private final JSpinner jSPRandomizeHours;
    public JPanel contentPanel;
    static final String SERVERPANEL = "ServerPanel";
    static final String CLIENTPANEL = "ClientPanel";
    static final String NOPANEL = "NoPanel";
    static final String CUSTOMPANEL = "CustomPanel";
    static final String IMMEDIATELY = "Now";
    static final String LATER = "Later";
    public JCheckBox jChkHardRestart;
    public JCheckBox jChkAutoRestart;
    public JPanel centerPanel;
    public MultiLineLabel jLblHardRestart;
    public MultiLineLabel jLblAutoRestart;
    public JLabel jLblNA;
    public JLabel jLblScheduledTime;
    public JLabel jLblNA2;
    public JRadioButton jRBServerRestart;
    public JRadioButton jRBClientRestart;
    public JRadioButton jRBNoRestart;
    public JRadioButton jRBCustomRestart;
    public JRadioButton jRBRestartImmediately;
    public JRadioButton jRBRestartAtThisTime;
    public ButtonGroup typeOfRestartBG;
    public ButtonGroup promptBG;
    public ButtonGroup restartTimeBG;
    public JPanel promptAndAllowSnoozePanel;
    public JPanel countdownPanel;
    private final JTextArea messageTxtArea;
    private final JPanel snoozeTextPanel;
    private final JPanel snoozeNAPanel;
    private final JPanel mytemp;
    private final JLabel jlblRandomHour;
    private int mode;
    private Platform platform;
    private final JSpinner jSPPromptAllowSnooze;

    private static String guaranteeStringLength(String msg) {
        if (msg.length() >= 500) {
            return msg;
        }
        StringBuilder buf = new StringBuilder(msg);
        while (buf.length() < 500) {
            buf.append("    ");
        }
        return buf.toString();
    }

    public RebootOptionsPanel() {
        this(0);
    }

    public RebootOptionsPanel(int displayMode) {
        this(displayMode, Platform.WINDOWS);
    }

    public RebootOptionsPanel(int displayMode, Platform platform) {
        UIUtilities.enableOnlyValidEdits(this.jSPMaxNumber);
        UIUtilities.enableOnlyValidEdits(this.jSPSnoozeInterval);
        UIUtilities.enableOnlyValidEdits(this.jSPCountdown);
        this.jChkRandomize = new JCheckBox(MSGRES.getString("GlobalSettingDlg.randomizeMsg"));
        this.hardRestartStr = MSGRES.getString("GlobalSettingDlg.hardRestartStr");
        this.autoRestartStr = MSGRES.getString("GlobalSettingDlg.autoRestartStr");
        this.hardRestartTitle = MSGRES.getString("GlobalSettingDlg.hardRestartTitle");
        this.autoRestartTitle = MSGRES.getString("GlobalSettingDlg.autoRestartTitle");
        this.noPromptStr = MSGRES.getString("GlobalSettingDlg.noPromptStr");
        this.promptCountdownStr = MSGRES.getString("GlobalSettingDlg.promptCountdownStr");
        this.promptSnoozeStr = MSGRES.getString("GlobalSettingDlg.promptSnoozeStr");
        this.promptSnoozeStrScheduled = MSGRES.getString("GlobalSettingDlg.promptSnoozeStrScheduled");
        this.clientRestartOptionsTitle = MSGRES.getString("GlobalSettingDlg.clientRestartOptionsTitle");
        this.serverRestartOptionsTitle = MSGRES.getString("GlobalSettingDlg.serverRestartOptionsTitle");
        this.noRestartOptionsTitle = MSGRES.getString("GlobalSettingDlg.noRestartOptionsTitle");
        this.customRestartOptionsTitle = MSGRES.getString("GlobalSettingDlg.customRestartOptionsTitle");
        this.clientLabelStr1 = RebootOptionsPanel.guaranteeStringLength(MSGRES.getString("GlobalSettingDlg.clientLabelStr1"));
        this.serverLabelStr1 = RebootOptionsPanel.guaranteeStringLength(MSGRES.getString("GlobalSettingDlg.serverLabelStr1"));
        this.noLabelStr1 = RebootOptionsPanel.guaranteeStringLength(MSGRES.getString("GlobalSettingDlg.noLabelStr1"));
        this.customLabelStr1 = RebootOptionsPanel.guaranteeStringLength(MSGRES.getString("GlobalSettingDlg.customLabelStr1"));
        this.descLabel1 = new MultiLineLabel(this.clientLabelStr1);
        this.jLblCountdownMinutes = new JLabel(MSGRES.getString("GlobalSettingDlg.minutes"));
        this.jLblMinutes = new JLabel(MSGRES.getString("GlobalSettingDlg.minutes"));
        this.restartImmediatelyStr = MSGRES.getString("GlobalSettingDlg.immediately");
        this.restartAtThisTimeStr = MSGRES.getString("GlobalSettingDlg.atThisTime");
        this.restartUpToThisTimeStr = MSGRES.getString("GlobalSettingDlg.upToThisTime");
        this.jRBNoPrompt = new JRadioButton(this.noPromptStr);
        this.jRBPromptCountdown = new JRadioButton(this.promptCountdownStr);
        this.jRBPromptSnooze = new JRadioButton(this.promptSnoozeStr);
        this.jSPRandomizeHours = new JSpinner(new SpinnerNumberModel(2, 1, 8, 1));
        UIUtilities.enableOnlyValidEdits(this.jSPRandomizeHours);
        this.jChkHardRestart = new JCheckBox(this.hardRestartTitle);
        this.jChkAutoRestart = new JCheckBox(this.autoRestartTitle);
        this.jLblHardRestart = new MultiLineLabel(this.hardRestartStr);
        this.jLblAutoRestart = new MultiLineLabel(this.autoRestartStr);
        this.jLblNA = new JLabel(MSGRES.getString("GlobalSettingDlg.NA"));
        this.jLblScheduledTime = new JLabel(MSGRES.getString("GlobalSettingDlg.ScheduledTime"));
        this.jLblNA2 = new JLabel(MSGRES.getString("GlobalSettingDlg.NA"));
        this.jRBServerRestart = new JRadioButton(MSGRES.getString("GlobalSettingDlg.serverRestart"));
        this.jRBClientRestart = new JRadioButton(MSGRES.getString("GlobalSettingDlg.clientRestart"));
        this.jRBNoRestart = new JRadioButton(MSGRES.getString("GlobalSettingDlg.noRestart"));
        this.jRBCustomRestart = new JRadioButton(MSGRES.getString("GlobalSettingDlg.customRestart"));
        this.jRBRestartImmediately = new JRadioButton(this.restartImmediatelyStr);
        this.jRBRestartAtThisTime = new JRadioButton(this.restartAtThisTimeStr);
        this.typeOfRestartBG = new ButtonGroup();
        this.promptBG = new ButtonGroup();
        this.restartTimeBG = new ButtonGroup();
        this.messageTxtArea = new JTextArea((Document)new RestrictedPathDocument(255), MSGRES.getString("GlobalSettingDlg.administratorNeedsToRebootYourMachine"), 2, 30);
        this.mytemp = new JPanel(new FlowLayout(0, 5, 0));
        this.jlblRandomHour = new JLabel(MSGRES.getString("GlobalSettingDlg.hours"));
        this.mode = 0;
        this.platform = Platform.WINDOWS;
        this.jSPPromptAllowSnooze = new JSpinner(new SpinnerNumberModel(5, 5, 60, 1));
        UIUtilities.enableOnlyValidEdits(this.jSPPromptAllowSnooze);
        this.lock.setSelectedIcon(AvConstants.lockIcon);
        this.platform = platform;
        this.mode = displayMode;
        this.timeSpinner = new TimeSpinner1(this.timePattern);
        if (this.timePattern.indexOf("h") != -1) {
            this.hourPattern = "h";
            this.hasHour = true;
        }
        if (this.timePattern.indexOf("H") != -1) {
            this.hourPattern = "H";
            this.hasHour = true;
        }
        if (this.timePattern.indexOf("k") != -1) {
            this.hourPattern = "k";
            this.hasHour = true;
        }
        if (this.timePattern.indexOf("K") != -1) {
            this.hourPattern = "K";
            this.hasHour = true;
        }
        if (this.timePattern.indexOf("m") != -1) {
            this.hasMinute = true;
        }
        if (this.timePattern.indexOf("a") != -1) {
            this.hasAmpm = true;
        }
        this.setLayout(new BorderLayout());
        this.messageTxtArea.setText(this.getDefaultRebootMessage(this.mode, platform));
        this.messageTxtArea.setLineWrap(true);
        this.messageTxtArea.setWrapStyleWord(true);
        this.promptAndAllowSnoozePanel = new JPanel(new FlowLayout(0, 5, 0));
        this.snoozeTextPanel = new JPanel(new FlowLayout(0, 5, 0));
        this.snoozeNAPanel = new JPanel(new FlowLayout(0, 5, 0));
        Dimension d = this.jRBPromptSnooze.getPreferredSize();
        Dimension dAdjusted = new Dimension(d.width + 100, d.height);
        this.jRBPromptSnooze.setMinimumSize(dAdjusted);
        Dimension d2 = this.jSPPromptAllowSnooze.getPreferredSize();
        Dimension d2Adjusted = new Dimension(d2.width + 20, d.height);
        this.jSPPromptAllowSnooze.setPreferredSize(d2Adjusted);
        this.jRBPromptSnooze.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RebootOptionsPanel.this.jSPPromptAllowSnooze.setEnabled(RebootOptionsPanel.this.jRBPromptSnooze.isSelected());
            }
        });
        this.promptAndAllowSnoozePanel.add(this.jRBPromptSnooze);
        this.mytemp.removeAll();
        this.mytemp.add(this.jSPPromptAllowSnooze);
        this.mytemp.add(this.jLblMinutes);
        this.promptAndAllowSnoozePanel.add(this.mytemp);
        this.cardPanelForSnooze = new JPanel(new CardLayout());
        this.cardPanelForSnooze.add((Component)this.promptAndAllowSnoozePanel, SNOOZEMINUTEPANEL);
        this.cardPanelForSnooze.add((Component)this.snoozeTextPanel, SNOOZETEXTPANEL);
        this.cardPanelForSnooze.add((Component)this.snoozeNAPanel, SNOOZENAPANEL);
        this.countdownPanel = new JPanel(new FlowLayout(0, 5, 0));
        this.jRBPromptCountdown.setPreferredSize(dAdjusted);
        this.jSPCountdown.setPreferredSize(this.jSPPromptAllowSnooze.getPreferredSize());
        this.jRBPromptCountdown.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RebootOptionsPanel.this.jSPCountdown.setEnabled(RebootOptionsPanel.this.jRBPromptCountdown.isSelected());
            }
        });
        this.countdownPanel.add(this.jRBPromptCountdown);
        JPanel mytemp2 = new JPanel(new FlowLayout(0, 5, 0));
        mytemp2.add(this.jSPCountdown);
        mytemp2.add(this.jLblCountdownMinutes);
        this.countdownPanel.add(mytemp2);
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.jLblRestartMethodDesc = new JLabel(RESTART_METHOD_DESCRIPTION);
        JPanel warningAndChoice = new JPanel(new BorderLayout());
        warningAndChoice.add((Component)this.getChoicePanel(), "Center");
        this.contentPanel.add((Component)warningAndChoice, "North");
        this.centerPanel = this.getMainPanel();
        this.contentPanel.add((Component)this.centerPanel, "Center");
        this.contentPanel.add((Component)new JPanel(), "East");
        this.contentPanel.add((Component)new JPanel(), "West");
        if (this.mode == 0) {
            JPanel lockPanel = new JPanel(new BorderLayout());
            lockPanel.add((Component)this.lock, "West");
            this.add((Component)lockPanel, "North");
        }
        this.add((Component)this.contentPanel, "Center");
        this.add((Component)new JPanel(), "East");
        this.add((Component)new JPanel(), "West");
        this.jLblNA.setEnabled(false);
        this.jLblNA2.setEnabled(false);
        RebootOptions opts = this.getDefaultRebootOptionsByMode(this.mode, this.platform);
        this.updateSettings(opts);
        if (this.mode == 1 || this.mode == 3) {
            this.jRBNoRestart.setVisible(false);
            this.jRBCustomRestart.doClick();
        }
    }

    public boolean getPromptUser() {
        return !this.jRBNoPrompt.isSelected();
    }

    public int getPromptType() {
        if (this.jRBPromptCountdown.isSelected()) {
            return RebootOptions.COUNTDOWN;
        }
        return RebootOptions.SNOOZE;
    }

    public void setRebootMethod(Integer method) {
        if (method.equals(RebootOptions.CLIENT)) {
            this.jRBClientRestart.doClick();
        } else if (method.equals(RebootOptions.SERVER)) {
            this.jRBServerRestart.doClick();
        } else if (method.equals(RebootOptions.NONE)) {
            this.jRBNoRestart.doClick();
        } else if (method.equals(RebootOptions.CUSTOM)) {
            this.jRBCustomRestart.doClick();
        }
    }

    public Integer getRebootMethod() {
        if (this.jRBClientRestart.isSelected()) {
            return RebootOptions.CLIENT;
        }
        if (this.jRBServerRestart.isSelected()) {
            return RebootOptions.SERVER;
        }
        if (this.jRBNoRestart.isSelected()) {
            return RebootOptions.NONE;
        }
        if (this.jRBCustomRestart.isSelected()) {
            return RebootOptions.CUSTOM;
        }
        return null;
    }

    public void setRebootSchedule(Integer schedule) {
        if (schedule.equals(RebootOptions.NOW) && this.jRBRestartImmediately.isEnabled()) {
            this.jRBRestartImmediately.setSelected(true);
            this.jRBRestartImmediately.doClick();
        } else {
            this.jRBRestartAtThisTime.setSelected(true);
        }
    }

    public Integer getRebootSchedule() {
        if (this.jRBRestartImmediately.isSelected()) {
            return RebootOptions.NOW;
        }
        return RebootOptions.LATER;
    }

    public void setPromptMessage(String msg) {
        this.messageTxtArea.setText(msg);
    }

    public String getPromptMessage() {
        return this.messageTxtArea.getText();
    }

    public Boolean getHardRestart() {
        return this.jChkHardRestart.isSelected();
    }

    public Boolean getAutoRestart() {
        return this.jChkAutoRestart.isSelected();
    }

    public void setHardRestart(boolean hardRestart) {
        this.jChkHardRestart.setSelected(hardRestart);
    }

    public void setAutoRestart(boolean autoRestart) {
        this.jChkAutoRestart.setSelected(autoRestart);
    }

    public boolean getIsRebootRandomized() {
        return this.jChkRandomize.isSelected();
    }

    public void setIsRebootRandomized(boolean b) {
        this.jChkRandomize.setSelected(b);
    }

    public Integer getRandomizeHours() {
        return (Integer)this.jSPRandomizeHours.getValue();
    }

    private final int rangeCheck(int input, int myMin, int myMax) {
        int returnVal = input;
        if (returnVal < myMin) {
            returnVal = myMin;
        } else if (returnVal > myMax) {
            returnVal = myMax;
        }
        return returnVal;
    }

    public void setRandomizeHours(Integer i) {
        int myint = this.rangeCheck(i, 1, 8);
        this.jSPRandomizeHours.setValue(myint);
    }

    public void setCountdown(Integer i) {
        int myint = this.rangeCheck(i, 1, 60);
        this.jSPCountdown.setValue(myint);
    }

    public void setSnoozeInterval(Integer i) {
        int myint = this.rangeCheck(i, 1, 240);
        this.jSPPromptAllowSnooze.setValue(myint);
    }

    public Integer getCountdown() {
        return (Integer)this.jSPCountdown.getValue();
    }

    public Integer getSnoozeInterval() {
        return (Integer)this.jSPPromptAllowSnooze.getValue();
    }

    public void setPromptUser(boolean prompt, int promptType) {
        if (!prompt) {
            this.jRBNoPrompt.setSelected(true);
        } else if (promptType == RebootOptions.COUNTDOWN) {
            this.jRBPromptCountdown.setSelected(true);
        } else {
            this.jRBPromptSnooze.setSelected(true);
        }
    }

    public Integer getRebootDay() {
        return this.jCBRebootDay.getSelectedIndex();
    }

    public void setRebootDay(Integer i) {
        this.jCBRebootDay.setSelectedIndex(i);
    }

    public void setRebootMinutes(Integer i) {
        int hr = 0;
        int minute = 0;
        int ampm = 0;
        Long stTime = (long)i.intValue() * 1L;
        if (stTime != null) {
            int startTime = stTime.intValue();
            int hourOfDay = startTime / 60;
            if (this.hasAmpm) {
                ampm = Utility.getAmpmFrom_H_Pattern((int)hourOfDay, (String)this.hourPattern);
            }
            if (this.hasHour) {
                hr = Utility.convertHourFrom_H_Pattern((int)hourOfDay, (String)this.hourPattern);
            }
            if (this.hasMinute) {
                minute = startTime - hourOfDay * 60;
            }
        }
        this.timeSpinner.setHour(hr);
        this.timeSpinner.setMinute(minute);
        if (this.hasAmpm) {
            this.timeSpinner.setAmpm(ampm);
        }
    }

    public Integer getRebootMinutes() {
        int hr = 0;
        int minute = 0;
        int ampm = -1;
        if (this.hasHour) {
            hr = this.timeSpinner.getHour();
            if (this.hasAmpm) {
                ampm = this.timeSpinner.getAmpm();
            }
            hr = Utility.convertHourTo_H_Pattern((int)hr, (String)this.hourPattern, (int)ampm);
        }
        if (this.hasMinute) {
            minute = this.timeSpinner.getMinute();
        }
        return hr * 60 + minute;
    }

    public RebootOptions saveSettings(RebootOptions rop) {
        if (rop == null) {
            rop = this.getDefaultRebootOptionsByMode(this.mode, this.platform);
        }
        rop.setOptRebootMinutes(this.getRebootMinutes());
        if (this.jRBClientRestart.isSelected()) {
            rop.setOptRebootMethod(RebootOptions.CLIENT);
        } else if (this.jRBServerRestart.isSelected()) {
            rop.setOptRebootMethod(RebootOptions.SERVER);
        } else if (this.jRBNoRestart.isSelected()) {
            rop.setOptRebootMethod(RebootOptions.NONE);
        } else if (this.jRBCustomRestart.isSelected()) {
            rop.setOptRebootMethod(RebootOptions.CUSTOM);
        }
        if (this.jRBPromptCountdown.isSelected()) {
            rop.setOptPromptUser(Boolean.valueOf(true));
            rop.setOptPromptType(RebootOptions.COUNTDOWN);
        } else if (this.jRBPromptSnooze.isSelected()) {
            rop.setOptPromptUser(Boolean.valueOf(true));
            rop.setOptPromptType(RebootOptions.SNOOZE);
        } else {
            rop.setOptPromptUser(Boolean.valueOf(false));
            rop.setOptPromptType(RebootOptions.SNOOZE);
        }
        rop.setOptPromptMessage(this.getPromptMessage());
        rop.setOptRebootSchedule(this.getRebootSchedule());
        rop.setOptRebootDay(this.getRebootDay());
        rop.setOptRandomize(Boolean.valueOf(this.getIsRebootRandomized()));
        rop.setOptRandomizeHours(this.getRandomizeHours());
        rop.setOptSnoozeInterval(this.getSnoozeInterval());
        rop.setOptCountdown(this.getCountdown());
        rop.setOptHardReboot(this.getHardRestart());
        rop.setOptAutoReboot(this.getAutoRestart());
        if (this.mode == 0) {
            rop.setOptLocked(Boolean.valueOf(this.lock.isSelected()));
        }
        return rop;
    }

    public void updateSettings(RebootOptions rop) {
        String message;
        if (rop == null) {
            rop = this.getDefaultRebootOptionsByMode(this.mode, this.platform);
        }
        this.options = rop;
        Integer rebootMethod = this.options.getOptRebootMethod() != null ? this.options.getOptRebootMethod() : this.options.getDefRebootMethod();
        this.setRebootMethod(rebootMethod);
        Integer rebootMinutes = this.options.getOptRebootMinutes() != null ? this.options.getOptRebootMinutes() : this.options.getDefRebootMinutes();
        this.setRebootMinutes(rebootMinutes);
        boolean bPrompt = this.options.getOptPromptUser() != null ? this.options.getOptPromptUser() : this.options.getDefPromptUser();
        int iPromptType = this.options.getOptPromptType() != null ? this.options.getOptPromptType() : this.options.getDefPromptType();
        this.setPromptUser(bPrompt, iPromptType);
        boolean bHardReboot = this.options.getOptHardReboot() != null ? this.options.getOptHardReboot() : this.options.getDefHardReboot();
        this.setHardRestart(bHardReboot);
        boolean bAutoReboot = this.options.getOptAutoReboot() != null ? this.options.getOptAutoReboot() : this.options.getDefAutoReboot();
        this.setAutoRestart(bAutoReboot);
        Integer rebootSchedule = this.options.getOptRebootSchedule() != null ? this.options.getOptRebootSchedule() : this.options.getDefRebootSchedule();
        this.setRebootSchedule(rebootSchedule);
        Integer rebootDay = this.options.getOptRebootDay() != null ? this.options.getOptRebootDay() : this.options.getDefRebootDay();
        this.setRebootDay(rebootDay);
        Boolean randomize = this.options.getOptRandomize() != null ? this.options.getOptRandomize() : this.options.getDefRandomize();
        this.setIsRebootRandomized(randomize);
        Integer randomizeHours = this.options.getOptRandomizeHours() != null ? this.options.getOptRandomizeHours() : this.options.getDefRandomizeHours();
        this.setRandomizeHours(randomizeHours);
        Integer countdown = this.options.getOptCountdown() != null ? this.options.getOptCountdown() : this.options.getDefCountdown();
        this.setCountdown(countdown);
        Integer snoozeInterval = this.options.getOptSnoozeInterval() != null ? this.options.getOptSnoozeInterval() : this.options.getDefSnoozeInterval();
        this.setSnoozeInterval(snoozeInterval);
        if (this.mode == 0) {
            Boolean b = rop.getOptLocked();
            if (b == null) {
                b = rop.getDefLocked();
            }
            if (b.equals(Boolean.TRUE)) {
                this.lock.setSelected(true);
            } else {
                this.lock.setSelected(false);
            }
        }
        if ((message = this.options.getOptPromptMessage()) != null) {
            this.setPromptMessage(message);
        }
        this.updateUI();
    }

    private JPanel getDescriptionPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)this.descLabel1, "Center");
        return p;
    }

    public JPanel getRestartPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        this.jRBRestartAtThisTime.setActionCommand(LATER);
        this.jRBRestartAtThisTime.addActionListener(this);
        this.jRBRestartImmediately.setActionCommand(IMMEDIATELY);
        this.jRBRestartImmediately.addActionListener(this);
        int row = 0;
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
            Dimension size = this.jSPRandomizeHours.getPreferredSize();
            this.jSPRandomizeHours.setPreferredSize(new Dimension(35, size.height));
        });
        JLabel l = new JLabel(MSGRES.getString("GlobalSettingDlg.restartClientComputerHeader"));
        l = this.emboldenLabel(l);
        Dimension dprime = l.getPreferredSize();
        l.setPreferredSize(new Dimension(235, dprime.height));
        p.add((Component)l, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel tmp1 = new JPanel(new FlowLayout(0, 5, 0));
        JLabel dummy = new JLabel("  ");
        tmp1.add(this.jRBRestartAtThisTime);
        tmp1.add(this.timeSpinner);
        tmp1.add(dummy);
        tmp1.add(this.jCBRebootDay);
        JPanel tmp2 = new JPanel(new FlowLayout(2, 5, 2));
        this.jChkRandomize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RebootOptionsPanel.this.jSPRandomizeHours.setEnabled(RebootOptionsPanel.this.jChkRandomize.isSelected());
                RebootOptionsPanel.this.jlblRandomHour.setEnabled(RebootOptionsPanel.this.jChkRandomize.isSelected());
            }
        });
        tmp2.add(this.jChkRandomize);
        tmp2.add(this.jSPRandomizeHours);
        tmp2.add(this.jlblRandomHour);
        JPanel tmp3 = new JPanel(new BorderLayout());
        tmp3.add((Component)tmp1, "Center");
        tmp3.add((Component)tmp2, "South");
        JPanel tmp4 = new JPanel(new FlowLayout(0, 5, 0));
        JPanel tmp5 = new JPanel(new BorderLayout());
        tmp4.add(this.jRBRestartImmediately);
        tmp5.add((Component)tmp4, "Center");
        p.add((Component)tmp5, new GridBagConstraints(1, row++, 5, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        p.add((Component)tmp3, new GridBagConstraints(1, row++, 5, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        return p;
    }

    private JPanel getPromptPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        int row = 0;
        this.promptBG.add(this.jRBNoPrompt);
        this.promptBG.add(this.jRBPromptCountdown);
        this.promptBG.add(this.jRBPromptSnooze);
        JPanel temp = new JPanel(new FlowLayout(0, 5, 0));
        temp.add(this.jRBNoPrompt);
        JLabel l = new JLabel(MSGRES.getString("GlobalSettingDlg.promptHeader"));
        l = this.emboldenLabel(l);
        Dimension d = l.getPreferredSize();
        l.setPreferredSize(new Dimension(150, d.height));
        p.add((Component)l, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        p.add((Component)temp, new GridBagConstraints(1, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        p.add((Component)this.countdownPanel, new GridBagConstraints(1, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        p.add((Component)this.cardPanelForSnooze, new GridBagConstraints(1, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        return p;
    }

    private JPanel getMessagePanel() {
        int row = 0;
        JPanel messagePanel = new JPanel(new GridBagLayout());
        JLabel l = new JLabel(MSGRES.getString("GlobalSettingDlg.restartMessageHeader"));
        l = this.emboldenLabel(l);
        Dimension d = l.getPreferredSize();
        l.setPreferredSize(new Dimension(165, d.height));
        messagePanel.add((Component)l, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane areaScrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)areaScrollPane, (JTextArea)this.messageTxtArea);
        areaScrollPane.setVerticalScrollBarPolicy(20);
        areaScrollPane.setHorizontalScrollBarPolicy(31);
        areaScrollPane.setPreferredSize(new Dimension(500, 60));
        messagePanel.add((Component)areaScrollPane, new GridBagConstraints(1, row, 2, 2, 0.0, 0.0, 17, 0, new Insets(5, 20, 5, 0), 0, 0));
        return messagePanel;
    }

    private JPanel getCheckboxPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        int row = 0;
        JLabel l = new JLabel(MSGRES.getString("GlobalSettingDlg.otherOptionsHeader"));
        l = this.emboldenLabel(l);
        Dimension d = l.getPreferredSize();
        l.setPreferredSize(new Dimension(165, d.height));
        p.add((Component)l, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        p.add((Component)this.jChkHardRestart, new GridBagConstraints(1, row++, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        p.add((Component)this.jLblHardRestart, new GridBagConstraints(2, row++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 50, 0, 0), 0, 0));
        p.add((Component)this.jChkAutoRestart, new GridBagConstraints(1, row++, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        p.add((Component)this.jLblAutoRestart, new GridBagConstraints(2, row++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 50, 0, 0), 0, 0));
        return p;
    }

    public JPanel getMainPanel() {
        this.restartTimeBG.add(this.jRBRestartImmediately);
        this.restartTimeBG.add(this.jRBRestartAtThisTime);
        ActionListener listernerObject = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RebootOptionsPanel.this.setRandomizeBlockEnabled(RebootOptionsPanel.this.jRBRestartAtThisTime.isSelected());
            }
        };
        this.jRBRestartImmediately.addActionListener(listernerObject);
        this.jRBRestartAtThisTime.addActionListener(listernerObject);
        int row = 0;
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        JPanel descriptionPanel = this.getDescriptionPanel();
        p.add((Component)descriptionPanel, new GridBagConstraints(0, row++, 5, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 0, 0), 0, 0));
        JPanel restartPanel = this.getRestartPanel();
        p.add((Component)restartPanel, new GridBagConstraints(0, row++, 5, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        JPanel promptPanel = this.getPromptPanel();
        p.add((Component)new JSeparator(), new GridBagConstraints(0, row++, 5, 1, 0.0, 0.0, 10, 1, new Insets(2, 5, 0, 5), 0, 0));
        p.add((Component)promptPanel, new GridBagConstraints(0, row++, 5, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        JPanel messagePanel = this.getMessagePanel();
        p.add((Component)new JSeparator(), new GridBagConstraints(0, row++, 5, 1, 0.0, 0.0, 10, 1, new Insets(2, 5, 0, 5), 0, 0));
        p.add((Component)messagePanel, new GridBagConstraints(0, row++, 5, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        JPanel checkboxPanel = this.getCheckboxPanel();
        p.add((Component)new JSeparator(), new GridBagConstraints(0, row++, 5, 1, 0.0, 0.0, 10, 1, new Insets(2, 5, 0, 5), 0, 0));
        p.add((Component)checkboxPanel, new GridBagConstraints(0, row++, 5, 1, 1.0, 0.0, 17, 1, new Insets(0, 20, 0, 0), 0, 0));
        JScrollPane scrollPane = new JScrollPane(p, 20, 31);
        scrollPane.setBorder(null);
        scrollPane.setBackground(p.getBackground());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)scrollPane, "North");
        return mainPanel;
    }

    private JLabel emboldenLabel(JLabel label) {
        label.setFont(UIFontUtilities.BOLD_FONT);
        return label;
    }

    private JPanel getChoicePanel() {
        JPanel restartPanel = new JPanel();
        restartPanel.setLayout(new GridBagLayout());
        int row = 0;
        JLabel l = new JLabel(MSGRES.getString("GlobalSettingDlg.restartMethod"));
        l = this.emboldenLabel(l);
        Dimension d = l.getPreferredSize();
        l.setPreferredSize(new Dimension(140, d.height));
        restartPanel.add((Component)this.jLblRestartMethodDesc, new GridBagConstraints(0, row++, 6, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 20, 0), 0, 0));
        restartPanel.add((Component)l, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        restartPanel.add((Component)this.jRBServerRestart, new GridBagConstraints(1, row++, 5, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        restartPanel.add((Component)this.jRBClientRestart, new GridBagConstraints(1, row++, 5, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        if (this.platform != Platform.MAC) {
            restartPanel.add((Component)this.jRBNoRestart, new GridBagConstraints(1, row++, 5, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        }
        restartPanel.add((Component)this.jRBCustomRestart, new GridBagConstraints(1, row++, 5, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.typeOfRestartBG.add(this.jRBServerRestart);
        this.typeOfRestartBG.add(this.jRBClientRestart);
        this.typeOfRestartBG.add(this.jRBNoRestart);
        this.typeOfRestartBG.add(this.jRBCustomRestart);
        this.jRBServerRestart.setActionCommand(SERVERPANEL);
        this.jRBClientRestart.setActionCommand(CLIENTPANEL);
        this.jRBNoRestart.setActionCommand(NOPANEL);
        this.jRBCustomRestart.setActionCommand(CUSTOMPANEL);
        this.jRBServerRestart.addActionListener(this);
        this.jRBClientRestart.addActionListener(this);
        this.jRBNoRestart.addActionListener(this);
        this.jRBCustomRestart.addActionListener(this);
        return restartPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(CLIENTPANEL)) {
            this.descLabel1.setText(this.clientLabelStr1);
            this.jRBNoPrompt.setEnabled(false);
            this.jRBPromptCountdown.setEnabled(false);
            this.jRBPromptSnooze.setEnabled(true);
            this.jRBRestartImmediately.setEnabled(false);
            this.jRBRestartAtThisTime.setText(this.restartUpToThisTimeStr);
            this.jRBRestartAtThisTime.setEnabled(true);
            this.jRBRestartAtThisTime.setSelected(true);
            this.setRandomizeBlockEnabled(true);
            this.setMessageTxtAreaEnabled(true);
            this.centerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.clientRestartOptionsTitle));
            this.setCountdownEnabled(false);
            this.snoozeNAPanel.removeAll();
            this.jRBPromptSnooze.setText(this.promptSnoozeStrScheduled);
            this.snoozeNAPanel.add(this.jRBPromptSnooze);
            this.mytemp.removeAll();
            this.mytemp.add(this.jLblScheduledTime);
            this.snoozeNAPanel.add(this.mytemp);
            CardLayout cl = (CardLayout)this.cardPanelForSnooze.getLayout();
            cl.show(this.cardPanelForSnooze, SNOOZENAPANEL);
            this.setHardRestartEnabled(true);
            this.setAutoRestartEnabled(false);
            this.setHardRestart(true);
            this.setAutoRestart(true);
            this.jRBPromptSnooze.doClick();
            this.setSnoozeEnabled(false);
            this.jLblMinutes.setEnabled(false);
            this.jLblCountdownMinutes.setEnabled(false);
            this.jSPRandomizeHours.setEnabled(this.jChkRandomize.isSelected());
            this.jlblRandomHour.setEnabled(this.jChkRandomize.isSelected());
        } else if (e.getActionCommand().equals(SERVERPANEL)) {
            this.centerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.serverRestartOptionsTitle));
            this.descLabel1.setText(this.serverLabelStr1);
            this.jRBRestartImmediately.setEnabled(true);
            this.jRBRestartAtThisTime.setText(this.restartAtThisTimeStr);
            this.jRBRestartAtThisTime.setEnabled(true);
            this.setRandomizeBlockEnabled(true);
            this.jRBNoPrompt.setEnabled(true);
            this.jLblScheduledTime.setEnabled(false);
            this.jRBPromptCountdown.setEnabled(true);
            this.jRBPromptSnooze.setEnabled(false);
            this.setCountdownEnabled(true);
            this.setSnoozeEnabled(false);
            this.setMessageTxtAreaEnabled(true);
            this.snoozeTextPanel.removeAll();
            this.jRBPromptSnooze.setText(this.promptSnoozeStr);
            this.snoozeTextPanel.add(this.jRBPromptSnooze);
            this.mytemp.removeAll();
            this.mytemp.add(this.jLblNA);
            this.snoozeTextPanel.add(this.mytemp);
            CardLayout cl = (CardLayout)this.cardPanelForSnooze.getLayout();
            cl.show(this.cardPanelForSnooze, SNOOZETEXTPANEL);
            this.setHardRestartEnabled(false);
            this.setAutoRestartEnabled(false);
            this.setHardRestart(true);
            this.setAutoRestart(true);
            this.jSPCountdown.setEnabled(this.jRBPromptCountdown.isSelected());
            this.jLblCountdownMinutes.setEnabled(this.jRBPromptCountdown.isSelected());
            this.jRBPromptCountdown.doClick();
        } else if (e.getActionCommand().equals(NOPANEL)) {
            this.descLabel1.setText(this.noLabelStr1);
            this.jRBNoPrompt.setEnabled(false);
            this.jRBPromptCountdown.setEnabled(false);
            this.jRBPromptSnooze.setEnabled(false);
            this.jRBRestartImmediately.setEnabled(false);
            this.jRBRestartAtThisTime.setText(this.restartAtThisTimeStr);
            this.jRBRestartAtThisTime.setEnabled(false);
            this.setRandomizeBlockEnabled(false);
            this.setMessageTxtAreaEnabled(false);
            this.centerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.noRestartOptionsTitle));
            this.setSnoozeEnabled(false);
            this.setCountdownEnabled(false);
            this.snoozeNAPanel.removeAll();
            this.jRBPromptSnooze.setText(this.promptSnoozeStr);
            this.snoozeNAPanel.add(this.jRBPromptSnooze);
            this.mytemp.removeAll();
            this.mytemp.add(this.jLblNA);
            this.snoozeNAPanel.add(this.mytemp);
            CardLayout cl = (CardLayout)this.cardPanelForSnooze.getLayout();
            cl.show(this.cardPanelForSnooze, SNOOZENAPANEL);
            this.setHardRestartEnabled(false);
            this.setAutoRestartEnabled(false);
            this.setHardRestart(false);
            this.setAutoRestart(false);
            this.promptBG.setSelected(null, true);
            this.restartTimeBG.setSelected(null, true);
            this.jLblMinutes.setEnabled(false);
            this.jLblCountdownMinutes.setEnabled(false);
            this.jLblNA.setEnabled(false);
            this.jLblNA2.setEnabled(false);
        } else if (e.getActionCommand().equals(CUSTOMPANEL)) {
            CardLayout cl;
            this.descLabel1.setText(this.customLabelStr1);
            this.setMessageTxtAreaEnabled(true);
            this.jRBNoPrompt.setEnabled(true);
            this.jRBPromptCountdown.setEnabled(true);
            this.jRBPromptSnooze.setEnabled(true);
            this.jRBRestartImmediately.setEnabled(true);
            this.jRBRestartAtThisTime.setText(this.restartAtThisTimeStr);
            this.jRBRestartAtThisTime.setEnabled(true);
            this.setRandomizeBlockEnabled(true);
            if (this.getRebootSchedule().equals(RebootOptions.NOW)) {
                this.setSnoozeEnabled(true);
                cl = (CardLayout)this.cardPanelForSnooze.getLayout();
                cl.show(this.cardPanelForSnooze, SNOOZEMINUTEPANEL);
                this.jRBPromptSnooze.setEnabled(true);
                this.jSPPromptAllowSnooze.setEnabled(true);
                this.jLblMinutes.setEnabled(true);
            } else {
                this.setSnoozeEnabled(true);
                cl = (CardLayout)this.cardPanelForSnooze.getLayout();
                cl.show(this.cardPanelForSnooze, SNOOZETEXTPANEL);
            }
            this.setCountdownEnabled(true);
            this.centerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.customRestartOptionsTitle));
            if (this.getRebootSchedule().equals(RebootOptions.NOW)) {
                this.promptAndAllowSnoozePanel.removeAll();
                this.jRBPromptSnooze.setText(this.promptSnoozeStr);
                this.promptAndAllowSnoozePanel.add(this.jRBPromptSnooze);
                this.mytemp.removeAll();
                this.mytemp.add(this.jSPPromptAllowSnooze);
                this.mytemp.add(this.jLblMinutes);
                this.promptAndAllowSnoozePanel.add(this.mytemp);
                this.setSnoozeEnabled(true);
                cl = (CardLayout)this.cardPanelForSnooze.getLayout();
                cl.show(this.cardPanelForSnooze, SNOOZEMINUTEPANEL);
                this.jRBPromptSnooze.setEnabled(true);
                this.jSPPromptAllowSnooze.setEnabled(true);
                this.jRBPromptSnooze.setSelected(true);
                this.jLblMinutes.setEnabled(true);
            } else {
                this.setSnoozeEnabled(true);
                this.snoozeTextPanel.removeAll();
                this.jRBPromptSnooze.setText(this.promptSnoozeStrScheduled);
                this.snoozeTextPanel.add(this.jRBPromptSnooze);
                this.mytemp.removeAll();
                this.mytemp.add(this.jLblScheduledTime);
                this.snoozeTextPanel.add(this.mytemp);
                cl = (CardLayout)this.cardPanelForSnooze.getLayout();
                cl.show(this.cardPanelForSnooze, SNOOZETEXTPANEL);
            }
            this.setHardRestartEnabled(true);
            this.setAutoRestartEnabled(true);
            this.setHardRestart(true);
            this.setAutoRestart(true);
        } else if (e.getActionCommand().equals(IMMEDIATELY)) {
            if (this.getRebootMethod().equals(RebootOptions.CUSTOM)) {
                this.promptAndAllowSnoozePanel.removeAll();
                this.jRBPromptSnooze.setText(this.promptSnoozeStr);
                this.promptAndAllowSnoozePanel.add(this.jRBPromptSnooze);
                this.mytemp.removeAll();
                this.mytemp.add(this.jSPPromptAllowSnooze);
                this.mytemp.add(this.jLblMinutes);
                this.promptAndAllowSnoozePanel.add(this.mytemp);
                CardLayout cl = (CardLayout)this.cardPanelForSnooze.getLayout();
                cl.show(this.cardPanelForSnooze, SNOOZEMINUTEPANEL);
                this.setSnoozeEnabled(true);
                this.jSPPromptAllowSnooze.setEnabled(this.jRBPromptSnooze.isSelected());
                this.jLblMinutes.setEnabled(this.jRBPromptSnooze.isSelected());
                this.jSPCountdown.setEnabled(this.jRBPromptCountdown.isSelected());
                this.jLblCountdownMinutes.setEnabled(this.jRBPromptCountdown.isSelected());
            }
        } else if (e.getActionCommand().equals(LATER)) {
            if (this.getRebootMethod().equals(RebootOptions.CUSTOM)) {
                this.snoozeTextPanel.removeAll();
                this.jRBPromptSnooze.setText(this.promptSnoozeStr);
                this.snoozeTextPanel.add(this.jRBPromptSnooze);
                this.mytemp.removeAll();
                this.mytemp.add(this.jLblScheduledTime);
                this.snoozeTextPanel.add(this.mytemp);
                CardLayout cl = (CardLayout)this.cardPanelForSnooze.getLayout();
                cl.show(this.cardPanelForSnooze, SNOOZETEXTPANEL);
                this.setSnoozeEnabled(true);
            } else {
                this.setSnoozeEnabled(false);
                if (this.getPromptType() == RebootOptions.SNOOZE.intValue()) {
                    this.setPromptUser(true, RebootOptions.COUNTDOWN);
                }
            }
        }
    }

    public static RebootOptions getDefaultRebootOptions() {
        RebootOptions options = PackageUtil.getDefaultRebootOptions();
        return options;
    }

    private RebootOptions getDefaultRebootOptionsByMode(int rebootMode, Platform platform) {
        String message = this.getDefaultRebootMessage(rebootMode, platform);
        RebootOptions options = PackageUtil.getDefaultRebootOptions((String)message);
        if (3 == rebootMode) {
            options.setOptRebootMethod(RebootOptions.CUSTOM);
            options.setOptRebootSchedule(RebootOptions.NOW);
            options.setOptSnoozeInterval(Integer.valueOf(30));
        }
        return options;
    }

    protected String getDefaultRebootMessage(int rebootMode, Platform platform) {
        String message = REBOOT_DEFAULT_MSG;
        if (rebootMode == 1 || rebootMode == 3) {
            message = REBOOT_COMMAND_MSG;
        } else if (rebootMode == 2) {
            message = Platform.MAC.equals((Object)platform) ? REBOOT_MAC_INSTALL_MSG : REBOOT_WINDOWS_INSTALL_MSG;
        }
        return message;
    }

    private void setMessageTxtAreaEnabled(boolean enabled) {
        this.messageTxtArea.setEnabled(enabled);
        this.messageTxtArea.setEditable(enabled);
    }

    private void setAutoRestartEnabled(boolean enabled) {
        this.jChkAutoRestart.setEnabled(enabled);
        this.jLblAutoRestart.setEnabled(enabled);
    }

    private void setHardRestartEnabled(boolean enabled) {
        this.jChkHardRestart.setEnabled(enabled);
        this.jLblHardRestart.setEnabled(enabled);
    }

    private void setCountdownEnabled(boolean enabled) {
        this.jRBPromptCountdown.setEnabled(enabled);
        this.jSPCountdown.setEnabled(enabled);
        this.jLblCountdownMinutes.setEnabled(enabled);
    }

    private void setSnoozeEnabled(boolean enabled) {
        this.jRBPromptSnooze.setEnabled(enabled);
        this.jSPPromptAllowSnooze.setEnabled(enabled);
        this.jLblMinutes.setEnabled(enabled);
    }

    private void setRandomizeBlockEnabled(boolean enabled) {
        if (enabled) {
            if (!this.jRBRestartImmediately.isSelected()) {
                this.timeSpinner.setEnabled(enabled);
                this.jSPRandomizeHours.setEnabled(enabled);
                this.jChkRandomize.setEnabled(enabled);
                this.jCBRebootDay.setEnabled(enabled);
            }
            return;
        }
        this.timeSpinner.setEnabled(enabled);
        this.jSPRandomizeHours.setEnabled(enabled);
        this.jChkRandomize.setEnabled(enabled);
        this.jCBRebootDay.setEnabled(enabled);
    }

    public JPanel getRebootOptionsPanel() {
        return this;
    }

    public static enum Platform {
        WINDOWS,
        MAC,
        LINUX;

    }
}

