/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.schema.PrivateInsightServer;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.ExternalCommunicationObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.ServerPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PrivateServerDlg
extends DialogBase
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private PrivateInsightServer serverObj;
    private ExternalCommunicationObject extCommObj;
    private ServerPanel panel;
    private JPanel jContentPane = null;

    public PrivateServerDlg(JFrame frame, String title, boolean modal, ExternalCommunicationObject extComm) {
        super(frame, title, modal);
        this.extCommObj = extComm;
        this.initialize();
    }

    private void initialize() {
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getJContentPane());
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    private JPanel getJContentPane() {
        if (this.panel == null) {
            this.panel = new ServerPanel();
            this.panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.panel, "Center");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    public void setObject(PrivateInsightServer server) {
        this.serverObj = server;
        this.panel.setObject(this.serverObj);
    }

    @Override
    protected void commit() {
        this.serverObj.setName("PrivateServer");
        this.panel.save();
    }

    @Override
    public boolean isValidate() {
        String serverAddress = this.panel.getServerAddress();
        if (this.extCommObj.duplicateServerExists(serverAddress)) {
            if (this.serverObj.getAddress() == null) {
                JOptionPane.showMessageDialog(Manager.getFrame(), PrivateServerDlg.getString("PrivateCloudPanel.error.duplicate"), PrivateServerDlg.getString("PrivateCloudPanel.error"), 0);
                return false;
            }
            if (!this.serverObj.getAddress().equals(serverAddress)) {
                JOptionPane.showMessageDialog(Manager.getFrame(), PrivateServerDlg.getString("PrivateCloudPanel.error.duplicate"), PrivateServerDlg.getString("PrivateCloudPanel.error"), 0);
                return false;
            }
        }
        return this.panel.isValidate();
    }

    private static String getString(String propertyKey) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", propertyKey);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_private_submission_add_edit";
    }
}

