/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.ExternalCommunication;
import com.sygate.scm.common.configobject.schema.PrivateInsightServer;
import com.sygate.scm.common.configobject.schema.PrivateInsightServerGroup;
import com.sygate.scm.common.configobject.schema.SemLocationConfig;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.DeletableObjInt;
import com.sygate.scm.console.logicobject.ExternalCommunicationObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.LocationObject;
import com.sygate.scm.console.logicobject.PrivateInsightServerGroupObject;
import com.sygate.scm.console.logicobject.PrivateInsightServerObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.common.ApplyToDialog;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.dialog.PrivateServerDlg;
import com.sygate.scm.console.ui.policy.explorer.common.CheckItemTreeCellRenderer;
import com.sygate.scm.console.ui.policy.explorer.common.LocationCheckBoxTree;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PrivateCloudPanel
extends AvTemplatePane
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    public static final int MAX_SERVERS_IN_BLOCK = 32;
    private static final String TITLE = PrivateCloudPanel.getString("PrivateCloudPanel.submissionTitle");
    private static final String DESC = PrivateCloudPanel.getString("PrivateCloudPanel.submissionDesc");
    private ExternalCommunicationObject extCommObj;
    private String groupOrLocationId;
    private JCheckBox enablePrivateServerChk;
    private JCheckBox useSymantecServerChk;
    private JLabel legacyServerLabel;
    private JLabel legacyServerUrlLabel;
    private JRadioButton insightATPServer;
    private JRadioButton insightPrivateServer;
    private JPanel jContentPane = null;
    private JPanel jPanel = null;
    private JPanel jPanel1 = null;
    private JPanel legacyServerPanel = null;
    private JScrollPane jScrollPane1 = null;
    private JTree serverListTree = null;
    private JButton addBtn = null;
    private JButton deleteBtn = null;
    private JButton editBtn = null;
    private JButton moveUpBtn = null;
    private JButton moveDownBtn = null;
    private JButton applyToBtn = null;
    private Action addGroup;
    private Action addServer;
    private Action editServer;
    private Action delete;
    private Action moveUp;
    private Action moveDown;
    private final JPopupMenu fullMenu = new JPopupMenu();
    private final JPopupMenu addMenu = new JPopupMenu();
    private DefaultMutableTreeNode root;
    private DefaultTreeModel serverListModel;
    private final LocationCheckBoxTree locationTree = new LocationCheckBoxTree(new CheckItemTreeCellRenderer(true, true, false), null, true, false, false);
    private boolean readOnly = false;
    private boolean appyToActivated = false;

    public PrivateCloudPanel() {
        super(TITLE, DESC);
        this.initialize();
    }

    public void initialize() {
        this.initializeAction();
        this.initializeMenu();
        JPanel mainPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        mainPanel.setLayout(gridbag);
        mainPanel.add((Component)this.getMainFormJPanel(), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
        mainPanel.add((Component)this.getJContentPane(), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
        mainPanel.add((Component)this.getApplyToPanel(), new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 12, 0, new Insets(0, 5, 5, 5), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.add((Component)mainPanel, "West");
        this.add(wrapPanel);
        this.toggleForm(false);
    }

    private void initializeAction() {
        this.addGroup = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "PrivateCloudPanel.label.newGroup")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AjaxSwingCommonUtil.beginOperation();
                PrivateCloudPanel.this.addNewGroup();
                AjaxSwingCommonUtil.endOperation();
            }
        };
        this.addServer = new AbstractAction(PrivateCloudPanel.getString("PrivateCloudPanel.label.newServer")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AjaxSwingCommonUtil.beginOperation();
                PrivateCloudPanel.this.addNewServer();
                AjaxSwingCommonUtil.endOperation();
            }
        };
        this.editServer = new AbstractAction(PrivateCloudPanel.getString("ServerListEditorDlg.label.Edit")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PrivateCloudPanel.this.editServer();
            }
        };
        this.delete = new AbstractAction(PrivateCloudPanel.getString("ServerListEditorDlg.label.Delete")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PrivateCloudPanel.this.deleteNode();
            }
        };
        this.moveUp = new AbstractAction(PrivateCloudPanel.getString("ServerListEditorDlg.label.moveUp")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PrivateCloudPanel.this.moveUpServer();
            }
        };
        this.moveDown = new AbstractAction(PrivateCloudPanel.getString("ServerListEditorDlg.label.moveDown")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PrivateCloudPanel.this.moveDownServer();
            }
        };
    }

    private void initializeMenu() {
        JMenuItem addGroupMenu = new JMenuItem(this.addGroup);
        JMenuItem addServerMenu = new JMenuItem(this.addServer);
        JMenuItem editMenu = new JMenuItem(this.editServer);
        JMenuItem deleteMenu = new JMenuItem(this.delete);
        JMenuItem moveUpMenu = new JMenuItem(this.moveUp);
        JMenuItem moveDownMenu = new JMenuItem(this.moveDown);
        JMenu addSubMenu = new JMenu(PrivateCloudPanel.getString("ServerListEditorDlg.add"));
        addSubMenu.add(addGroupMenu);
        addSubMenu.add(addServerMenu);
        this.fullMenu.add(addSubMenu);
        this.fullMenu.add(deleteMenu);
        this.fullMenu.add(editMenu);
        this.fullMenu.add(moveUpMenu);
        this.fullMenu.add(moveDownMenu);
        this.fullMenu.addSeparator();
        addGroupMenu = new JMenuItem(this.addGroup);
        addServerMenu = new JMenuItem(this.addServer);
        this.addMenu.add(addGroupMenu);
        this.addMenu.add(addServerMenu);
    }

    private static String getString(String propertyKey) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", propertyKey);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_av_private_submission";
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getPrivateServerJPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getMainFormJPanel() {
        this.enablePrivateServerChk = new JCheckBox(PrivateCloudPanel.getString("PrivateCloudPanel.enablePrivateServer"));
        this.enablePrivateServerChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrivateCloudPanel.this.toggleForm(PrivateCloudPanel.this.enablePrivateServerChk.isSelected());
            }
        });
        this.insightATPServer = new JRadioButton(PrivateCloudPanel.getString("PrivateCloudPanel.insightServer.ATP"));
        this.insightPrivateServer = new JRadioButton(PrivateCloudPanel.getString("PrivateCloudPanel.insightServer.private"));
        ButtonGroup insightGroup = new ButtonGroup();
        insightGroup.add(this.insightATPServer);
        insightGroup.add(this.insightPrivateServer);
        this.useSymantecServerChk = new JCheckBox(PrivateCloudPanel.getString("PrivateCloudPanel.useSymantecServer"));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)this.enablePrivateServerChk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 5, 5), 0, 0));
        panel.add((Component)this.insightATPServer, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 20, 5, 5), 0, 0));
        panel.add((Component)this.insightPrivateServer, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 20, 5, 5), 0, 0));
        panel.add((Component)this.useSymantecServerChk, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 20, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getPrivateServerJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getScrollPanel(), new GridBagConstraints(0, 1, 1, 5, 1.0, 1.0, 18, 1, new Insets(10, 5, 10, 5), 0, 0));
            this.jPanel.add((Component)this.getAddBtn(), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 10), 0, 0));
            this.jPanel.add((Component)this.getEditBtn(), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 10), 0, 0));
            this.jPanel.add((Component)this.getDeleteBtn(), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 10), 0, 0));
            this.jPanel.add((Component)this.getMoveUpBtn(), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 10), 0, 0));
            this.jPanel.add((Component)this.getMoveDownBtn(), new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 10), 0, 0));
            this.jPanel.add((Component)this.getLegacyServerPanel(), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 50), 0, 0));
            this.jPanel.setMinimumSize(new Dimension(431, 379));
            if (this.jPanel1 == null) {
                this.jPanel1 = new JPanel();
            }
            this.jPanel1.setLayout(new BorderLayout());
            this.jPanel1.add((Component)this.jPanel, "Center");
            this.jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), PrivateCloudPanel.getString("PrivateCloudPanel.privateServers"), 0, 0, null, null));
        }
        return this.jPanel1;
    }

    private JPanel getLegacyServerPanel() {
        if (this.legacyServerPanel == null) {
            this.legacyServerPanel = new JPanel();
            this.legacyServerPanel.setLayout(new GridBagLayout());
            this.legacyServerLabel = new JLabel();
            this.legacyServerLabel.setText(PrivateCloudPanel.getString("PrivateCloudPanel.legacyPrivateInsightServerLabel"));
            this.legacyServerPanel.add((Component)this.legacyServerLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.legacyServerUrlLabel = new JLabel();
            this.legacyServerPanel.add((Component)this.legacyServerUrlLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 10, 0), 0, 0));
        }
        return this.legacyServerPanel;
    }

    private JPanel getApplyToPanel() {
        JPanel panel = new JPanel();
        JLabel applyToLabel = new JLabel(PrivateCloudPanel.getString("PrivateCloudPanel.label.applyTo"));
        panel.add(applyToLabel);
        panel.add(this.getApplyToBtn());
        return panel;
    }

    private JPanel getScrollPanel() {
        JScrollPane scrollPane = this.getTreeScrollPane();
        JPanel scrollPanel = new JPanel(new BorderLayout());
        scrollPanel.add((Component)scrollPane, "Center");
        return scrollPanel;
    }

    private JScrollPane getTreeScrollPane() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getServerListTree());
        }
        return this.jScrollPane1;
    }

    private JTree getServerListTree() {
        if (this.serverListTree == null) {
            this.serverListTree = new JTree();
            this.serverListTree.setRootVisible(false);
            this.serverListTree.setShowsRootHandles(true);
            this.serverListTree.getSelectionModel().setSelectionMode(1);
            DefaultTreeCellRenderer treeRender = (DefaultTreeCellRenderer)this.serverListTree.getCellRenderer();
            treeRender.setLeafIcon(null);
            treeRender.setClosedIcon(null);
            treeRender.setOpenIcon(null);
            this.serverListTree.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    PrivateCloudPanel.this.showPopupMenu(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PrivateCloudPanel.this.showPopupMenu(e);
                }
            });
            this.serverListTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    PrivateCloudPanel.this.setActionStatus();
                }
            });
            this.root = new DefaultMutableTreeNode();
            this.serverListModel = new DefaultTreeModel(this.root);
            this.serverListTree.setModel(this.serverListModel);
        }
        return this.serverListTree;
    }

    private JButton getApplyToBtn() {
        if (this.applyToBtn == null) {
            this.applyToBtn = new JButton();
            this.applyToBtn.setText(UIText.get(522));
            this.applyToBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.common.common", "ApplyToDialog.title");
                    ApplyToDialog dlg = new ApplyToDialog(title, PrivateCloudPanel.this.locationTree);
                    dlg.setVisible(true);
                    if (dlg.isOk()) {
                        PrivateCloudPanel.this.appyToActivated = true;
                    }
                }
            });
        }
        return this.applyToBtn;
    }

    private JButton getAddBtn() {
        if (this.addBtn == null) {
            this.addBtn = new JButton();
            this.addBtn.setBounds(282, 64, 109, 22);
            this.addBtn.setText(UIText.get(8));
            this.addBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AjaxSwingCommonUtil.beginOperation();
                    PrivateCloudPanel.this.addBtnIsClicked(e);
                    AjaxSwingCommonUtil.endOperation();
                }
            });
        }
        return this.addBtn;
    }

    private JButton getDeleteBtn() {
        if (this.deleteBtn == null) {
            this.deleteBtn = new JButton();
            this.deleteBtn.setBounds(282, 97, 109, 22);
            this.deleteBtn.setText(UIText.get(769));
            this.deleteBtn.setAction(this.delete);
        }
        return this.deleteBtn;
    }

    private JButton getEditBtn() {
        if (this.editBtn == null) {
            this.editBtn = new JButton();
            this.editBtn.setBounds(282, 132, 109, 22);
            this.editBtn.setText(UIText.get(1024));
            this.editBtn.setAction(this.editServer);
        }
        return this.editBtn;
    }

    private JButton getMoveUpBtn() {
        if (this.moveUpBtn == null) {
            this.moveUpBtn = new JButton();
            this.moveUpBtn.setBounds(282, 161, 109, 22);
            this.moveUpBtn.setText(UIText.get(3075));
            this.moveUpBtn.setAction(this.moveUp);
        }
        return this.moveUpBtn;
    }

    private JButton getMoveDownBtn() {
        if (this.moveDownBtn == null) {
            this.moveDownBtn = new JButton();
            this.moveDownBtn.setBounds(282, 192, 109, 22);
            this.moveDownBtn.setText(UIText.get(3074));
            this.moveDownBtn.setAction(this.moveDown);
        }
        return this.moveDownBtn;
    }

    protected void addBtnIsClicked(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        button.add(this.addMenu);
        int x = button.getWidth();
        this.addMenu.show(button, x, 0);
    }

    protected void setActionStatus() {
        this.addServer.setEnabled(false);
        this.addGroup.setEnabled(false);
        this.editServer.setEnabled(false);
        this.delete.setEnabled(false);
        this.moveUp.setEnabled(false);
        this.moveDown.setEnabled(false);
        if (this.readOnly) {
            return;
        }
        if (this.root.getChildCount() < 1) {
            this.addGroup.setEnabled(true);
        } else {
            boolean hasEmptyGroup = this.hasEmptyServerGroup();
            if (!hasEmptyGroup) {
                this.addGroup.setEnabled(true);
            }
        }
        TreePath path = this.serverListTree.getSelectionPath();
        if (path != null && path.getLastPathComponent() != this.root) {
            this.delete.setEnabled(true);
            this.addServer.setEnabled(true);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object nodeObj = node.getUserObject();
            if (nodeObj instanceof PrivateInsightServerObject) {
                this.editServer.setEnabled(true);
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
                if (parentNode.getPreviousSibling() != null) {
                    this.moveUp.setEnabled(true);
                }
                if (parentNode.getNextSibling() != null) {
                    this.moveDown.setEnabled(true);
                }
            } else {
                int indexOfParent = this.root.getIndex(node);
                if (indexOfParent > 0) {
                    this.moveUp.setEnabled(true);
                }
                if (indexOfParent < this.root.getChildCount() - 1) {
                    this.moveDown.setEnabled(true);
                }
                if (this.root.getChildCount() <= 1) {
                    this.delete.setEnabled(false);
                }
            }
        } else {
            TreePath newPath = new TreePath(this.root.getFirstLeaf().getPath());
            this.serverListTree.setSelectionPath(newPath);
        }
    }

    protected boolean hasEmptyServerGroup() {
        boolean hasEmptyGroup = false;
        DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)this.root.getFirstChild();
        do {
            if (groupNode.getChildCount() > 0) continue;
            hasEmptyGroup = true;
            break;
        } while ((groupNode = groupNode.getNextSibling()) != null);
        return hasEmptyGroup;
    }

    protected void showPopupMenu(MouseEvent e) {
        if (this.readOnly) {
            return;
        }
        if (e.isPopupTrigger()) {
            TreePath path = this.serverListTree.getPathForLocation(e.getX(), e.getY());
            this.serverListTree.setSelectionPath(path);
            this.serverListTree.add(this.fullMenu);
            this.fullMenu.show(this.serverListTree, e.getX(), e.getY());
        }
    }

    protected void addNewGroup() {
        int index = this.root.getChildCount();
        if (index >= 32) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.maxBlocks"));
            return;
        }
        PrivateInsightServerGroup newGroup = new PrivateInsightServerGroup();
        PrivateInsightServerGroupObject newGroupObj = new PrivateInsightServerGroupObject(index, newGroup);
        this.extCommObj.addPrivateInsightServerGroup(newGroupObj.getPrivateInsightServerGroup());
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(newGroupObj);
        this.serverListModel.insertNodeInto(node, this.root, index);
        TreePath pathToIt = new TreePath(node.getPath());
        this.serverListTree.scrollPathToVisible(pathToIt);
        this.serverListTree.setSelectionPath(pathToIt);
    }

    protected void addNewServer() {
        int children;
        TreePath path = this.serverListTree.getSelectionPath();
        if (path == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.pleaseSelectANodeToAddTo"));
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object nodeObj = node.getUserObject();
        if (nodeObj instanceof PrivateInsightServerObject) {
            node = (DefaultMutableTreeNode)node.getParent();
            nodeObj = node.getUserObject();
        }
        if ((children = node.getChildCount()) >= 32) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.maxServers"));
            return;
        }
        PrivateInsightServerGroupObject selectedGroup = (PrivateInsightServerGroupObject)nodeObj;
        PrivateInsightServer server = new PrivateInsightServer();
        String title = PrivateCloudPanel.getString("PrivateCloudPanel.addServer");
        PrivateServerDlg dlg = new PrivateServerDlg((JFrame)Manager.getFrame(), title, true, this.extCommObj);
        dlg.setObject(server);
        dlg.setVisible(true);
        if (dlg.isOk()) {
            selectedGroup.addPrivateInsightServer(server);
            PrivateInsightServerObject serverObj = new PrivateInsightServerObject(server);
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(serverObj);
            this.toggleEnabledLegacyServers(server);
            this.toggleLegacyServerPanel();
            this.serverListModel.insertNodeInto(newNode, node, children);
            TreePath newPath = new TreePath(newNode.getPath());
            this.serverListTree.setSelectionPath(newPath);
        }
    }

    protected void deleteNode() {
        TreePath path = this.serverListTree.getSelectionPath();
        if (path == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), PrivateCloudPanel.getString("ServerListEditorDlg.selectANodeToDelete"));
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object nodeObj = node.getUserObject();
        String dialogMessage = nodeObj instanceof PrivateInsightServerObject ? PrivateCloudPanel.getString("PrivateCloudPanel.deleteServerConfirmation") : PrivateCloudPanel.getString("PrivateCloudPanel.deleteGroupConfirmation");
        if (nodeObj instanceof DeletableObjInt) {
            Object[] choice = new String[]{PrivateCloudPanel.getString("ServerListEditorDlg.label.yes"), PrivateCloudPanel.getString("ServerListEditorDlg.label.no")};
            int result = JOptionPane.showOptionDialog(Manager.getFrame(), dialogMessage, PrivateCloudPanel.getString("ServerListEditorDlg.deletNode"), 0, 3, null, choice, choice[0]);
            if (result == 0) {
                if (nodeObj instanceof PrivateInsightServerGroupObject) {
                    PrivateInsightServerGroupObject selectedGroup = (PrivateInsightServerGroupObject)nodeObj;
                    this.extCommObj.removePrivateInsightServerGroup(selectedGroup.getPrivateInsightServerGroup());
                    this.adjustPriorityOfNextGroups(node);
                } else {
                    PrivateInsightServerGroupObject selectedGroup = (PrivateInsightServerGroupObject)((DefaultMutableTreeNode)node.getParent()).getUserObject();
                    PrivateInsightServerObject selectedServer = (PrivateInsightServerObject)nodeObj;
                    selectedGroup.removePrivateInsightServer(selectedServer.getPrivateInsightServer());
                }
                this.serverListModel.removeNodeFromParent(node);
                this.toggleEnabledLegacyServers(null);
                this.toggleLegacyServerPanel();
            }
        }
    }

    protected void editServer() {
        TreePath path = this.serverListTree.getSelectionPath();
        if (path == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.pleaseSelectANodeToEdit"));
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object nodeObj = node.getUserObject();
        if (!(nodeObj instanceof PrivateInsightServerObject)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.onlyServerAddressesCanBeEdited"));
            return;
        }
        PrivateInsightServerObject selectedServerObj = (PrivateInsightServerObject)nodeObj;
        PrivateInsightServerObject newObj = selectedServerObj.getClone();
        String title = PrivateCloudPanel.getString("PrivateCloudPanel.editServer");
        PrivateServerDlg dlg = new PrivateServerDlg((JFrame)Manager.getFrame(), title, true, this.extCommObj);
        PrivateInsightServer clonedServer = newObj.getPrivateInsightServer();
        dlg.setObject(clonedServer);
        dlg.setVisible(true);
        if (dlg.isOk()) {
            PrivateInsightServer selectedServer = selectedServerObj.getPrivateInsightServer();
            selectedServer.setAddress(clonedServer.getAddress());
            selectedServer.setOptProtocol(clonedServer.getOptProtocol());
            selectedServer.setPort(clonedServer.getPort());
            selectedServer.setOptHttpsVerifyCA(clonedServer.getOptHttpsVerifyCA());
            selectedServer.setOptLegacyClientSupport(clonedServer.getOptLegacyClientSupport());
            this.toggleEnabledLegacyServers(selectedServer);
            this.toggleLegacyServerPanel();
            this.serverListModel.nodeChanged(node);
        }
    }

    public void adjustPriorityOfNextGroups(DefaultMutableTreeNode node) {
        for (DefaultMutableTreeNode nextOne = node.getNextSibling(); nextOne != null; nextOne = nextOne.getNextSibling()) {
            PrivateInsightServerGroupObject sbObj = (PrivateInsightServerGroupObject)nextOne.getUserObject();
            sbObj.decreaseIndex();
        }
    }

    public void toggleEnabledLegacyServers(PrivateInsightServer selectedServer) {
        if (selectedServer != null && selectedServer.getOptLegacyClientSupport() != null && selectedServer.getOptLegacyClientSupport().booleanValue()) {
            for (DefaultMutableTreeNode nextNode = this.root.getNextNode(); nextNode != null; nextNode = nextNode.getNextNode()) {
                PrivateInsightServerObject serverObj;
                PrivateInsightServer server;
                Object nodeObj = nextNode.getUserObject();
                if (!(nodeObj instanceof PrivateInsightServerObject) || (server = (serverObj = (PrivateInsightServerObject)nodeObj).getPrivateInsightServer()) == selectedServer) continue;
                server.setOptLegacyClientSupport(Boolean.FALSE);
                this.serverListModel.nodeChanged(nextNode);
            }
        } else {
            PrivateInsightServer legacyServer = this.getPrivateInsightServerForLegacyClient();
            if (legacyServer != null) {
                legacyServer.setOptLegacyClientSupport(Boolean.TRUE);
            }
        }
    }

    protected boolean isValidate() {
        try {
            if (this.enablePrivateServerChk.isSelected() && !this.extCommObj.hasPrivateInsightServer()) {
                throw new GUICheckException(PrivateCloudPanel.getString("PrivateCloudPanel.error.noserver"), null);
            }
            return true;
        }
        catch (GUICheckException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), PrivateCloudPanel.getString("PrivateCloudPanel.error"), 0);
            if (ex.getErrorComponent() != null) {
                ex.getErrorComponent().requestFocus();
            }
            return false;
        }
    }

    protected void moveUpServer() {
        TreePath path = this.serverListTree.getSelectionPath();
        if (path == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.pleaseSelectAModeToMove"));
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object nodeObj = node.getUserObject();
        if (nodeObj instanceof PrivateInsightServerObject) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            DefaultMutableTreeNode preNode = parentNode.getPreviousSibling();
            if (preNode != null) {
                PrivateInsightServerGroupObject selectedGroup = (PrivateInsightServerGroupObject)parentNode.getUserObject();
                PrivateInsightServerGroupObject prevGroup = (PrivateInsightServerGroupObject)preNode.getUserObject();
                PrivateInsightServerObject selectedServer = (PrivateInsightServerObject)node.getUserObject();
                this.serverListModel.removeNodeFromParent(node);
                int children = preNode.getChildCount();
                this.serverListModel.insertNodeInto(node, preNode, children);
                TreePath newPath = new TreePath(node.getPath());
                this.serverListTree.setSelectionPath(newPath);
                selectedGroup.removePrivateInsightServer(selectedServer.getPrivateInsightServer());
                prevGroup.addPrivateInsightServer(selectedServer.getPrivateInsightServer());
            }
        } else {
            int index = this.root.getIndex(node);
            if (index > 0) {
                PrivateInsightServerGroupObject selectedGroup = (PrivateInsightServerGroupObject)node.getUserObject();
                DefaultMutableTreeNode preNode = (DefaultMutableTreeNode)this.root.getChildAt(index - 1);
                PrivateInsightServerGroupObject preGroupObj = (PrivateInsightServerGroupObject)preNode.getUserObject();
                preGroupObj.increaseIndex();
                this.serverListModel.removeNodeFromParent(node);
                selectedGroup.decreaseIndex();
                this.serverListModel.insertNodeInto(node, this.root, index - 1);
                this.serverListModel.nodeChanged(preNode);
                TreePath newPath = new TreePath(node.getPath());
                this.serverListTree.setSelectionPath(newPath);
                this.serverListTree.expandPath(newPath);
                this.extCommObj.adjustPrivateInsightServerGroupList(selectedGroup);
            }
        }
    }

    protected void moveDownServer() {
        TreePath path = this.serverListTree.getSelectionPath();
        if (path == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.pleaseSelectAModeToMove"));
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object nodeObj = node.getUserObject();
        if (nodeObj instanceof PrivateInsightServerObject) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            DefaultMutableTreeNode nextNode = parentNode.getNextSibling();
            if (nextNode != null) {
                PrivateInsightServerGroupObject selectedGroup = (PrivateInsightServerGroupObject)parentNode.getUserObject();
                PrivateInsightServerGroupObject nextGroup = (PrivateInsightServerGroupObject)nextNode.getUserObject();
                PrivateInsightServerObject pObj = (PrivateInsightServerObject)node.getUserObject();
                this.serverListModel.removeNodeFromParent(node);
                this.serverListModel.insertNodeInto(node, nextNode, 0);
                TreePath newPath = new TreePath(node.getPath());
                this.serverListTree.setSelectionPath(newPath);
                selectedGroup.removePrivateInsightServer(pObj.getPrivateInsightServer());
                nextGroup.addPrivateInsightServer(pObj.getPrivateInsightServer(), 0);
            }
        } else {
            int total;
            int index = this.root.getIndex(node);
            if (index < (total = this.root.getChildCount()) - 1) {
                PrivateInsightServerGroupObject selectedGroup = (PrivateInsightServerGroupObject)node.getUserObject();
                DefaultMutableTreeNode nextNode = (DefaultMutableTreeNode)this.root.getChildAt(index + 1);
                PrivateInsightServerGroupObject nextGroup = (PrivateInsightServerGroupObject)nextNode.getUserObject();
                nextGroup.decreaseIndex();
                this.serverListModel.removeNodeFromParent(node);
                selectedGroup.increaseIndex();
                this.serverListModel.insertNodeInto(node, this.root, index + 1);
                this.serverListModel.nodeChanged(nextNode);
                TreePath newPath = new TreePath(node.getPath());
                this.serverListTree.setSelectionPath(newPath);
                this.serverListTree.expandPath(newPath);
                this.extCommObj.adjustPrivateInsightServerGroupList(selectedGroup);
            }
        }
    }

    public void setObject(ExternalCommunicationObject extComObj, String groupOrLocationId) {
        this.extCommObj = extComObj;
        this.groupOrLocationId = groupOrLocationId;
        boolean enabled = this.extCommObj.isPrivateInsightServerEnable();
        this.enablePrivateServerChk.setSelected(enabled);
        boolean useATPFailoverToSymantecServer = this.extCommObj.isFailoverToSymantecServer();
        this.useSymantecServerChk.setSelected(useATPFailoverToSymantecServer);
        if (this.extCommObj.getPrivateServerType() == ExternalCommunication.ATP.intValue()) {
            this.insightATPServer.setSelected(true);
        } else {
            this.insightPrivateServer.setSelected(true);
        }
        this.createServerTree();
        if (this.serverListModel != null && this.root != null && this.serverListModel.getChildCount(this.root) < 1) {
            this.addNewGroup();
        }
        this.toggleLegacyServerPanel();
        this.toggleForm(enabled);
    }

    public void save() {
        this.extCommObj.setEnablePrivateInsightServer(this.enablePrivateServerChk.isSelected());
        this.extCommObj.setAllServers(this.enablePrivateServerChk.isSelected());
        this.extCommObj.setOptEnableFailoverToSymantecServer(this.useSymantecServerChk.isSelected());
        if (this.insightATPServer.isSelected()) {
            this.extCommObj.setPrivateServerType(ExternalCommunication.ATP);
        } else if (this.insightPrivateServer.isSelected()) {
            this.extCommObj.setPrivateServerType(ExternalCommunication.INSIGHT);
        }
        if (this.appyToActivated) {
            this.applyPrivateCloudSettingsToOtherGroups(this.locationTree.getModel());
        }
    }

    public void toggleForm(boolean enabled) {
        this.insightATPServer.setEnabled(enabled);
        this.insightPrivateServer.setEnabled(enabled);
        this.useSymantecServerChk.setEnabled(enabled);
        if (enabled) {
            this.addBtn.setEnabled(enabled);
            this.serverListTree.setEnabled(enabled);
            this.jScrollPane1.setEnabled(enabled);
            this.setActionStatus();
        } else {
            this.addBtn.setEnabled(enabled);
            this.editBtn.setEnabled(enabled);
            this.deleteBtn.setEnabled(enabled);
            this.moveUpBtn.setEnabled(enabled);
            this.moveDownBtn.setEnabled(enabled);
            this.serverListTree.setEnabled(enabled);
            this.jScrollPane1.setEnabled(enabled);
        }
    }

    public void createServerTree() {
        PrivateInsightServerGroupObject[] serverGroupList = this.extCommObj.getPrivateInsightServerGroupList();
        for (int i = 0; i < serverGroupList.length; ++i) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(serverGroupList[i]);
            this.serverListModel.insertNodeInto(node, this.root, i);
            this.createHostsForOneLevel(node, serverGroupList[i]);
        }
        UIUtilities.expandTreeByDepth(this.serverListTree, this.root, 2);
    }

    private void createHostsForOneLevel(DefaultMutableTreeNode parent, PrivateInsightServerGroupObject group) {
        int cnt = 0;
        for (PrivateInsightServer server : group.getPrivateInsightServerGroup().getPrivateInsightServer()) {
            PrivateInsightServerObject serverObj = new PrivateInsightServerObject(server);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(serverObj);
            this.serverListModel.insertNodeInto(node, parent, cnt);
            ++cnt;
        }
    }

    private PrivateInsightServer getPrivateInsightServerForLegacyClient() {
        PrivateInsightServer firstServer = null;
        PrivateInsightServer legacyServer = null;
        PrivateInsightServerGroupObject[] serverGroupList = this.extCommObj.getPrivateInsightServerGroupList();
        for (int i = 0; i < serverGroupList.length; ++i) {
            for (PrivateInsightServer server : serverGroupList[i].getPrivateInsightServerGroup().getPrivateInsightServer()) {
                if (firstServer == null) {
                    firstServer = server;
                }
                if (server.getOptLegacyClientSupport() == null || !server.getOptLegacyClientSupport().booleanValue()) continue;
                legacyServer = server;
                break;
            }
            if (legacyServer != null) break;
        }
        if (legacyServer == null) {
            legacyServer = firstServer;
        }
        return legacyServer;
    }

    private void toggleLegacyServerPanel() {
        PrivateInsightServer legacyServer = this.getPrivateInsightServerForLegacyClient();
        if (legacyServer == null) {
            this.legacyServerPanel.setVisible(false);
        } else {
            this.legacyServerPanel.setVisible(true);
        }
        this.updateLegacyServerLabel(legacyServer);
    }

    private void updateLegacyServerLabel(PrivateInsightServer server) {
        if (server != null && this.legacyServerUrlLabel != null) {
            PrivateInsightServerObject serverObj = new PrivateInsightServerObject(server);
            this.legacyServerUrlLabel.setText(serverObj.toString());
        }
    }

    public void setReadOnly() {
        this.readOnly = true;
        this.enablePrivateServerChk.setEnabled(false);
        this.applyToBtn.setEnabled(false);
        this.toggleForm(false);
    }

    private void applyPrivateCloudSettingsToOtherGroups(TreeModel treeModel) {
        try {
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)((DefaultTreeModel)treeModel).getRoot();
            if (rootNode == null) {
                return;
            }
            Enumeration<TreeNode> nodeList = rootNode.breadthFirstEnumeration();
            while (nodeList.hasMoreElements()) {
                boolean processGroup;
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)nodeList.nextElement();
                Object obj = treeNode.getUserObject();
                if (obj != null && obj instanceof GroupObject && ((GroupObject)obj).isSelected()) {
                    GroupObject gObject = (GroupObject)obj;
                    processGroup = true;
                    if (!StringUtilities.isEmpty((String)this.groupOrLocationId) && gObject.getId().equals(this.groupOrLocationId)) {
                        processGroup = false;
                    }
                    if (!processGroup) continue;
                    GroupPolicyObject gpObject = PolicyHandler.getGroupPolicyByGroup(gObject, false);
                    ExternalCommunicationObject comObj = gpObject.getExternalCommunicationObject();
                    ExternalCommunicationObject newObj = this.applyExternalCommunicationObject(comObj);
                    gpObject.setExternalCommunicationObject(newObj);
                    PolicyHandler.updateGroupPolicy(gpObject);
                    continue;
                }
                if (obj == null || !(obj instanceof LocationObject) || !((LocationObject)obj).isSelected()) continue;
                LocationObject lObject = (LocationObject)obj;
                processGroup = true;
                if (!StringUtilities.isEmpty((String)this.groupOrLocationId) && lObject.getId().equals(this.groupOrLocationId)) {
                    processGroup = false;
                }
                if (!processGroup || lObject.isExternalCommunicationGlobal()) continue;
                ExternalCommunicationObject comObj = lObject.getExternalCommunicationObject();
                ExternalCommunicationObject newObj = this.applyExternalCommunicationObject(comObj);
                lObject.setExternalCommunication(newObj);
                SemLocationConfig locConfig = lObject.getSemLocationConfigObj();
                if (locConfig == null) continue;
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)treeNode.getParent();
                GroupObject gObject = (GroupObject)parentNode.getUserObject();
                GroupPolicyObject gpObject = PolicyHandler.getGroupPolicyByGroup(gObject, false);
                gpObject.addChangedObject((TopLevelObject)locConfig);
                PolicyHandler.updateGroupPolicy(gpObject);
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private ExternalCommunicationObject applyExternalCommunicationObject(ExternalCommunicationObject comObj) {
        try {
            ExternalCommunication extComm = (ExternalCommunication)PolicyHandler.getCopyOfObj((ConfigObject)this.extCommObj.getExternalCommunication());
            comObj.setEnablePrivateInsightServer(extComm.getOptEnablePrivateInsightServer());
            comObj.setOptEnableFailoverToSymantecServer(extComm.getOptEnableFailoverToSymantecServer());
            comObj.setPrivateServerType(extComm.getOptPrivateInsightServerType());
            for (PrivateInsightServerGroupObject extGroup : comObj.getPrivateInsightServerGroupList()) {
                comObj.removePrivateInsightServerGroup(extGroup.getPrivateInsightServerGroup());
            }
            for (PrivateInsightServerGroup group : extComm.getPrivateInsightServerGroup()) {
                comObj.addPrivateInsightServerGroup(group);
            }
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        return comObj;
    }
}

