/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AppProtectionPolicyObject;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.FirewallPolicyObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.HostIntegrityObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.MemPolicyObject;
import com.sygate.scm.console.logicobject.NtrPolicyObject;
import com.sygate.scm.console.logicobject.QuarantineFirewallObject;
import com.sygate.scm.console.logicobject.QuarantineOSPObject;
import com.sygate.scm.console.ui.policy.adaptive.AdaptivePolicyDialog;
import com.sygate.scm.console.ui.policy.adaptive.AdaptivePolicySelectDlg;
import com.sygate.scm.console.ui.policy.adaptive.QuarantineAdaptivePolicyDialog;
import com.sygate.scm.console.ui.policy.adaptive.QuarantineAdaptivePolicySelectDlg;
import com.sygate.scm.console.ui.policy.adaptive.logicobject.AdaptivePolicyObject;
import com.sygate.scm.console.ui.policy.adaptive.logicobject.QuarantineAdaptivePolicyObject;
import com.sygate.scm.console.ui.policy.av.AvPolicyDialog;
import com.sygate.scm.console.ui.policy.av.AvPolicySelectDlg;
import com.sygate.scm.console.ui.policy.av.QuarantineAvPolicyDialog;
import com.sygate.scm.console.ui.policy.av.QuarantineAvPolicySelectDlg;
import com.sygate.scm.console.ui.policy.av.logicobject.AvPolicyObject;
import com.sygate.scm.console.ui.policy.av.logicobject.QuarantineAvPolicyObject;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.dialog.FirewallPolicySelectDlg;
import com.sygate.scm.console.ui.policy.dialog.QuarantineOSPPolicyEditorDlg;
import com.sygate.scm.console.ui.policy.dialog.QuarantineOSPSelectDlg;
import com.sygate.scm.console.ui.policy.dialog.QuarantinePolicyEditorDlg;
import com.sygate.scm.console.ui.policy.dialog.QuarantinePolicySelectDlg;
import com.sygate.scm.console.ui.policy.dialog.WizardPanel;
import com.sygate.scm.console.ui.policy.explorer.osp.OpAppProtectionPolicyHandler;
import com.sygate.scm.console.ui.policy.firewall.dialog.FwPolicyDialog;
import com.sygate.scm.console.ui.policy.hi.HiPolicyDialog;
import com.sygate.scm.console.ui.policy.hi.HostIntegritySelectDlg;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsPolicyDialog;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsPolicySelectDlg;
import com.sygate.scm.console.ui.policy.ids.dialog.QuarantineIdsPolicyDialog;
import com.sygate.scm.console.ui.policy.ids.dialog.QuarantineIdsPolicySelectDlg;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsPolicyObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.QuarantineIdsPolicyObject;
import com.sygate.scm.console.ui.policy.lu.LuPolicyDialog;
import com.sygate.scm.console.ui.policy.lu.LuPolicySelectDlg;
import com.sygate.scm.console.ui.policy.lu.QuarantineLuPolicyDialog;
import com.sygate.scm.console.ui.policy.lu.QuarantineLuPolicySelectDlg;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.QuarantineLuPolicyObject;
import com.sygate.scm.console.ui.policy.mem.MemPolicyDialog;
import com.sygate.scm.console.ui.policy.mem.MemPolicySelectDlg;
import com.sygate.scm.console.ui.policy.mem.QuarantineMemPolicyDialog;
import com.sygate.scm.console.ui.policy.mem.QuarantineMemPolicySelectDlg;
import com.sygate.scm.console.ui.policy.mem.logicobject.QuarantineMemPolicyObject;
import com.sygate.scm.console.ui.policy.ntr.NtrPolicyDialog;
import com.sygate.scm.console.ui.policy.ntr.NtrPolicySelectDlg;
import com.sygate.scm.console.ui.policy.ntr.QuarantineNtrPolicyDialog;
import com.sygate.scm.console.ui.policy.ntr.QuarantineNtrPolicySelectDlg;
import com.sygate.scm.console.ui.policy.ntr.logicobject.QuarantineNtrPolicyObject;
import com.sygate.scm.console.ui.policy.osprotect.dialog.OSProtectPolicySelectDlg;
import com.sygate.scm.console.ui.policy.osprotect.dialog.OspPolicyDialog;
import com.sygate.scm.console.ui.policy.override.OverridePolicyDialog;
import com.sygate.scm.console.ui.policy.override.OverridePolicySelectDlg;
import com.sygate.scm.console.ui.policy.override.QuarantineCeSelectDlg;
import com.sygate.scm.console.ui.policy.override.QuarantineOverridePolicyDialog;
import com.sygate.scm.console.ui.policy.override.logicobject.OverridePolicyObject;
import com.sygate.scm.console.ui.policy.override.logicobject.QuarantineOverridePolicyObject;
import com.sygate.scm.console.ui.policy.up.QuarantineUpgradePolicyDialog;
import com.sygate.scm.console.ui.policy.up.QuarantineUpgradePolicySelectDlg;
import com.sygate.scm.console.ui.policy.up.UpgradePolicyDialog;
import com.sygate.scm.console.ui.policy.up.UpgradePolicySelectDlg;
import com.sygate.scm.console.ui.policy.up.logicobject.QuarantineUpgradePolicyObject;
import com.sygate.scm.console.ui.policy.up.logicobject.UpgradePolicyObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.util.ConsoleException;
import java.awt.Cursor;
import javax.swing.JOptionPane;

public class PolicyType {
    public static final int AVPOLICY = 0;
    public static final int FIREWALL = 1;
    public static final int HOSTINTEGRITY = 2;
    public static final int OSPROTECT = 3;
    public static final int POLICYOVERRIDE = 4;
    public static final int LIVEUPDATE = 5;
    public static final int IDSPOLICY = 6;
    public static final int MEMPOLICY = 14;
    public static final int NTRPOLICY = 15;
    public static final int UPGRADEPOLICY = 17;
    public static final int ADAPTIVEPOLICY = 19;
    public static final int QUARANTINE_AV = 7;
    public static final int QUARANTINE_FW = 8;
    public static final int QUARANTINE_OSP = 9;
    public static final int QUARANTINE_POLICYOVERRIDE = 10;
    public static final int QUARANTINE_LIVEUPDATE = 11;
    public static final int QUARANTINE_IDSPOLICY = 12;
    public static final int QUARANTINE_MEMPOLICY = 13;
    public static final int QUARANTINE_NTRPOLICY = 16;
    public static final int QUARANTINE_UPGRADEPOLICY = 18;
    public static final int QUARANTINE_ADAPTIVEPOLICY = 20;
    private String name;
    private String desc;
    private int type;
    private PolicyInt policyObj;

    public PolicyType(String name, String desc, int type) {
        this.name = name;
        this.desc = desc;
        this.type = type;
    }

    public String toString() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int getPolicyTreeItem() {
        switch (this.type) {
            case 0: 
            case 7: {
                return 134;
            }
            case 1: 
            case 8: {
                return 43;
            }
            case 2: {
                return 56;
            }
            case 3: 
            case 9: {
                return 63;
            }
            case 4: 
            case 10: {
                return 128;
            }
            case 5: 
            case 11: {
                return 144;
            }
            case 13: 
            case 14: {
                return 169;
            }
            case 15: 
            case 16: {
                return 171;
            }
            case 17: 
            case 18: {
                return 309;
            }
            case 19: 
            case 20: {
                return 313;
            }
        }
        return 143;
    }

    public WizardPanel getEditor(boolean isLocal, String locationName, GroupPolicyObject gpObj) {
        DialogBase dlg = null;
        Cursor curCursor = Manager.getFrame().getCursor();
        Manager.getFrame().setCursor(new Cursor(3));
        if (isLocal) {
            switch (this.type) {
                case 0: {
                    dlg = new AvPolicyDialog(locationName, gpObj, isLocal);
                    break;
                }
                case 1: {
                    dlg = new FwPolicyDialog(locationName, gpObj, isLocal);
                    break;
                }
                case 2: {
                    dlg = new HiPolicyDialog(locationName, gpObj, isLocal);
                    break;
                }
                case 3: {
                    dlg = new OspPolicyDialog(locationName, gpObj, isLocal);
                    break;
                }
                case 4: {
                    dlg = new OverridePolicyDialog(locationName, gpObj, isLocal);
                    break;
                }
                case 5: {
                    dlg = new LuPolicyDialog(locationName, gpObj, isLocal);
                    break;
                }
                case 6: {
                    dlg = new IdsPolicyDialog(locationName, gpObj, isLocal);
                    break;
                }
                case 14: {
                    dlg = new MemPolicyDialog(locationName, gpObj, isLocal);
                    break;
                }
                case 15: {
                    dlg = new NtrPolicyDialog(locationName, gpObj, isLocal);
                    break;
                }
                case 17: {
                    dlg = new UpgradePolicyDialog(locationName, gpObj, isLocal);
                    break;
                }
                case 19: {
                    dlg = new AdaptivePolicyDialog(locationName, gpObj, isLocal);
                    break;
                }
                case 7: {
                    dlg = new QuarantineAvPolicyDialog(locationName, gpObj, isLocal);
                    break;
                }
                case 8: {
                    dlg = new QuarantinePolicyEditorDlg(locationName, gpObj, isLocal);
                    break;
                }
                case 9: {
                    dlg = new QuarantineOSPPolicyEditorDlg(locationName, gpObj, isLocal);
                    break;
                }
                case 10: {
                    dlg = new QuarantineOverridePolicyDialog(locationName, gpObj, isLocal);
                    break;
                }
                case 11: {
                    dlg = new QuarantineLuPolicyDialog(locationName, gpObj, isLocal);
                    break;
                }
                case 12: {
                    dlg = new QuarantineIdsPolicyDialog(locationName, gpObj, isLocal);
                    break;
                }
                case 13: {
                    dlg = new QuarantineMemPolicyDialog(locationName, gpObj, isLocal);
                    break;
                }
                case 16: {
                    dlg = new QuarantineNtrPolicyDialog(locationName, gpObj, isLocal);
                    break;
                }
                case 18: {
                    dlg = new QuarantineUpgradePolicyDialog(locationName, gpObj, isLocal);
                    break;
                }
                case 20: {
                    dlg = new QuarantineAdaptivePolicyDialog(locationName, gpObj, isLocal);
                    break;
                }
            }
        } else {
            String gName = gpObj == null ? "" : gpObj.getGroupName();
            switch (this.type) {
                case 0: {
                    dlg = new AvPolicySelectDlg(gName, locationName, null);
                    break;
                }
                case 1: {
                    dlg = new FirewallPolicySelectDlg(gName, locationName, null);
                    break;
                }
                case 2: {
                    dlg = new HostIntegritySelectDlg(gName, locationName, null);
                    break;
                }
                case 3: {
                    dlg = new OSProtectPolicySelectDlg(gName, locationName, null);
                    break;
                }
                case 4: {
                    dlg = new OverridePolicySelectDlg(gName, locationName, null);
                    break;
                }
                case 5: {
                    dlg = new LuPolicySelectDlg(gName, locationName, null);
                    break;
                }
                case 6: {
                    dlg = new IdsPolicySelectDlg(gName, locationName, null);
                    break;
                }
                case 14: {
                    dlg = new MemPolicySelectDlg(gName, locationName, null);
                    break;
                }
                case 15: {
                    dlg = new NtrPolicySelectDlg(gName, locationName, null);
                    break;
                }
                case 17: {
                    dlg = new UpgradePolicySelectDlg(gName, locationName, null);
                    break;
                }
                case 19: {
                    dlg = new AdaptivePolicySelectDlg(gName, locationName, null);
                    break;
                }
                case 7: {
                    dlg = new QuarantineAvPolicySelectDlg(gName, locationName, null);
                    break;
                }
                case 8: {
                    dlg = new QuarantinePolicySelectDlg(gName, locationName, null);
                    break;
                }
                case 9: {
                    dlg = new QuarantineOSPSelectDlg(gName, locationName, null);
                    break;
                }
                case 10: {
                    dlg = new QuarantineCeSelectDlg(gName, locationName, null);
                    break;
                }
                case 11: {
                    dlg = new QuarantineLuPolicySelectDlg(gName, locationName, null);
                    break;
                }
                case 12: {
                    dlg = new QuarantineIdsPolicySelectDlg(gName, locationName, null);
                    break;
                }
                case 13: {
                    dlg = new QuarantineMemPolicySelectDlg(gName, locationName, null);
                    break;
                }
                case 16: {
                    dlg = new QuarantineNtrPolicySelectDlg(gName, locationName, null);
                    break;
                }
                case 18: {
                    dlg = new QuarantineUpgradePolicySelectDlg(gName, locationName, null);
                    break;
                }
                case 20: {
                    dlg = new QuarantineAdaptivePolicySelectDlg(gName, locationName, null);
                    break;
                }
            }
        }
        Manager.getFrame().setCursor(curCursor);
        return dlg;
    }

    public String getPolicyTargetName() {
        switch (this.type) {
            case 0: {
                return "AvPolicyApplied";
            }
            case 1: {
                return "FirewallPolicyApplied";
            }
            case 2: {
                return "HostIntegrityApplied";
            }
            case 3: {
                return "OpAppProtectionPolicyApplied";
            }
            case 4: {
                return "PolicyOverrideApplied";
            }
            case 5: {
                return "LuPolicyApplied";
            }
            case 6: {
                return "IdsPolicyApplied";
            }
            case 14: {
                return "MemPolicyApplied";
            }
            case 15: {
                return "NtrPolicyApplied";
            }
            case 17: {
                return "UpgradePolicyApplied";
            }
            case 19: {
                return "AdaptivePolicyApplied";
            }
            case 7: {
                return "QuarantineAvPolicyApplied";
            }
            case 8: {
                return "QuarantineFWPolicyApplied";
            }
            case 9: {
                return "QuarantineOSPPolicyApplied";
            }
            case 10: {
                return "QuarantineCePolicyApplied";
            }
            case 11: {
                return "QuarantineLuPolicyApplied";
            }
            case 13: {
                return "QuarantineMemPolicyApplied";
            }
            case 16: {
                return "QuarantineNtrPolicyApplied";
            }
            case 18: {
                return "QuarantineUpgradePolicyApplied";
            }
            case 20: {
                return "QuarantineAdaptivePolicyApplied";
            }
        }
        return "QuarantineIdsPolicyApplied";
    }

    public PolicyInt getPolicyObject() {
        if (this.policyObj == null) {
            switch (this.type) {
                case 0: {
                    this.policyObj = new AvPolicyObject();
                    break;
                }
                case 1: {
                    this.policyObj = new FirewallPolicyObject();
                    break;
                }
                case 2: {
                    this.policyObj = new HostIntegrityObject();
                    break;
                }
                case 3: {
                    this.policyObj = new AppProtectionPolicyObject();
                    break;
                }
                case 4: {
                    this.policyObj = new OverridePolicyObject();
                    break;
                }
                case 5: {
                    this.policyObj = new LiveUpdateObject();
                    break;
                }
                case 6: {
                    this.policyObj = new IdsPolicyObject();
                    break;
                }
                case 14: {
                    this.policyObj = new MemPolicyObject();
                    break;
                }
                case 15: {
                    this.policyObj = new NtrPolicyObject();
                    break;
                }
                case 17: {
                    this.policyObj = new UpgradePolicyObject();
                    break;
                }
                case 19: {
                    this.policyObj = new AdaptivePolicyObject();
                    break;
                }
                case 7: {
                    this.policyObj = new QuarantineAvPolicyObject();
                    break;
                }
                case 8: {
                    this.policyObj = new QuarantineFirewallObject();
                    break;
                }
                case 9: {
                    this.policyObj = new QuarantineOSPObject();
                    break;
                }
                case 10: {
                    this.policyObj = new QuarantineOverridePolicyObject();
                    break;
                }
                case 11: {
                    this.policyObj = new QuarantineLuPolicyObject();
                    break;
                }
                case 12: {
                    this.policyObj = new QuarantineIdsPolicyObject();
                    break;
                }
                case 13: {
                    this.policyObj = new QuarantineMemPolicyObject();
                    break;
                }
                case 16: {
                    this.policyObj = new QuarantineNtrPolicyObject();
                    break;
                }
                case 18: {
                    this.policyObj = new QuarantineUpgradePolicyObject();
                    break;
                }
                case 20: {
                    this.policyObj = new QuarantineAdaptivePolicyObject();
                    break;
                }
            }
        }
        return this.policyObj;
    }

    public PolicyInt getImportedObject() throws ConsoleException {
        switch (this.type) {
            case 3: 
            case 9: {
                OpAppProtectionPolicyHandler handler = OpAppProtectionPolicyHandler.getInstance();
                return handler.importFile();
            }
        }
        ConfigObject obj = PolicyHandler.importPolicy();
        if (obj == null) {
            return null;
        }
        PolicyInt pObj = this.getPolicyObject();
        if (this.isSameType(obj, pObj)) {
            pObj.setSchemaObj((TopLevelObject)obj);
            pObj.addNewObj((TopLevelObject)obj);
            return pObj;
        }
        JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "PolicyHandler.FailedImportPolicy"));
        return null;
    }

    private boolean isSameType(ConfigObject o, PolicyInt p) {
        boolean tf = false;
        try {
            String s = p.getTargetType();
            String type = o.getObjectTypeName();
            tf = type.compareTo(s) == 0;
        }
        catch (Exception e) {
            tf = false;
        }
        return tf;
    }

    public static AppliablePolicyPool getObjectPool(String targetType) throws ConsoleException {
        int treeItem = PolicyType.getPolicyTreeitemFromPolicyTargetType(targetType);
        return AppliablePolicyPool.getPolicyPoolObject(treeItem);
    }

    public static int getPolicyTreeitemFromPolicyTargetType(String targetType) throws ConsoleException {
        if (targetType.equals("AvPolicy")) {
            return 134;
        }
        if (targetType.equals("FwFirewallPolicy")) {
            return 43;
        }
        if (targetType.equals("HiHostIntegrityPolicy")) {
            return 56;
        }
        if (targetType.equals("OpAppProtectionPolicy")) {
            return 63;
        }
        if (targetType.equals("PolicyOverride")) {
            return 128;
        }
        if (targetType.equals("LuPolicy")) {
            return 144;
        }
        if (targetType.equals("MemPolicy")) {
            return 169;
        }
        if (targetType.equals("NtrPolicy")) {
            return 171;
        }
        if (targetType.equals("UpgradePolicy")) {
            return 309;
        }
        if (targetType.equals("AdaptivePolicy")) {
            return 313;
        }
        return 143;
    }

    public static String getPolicyTargetTypeFromPolicyTreeItemType(int treeItemType) {
        switch (treeItemType) {
            case 134: {
                return "AvPolicy";
            }
            case 43: {
                return "FwFirewallPolicy";
            }
            case 56: {
                return "HiHostIntegrityPolicy";
            }
            case 63: {
                return "OpAppProtectionPolicy";
            }
            case 128: {
                return "PolicyOverride";
            }
            case 144: {
                return "LuPolicy";
            }
            case 169: {
                return "MemPolicyApplied";
            }
            case 171: {
                return "NtrPolicyApplied";
            }
            case 309: {
                return "UpgradePolicyApplied";
            }
            case 313: {
                return "AdaptivePolicy";
            }
        }
        return "IdsPolicy";
    }

    public static boolean isQuaratinePolicy(String policyTargetName) {
        return policyTargetName.equals("QuarantineAvPolicyApplied") || policyTargetName.equals("QuarantineFWPolicyApplied") || policyTargetName.equals("QuarantineOSPPolicyApplied") || policyTargetName.equals("QuarantineLuPolicyApplied") || policyTargetName.equals("QuarantineCePolicyApplied") || policyTargetName.equals("QuarantineIdsPolicyApplied") || policyTargetName.equals("QuarantineMemPolicyApplied") || policyTargetName.equals("QuarantineNtrPolicyApplied") || policyTargetName.equals("QuarantineUpgradePolicyApplied") || policyTargetName.equals("QuarantineAdaptivePolicyApplied");
    }

    public static String getPolicyTargetNameFromPolicyTargetType(String policyTargetType, boolean isQuarantine) {
        if (isQuarantine) {
            if (policyTargetType.equals("AvPolicy")) {
                return "QuarantineAvPolicyApplied";
            }
            if (policyTargetType.equals("FwFirewallPolicy")) {
                return "QuarantineFWPolicyApplied";
            }
            if (policyTargetType.equals("OpAppProtectionPolicy")) {
                return "QuarantineOSPPolicyApplied";
            }
            if (policyTargetType.equals("PolicyOverride")) {
                return "QuarantineCePolicyApplied";
            }
            if (policyTargetType.equals("LuPolicy")) {
                return "QuarantineLuPolicyApplied";
            }
            if (policyTargetType.equals("IdsPolicy")) {
                return "QuarantineIdsPolicyApplied";
            }
            if (policyTargetType.equals("MemPolicy")) {
                return "QuarantineMemPolicyApplied";
            }
            if (policyTargetType.equals("NtrPolicy")) {
                return "QuarantineNtrPolicyApplied";
            }
            if (policyTargetType.equals("UpgradePolicy")) {
                return "QuarantineUpgradePolicyApplied";
            }
            if (policyTargetType.equals("AdaptivePolicy")) {
                return "QuarantineAdaptivePolicyApplied";
            }
        } else {
            if (policyTargetType.equals("AvPolicy")) {
                return "AvPolicyApplied";
            }
            if (policyTargetType.equals("FwFirewallPolicy")) {
                return "FirewallPolicyApplied";
            }
            if (policyTargetType.equals("HiHostIntegrityPolicy")) {
                return "HostIntegrityApplied";
            }
            if (policyTargetType.equals("OpAppProtectionPolicy")) {
                return "OpAppProtectionPolicyApplied";
            }
            if (policyTargetType.equals("PolicyOverride")) {
                return "PolicyOverrideApplied";
            }
            if (policyTargetType.equals("LuPolicy")) {
                return "LuPolicyApplied";
            }
            if (policyTargetType.equals("IdsPolicy")) {
                return "IdsPolicyApplied";
            }
            if (policyTargetType.equals("MemPolicy")) {
                return "MemPolicyApplied";
            }
            if (policyTargetType.equals("NtrPolicy")) {
                return "NtrPolicyApplied";
            }
            if (policyTargetType.equals("UpgradePolicy")) {
                return "UpgradePolicyApplied";
            }
            if (policyTargetType.equals("AdaptivePolicy")) {
                return "AdaptivePolicyApplied";
            }
        }
        return null;
    }

    public static String getLocalPolicyTargetNameFromPolicyTargetType(String policyTargetType, boolean isQuarantine) {
        if (isQuarantine) {
            if (policyTargetType.equals("AvPolicy")) {
                return "LocalAvQuarantinePolicy";
            }
            if (policyTargetType.equals("FwFirewallPolicy")) {
                return "LocalFWQuarantinePolicy";
            }
            if (policyTargetType.equals("OpAppProtectionPolicy")) {
                return "LocalOSPQuarantinePolicy";
            }
            if (policyTargetType.equals("PolicyOverride")) {
                return "LocalCeQuarantinePolicy";
            }
            if (policyTargetType.equals("LuPolicy")) {
                return "LocalLuQuarantinePolicy";
            }
            if (policyTargetType.equals("IdsPolicy")) {
                return "LocalIdsQuarantinePolicy";
            }
            if (policyTargetType.equals("MemPolicy")) {
                return "LocalMemQuarantinePolicy";
            }
            if (policyTargetType.equals("NtrPolicy")) {
                return "LocalNtrQuarantinePolicy";
            }
            if (policyTargetType.equals("UpgradePolicy")) {
                return "LocalUpgradeQuarantinePolicy";
            }
            if (policyTargetType.equals("AdaptivePolicy")) {
                return "LocalAdaptiveQuarantinePolicy";
            }
        } else {
            if (policyTargetType.equals("AvPolicy")) {
                return "LocalAvPolicy";
            }
            if (policyTargetType.equals("FwFirewallPolicy")) {
                return "LocalFirewallPolicy";
            }
            if (policyTargetType.equals("HiHostIntegrityPolicy")) {
                return "LocalHostIntegrityPolicy";
            }
            if (policyTargetType.equals("OpAppProtectionPolicy")) {
                return "LocalOpAppProtectionPolicy";
            }
            if (policyTargetType.equals("PolicyOverride")) {
                return "LocalPolicyOverride";
            }
            if (policyTargetType.equals("LuPolicy")) {
                return "LocalLuPolicy";
            }
            if (policyTargetType.equals("IdsPolicy")) {
                return "LocalIdsPolicy";
            }
            if (policyTargetType.equals("MemPolicy")) {
                return "LocalMemPolicy";
            }
            if (policyTargetType.equals("NtrPolicy")) {
                return "LocalNtrPolicy";
            }
            if (policyTargetType.equals("UpgradePolicy")) {
                return "LocalUpgradePolicy";
            }
            if (policyTargetType.equals("AdaptivePolicy")) {
                return "LocalAdaptivePolicy";
            }
        }
        return null;
    }

    public static boolean isQualifiedPolicyType(int policyType) {
        LicenseObject licenseObj = LicenseObject.getInstance();
        if (licenseObj.isSNACOnlyProduct()) {
            return policyType == 2 || policyType == 5 || policyType == 11;
        }
        return true;
    }
}

