/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.PolicyHelper;
import com.sygate.scm.console.ui.policy.adaptive.AdaptivePolicySelectDlg;
import com.sygate.scm.console.ui.policy.adaptive.QuarantineAdaptivePolicySelectDlg;
import com.sygate.scm.console.ui.policy.av.AvPolicySelectDlg;
import com.sygate.scm.console.ui.policy.av.QuarantineAvPolicySelectDlg;
import com.sygate.scm.console.ui.policy.dialog.FirewallPolicySelectDlg;
import com.sygate.scm.console.ui.policy.dialog.QuarantineOSPSelectDlg;
import com.sygate.scm.console.ui.policy.dialog.QuarantinePolicySelectDlg;
import com.sygate.scm.console.ui.policy.dialog.SelectDlg;
import com.sygate.scm.console.ui.policy.dialog.WizardListener;
import com.sygate.scm.console.ui.policy.dialog.WizardPanel;
import com.sygate.scm.console.ui.policy.hi.HostIntegritySelectDlg;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsPolicySelectDlg;
import com.sygate.scm.console.ui.policy.ids.dialog.QuarantineIdsPolicySelectDlg;
import com.sygate.scm.console.ui.policy.lu.LuPolicySelectDlg;
import com.sygate.scm.console.ui.policy.lu.QuarantineLuPolicySelectDlg;
import com.sygate.scm.console.ui.policy.mem.MemPolicySelectDlg;
import com.sygate.scm.console.ui.policy.mem.QuarantineMemPolicySelectDlg;
import com.sygate.scm.console.ui.policy.ntr.NtrPolicySelectDlg;
import com.sygate.scm.console.ui.policy.ntr.QuarantineNtrPolicySelectDlg;
import com.sygate.scm.console.ui.policy.osprotect.dialog.OSProtectPolicySelectDlg;
import com.sygate.scm.console.ui.policy.override.OverridePolicySelectDlg;
import com.sygate.scm.console.ui.policy.override.QuarantineCeSelectDlg;
import com.sygate.scm.console.ui.policy.up.QuarantineUpgradePolicySelectDlg;
import com.sygate.scm.console.ui.policy.up.UpgradePolicySelectDlg;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public abstract class PolicySelectDlg
extends SelectDlg
implements WizardPanel {
    private static final long serialVersionUID = 1L;
    private boolean isCloudEnrolled = CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId());
    protected AppliablePolicyPool pool;

    protected PolicySelectDlg(String groupName, String locationName, String oldPolicyName) {
        super("");
        this.setContentPane(this.getPolicyPanel(groupName, locationName, oldPolicyName));
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setData();
    }

    public static SelectDlg getSelectDlg(String policyTargetName, String groupName, String locationName, String oldPolicyName) {
        if (policyTargetName.equals("AvPolicyApplied")) {
            return new AvPolicySelectDlg(groupName, locationName, oldPolicyName);
        }
        if (policyTargetName.equals("FirewallPolicyApplied")) {
            return new FirewallPolicySelectDlg(groupName, locationName, oldPolicyName);
        }
        if (policyTargetName.equals("HostIntegrityApplied")) {
            return new HostIntegritySelectDlg(groupName, locationName, oldPolicyName);
        }
        if (policyTargetName.equals("OpAppProtectionPolicyApplied")) {
            return new OSProtectPolicySelectDlg(groupName, locationName, oldPolicyName);
        }
        if (policyTargetName.equals("PolicyOverrideApplied")) {
            return new OverridePolicySelectDlg(groupName, locationName, oldPolicyName);
        }
        if (policyTargetName.equals("LuPolicyApplied")) {
            return new LuPolicySelectDlg(groupName, locationName, oldPolicyName);
        }
        if (policyTargetName.equals("IdsPolicyApplied")) {
            return new IdsPolicySelectDlg(groupName, locationName, oldPolicyName);
        }
        if (policyTargetName.equals("MemPolicyApplied")) {
            return new MemPolicySelectDlg(groupName, locationName, oldPolicyName);
        }
        if (policyTargetName.equals("NtrPolicyApplied")) {
            return new NtrPolicySelectDlg(groupName, locationName, oldPolicyName);
        }
        if (policyTargetName.equals("UpgradePolicyApplied")) {
            return new UpgradePolicySelectDlg(groupName, locationName, oldPolicyName);
        }
        if (policyTargetName.equals("AdaptivePolicyApplied")) {
            return new AdaptivePolicySelectDlg(groupName, locationName, oldPolicyName);
        }
        if (policyTargetName.equals("QuarantineAvPolicyApplied")) {
            return new QuarantineAvPolicySelectDlg(groupName, locationName, oldPolicyName);
        }
        if (policyTargetName.equals("QuarantineFWPolicyApplied")) {
            return new QuarantinePolicySelectDlg(groupName, locationName, oldPolicyName);
        }
        if (policyTargetName.equals("QuarantineOSPPolicyApplied")) {
            return new QuarantineOSPSelectDlg(groupName, locationName, oldPolicyName);
        }
        if (policyTargetName.equals("QuarantineCePolicyApplied")) {
            return new QuarantineCeSelectDlg(groupName, locationName, oldPolicyName);
        }
        if (policyTargetName.equals("QuarantineLuPolicyApplied")) {
            return new QuarantineLuPolicySelectDlg(groupName, locationName, oldPolicyName);
        }
        if (policyTargetName.equals("QuarantineIdsPolicyApplied")) {
            return new QuarantineIdsPolicySelectDlg(groupName, locationName, oldPolicyName);
        }
        if (policyTargetName.equals("QuarantineMemPolicyApplied")) {
            return new QuarantineMemPolicySelectDlg(groupName, locationName, oldPolicyName);
        }
        if (policyTargetName.equals("QuarantineNtrPolicyApplied")) {
            return new QuarantineNtrPolicySelectDlg(groupName, locationName, oldPolicyName);
        }
        if (policyTargetName.equals("QuarantineUpgradePolicyApplied")) {
            return new QuarantineUpgradePolicySelectDlg(groupName, locationName, oldPolicyName);
        }
        if (policyTargetName.equals("QuarantineAdaptivePolicyApplied")) {
            return new QuarantineAdaptivePolicySelectDlg(groupName, locationName, oldPolicyName);
        }
        return null;
    }

    @Override
    public WizardPanel getNextPanel() {
        return null;
    }

    @Override
    public WizardPanel getPreviousPanel() {
        return null;
    }

    @Override
    public void setPreviousPanel(WizardPanel panel) {
    }

    @Override
    public void addListener(WizardListener listener) {
    }

    @Override
    public void removeListener(WizardListener listener) {
    }

    @Override
    public Dimension getWizardPreferredSize() {
        return this.getPreferredSize();
    }

    protected abstract AppliablePolicyPool getPolicyPool() throws ConsoleException;

    protected abstract BasePolicyDialog getPolicyEditor();

    protected void setTitles(String title, String borderTitle) {
        this.setTitleName(borderTitle);
        if (title == null) {
            title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "PolicySelectDlg.title");
            this.setDescription(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "PolicySelectDlg.addNewPolicyDesc"));
        }
        this.setTitle(title);
    }

    @Override
    protected void setData() {
        try {
            this.pool = this.getPolicyPool();
            ObjInfoObject[] infoObj = this.pool.getInfoObjectList();
            for (int i = 0; i < infoObj.length; ++i) {
                String type;
                PolicyObjectBase policyObj;
                if (this.isCloudEnrolled && (policyObj = (PolicyObjectBase)PolicyHelper.getPolicyObject(infoObj[i])).getItemType() == 128 && policyObj.isExclusiveEdit() || (type = infoObj[i].getTargetType()) != null && !type.equals("IdsPolicy")) continue;
                this.policyModel.addElement(infoObj[i]);
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicySelectDlg.error"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    @Override
    protected boolean isValidate() {
        return true;
    }

    @Override
    protected void commit() {
        try {
            this.selectedServerList = this.getUIObject();
            if (LicenseObject.getInstance().isSBProduct()) {
                PolicyHelper.refreshSerialNumber();
            }
        }
        catch (HeadlessException e1) {
            LoggerUtilities.logException((Throwable)e1);
            JOptionPane.showMessageDialog(Manager.getFrame(), e1.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "SelectDlg.error"), 0);
            Manager.getFrame().showLoginPanel();
        }
        catch (ConsoleException e1) {
            LoggerUtilities.logException((Throwable)e1);
            JOptionPane.showMessageDialog(Manager.getFrame(), e1.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "SelectDlg.error"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private JPanel getPolicyPanel(String groupName, String locationName, String oldPolicyName) {
        boolean isAddNewPolicy;
        boolean bl = isAddNewPolicy = oldPolicyName == null;
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            MessageResources mRes = MessageResources.getInstance();
            String resFile = "com.sygate.scm.console.ui.policy.dialog.policydialog";
            JLabel groupLbl = new JLabel(mRes.getString(resFile, "SelectDlg.group"));
            JLabel locLbl = new JLabel(mRes.getString(resFile, "SelectDlg.location"));
            DescriptionTextArea groupNameLbl = new DescriptionTextArea("");
            if (groupName != null && groupName.length() > 50) {
                groupNameLbl.setText(groupName.substring(0, 50) + "...");
            } else {
                groupNameLbl.setText(groupName);
            }
            String newPolicyStr = mRes.getString(resFile, "SelectDlg.newPolicy");
            if (isAddNewPolicy) {
                newPolicyStr = mRes.getString(resFile, "SelectDlg.addPolicy");
            }
            JLabel newPolicy = new JLabel(newPolicyStr);
            JLabel oPolicyLbl = new JLabel(mRes.getString(resFile, "SelectDlg.oldPolicy"));
            JLabel locNameLbl = new JLabel(locationName);
            this.jPanel.setLayout(new GridBagLayout());
            this.getJTextArea().setColumns(45);
            this.jPanel.add((Component)this.getJTextArea(), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 5, 10), 0, 0));
            this.jPanel.add((Component)groupLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 2, 10), 0, 0));
            this.jPanel.add((Component)groupNameLbl, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 2, 10), 0, 0));
            if (!LicenseObject.getInstance().isSBProduct()) {
                this.jPanel.add((Component)locLbl, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 2, 10), 0, 0));
                this.jPanel.add((Component)locNameLbl, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 2, 10), 0, 0));
            }
            int gridY = 3;
            if (oldPolicyName != null) {
                JLabel oPolicyNameLbl = new JLabel(oldPolicyName);
                this.jPanel.add((Component)oPolicyLbl, new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 2, 10), 0, 0));
                this.jPanel.add((Component)oPolicyNameLbl, new GridBagConstraints(1, gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 2, 10), 0, 0));
                ++gridY;
            }
            this.jPanel.add((Component)newPolicy, new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 15, 10), 0, 0));
            this.jPanel.add(this.getPolicyList(), new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 15, 10), 0, 0));
            this.jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), mRes.getString(resFile, "SelectDlg.policyManagerLists"), 0, 0, null, null));
        }
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.add((Component)this.jPanel, "Center");
        wrapPanel.add((Component)this.getButtonPanel(), "South");
        return wrapPanel;
    }

    public JComboBox<ObjInfoObject> getPolicyList() {
        if (this.policyList == null) {
            this.policyList = new JComboBox();
            this.policyList.setModel(this.policyModel);
        }
        return this.policyList;
    }
}

