/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.OS;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AlSignatureOrObject;
import com.sygate.scm.console.ui.policy.common.OSPanel;
import com.sygate.scm.console.ui.policy.dialog.ConditionsPanelBase;
import com.sygate.scm.console.ui.util.DialogBase;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class OSVersionConditionsPanel
extends ConditionsPanelBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String POLICYDIALOG = "com.sygate.scm.console.ui.policy.dialog.policydialog";
    private static final int DLG_WIDTH = 600;
    private static final int DLG_HEIGHT = 200;
    private OSPanel editor = new OSPanel();
    private String editorTitle;

    OSVersionConditionsPanel(String conditionTitle, String equalMessage, String notEqualMessage, String editorTitle) {
        super(conditionTitle, equalMessage, notEqualMessage);
        this.editorTitle = editorTitle;
    }

    @Override
    String getCellText(Object value) {
        String text = null;
        text = this.formatOS((OS)value);
        return text;
    }

    @Override
    public Object[] getConditions() {
        int count = this.listModel.size();
        Object[] conditions = null;
        conditions = new OS[count];
        for (int index = 0; index < count; ++index) {
            conditions[index] = this.listModel.get(index);
        }
        return conditions;
    }

    @Override
    public void showEditor(boolean isNew) {
        new EditorDialog(Manager.getFrame(), this, this.editorTitle, true, isNew);
    }

    private String formatOS(OS os) {
        StringBuilder buffer = new StringBuilder();
        if (os.getOptName() != null) {
            buffer.append(" ");
            buffer.append(AlSignatureOrObject.OS_VERSION_NAME_DESC);
            buffer.append(os.getOptName());
        }
        buffer.append(AlSignatureOrObject.OS_VERSION_ARCH_DESC);
        try {
            buffer.append(os.getOptArchValue());
        }
        catch (ValidationException e) {
            buffer.append(AlSignatureOrObject.OS_VERSION_INVALID_ARCH_DESC);
        }
        if (os.getOptBuildNumber() != null) {
            buffer.append(" ");
            buffer.append(AlSignatureOrObject.OS_VERSION_BUILD_NUMBER_DESC);
            buffer.append(os.getOptBuildNumber());
        }
        return buffer.toString();
    }

    private class EditorDialog
    extends DialogBase {
        private static final long serialVersionUID = 1L;
        boolean isNew;

        public EditorDialog(JFrame parent, JPanel relativePanel, String title, boolean modal, boolean isNew) {
            super(parent, title, modal);
            this.isNew = isNew;
            this.initialize(relativePanel);
        }

        private void initialize(JPanel relativePanel) {
            Container container = this.getContentPane();
            GridBagConstraints constraints = new GridBagConstraints();
            JPanel centralpanel = new JPanel(new GridBagLayout());
            constraints.anchor = 17;
            constraints.insets = new Insets(3, 15, 3, 15);
            constraints.weightx = 1.0;
            constraints.gridy = 1;
            constraints.fill = 1;
            centralpanel.add((Component)OSVersionConditionsPanel.this.editor, constraints);
            container.add((Component)centralpanel, "Center");
            if (!this.isNew) {
                OS os = (OS)OSVersionConditionsPanel.this.conditionsList.getSelectedValue();
                OSVersionConditionsPanel.this.editor.setOS(os);
            }
            container.add((Component)this.getButtonPanel(), "South");
            this.setSize(600, 200);
            this.setLocationRelativeTo(relativePanel);
            this.setVisible(true);
        }

        @Override
        protected boolean isHelpButtonShown() {
            return false;
        }

        @Override
        protected boolean isValidate() {
            OS condition = OSVersionConditionsPanel.this.editor.getOS();
            if (condition == null) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(OSVersionConditionsPanel.POLICYDIALOG, "AutoLocationPanel.enterNameForOSVersion"), MSGRES.getString(OSVersionConditionsPanel.POLICYDIALOG, "AutoLocationPanel.error"), 0);
                return false;
            }
            return true;
        }

        @Override
        protected void commit() {
            OS condition = OSVersionConditionsPanel.this.editor.getOS();
            if (this.isNew) {
                OSVersionConditionsPanel.this.addCondition(condition);
            } else {
                OS selectedOS = (OS)OSVersionConditionsPanel.this.conditionsList.getSelectedValue();
                selectedOS.setOptArch(condition.getOptArch());
                selectedOS.setOptBuildNumber(condition.getOptBuildNumber());
                selectedOS.setOptName(condition.getOptName());
            }
            this.dispose();
            OSVersionConditionsPanel.this.conditionsList.updateUI();
        }
    }
}

