/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.schema.ExtendedOpDevice;
import com.sygate.scm.common.configobject.schema.OpDevice;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.UsbDeviceHandler;
import com.sygate.scm.console.logicobject.DeviceObject;
import com.sygate.scm.console.ui.policy.common.ButtonPane;
import com.sygate.scm.console.ui.util.MacDeviceControlRuleUtil;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MacDeviceSelectDialog
extends JDialog {
    private static final long serialVersionUID = -2769737510259298789L;
    private List<DeviceObject> selectedDeviceList;
    private List<DeviceObject> intDeviceList;
    private List<DeviceObject> intDeviceList2;
    private JTable deviceTable;
    private SortableTableModel model = new SortableTableModel();
    private JScrollPane scrollPane;
    private JTextField jTFVendor = new JTextField();
    private JTextField jTFModel = new JTextField();
    private JTextField jTFSerialNumber = new JTextField();
    private JComboBox<String> jCBPermission = new JComboBox();
    private Integer[] permssionValus = new Integer[]{ExtendedOpDevice.READONLY, ExtendedOpDevice.READWRITE, ExtendedOpDevice.READEXECUTE, ExtendedOpDevice.ALL};
    private JButton okButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private boolean isCancel;
    private final String[] tableColumnName = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "MacDeviceSelectDialog.column.DeviceName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "MacDeviceSelectDialog.column.Identification")};
    private final int[] tableColumnMap = new int[]{0, 2};
    private final float[] tableColumnWidth = new float[]{1.0f, 1.0f};
    private int selectionModel;
    private boolean isBlock;
    private boolean isEdit;
    private DeviceObject editObject;
    private transient ListSelectionListener tableSelectionListener;

    public MacDeviceSelectDialog(List<DeviceObject> intList, List<DeviceObject> intList2, boolean isBlock, boolean isEdit, DeviceObject editObj) {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "MacDeviceSelectDialog.title"), true);
        this.intDeviceList = intList;
        this.intDeviceList2 = intList2;
        this.editObject = editObj;
        this.isBlock = isBlock;
        this.isEdit = isEdit;
        this.selectionModel = 0;
        this.init();
    }

    public MacDeviceSelectDialog(List<DeviceObject> intList, List<DeviceObject> intList2, boolean isBlock) {
        this(intList, intList2, isBlock, false, null);
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.initMainSelectionPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setSize(new Dimension(520, this.isBlock ? 320 : 360));
        this.setDefaultCloseOperation(2);
        UiUtilities.centerComponent((Component)this);
        this.refreshData();
        this.okButton.setEnabled(this.isEdit);
        this.jCBPermission.setEnabled(this.isEdit);
        this.jTFModel.setEditable(this.isEdit);
        this.jTFVendor.setEditable(this.isEdit && this.isVendorFieldEditable(this.editObject == null ? null : this.editObject.getDeviceClassId()));
        this.jTFSerialNumber.setEditable(this.isEdit && this.isSerialNumberFieldEditable(this.editObject == null ? null : this.editObject.getDeviceClassId()));
        this.setVisible(true);
    }

    private boolean isSerialNumberFieldEditable(String deviceType) {
        return "Mac USB".equals(deviceType) || "Mac Thunderbolt".equals(deviceType);
    }

    private boolean isVendorFieldEditable(String deviceType) {
        return !"Mac Thunderbolt".equals(deviceType);
    }

    private JScrollPane initScrollPaneTable() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
        }
        if (this.deviceTable == null) {
            this.deviceTable = new StripesTable();
            this.model.setColumnNames(this.tableColumnName);
            this.model.setColumnMapping(this.tableColumnMap);
            this.model.addMouseListenerToHeaderInTable(this.deviceTable);
            this.deviceTable.setModel(this.model);
            this.deviceTable.getSelectionModel().addListSelectionListener(this.getTableSelectionListener());
            this.deviceTable.getSelectionModel().setSelectionMode(this.selectionModel);
            UIUtilities.resizeColumns(this.deviceTable, this.tableColumnWidth, this.scrollPane.getWidth());
        }
        UiUtilities.setupScrollPane((JScrollPane)this.scrollPane, (JTable)this.deviceTable);
        return this.scrollPane;
    }

    private JPanel initMainSelectionPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.initScrollPaneTable(), "Center");
        mainPanel.add((Component)this.initExtendFieldPanel(), "South");
        return mainPanel;
    }

    private JPanel initExtendFieldPanel() {
        JPanel extraFieldsPanel = new JPanel();
        extraFieldsPanel.setLayout(new GridBagLayout());
        int gridy = 0;
        if (!this.isBlock) {
            extraFieldsPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "MacDeviceSelectDialog.label.Permission")), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.initPermissionComboBox();
            extraFieldsPanel.add(this.jCBPermission, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        }
        RestrictedPlainDocument vendorDoc = new RestrictedPlainDocument(128);
        extraFieldsPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "MacDeviceSelectDialog.label.DeviceVendor")), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        extraFieldsPanel.add((Component)this.jTFVendor, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.jTFVendor.setDocument(vendorDoc);
        RestrictedPlainDocument modelDoc = new RestrictedPlainDocument(128);
        extraFieldsPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "MacDeviceSelectDialog.label.DeviceModel")), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        extraFieldsPanel.add((Component)this.jTFModel, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.jTFModel.setDocument(modelDoc);
        RestrictedPlainDocument serialDoc = new RestrictedPlainDocument(128);
        extraFieldsPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "MacDeviceSelectDialog.label.SerialNumber")), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        extraFieldsPanel.add((Component)this.jTFSerialNumber, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.jTFSerialNumber.setDocument(serialDoc);
        return extraFieldsPanel;
    }

    private void initPermissionComboBox() {
        for (Integer item : this.permssionValus) {
            this.jCBPermission.addItem(DeviceObject.getPermssionMessage(item));
        }
    }

    protected void refreshData() {
        try {
            this.model.removeAll();
            ArrayList<OpDevice> list = UsbDeviceHandler.getPooledDevicesByPlatform(OpDevice.MAC);
            int selIndex = 0;
            for (OpDevice device : list) {
                DeviceObject deviceObject = new DeviceObject(device);
                this.model.addRow(deviceObject);
                if (this.isEdit && this.editObject != null && deviceObject.equals(this.editObject)) {
                    this.deviceTable.changeSelection(selIndex, -1, false, true);
                    this.deviceTable.scrollRectToVisible(this.deviceTable.getCellRect(selIndex, -1, false));
                    if (!this.isBlock) {
                        this.jCBPermission.setSelectedItem(DeviceObject.getPermssionMessage(this.editObject.getPermission()));
                    }
                    this.jTFModel.setText(this.editObject.getDeviceModel());
                    this.jTFVendor.setText(this.editObject.getDeviceVendor());
                    this.jTFSerialNumber.setText(this.editObject.getSerialNumber());
                }
                ++selIndex;
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.okButton = new JButton(UIText.get(3584));
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MacDeviceSelectDialog.this.isValidated()) {
                        MacDeviceSelectDialog.this.this_okAction(e);
                        MacDeviceSelectDialog.this.dispose();
                    }
                }
            });
            this.cancelButton = new JButton(UIText.get(512));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacDeviceSelectDialog.this.isCancel = true;
                    MacDeviceSelectDialog.this.dispose();
                }
            });
            JButton[] buttons = new JButton[]{this.okButton, this.cancelButton};
            this.buttonPanel = new ButtonPane(buttons, 4);
        }
        return this.buttonPanel;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    private boolean isValidated() {
        boolean ret = false;
        int[] iSelectedRow = this.deviceTable.getSelectedRows();
        if (iSelectedRow.length > 0) {
            DeviceObject deviceObject = (DeviceObject)Cast.cast((Object)this.model.getRow(this.deviceTable.getSelectedRow()));
            deviceObject.setPermission(this.isBlock ? null : this.permssionValus[this.jCBPermission.getSelectedIndex()]);
            deviceObject.setDeviceVendor(this.getVendor());
            deviceObject.setDeviceModel(this.getModel());
            deviceObject.setSerialNumber(this.getSerialNumber());
            if (this.isEdit) {
                if (MacDeviceControlRuleUtil.isDuplicatedMacDeviceItem(this.editObject, deviceObject)) {
                    ret = true;
                } else if (!this.isItemAlreadyExist(deviceObject, this.intDeviceList, this.isBlock) && !this.isItemAlreadyExist(deviceObject, this.intDeviceList2, !this.isBlock)) {
                    ret = true;
                }
            } else if (!this.isItemAlreadyExist(deviceObject, this.intDeviceList, this.isBlock) && !this.isItemAlreadyExist(deviceObject, this.intDeviceList2, !this.isBlock)) {
                ret = true;
            }
        }
        return ret;
    }

    private boolean isItemAlreadyExist(DeviceObject curSelectionItem, List<DeviceObject> alreadySelected, boolean isCheckBlockedList) {
        boolean ret = false;
        for (DeviceObject existed : alreadySelected) {
            if (!MacDeviceControlRuleUtil.isDuplicatedMacDeviceItem(existed, curSelectionItem)) continue;
            ret = true;
            String strListName = isCheckBlockedList ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.label.BlockedDevices") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.label.DevicesExcludedromBlocking");
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.warning.DeviceAlreadyInList"), curSelectionItem.getName(), strListName), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "MacDeviceBlockPanel.title.Warning"), 0);
            break;
        }
        return ret;
    }

    private String getModel() {
        String input = this.jTFModel.getText().trim();
        if (StringUtilities.isEmpty((String)input) || "*".equals(input)) {
            input = ".*";
        }
        return input;
    }

    private String getVendor() {
        String input = this.jTFVendor.getText().trim();
        if (StringUtilities.isEmpty((String)input) || "*".equals(input)) {
            input = ".*";
        }
        return input;
    }

    private String getSerialNumber() {
        String input = this.jTFSerialNumber.getText().trim();
        if (StringUtilities.isEmpty((String)input) || "*".equals(input)) {
            input = ".*";
        }
        return input;
    }

    private void this_okAction(ActionEvent e) {
        try {
            if (this.selectedDeviceList == null) {
                this.selectedDeviceList = new ArrayList<DeviceObject>();
            }
            int[] iSelectedRow = this.deviceTable.getSelectedRows();
            for (int i = 0; i < iSelectedRow.length; ++i) {
                DeviceObject deviceObject = (DeviceObject)Cast.cast((Object)this.model.getRow(iSelectedRow[i]));
                deviceObject.setPermission(this.isBlock ? null : this.permssionValus[this.jCBPermission.getSelectedIndex()]);
                deviceObject.setDeviceVendor(this.getVendor());
                deviceObject.setDeviceModel(this.getModel());
                deviceObject.setSerialNumber(this.getSerialNumber());
                this.selectedDeviceList.add(deviceObject);
            }
            this.isCancel = false;
        }
        catch (Exception e1) {
            LoggerUtilities.logException((Throwable)e1);
            JOptionPane.showMessageDialog(Manager.getFrame(), e1.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "MacDeviceSelectDialog.error.title"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private ListSelectionListener getTableSelectionListener() {
        if (this.tableSelectionListener == null) {
            this.tableSelectionListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    MacDeviceSelectDialog.this.jCBPermission.setEnabled(true);
                    if (!MacDeviceSelectDialog.this.isBlock) {
                        MacDeviceSelectDialog.this.jCBPermission.setSelectedIndex(0);
                    }
                    MacDeviceSelectDialog.this.jTFModel.setEditable(true);
                    MacDeviceSelectDialog.this.okButton.setEnabled(true);
                    DeviceObject deviceObject = null;
                    int[] iSelectedRow = MacDeviceSelectDialog.this.deviceTable.getSelectedRows();
                    for (int i = 0; i < iSelectedRow.length; ++i) {
                        deviceObject = (DeviceObject)Cast.cast((Object)MacDeviceSelectDialog.this.model.getRow(iSelectedRow[i]));
                    }
                    MacDeviceSelectDialog.this.updateSerialNumberField(deviceObject);
                    MacDeviceSelectDialog.this.updateVendorField(deviceObject);
                }
            };
        }
        return this.tableSelectionListener;
    }

    private void updateSerialNumberField(DeviceObject deviceObject) {
        if (deviceObject == null) {
            this.jTFSerialNumber.setText("");
            this.jTFSerialNumber.setEditable(false);
        } else if (this.isSerialNumberFieldEditable(deviceObject.getDeviceClassId())) {
            this.jTFSerialNumber.setEditable(true);
        } else {
            this.jTFSerialNumber.setText("");
            this.jTFSerialNumber.setEditable(false);
        }
    }

    private void updateVendorField(DeviceObject deviceObject) {
        if (deviceObject == null) {
            this.jTFVendor.setText("");
            this.jTFVendor.setEditable(false);
        } else if (this.isVendorFieldEditable(deviceObject.getDeviceClassId())) {
            this.jTFVendor.setEditable(true);
        } else {
            this.jTFVendor.setText("");
            this.jTFVendor.setEditable(false);
        }
    }

    public List<DeviceObject> getSelection() {
        if (this.selectedDeviceList == null && AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            this.selectedDeviceList = new ArrayList<DeviceObject>();
        }
        return this.selectedDeviceList;
    }
}

