/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.schema.ComputerImage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.WhiteListHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.LockdownFileListObject;
import com.sygate.scm.console.ui.policy.dialog.LockDownPanel;
import com.sygate.scm.console.ui.policy.dialog.SelectDlg;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.util.ArrayList;
import javax.swing.JFrame;

public class LockdownWhiteListDlg
extends SelectDlg {
    private static final long serialVersionUID = 1L;
    private static final String AUTOMATION_ID_FINGERPRINT_LIST_PANEL = "FingerprintListPanel";
    private static final String AUTOMATION_ID_FINGERPRINT_LIST_PANEL_OK = "FingerprintListPanelOK";
    private LockDownPanel lockDownPanel = null;

    public LockdownWhiteListDlg(LockDownPanel lockDownPanel, JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.lockDownPanel = lockDownPanel;
        this.refresh();
        this.setTitleName(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockdownWhiteListDlg.fileFingerPrint"));
        this.setDescription(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockdownWhiteListDlg.theListBelowShowsTheFingerprintFiles"));
        UIUtilities.setName(this.jPanel, "clientPage", UIUtilities.ComponentType.JPANEL, AUTOMATION_ID_FINGERPRINT_LIST_PANEL);
        UIUtilities.setName(this.jBOk, "clientPage", UIUtilities.ComponentType.BUTTON, AUTOMATION_ID_FINGERPRINT_LIST_PANEL_OK);
    }

    @Override
    protected void setData() {
        this.refresh();
    }

    @Override
    protected AbstractUIObject getUIObject() throws ConsoleException {
        return (AbstractUIObject)this.serverModel.getElementAt(this.serverList.getSelectedIndex());
    }

    protected void refresh() {
        try {
            this.serverModel.removeAllElements();
            ArrayList<ComputerImage> list = WhiteListHandler.getComputerImagesFromPool();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    LockdownFileListSelectObject o = new LockdownFileListSelectObject(list.get(i), false);
                    if (this.lockDownPanel != null) {
                        if (this.lockDownPanel.hasWhiteList(o)) continue;
                        this.serverModel.addElement(o);
                        continue;
                    }
                    this.serverModel.addElement(o);
                }
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    static class LockdownFileListSelectObject
    extends LockdownFileListObject {
        public LockdownFileListSelectObject(ComputerImage image, boolean test) {
            super(image, test);
        }

        @Override
        public String toString() {
            return this.getDisplayName();
        }

        private String getDisplayName() {
            return this.getName();
        }
    }
}

