/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.logicobject.ComputerLockdownProtectionObject;
import com.sygate.scm.console.logicobject.LockdownExceptionObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class LockdownViewExceptionsDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final int DLG_WIDTH = 900;
    private final float[] COL_SIZE = new float[]{0.18f, 0.12f, 0.1f, 0.2f, 0.2f, 0.2f};
    private ComputerLockdownProtectionObject lockdownObj = null;
    private String[] groupId = null;
    private final JPanel upPanel = new JPanel();
    private final SortableTableModel tmExceptionTable = new SortableTableModel();
    private final JTable tbExceptionTable = new StripesTable();
    private final JTextArea lbDescription = new JTextArea();
    private final JButton resetBtn = new JButton();
    private final JScrollPane tableSPane = new JScrollPane();

    public LockdownViewExceptionsDlg(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    @Override
    protected boolean isCancelButtonShown() {
        return false;
    }

    @Override
    protected String getOkButtonText() {
        return UIText.get(519);
    }

    private void jbInit() throws Exception {
        this.lbDescription.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockdownViewExceptionsDlg.theCurrentTestHasBeenRunning"));
        this.lbDescription.setEditable(false);
        this.lbDescription.setOpaque(false);
        this.lbDescription.setLineWrap(true);
        this.lbDescription.setWrapStyleWord(true);
        this.lbDescription.setFont(this.upPanel.getFont());
        this.lbDescription.setAlignmentX(0.0f);
        this.lbDescription.setAlignmentY(0.0f);
        this.lbDescription.setMargin(new Insets(0, 20, 0, 0));
        JPanel panelReset = new JPanel();
        panelReset.setLayout(new FlowLayout(2));
        this.resetBtn.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockdownViewExceptionsDlg.resetTest"));
        this.resetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LockdownViewExceptionsDlg.this.resetBtnActionPerformed();
            }
        });
        panelReset.add(this.resetBtn);
        String[] COL_NAMES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockdownViewExceptionsDlg.time"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockdownViewExceptionsDlg.machineName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockdownViewExceptionsDlg.userName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockdownViewExceptionsDlg.fileName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockdownViewExceptionsDlg.processName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockdownViewExceptionsDlg.description")};
        this.tmExceptionTable.setColumnNames(COL_NAMES);
        this.tmExceptionTable.setEditMode(false);
        this.tmExceptionTable.addMouseListenerToHeaderInTable(this.tbExceptionTable);
        this.tbExceptionTable.setModel(this.tmExceptionTable);
        this.tbExceptionTable.setAutoResizeMode(0);
        this.upPanel.setLayout(new BorderLayout());
        this.upPanel.setBorder(BorderFactory.createEmptyBorder(20, 10, 20, 10));
        this.tableSPane.getViewport().add(this.tbExceptionTable);
        this.upPanel.add((Component)this.tableSPane, "Center");
        this.upPanel.add((Component)panelReset, "South");
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(8, 10, 8, 10));
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.lbDescription, "North");
        mainPanel.add((Component)this.upPanel, "Center");
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setSize(new Dimension(900, 380));
        UiUtilities.centerComponent((Component)this);
    }

    public void init(ComputerLockdownProtectionObject lockdownObj, String[] groupId, boolean isReadOnly) {
        this.lockdownObj = lockdownObj;
        this.groupId = groupId == null ? null : (String[])groupId.clone();
        this.resetBtn.setEnabled(!isReadOnly);
        this.refresh();
        int width = this.tableSPane.getWidth();
        if (width == 0) {
            width = 833;
        }
        UIUtilities.setTableColumnWidth(this.tbExceptionTable, this.COL_SIZE, width);
    }

    private void resetBtnActionPerformed() {
        this.lockdownObj.resetLastTestModifiedTime();
        this.refresh();
    }

    private void refresh() {
        this.tmExceptionTable.removeAll();
        if (this.groupId != null) {
            ArrayList<LockdownExceptionObject> list;
            this.lbDescription.setText(this.lockdownObj.getStatusDisplayString(this.groupId));
            if (this.lockdownObj.hasTestRunning() && (list = this.lockdownObj.getExceptionList(this.groupId)) != null) {
                for (int i = 0; i < list.size(); ++i) {
                    LockdownExceptionObject e = list.get(i);
                    this.tmExceptionTable.addRow(e);
                }
            }
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_hdp_hardware_device_protection_add_file_definition_view_unapproved";
    }
}

