/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.AdditionalAllowedFile;
import com.sygate.scm.common.configobject.schema.AppliedImage;
import com.sygate.scm.common.configobject.schema.ComputerImage;
import com.sygate.scm.common.configobject.schema.OpFileNameMatchEntity;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.WhiteListHandler;
import com.sygate.scm.console.logicobject.ComputerLockdownProtectionObject;
import com.sygate.scm.console.logicobject.LockdownFileListObject;
import com.sygate.scm.console.ui.policy.av.common.DashLine;
import com.sygate.scm.console.ui.policy.dialog.AdditionalTextDialog;
import com.sygate.scm.console.ui.policy.dialog.LockdownExtraFileTableModel;
import com.sygate.scm.console.ui.policy.dialog.LockdownFingerprintListTableModel;
import com.sygate.scm.console.ui.policy.dialog.LockdownViewExceptionsDlg;
import com.sygate.scm.console.ui.policy.dialog.LockdownWhiteListDlg;
import com.sygate.scm.console.ui.policy.osprotect.dialog.StringConditionEditorDlg;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class LockDownPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String MSG_KEY_ERROR = "LockDownPanel.error";
    private static final String AUTOMATION_TEST_POLICY = "SystemLockdownTestMode";
    private static final String AUTOMATION_NORMAL_POLICY = "SystemLockdownNormalMode";
    private static final String AUTOMATION_DISABLE_POLICY = "SystemLockdownDisableMode";
    private static final String AUTOMATION_ACTION_ALLOW = "SystemLockdownAllowMode";
    private static final String AUTOMATION_ACTION_DENY = "SystemLockdownDenyMode";
    private static final String AUTOMATION_FINGERPRINTLIST_ADD = "FingerprintListAdd";
    private static final float[] COL_SIZE_FINGERPRINTLIST = new float[]{0.7f, 0.3f};
    private static final float[] COL_SIZE_EXTRAFILES = new float[]{0.6f, 0.4f};
    private static final String COL_NAME_TEST_BEFORE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.testBeforeRemoval");
    private static final String COL_NAME_FINGERPRINT_LIST = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.fileFingerprintList");
    private static final String WARNING_MESSAGE_EMPTY_APP_LIST = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.eitherUnapprovedExecutablesOrExtraFilesCannotBeEmpty");
    private static final String[] COL_NAMES_FINGERPRINTLIST = new String[]{COL_NAME_FINGERPRINT_LIST, COL_NAME_TEST_BEFORE};
    private static final String[] COL_NAMES_EXTRAFILES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.fileName"), COL_NAME_TEST_BEFORE};
    private ComputerLockdownProtectionObject lockdownObj = null;
    private String[] groupId;
    boolean isReadOnly = false;
    private String extraMessage = null;
    private final JRadioButton rbDisablePolicy = new JRadioButton();
    private final JRadioButton rbTestPolicy = new JRadioButton();
    private final JTextArea lbTestPolicy = new JTextArea();
    private final JRadioButton rbActivatePolicy = new JRadioButton();
    private final JTextArea lbActivatePolicy = new JTextArea();
    private final JRadioButton rbAllowPolicy = new JRadioButton();
    private final JTextArea lbAllowPolicy = new JTextArea();
    private final JRadioButton rbDenyPolicy = new JRadioButton();
    private final JTextArea lbDenyPolicy = new JTextArea();
    private final LockdownFingerprintListTableModel tmFingerprintList = new LockdownFingerprintListTableModel();
    private final JTable tbFingerprintList = new StripesTable();
    private JScrollPane spFingerprintList = null;
    private final JButton btFingerprintListAdd = new JButton();
    private final JButton btFingerprintListRemove = new JButton();
    private final LockdownExtraFileTableModel tmExtraFiles = new LockdownExtraFileTableModel();
    private final JTable tbExtraFiles = new StripesTable();
    private JScrollPane spExtraFiles = null;
    private final JButton btExtraFilesImport = new JButton();
    private final JButton btExtraFilesAdd = new JButton();
    private final JButton btExtraFilesRemove = new JButton();
    private final JTextArea taStatus = new JTextArea();
    private final JButton btViewExceptionList = new JButton();
    private final JCheckBox cbNotify = new JCheckBox();
    private final JButton btNotification = new JButton();
    JPanel panelPolicyMode = null;
    JPanel panelSettings = null;
    JPanel panelStatus = null;
    private final ButtonGroup buttonGroupFirst = new ButtonGroup();
    private final ButtonGroup buttonGroupSecond = new ButtonGroup();
    private final DashLine dashLine = new DashLine(UIColorUtilities.CONTROL_BACKGROUND, 5000);
    TableColumn columnTestForRemoveForWhiteList = null;
    TableColumn columnTestForRemoveForExtraFile = null;

    public LockDownPanel() {
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.panelPolicyMode = this.initGUI_PolicyMode();
        this.panelSettings = this.initGUI_Settings();
        this.panelStatus = this.initGUI_Status();
        this.adjustSize();
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.add((Component)this.panelPolicyMode, "North");
        this.add((Component)this.panelSettings, "Center");
        this.add((Component)this.panelStatus, "South");
    }

    private JPanel initGUI_PolicyMode() {
        this.rbDisablePolicy.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.disableSystemLockdown"));
        this.rbDisablePolicy.setAlignmentX(0.0f);
        this.rbDisablePolicy.setAlignmentY(0.0f);
        this.rbDisablePolicy.addActionListener(e -> this.policyMode_actionPerformed(e));
        this.rbDisablePolicy.setSelected(true);
        this.rbTestPolicy.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.step1LogUnapprovedApplication"));
        this.rbTestPolicy.setAlignmentX(0.0f);
        this.rbTestPolicy.setAlignmentY(0.0f);
        this.rbTestPolicy.addActionListener(e -> this.policyMode_actionPerformed(e));
        this.lbTestPolicy.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.ifSelectedApplicationsNotInAnyApprovedExecutablesListAreLogged"));
        this.lbTestPolicy.setEditable(false);
        this.lbTestPolicy.setOpaque(false);
        this.lbTestPolicy.setLineWrap(true);
        this.lbTestPolicy.setWrapStyleWord(true);
        this.lbTestPolicy.setFont(this.rbDisablePolicy.getFont());
        this.lbTestPolicy.setAlignmentX(0.0f);
        this.lbTestPolicy.setAlignmentY(0.0f);
        this.rbActivatePolicy.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.step2EnableSystemLockdown"));
        this.rbActivatePolicy.setAlignmentX(0.0f);
        this.rbActivatePolicy.setAlignmentY(0.0f);
        this.rbActivatePolicy.addActionListener(e -> this.policyMode_actionPerformed(e));
        this.lbActivatePolicy.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.ifSelectedApplicationsNotInAnyApprovedExecutablesListAreBlocked"));
        this.lbActivatePolicy.setEditable(false);
        this.lbActivatePolicy.setOpaque(false);
        this.lbActivatePolicy.setLineWrap(true);
        this.lbActivatePolicy.setWrapStyleWord(true);
        this.lbActivatePolicy.setFont(this.rbDisablePolicy.getFont());
        this.lbActivatePolicy.setAlignmentX(0.0f);
        this.lbActivatePolicy.setAlignmentY(0.0f);
        this.buttonGroupFirst.add(this.rbDisablePolicy);
        this.buttonGroupFirst.add(this.rbTestPolicy);
        this.buttonGroupFirst.add(this.rbActivatePolicy);
        UIUtilities.setName(this.rbDisablePolicy, "clientPage", UIUtilities.ComponentType.BUTTON, AUTOMATION_DISABLE_POLICY);
        UIUtilities.setName(this.rbTestPolicy, "clientPage", UIUtilities.ComponentType.BUTTON, AUTOMATION_TEST_POLICY);
        UIUtilities.setName(this.rbActivatePolicy, "clientPage", UIUtilities.ComponentType.BUTTON, AUTOMATION_NORMAL_POLICY);
        UIUtilities.setName(this.btFingerprintListAdd, "clientPage", UIUtilities.ComponentType.BUTTON, AUTOMATION_FINGERPRINTLIST_ADD);
        JPanel newPanel = new JPanel(new BorderLayout());
        JLabel descLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.summary"));
        descLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        newPanel.add((Component)descLabel, "North");
        JPanel policyPanel = new JPanel(new GridBagLayout());
        policyPanel.add((Component)this.rbDisablePolicy, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        policyPanel.add((Component)this.rbTestPolicy, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        policyPanel.add((Component)this.lbTestPolicy, new GridBagConstraints(0, 2, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 25, 5, 0), 0, 0));
        policyPanel.add((Component)this.rbActivatePolicy, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        policyPanel.add((Component)this.lbActivatePolicy, new GridBagConstraints(0, 4, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 25, 5, 0), 0, 0));
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(UIColorUtilities.TITLED_BORDER_HIGHLIGHT, UIColorUtilities.TITLED_BORDER_SHADOW), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.policyMode"));
        policyPanel.setBorder(titledBorder);
        newPanel.add((Component)policyPanel, "Center");
        return newPanel;
    }

    private JPanel initGUI_FingerprintList() {
        this.tmFingerprintList.setColumnNames(COL_NAMES_FINGERPRINTLIST);
        this.tmFingerprintList.setEditMode(true);
        this.tmFingerprintList.addMouseListenerToHeaderInTable(this.tbFingerprintList);
        this.tbFingerprintList.setModel(this.tmFingerprintList);
        this.tbFingerprintList.getColumnModel().getColumn(1).setCellRenderer(new FingerPrintListTableTestCellRenderer());
        Dimension size = this.tbFingerprintList.getPreferredScrollableViewportSize();
        this.tbExtraFiles.setPreferredScrollableViewportSize(new Dimension(size.width, (this.tbExtraFiles.getRowHeight() + this.tbExtraFiles.getRowMargin()) * 3));
        this.tbFingerprintList.getSelectionModel().addListSelectionListener(e -> this.btFingerprintListRemove.setEnabled(!this.isDisablePolicy() && this.tbFingerprintList.getSelectedRowCount() > 0));
        this.spFingerprintList = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)this.spFingerprintList, (JTable)this.tbFingerprintList);
        this.btFingerprintListAdd.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.add"));
        this.btFingerprintListAdd.addActionListener(e -> this.addFingerprintListActionPerformed(e));
        this.btFingerprintListAdd.setEnabled(false);
        this.btFingerprintListRemove.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.remove"));
        this.btFingerprintListRemove.setEnabled(false);
        this.btFingerprintListRemove.addActionListener(e -> this.removeFingerprintListActionPerformed(e));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(2));
        buttonsPanel.add(this.btFingerprintListAdd);
        buttonsPanel.add(this.btFingerprintListRemove);
        UIUtilities.fitJComponent(new JButton[]{this.btFingerprintListAdd, this.btFingerprintListRemove});
        JPanel panelFingerprintList = new JPanel();
        panelFingerprintList.setLayout(new BorderLayout());
        panelFingerprintList.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        panelFingerprintList.add((Component)this.spFingerprintList, "Center");
        panelFingerprintList.add((Component)buttonsPanel, "South");
        return panelFingerprintList;
    }

    private JPanel initGUI_ExtraFiles() {
        JPanel panelExtraFiles = new JPanel();
        panelExtraFiles.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        panelExtraFiles.setLayout(new BorderLayout());
        this.tmExtraFiles.setColumnNames(COL_NAMES_EXTRAFILES);
        this.tmExtraFiles.setEditMode(true);
        this.tmExtraFiles.addMouseListenerToHeaderInTable(this.tbExtraFiles);
        this.tbExtraFiles.setModel(this.tmExtraFiles);
        Dimension size = this.tbExtraFiles.getPreferredScrollableViewportSize();
        this.tbFingerprintList.setPreferredScrollableViewportSize(new Dimension(size.width, (this.tbFingerprintList.getRowHeight() + this.tbFingerprintList.getRowMargin()) * 3));
        this.tbExtraFiles.getSelectionModel().addListSelectionListener(e -> this.btExtraFilesRemove.setEnabled(!this.isDisablePolicy() && this.tbExtraFiles.getSelectedRowCount() > 0));
        this.spExtraFiles = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)this.spExtraFiles, (JTable)this.tbExtraFiles);
        this.btExtraFilesAdd.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.add"));
        this.btExtraFilesAdd.addActionListener(e -> this.addExtraFileActionPerformed(e));
        this.btExtraFilesImport.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.import"));
        this.btExtraFilesImport.addActionListener(e -> this.importExtraFileActionPerformed(e));
        this.btExtraFilesRemove.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.remove"));
        this.btExtraFilesRemove.setEnabled(false);
        this.btExtraFilesRemove.addActionListener(e -> this.removeExtraFileActionPerformed(e));
        JPanel panelExtraFilesButtons = new JPanel();
        panelExtraFilesButtons.setLayout(new FlowLayout(2));
        panelExtraFilesButtons.add(this.btExtraFilesImport);
        panelExtraFilesButtons.add(this.btExtraFilesAdd);
        panelExtraFilesButtons.add(this.btExtraFilesRemove);
        UIUtilities.fitJComponent(new JButton[]{this.btExtraFilesImport, this.btExtraFilesAdd, this.btExtraFilesRemove});
        panelExtraFiles.add((Component)this.spExtraFiles, "Center");
        panelExtraFiles.add((Component)panelExtraFilesButtons, "South");
        return panelExtraFiles;
    }

    private JPanel initGUI_Notify() {
        this.cbNotify.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.notifyUserIfApplicationIsBlocked"));
        this.cbNotify.addActionListener(e -> this.cbNotify_actionPerformed(e));
        this.btNotification.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.addExtraMessage"));
        this.btNotification.setEnabled(this.cbNotify.isSelected());
        this.btNotification.addActionListener(e -> this.addExtraMessageActionPerformed(e));
        JPanel panelNotify = new JPanel();
        panelNotify.setLayout(new GridBagLayout());
        panelNotify.add((Component)this.cbNotify, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        panelNotify.add((Component)this.btNotification, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 12), 0, 0));
        UIUtilities.fitJComponent(new JButton[]{this.btNotification});
        return panelNotify;
    }

    private JPanel initGUI_Settings() {
        this.rbAllowPolicy.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.enableAllowMode"));
        this.rbAllowPolicy.setAlignmentX(0.0f);
        this.rbAllowPolicy.setAlignmentY(0.0f);
        this.rbAllowPolicy.addActionListener(e -> this.policyMode_actionPerformed(e));
        this.lbAllowPolicy.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.ifSelectedSystemLockdownProtectionIsAllowMode"));
        this.lbAllowPolicy.setEditable(false);
        this.lbAllowPolicy.setOpaque(false);
        this.lbAllowPolicy.setLineWrap(true);
        this.lbAllowPolicy.setWrapStyleWord(true);
        this.lbAllowPolicy.setFont(this.rbAllowPolicy.getFont());
        this.lbAllowPolicy.setAlignmentX(0.0f);
        this.lbAllowPolicy.setAlignmentY(0.0f);
        this.rbDenyPolicy.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.enableDenyMode"));
        this.rbDenyPolicy.setAlignmentX(0.0f);
        this.rbDenyPolicy.setAlignmentY(0.0f);
        this.rbDenyPolicy.addActionListener(e -> this.policyMode_actionPerformed(e));
        this.lbDenyPolicy.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.ifSelectedSystemLockdownProtectionIsDenyMode"));
        this.lbDenyPolicy.setEditable(false);
        this.lbDenyPolicy.setOpaque(false);
        this.lbDenyPolicy.setLineWrap(true);
        this.lbDenyPolicy.setWrapStyleWord(true);
        this.lbDenyPolicy.setFont(this.rbDenyPolicy.getFont());
        this.lbDenyPolicy.setAlignmentX(0.0f);
        this.lbDenyPolicy.setAlignmentY(0.0f);
        this.buttonGroupSecond.add(this.rbAllowPolicy);
        this.buttonGroupSecond.add(this.rbDenyPolicy);
        UIUtilities.setName(this.rbAllowPolicy, "clientPage", UIUtilities.ComponentType.BUTTON, AUTOMATION_ACTION_ALLOW);
        UIUtilities.setName(this.rbDenyPolicy, "clientPage", UIUtilities.ComponentType.BUTTON, AUTOMATION_ACTION_DENY);
        JPanel policyPanel = new JPanel(new GridBagLayout());
        policyPanel.add((Component)this.rbAllowPolicy, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        policyPanel.add((Component)this.lbAllowPolicy, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 25, 5, 0), 0, 0));
        policyPanel.add((Component)this.rbDenyPolicy, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        policyPanel.add((Component)this.lbDenyPolicy, new GridBagConstraints(0, 3, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 25, 0, 0), 0, 0));
        policyPanel.add((Component)this.dashLine, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        JPanel panelSettingsTmp = new JPanel(new BorderLayout());
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(UIColorUtilities.TITLED_BORDER_HIGHLIGHT, UIColorUtilities.TITLED_BORDER_SHADOW), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.settingsTitle"));
        panelSettingsTmp.setBorder(titledBorder);
        JPanel panelFingerprintList = this.initGUI_FingerprintList();
        JPanel panelExtraFiles = this.initGUI_ExtraFiles();
        panelSettingsTmp.add((Component)policyPanel, "North");
        panelSettingsTmp.add((Component)panelFingerprintList, "Center");
        panelSettingsTmp.add((Component)panelExtraFiles, "South");
        return panelSettingsTmp;
    }

    private JPanel initGUI_Status() {
        JPanel panelNotify = this.initGUI_Notify();
        this.taStatus.setEditable(false);
        this.taStatus.setOpaque(false);
        this.taStatus.setLineWrap(true);
        this.taStatus.setWrapStyleWord(true);
        this.taStatus.setFont(this.btViewExceptionList.getFont());
        this.btViewExceptionList.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.viewExceptionList"));
        this.btViewExceptionList.addActionListener(e -> this.viewExceptionListActionPerformed(e));
        JPanel panelStatusTmp = new JPanel();
        panelStatusTmp.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(UIColorUtilities.TITLED_BORDER_HIGHLIGHT, UIColorUtilities.TITLED_BORDER_SHADOW), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.status"));
        panelStatusTmp.setBorder(titledBorder);
        panelStatusTmp.add((Component)this.taStatus, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 8, 0, 0), 0, 0));
        panelStatusTmp.add((Component)this.btViewExceptionList, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 12), 0, 0));
        panelStatusTmp.add((Component)panelNotify, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        return panelStatusTmp;
    }

    private void adjustSize() {
        UIUtilities.setTableColumnWidth(this.tbFingerprintList, COL_SIZE_FINGERPRINTLIST, (int)this.spFingerprintList.getPreferredSize().getWidth());
        UIUtilities.setTableColumnWidth(this.tbExtraFiles, COL_SIZE_EXTRAFILES, (int)this.spExtraFiles.getPreferredSize().getWidth());
    }

    public boolean savePane() {
        List fingerprintList = (List)Cast.cast(this.tmFingerprintList.getAllRows());
        List extraFiles = (List)Cast.cast(this.tmExtraFiles.getAllRows());
        if (this.rbDisablePolicy.isSelected() && !this.lockdownObj.isPolicyDisabled()) {
            for (int i = 0; fingerprintList != null && i < fingerprintList.size(); ++i) {
                LockdownFileListObject lockDownObj = (LockdownFileListObject)fingerprintList.get(i);
                if (lockDownObj.getImage() == null || !ComputerImage.WEBSERVICE.equals(lockDownObj.getImage().getOptSource())) continue;
                Object[] obj = new Object[]{lockDownObj.getName()};
                if (0 == JOptionPane.showConfirmDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.warning.fingerprintlistFromWebserviceDisable"), obj), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.warning"), 0)) continue;
                return false;
            }
        }
        if (this.rbActivatePolicy.isSelected()) {
            boolean isEmptyExtraFiles;
            boolean isEmptyFingerprintList = fingerprintList == null || fingerprintList.size() < 1;
            boolean bl = isEmptyExtraFiles = extraFiles == null || extraFiles.size() < 1;
            if (isEmptyFingerprintList && isEmptyExtraFiles) {
                JOptionPane.showMessageDialog(Manager.frame, WARNING_MESSAGE_EMPTY_APP_LIST, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", MSG_KEY_ERROR), 0);
                return false;
            }
        }
        int maxCount = 512;
        if (fingerprintList != null && fingerprintList.size() > 512) {
            Object[] obj = new Object[]{maxCount};
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.tooManyFileFingerprintsAreSelected"), obj), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", MSG_KEY_ERROR), 0);
            return false;
        }
        maxCount = ScmProperties.getSystemLockdownMaxCountExtrafiles();
        if (maxCount <= 0) {
            maxCount = 512;
        }
        if (extraFiles != null && extraFiles.size() > maxCount) {
            Object[] obj = new Object[]{maxCount};
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.tooManyFileFingerprintsAreSelected"), obj), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", MSG_KEY_ERROR), 0);
            return false;
        }
        if (this.rbActivatePolicy.isSelected()) {
            boolean showWarning = false;
            String warningMessage = "";
            if (this.lockdownObj == null || !this.lockdownObj.isValid()) {
                showWarning = true;
                warningMessage = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.theCurrentSettingHasNotBeenTestedYet");
            } else if (!this.lockdownObj.isPolicyActivated()) {
                long[] exceptionRet = this.lockdownObj.getExceptionCount(this.groupId);
                long exceptionCnt = exceptionRet[0];
                long elapsedTime = exceptionRet[1];
                if (elapsedTime < 86400000L) {
                    showWarning = true;
                    warningMessage = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.theSystemLockdownTestingHasBeenRunningLessThan1Day");
                } else if (exceptionCnt > 0L) {
                    showWarning = true;
                    warningMessage = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.theCurrentTestHasExceptionHappened");
                } else if (this.lockdownObj.hasDeletedItem(fingerprintList, extraFiles)) {
                    showWarning = true;
                    warningMessage = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.thereAreItemsInFileFingerpringList");
                }
            } else {
                List<List<ConfigObject>> deletedLists = this.lockdownObj.getDeletedItems(fingerprintList, extraFiles);
                if (deletedLists != null && (deletedLists.get(0) != null && deletedLists.get(0).size() > 0 || deletedLists.get(1) != null && deletedLists.get(1).size() > 0)) {
                    if (this.hasNormalMode(deletedLists)) {
                        showWarning = true;
                        warningMessage = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.thereAreItemsDeletedWithoutTesting");
                    } else if (this.lockdownObj.hasTestRunning()) {
                        long[] exceptionRet = this.lockdownObj.getExceptionCount(this.groupId);
                        if (exceptionRet[1] < 86400000L) {
                            showWarning = true;
                            warningMessage = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.theSystemLockdownTestingHasBeenRunningLessThan1Day");
                        } else if (exceptionRet[0] > 0L) {
                            showWarning = true;
                            warningMessage = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.theCurrentTestHasExceptionHappened");
                        }
                    }
                }
            }
            if (showWarning) {
                Object[] obj = new Object[]{warningMessage};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.doYouWantToActivateTheSystemLockdownPolicy");
                String fm = MessageFormat.format(str, obj);
                if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.systemLockdown"), 0)) {
                    return false;
                }
            }
        }
        try {
            if (this.lockdownObj == null || !this.lockdownObj.isValid()) {
                this.lockdownObj = ComputerLockdownProtectionObject.newInstance();
            }
            int mode = 0;
            if (this.rbTestPolicy.isSelected()) {
                mode = 2;
            } else if (this.rbActivatePolicy.isSelected()) {
                mode = 1;
            }
            if (this.lockdownObj.isModeChanged(mode) || this.lockdownObj.hasNewItem(fingerprintList, extraFiles, 0) || this.lockdownObj.hasChangeItem(fingerprintList, extraFiles) || this.lockdownObj.hasDeletedItem(fingerprintList, extraFiles)) {
                this.lockdownObj.resetLastTestModifiedTime();
            }
            if (this.rbDisablePolicy.isSelected()) {
                this.lockdownObj.setPolicyMode(0);
            } else if (this.rbTestPolicy.isSelected()) {
                this.lockdownObj.setPolicyMode(2);
            } else if (this.rbActivatePolicy.isSelected()) {
                this.lockdownObj.setPolicyMode(1);
            }
            this.lockdownObj.setBlacklistEnabled(this.rbDenyPolicy.isSelected());
            this.lockdownObj.setNotifyUser(this.cbNotify.isSelected(), this.extraMessage);
            this.lockdownObj.setFileList(fingerprintList, extraFiles);
            ConsoleLogger.log("LockDownPanel>> savePane: Done!");
            return true;
        }
        catch (Exception ex) {
            ConsoleLogger.log("LockDownPanel>> savePane: Error-> Throwable!");
            LoggerUtilities.logException((Throwable)ex);
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.failedToSaveTheDataForSystemLockdown"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", MSG_KEY_ERROR), 0);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasNormalMode(List<List<ConfigObject>> deletedLists) {
        List<ConfigObject> deletedFile;
        List<ConfigObject> deletedWhiteList = deletedLists.get(0);
        if (deletedWhiteList != null) {
            for (AppliedImage appliedImage : deletedWhiteList) {
                void var5_6;
                Integer n = appliedImage.getOptMode();
                if (n == null) {
                    Integer n2 = appliedImage.getDefMode();
                }
                if (!var5_6.equals(AppliedImage.NORMAL)) continue;
                return true;
            }
        }
        if ((deletedFile = deletedLists.get(1)) != null) {
            for (AdditionalAllowedFile additionalAllowedFile : deletedFile) {
                Integer mode = additionalAllowedFile.getOptMode();
                if (mode == null) {
                    mode = additionalAllowedFile.getDefMode();
                }
                if (!mode.equals(AdditionalAllowedFile.NORMAL)) continue;
                return true;
            }
        }
        return false;
    }

    public ComputerLockdownProtectionObject getLockdownObject() {
        return this.lockdownObj;
    }

    public void setReadOnly() {
        this.isReadOnly = true;
        UIUtilities.setContainerStatus(this, false);
    }

    public void setObject(ComputerLockdownProtectionObject lockdownObj, String[] groupId) {
        this.lockdownObj = lockdownObj;
        this.groupId = groupId == null ? null : (String[])groupId.clone();
        this.init();
    }

    private void init() {
        if (this.lockdownObj == null || this.lockdownObj.isDisabled()) {
            this.taStatus.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.thereIsNoTestRunning"));
            this.rbDisablePolicy.setSelected(true);
        }
        if (this.lockdownObj != null) {
            LockdownFileListObject o;
            int i;
            this.rbDenyPolicy.setSelected(this.lockdownObj.isBlacklistEnabled());
            this.rbAllowPolicy.setSelected(!this.lockdownObj.isBlacklistEnabled());
            this.cbNotify.setSelected(this.lockdownObj.needNotifyUser());
            this.extraMessage = this.lockdownObj.getExtraMessage();
            this.btNotification.setEnabled(this.cbNotify.isSelected());
            ArrayList<LockdownFileListObject> list = this.lockdownObj.getWhiteList();
            if (list != null) {
                for (i = 0; i < list.size(); ++i) {
                    o = list.get(i);
                    this.tmFingerprintList.addRow(o);
                }
            }
            if ((list = this.lockdownObj.getExtraFiles()) != null) {
                for (i = 0; i < list.size(); ++i) {
                    o = list.get(i);
                    this.tmExtraFiles.addRow(o);
                }
            }
            this.rbDisablePolicy.setSelected(this.lockdownObj.isPolicyDisabled());
            this.rbTestPolicy.setSelected(this.lockdownObj.isPolicyTesting());
            this.rbActivatePolicy.setSelected(this.lockdownObj.isPolicyActivated());
        }
        this.enableGUI_SettingsAndStatus();
        this.refreshStatus();
    }

    private void refreshStatus() {
        if (!this.isTestingRunning()) {
            this.taStatus.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.thereIsNoTestRunning"));
        } else {
            this.taStatus.setText(this.lockdownObj.getStatusDisplayString(this.groupId));
        }
    }

    private boolean isTestingRunning() {
        boolean canView = true;
        if (this.lockdownObj == null || this.lockdownObj.isDisabled() || !this.lockdownObj.isPolicyTesting() && !this.lockdownObj.hasTestRunning()) {
            canView = false;
        }
        return canView;
    }

    private void removeFingerprintListActionPerformed(ActionEvent e) {
        ConsoleLogger.log(e.toString());
        while (this.tbFingerprintList.getSelectedRow() > -1) {
            int row = this.tbFingerprintList.getSelectedRow();
            LockdownFileListObject lockDownObj = (LockdownFileListObject)this.tmFingerprintList.getRow(row);
            if (lockDownObj.getImage() != null && ComputerImage.WEBSERVICE.equals(lockDownObj.getImage().getOptSource()) && 0 != JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.warning.fingerprintlistFromWebserviceRemove"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.warning"), 0)) {
                return;
            }
            this.tmFingerprintList.removeRow(row);
        }
    }

    private void addFingerprintListActionPerformed(ActionEvent e) {
        ConsoleLogger.log(e.toString());
        try {
            ArrayList<ComputerImage> list = WhiteListHandler.getComputerImagesFromPool();
            if (this.hasNoMoreWhiteListsToBeAdded(list)) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.fingerprintlistEmpty"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", MSG_KEY_ERROR), 0);
                return;
            }
            LockdownWhiteListDlg dlg = new LockdownWhiteListDlg(this, Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.listsOfApprovedExecutablesPolicyLibrary"), true);
            dlg.setVisible(true);
            if (!dlg.isOk()) {
                return;
            }
            LockdownFileListObject obj = (LockdownFileListObject)dlg.getSelectedObject();
            if (!this.hasWhiteList(obj)) {
                this.tmFingerprintList.addRow(obj);
            } else {
                ConsoleLogger.log("LockDownPanel>> addFingerprintListActionPerformed: ignore! image id=" + obj.getId() + ", name=" + obj.getName());
            }
        }
        catch (HeadlessException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private boolean hasNoMoreWhiteListsToBeAdded(List<ComputerImage> whiteList) {
        for (int i = 0; i < whiteList.size(); ++i) {
            LockdownFileListObject lockDownFileListObject = new LockdownFileListObject(whiteList.get(i), false);
            if (this.hasWhiteList(lockDownFileListObject)) continue;
            return false;
        }
        return true;
    }

    private void removeExtraFileActionPerformed(ActionEvent e) {
        ConsoleLogger.log(e.toString());
        while (this.tbExtraFiles.getSelectedRow() > -1) {
            int row = this.tbExtraFiles.getSelectedRow();
            this.tmExtraFiles.removeRow(row);
        }
    }

    private void importExtraFileActionPerformed(ActionEvent e) {
        ConsoleLogger.log(e.toString());
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getPath().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.fileTypeDesc");
            }
        });
        fc.setApproveButtonText(UIText.get(2048));
        fc.setDialogTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.importDialogTitle"));
        fc.updateUI();
        if (0 == fc.showDialog(Manager.frame, null) && fc.getSelectedFile() != null) {
            File selectFile = fc.getSelectedFile();
            this.importApplicationsFromFile(selectFile);
        }
    }

    private void importApplicationsFromFile(File file) {
        String dilemma = " ";
        try (FileInputStream fis = new FileInputStream(file);
             BufferedReader inputFileReader = new BufferedReader(new InputStreamReader((InputStream)fis, Charset.defaultCharset()));){
            String line = null;
            int totalCount = 0;
            int validCount = 0;
            ArrayList<LockdownFileListObject> objectList = new ArrayList<LockdownFileListObject>();
            while ((line = inputFileReader.readLine()) != null) {
                String[] nameExclusive;
                ++totalCount;
                String name = null;
                String testBefore = null;
                String useRegularEx = null;
                int nameBegin = 0;
                int nameEnd = line.indexOf(dilemma);
                int quotePosition = line.indexOf("\"");
                if (quotePosition >= 0 && ((nameBegin = quotePosition + 1) >= line.length() || (nameEnd = line.indexOf("\"", nameBegin)) == -1)) continue;
                if (nameEnd <= 0 || nameEnd >= line.length()) {
                    nameEnd = line.length();
                }
                if ((name = line.substring(nameBegin, nameEnd).trim()).length() <= 0) continue;
                int exclusiveBegin = nameEnd + 1;
                if (exclusiveBegin > line.length()) {
                    exclusiveBegin = line.length();
                }
                if ((nameExclusive = line.substring(exclusiveBegin).trim().split(dilemma)).length > 0) {
                    testBefore = nameExclusive[0];
                }
                if (nameExclusive.length > 1) {
                    useRegularEx = nameExclusive[1];
                }
                LockdownFileListObject obj = this.constructFimeNameMatchEntry(name, testBefore, useRegularEx);
                objectList.add(obj);
                ++validCount;
            }
            if (validCount != totalCount) {
                JOptionPane.showMessageDialog(Manager.frame, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.invalidFile"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", MSG_KEY_ERROR), 0);
                return;
            }
            for (int i = 0; i < validCount; ++i) {
                LockdownFileListObject obj = (LockdownFileListObject)objectList.get(i);
                this.addToExtraFilesTable(obj);
            }
        }
        catch (Exception ex) {
            ConsoleLogger.log("LockDownPanel>> savePane: Error-> Throwable!");
            LoggerUtilities.logException((Throwable)ex);
            JOptionPane.showMessageDialog(Manager.frame, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.failedToSaveTheDataForSystemLockdown"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", MSG_KEY_ERROR), 0);
        }
    }

    private LockdownFileListObject constructFimeNameMatchEntry(String name, String testBefore, String useRegularEx) {
        OpFileNameMatchEntity nameEntity = new OpFileNameMatchEntity();
        nameEntity.setOptEnable(Boolean.valueOf(true));
        nameEntity.setKeyString(name);
        boolean bUseRegularEx = false;
        if (useRegularEx != null && (useRegularEx.equalsIgnoreCase("1") || useRegularEx.equalsIgnoreCase("Y") || useRegularEx.equalsIgnoreCase("True") || useRegularEx.equalsIgnoreCase("Yes"))) {
            bUseRegularEx = true;
        }
        if (bUseRegularEx) {
            nameEntity.setOptMethod(OpFileNameMatchEntity.REG_EX);
        } else {
            nameEntity.setOptMethod(OpFileNameMatchEntity.NORMAL);
        }
        boolean bTestBefore = false;
        if (testBefore != null && (testBefore.equalsIgnoreCase("1") || testBefore.equalsIgnoreCase("Y") || testBefore.equalsIgnoreCase("True") || testBefore.equalsIgnoreCase("Yes"))) {
            bTestBefore = true;
        }
        LockdownFileListObject obj = new LockdownFileListObject(nameEntity, bTestBefore);
        return obj;
    }

    private void addToExtraFilesTable(LockdownFileListObject obj) {
        int count = this.tmExtraFiles.getRowCount();
        for (int i = 0; i < count; ++i) {
            LockdownFileListObject objTable = (LockdownFileListObject)this.tmExtraFiles.getRow(i);
            if (!objTable.getName().equalsIgnoreCase(obj.getName())) continue;
            this.tmExtraFiles.removeRow(i);
            break;
        }
        this.tmExtraFiles.addRow(obj);
    }

    private void addExtraFileActionPerformed(ActionEvent e) {
        ConsoleLogger.log(e.toString());
        StringConditionEditorDlg dlg = new StringConditionEditorDlg(5);
        if (dlg.isOk()) {
            OpFileNameMatchEntity entity = dlg.getFileNameMatchEntity();
            if (entity == null) {
                return;
            }
            LockdownFileListObject obj = new LockdownFileListObject(entity, false);
            this.tmExtraFiles.addRow(obj);
        }
        dlg.dispose();
    }

    private void addExtraMessageActionPerformed(ActionEvent e) {
        ConsoleLogger.log(e.toString());
        AdditionalTextDialog dlg = new AdditionalTextDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.titleAddExtraMessage"), this.extraMessage, 128);
        if (dlg.isOk()) {
            this.extraMessage = dlg.getAdditionalText();
        }
        dlg.dispose();
    }

    private void cbNotify_actionPerformed(ActionEvent e) {
        ConsoleLogger.log(e.toString());
        this.btNotification.setEnabled(this.cbNotify.isSelected());
    }

    private void viewExceptionListActionPerformed(ActionEvent e) {
        ConsoleLogger.log(e.toString());
        if (!this.isTestingRunning()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.thereIsNoTestRuunng"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", MSG_KEY_ERROR), 0);
            this.taStatus.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.thereIsNoTestRunningForNow"));
        }
        LockdownViewExceptionsDlg dlg = new LockdownViewExceptionsDlg(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LockDownPanel.excptionList"), true);
        dlg.init(this.lockdownObj, this.groupId, this.isReadOnly);
        dlg.setVisible(true);
        this.refreshStatus();
    }

    private void policyMode_actionPerformed(ActionEvent e) {
        ConsoleLogger.log(e.toString());
        this.enableGUI_SettingsAndStatus();
    }

    private void enableGUI_SettingsAndStatus() {
        boolean test;
        boolean disable = this.isDisablePolicy();
        if (disable) {
            this.enableGUI_SettingsAndStatus(false, false);
            return;
        }
        if (!this.rbTestPolicy.isSelected() && !this.rbActivatePolicy.isSelected()) {
            this.rbActivatePolicy.setSelected(true);
        }
        if (test = this.isTestPolicy()) {
            this.enableGUI_SettingsAndStatus(!this.isReadOnly, false);
            return;
        }
        boolean activate = this.isActivatePolicy();
        if (activate) {
            this.enableGUI_SettingsAndStatus(!this.isReadOnly, true);
            return;
        }
    }

    private void enableGUI_SettingsAndStatus(boolean enabled, boolean tableEditable) {
        if (enabled) {
            this.tbFingerprintList.setBackground(new StripesTable().getBackground());
        } else {
            this.tbFingerprintList.setBackground(this.panelSettings.getBackground());
        }
        this.showTestForRemoveColumn(this.tbFingerprintList, tableEditable);
        this.tbFingerprintList.setEnabled(enabled);
        this.tmFingerprintList.setEditMode(tableEditable);
        this.btFingerprintListAdd.setEnabled(enabled);
        this.btFingerprintListRemove.setEnabled(enabled && this.tbFingerprintList.getSelectedRowCount() > 0);
        if (enabled) {
            this.tbExtraFiles.setBackground(new StripesTable().getBackground());
        } else {
            this.tbExtraFiles.setBackground(this.panelSettings.getBackground());
        }
        this.showTestForRemoveColumn(this.tbExtraFiles, tableEditable);
        this.rbAllowPolicy.setEnabled(enabled);
        this.lbAllowPolicy.setEnabled(enabled);
        this.rbDenyPolicy.setEnabled(enabled);
        this.lbDenyPolicy.setEnabled(enabled);
        this.tbExtraFiles.setEnabled(enabled);
        this.tmExtraFiles.setEditMode(tableEditable);
        this.btExtraFilesAdd.setEnabled(enabled);
        this.btExtraFilesImport.setEnabled(enabled);
        this.btExtraFilesRemove.setEnabled(enabled && this.tbExtraFiles.getSelectedRowCount() > 0);
        this.cbNotify.setEnabled(enabled && this.rbActivatePolicy.isSelected());
        this.btNotification.setEnabled(enabled && this.cbNotify.isEnabled() && this.cbNotify.isSelected());
        this.refreshStatus();
        this.btViewExceptionList.setEnabled(this.lockdownObj != null && this.lockdownObj.isEnabled());
    }

    private boolean isDisablePolicy() {
        return this.rbDisablePolicy.isSelected();
    }

    private boolean isTestPolicy() {
        return this.rbTestPolicy.isSelected();
    }

    private boolean isActivatePolicy() {
        return this.rbActivatePolicy.isSelected();
    }

    public boolean hasWhiteList(LockdownFileListObject obj) {
        int count = this.tmFingerprintList.getRowCount();
        if (count < 1) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            LockdownFileListObject row = (LockdownFileListObject)this.tmFingerprintList.getRow(i);
            if (!row.equals(obj)) continue;
            return true;
        }
        return false;
    }

    private void showTestForRemoveColumn(JTable table, boolean show) {
        TableColumn col = table == this.tbFingerprintList ? this.columnTestForRemoveForWhiteList : this.columnTestForRemoveForExtraFile;
        int columnCountAll = table == this.tbFingerprintList ? COL_NAMES_FINGERPRINTLIST.length : COL_NAMES_EXTRAFILES.length;
        TableColumnModel cm = table.getColumnModel();
        int count = cm.getColumnCount();
        if (show && count < columnCountAll && col != null) {
            cm.addColumn(col);
        } else if (!show && count >= columnCountAll) {
            if (col == null) {
                col = cm.getColumn(columnCountAll - 1);
                if (table == this.tbFingerprintList) {
                    this.columnTestForRemoveForWhiteList = col;
                } else {
                    this.columnTestForRemoveForExtraFile = col;
                }
            }
            if (col != null) {
                cm.removeColumn(col);
            }
        }
    }

    static class FingerPrintListTableTestCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        FingerPrintListTableTestCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String fingerprintListName = (String)table.getModel().getValueAt(row, 0);
            String curColumnName = table.getModel().getColumnName(column);
            ConsoleLogger.log("FingerPrintListTableCellRenderer >> Value Class Name: " + value.getClass() + ", FingerprintList Name: " + fingerprintListName + ", curColumnName: " + curColumnName + ", Row: " + row + ", Column: " + column);
            return comp;
        }
    }
}

