/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.logicobject.AlSignatureObject;
import com.sygate.scm.console.logicobject.AppliedPolicyObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.LocationObject;
import com.sygate.scm.console.logicobject.UserInterfaceObject;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.dialog.AutoLocationPanel;
import com.sygate.scm.console.ui.policy.dialog.LocationHandler;
import com.sygate.scm.console.ui.policy.dialog.LocationNamePanel;
import com.sygate.scm.console.ui.util.WizardBase;
import java.awt.Component;
import java.awt.Dimension;

public class LocationWizardDialog
extends WizardBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String POLICYDIALOG = "com.sygate.scm.console.ui.policy.dialog.policydialog";
    private static final int STAGE_COUNT = 4;
    private static final int STAGE_WELCOME = 0;
    private static final int STAGE_NAME = 1;
    private static final int STAGE_CONDITION = 2;
    private static final int STAGE_COMPLETE = 3;
    private WizardBase.WelcomeAndFinishPanel welcomePanel = new WizardBase.WelcomeAndFinishPanel(this, 0, MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationWizardDialog.welcomeTitle"), MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationWizardDialog.welcomeDesc"));
    private LocationNamePanel namePanel = new LocationNamePanel();
    private AutoLocationPanel conditionPanel = new AutoLocationPanel();
    private WizardBase.WelcomeAndFinishPanel completePanel = new WizardBase.WelcomeAndFinishPanel(this, 1, MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationWizardDialog.completeTitle"), MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationWizardDialog.completeDesc"));
    private boolean isSnacOnly = LicenseObject.getInstance().isSNACOnlyProduct();

    public LocationWizardDialog() {
        super(MSGRES.getString(POLICYDIALOG, "LocationWizardDialog.addLocation"), true, WizardBase.HelpButtonState.OFF);
        this.addStage(this.welcomePanel, 0);
        this.addStage(this.namePanel, 1);
        this.addStage(this.conditionPanel, 2);
        this.addStage(this.completePanel, 3);
        Dimension size = this.welcomePanel.getPreferredSize();
        this.welcomePanel.setPreferredSize(new Dimension(size.width * 3 / 4, size.height));
        this.completePanel.setPreferredSize(new Dimension(size.width * 3 / 4, size.height));
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.jBNext.requestFocus(true);
        this.setVisible(true);
    }

    @Override
    protected int getStageCount() {
        return 4;
    }

    @Override
    protected void prepareNext(int stage) {
        if (stage == 1) {
            this.namePanel.setName();
        }
    }

    @Override
    protected boolean validatePanel(int stage) {
        if (stage == 1) {
            return this.namePanel.isValidData();
        }
        if (stage == 2) {
            return this.conditionPanel.isValidData();
        }
        return true;
    }

    @Override
    protected void commit() {
        PolicyInt newPolicy;
        LocationObject locObj = LocationHandler.getInstance().getLocObj();
        AlSignatureObject alsigObj = LocationHandler.getInstance().getAlSignatureObject();
        if (alsigObj != null) {
            locObj.addAlSignature(alsigObj);
        }
        AppliedPolicyObject apObj = locObj.getAppliedPolicyObject();
        if (LocationHandler.getInstance().isFWSecured()) {
            newPolicy = LocationHandler.getInstance().getFWPolicyInt();
            apObj.addNewLocalPolicy(newPolicy);
            apObj.setPhysicalFileObject(newPolicy.getPhysicalFileObject());
            locObj.setAppliedPolicyObject(apObj);
        }
        if (LocationHandler.getInstance().isHISecured()) {
            newPolicy = LocationHandler.getInstance().getHIPolicyInt();
            apObj.addNewLocalPolicy(newPolicy);
            apObj.setPhysicalFileObject(newPolicy.getPhysicalFileObject());
            locObj.setAppliedPolicyObject(apObj);
        }
        if (LocationHandler.getInstance().isOSSecured()) {
            newPolicy = LocationHandler.getInstance().getOSPolicyInt();
            apObj.addNewLocalPolicy(newPolicy);
            apObj.setPhysicalFileObject(newPolicy.getPhysicalFileObject());
            locObj.setAppliedPolicyObject(apObj);
        }
        if (LocationHandler.getInstance().isHISecured() && LocationHandler.getInstance().isQuarantineSecured()) {
            newPolicy = LocationHandler.getInstance().getQuarantinePolicyInt();
            apObj.addNewLocalPolicy(newPolicy);
            apObj.setPhysicalFileObject(newPolicy.getPhysicalFileObject());
            locObj.setAppliedPolicyObject(apObj);
        }
        UserInterfaceObject uiObj = locObj.getUserInterfaceObject();
        uiObj.setMode(1);
        locObj.setUserInterface(uiObj);
        LocationHandler.getInstance().setLocObj(locObj);
    }

    @Override
    protected void skipPrevious(int stage) {
        if (stage == 3 && this.isSnacOnly) {
            this.skipBackward(1);
        }
    }

    @Override
    protected void skipNext(int stage) {
        if (stage == 2 && this.isSnacOnly) {
            this.skipForward(1);
        }
    }

    @Override
    protected void showStage(int stage) {
        super.showStage(stage);
        this.jBNext.requestFocus(true);
    }

    @Override
    protected String getDefaultContentSensitiveHelpToken() {
        return "sesm_clients_policies_add_location";
    }
}

