/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.common.ui.HtmlEnabledJTree;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AlSignatureObject;
import com.sygate.scm.console.logicobject.AlSignatureOrObject;
import com.sygate.scm.console.logicobject.AppliedPolicyObject;
import com.sygate.scm.console.logicobject.AutoLocationObject;
import com.sygate.scm.console.logicobject.CountableInt;
import com.sygate.scm.console.logicobject.DeletableObjInt;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.LocationObject;
import com.sygate.scm.console.ui.policy.common.ButtonPane;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.common.LocListCellRenderer;
import com.sygate.scm.console.ui.policy.dialog.AlSignatureConditionDlg;
import com.sygate.scm.console.ui.policy.dialog.LocationNameDlg;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LocationSettingDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final int SECONDS_INDEX = 0;
    private static final int MINUTES_INDEX = 1;
    private static final int HOURS_INDEX = 2;
    public static final Integer DEFAULT_FREQUENCE = 1800;
    public static final int MAX_HOURS = 1000;
    public static final int MIN_SECONDS = 5;
    public static final int MINUTES_PER_HOURS = 60;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int SECONDS_PER_HOURS = 3600;
    public static final int MIN_MINUTES_HOURS = 1;
    public static final int MAX_SECONDS = 3600000;
    public static final int MAX_MINUTES = 60000;
    public static final String DNS = "DNS";
    public static final String ICMP = "ICMP";
    private static final MessageResources MRS = MessageResources.getInstance();
    private static final String seconds = MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.TimerSeconds");
    private static final String minutes = MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.TimerMinutes");
    private static final String hours = MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.TimerHours");
    private static final String CANCEL_VALUE = MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.cancel");
    private static final String NODE_VALUE = MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.newnode");
    private static final int MAX_NOTIFICATION_MSG = 255;
    private static final Object[] locationPlaceHolderStrings = new Object[]{"[OLD_LOCATION]", "[NEW_LOCATION]"};
    private GroupPolicyObject gpObj;
    private AppliedPolicyObject defaultLocAppliedPolicies;
    private AutoLocationObject autoLocObj;
    private DefaultMutableTreeNode sigRoot;
    private DefaultTreeModel signatureModel;
    private LocationObject selectedLoc;
    private boolean isReadOnly = false;
    private boolean resetNameField = false;
    private List<LocationObject> newLocs = new ArrayList<LocationObject>();
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    MyListModel locListModel = new MyListModel();
    JList<LocationObject> locList = new JList<LocationObject>(this.locListModel);
    JLabel nameLabel = new JLabel(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.locationName"));
    JLabel desLabel = new JLabel(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.description"));
    JTextField nameField = new JTextField();
    JTextArea desArea = new JTextArea();
    JCheckBox enableChk = new JCheckBox(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.enableThisLocation"));
    Action moveUpLoc;
    Action moveDownLoc;
    Action addLoc;
    Action deleteLoc;
    Action setDefaultLoc;
    Action copyLoc;
    Action pasteLoc;
    JPopupMenu locPMenu;
    JPanel locPanel = new JPanel();
    JCheckBoxMenuItem defaultMenu;
    HtmlEnabledJTree signatureTree = new HtmlEnabledJTree();
    JCheckBox exclusive;
    JPanel autoLocPane;
    JLabel exclusiveDescLabel;
    Action addSig;
    Action deleteSig;
    Action editSig;
    Action moveUpSig;
    Action moveDownSig;
    Action addSigAnd;
    Action addSigOr;
    Action copySig;
    Action pasteSig;
    JPopupMenu andPMenu = new JPopupMenu();
    JPopupMenu orPMenu = new JPopupMenu();
    JPopupMenu addPMenu = new JPopupMenu();
    JPanel leftPane;
    JCheckBox defaultChkBox = new JCheckBox(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.setThisLocationAsDefault"));
    JCheckBox enableLocationCheckBox;
    JTextArea notificationMessageTextArea;
    JLabel notificationLabel;
    private JMenuItem addMenuForAnd;
    private JMenuItem addMenuForOr;
    private JButton addBtn;
    private String lastLocName = null;
    boolean dontcheck = false;
    ActionListener setDefaultLocationListener;
    private boolean showAllPanes = false;
    private JLabel frequencyLabel;
    private JLabel secondsLabel;
    private JTextField frequencyControl;
    private JTextField commandControl;
    private JCheckBox dnsQueryChk = null;
    private JCheckBox icmpRequestChk = null;
    private JLabel dnsRangeLabel = new JLabel(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.dnsRange"));
    private JLabel icmpRangeLabel = new JLabel(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.icmpsRange"));
    private JSpinner icmpSpinner = new JSpinner();
    private JSpinner dnsSpinner = new JSpinner();
    private JComboBox<Object> icmpUnitCombobox = null;
    private JComboBox<Object> dnsUnitCombobox = null;

    public LocationSettingDlg(JFrame frame, String title, boolean modal) {
        this(frame, title, modal, false);
    }

    public LocationSettingDlg(JFrame frame, String title, boolean modal, boolean showAllPanes) {
        super(frame, title, modal);
        this.showAllPanes = showAllPanes;
        try {
            this.jbInit();
            this.pack();
            UiUtilities.centerComponent((Component)this);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    protected void addSignature(ActionEvent e) {
        int childCnt = this.sigRoot.getChildCount();
        if (childCnt == 0) {
            this.addSigAndCondition();
        } else {
            this.showAddMenu(e);
        }
    }

    @Override
    protected boolean isValidate() {
        if (!this.locationNameChanged()) {
            return false;
        }
        String frequency = this.frequencyControl.getText();
        if (frequency.length() < 1) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.noLocationCheckFrequency"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.error"), 0);
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        this.locationDescChanged();
        String frequency = this.frequencyControl.getText();
        this.autoLocObj.setLocationCheckFrequency(Integer.parseInt(frequency));
        LocationObject loc = this.autoLocObj.getLocation(this.selectedLoc.getId());
        loc.setICMPQuery(this.icmpRequestChk.isSelected(), this.getTimerFrequenceAsSeconds(ICMP));
        loc.setDnsQuery(this.dnsQueryChk.isSelected(), this.getTimerFrequenceAsSeconds(DNS));
        boolean enableNotification = this.enableLocationCheckBox.isSelected();
        String notificationMsg = null;
        if (enableNotification) {
            notificationMsg = this.notificationMessageTextArea.getText();
        }
        this.autoLocObj.setEnableNotification(enableNotification);
        if (notificationMsg != null) {
            this.autoLocObj.setNotificationMessage(notificationMsg);
        }
        this.autoLocObj.resortData();
        this.gpObj.setAutoLocation(this.autoLocObj);
        this.updateNewLocs();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_computersnusers_policies_switch_location_edit";
    }

    private void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.getContentPane().add(this.panel1);
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        JComponent centralPane = this.getCentralPane();
        this.panel1.add((Component)centralPane, "Center");
        JComponent bottomPane = this.getBottomPane();
        this.panel1.add((Component)bottomPane, "South");
        bottomPane.setVisible(this.showAllPanes);
    }

    private JComponent getCentralPane() {
        JSplitPane sPane = new JSplitPane();
        this.setLocPane();
        this.leftPane = this.getLeftPane();
        sPane.add((Component)this.leftPane, "left");
        sPane.add((Component)this.locPanel, "right");
        sPane.setDividerLocation(200);
        if (!this.showAllPanes) {
            sPane.setDividerLocation(0.0);
            sPane.remove(0);
        } else {
            sPane.setOneTouchExpandable(true);
        }
        Border outer = BorderFactory.createEtchedBorder();
        sPane.setBorder(outer);
        return sPane;
    }

    private JPanel getLeftPane() {
        JPanel leftPane = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        leftPane.setLayout(borderLayout);
        JLabel locLabel = new JLabel(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.locations"));
        locLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        leftPane.add((Component)locLabel, "North");
        this.moveUpLoc = new AbstractAction(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.moveUpBtn")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.moveUpLocation();
            }
        };
        this.moveDownLoc = new AbstractAction(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.moveDownBtn")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.moveDownLocation();
            }
        };
        this.addLoc = new AbstractAction(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.addBtn")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.addLocation();
            }
        };
        this.deleteLoc = new AbstractAction(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.deleteBtn")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.deleteLocation();
            }
        };
        this.setDefaultLoc = new AbstractAction(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.setAsDefaultBtn")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.setDefaultLocation();
            }
        };
        this.copyLoc = new AbstractAction(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.copyBtn")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.copyLocation();
            }
        };
        this.pasteLoc = new AbstractAction(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.pasteBtn")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.pasteLocation();
            }
        };
        if (PolicyHandler.hasCopiedObject(LocationObject.class)) {
            this.pasteLoc.setEnabled(true);
        } else {
            this.pasteLoc.setEnabled(false);
        }
        this.locPMenu = new JPopupMenu();
        this.defaultMenu = new JCheckBoxMenuItem(this.setDefaultLoc);
        this.locPMenu.add(this.defaultMenu);
        JMenuItem menu = new JMenuItem(this.deleteLoc);
        this.locPMenu.add(menu);
        menu = new JMenuItem(this.moveUpLoc);
        this.locPMenu.add(menu);
        menu = new JMenuItem(this.moveDownLoc);
        this.locPMenu.add(menu);
        this.locPMenu.addSeparator();
        menu = new JMenuItem(this.copyLoc);
        this.locPMenu.add(menu);
        menu = new JMenuItem(this.pasteLoc);
        this.locPMenu.add(menu);
        this.locPMenu.addSeparator();
        menu = new JMenuItem(this.addLoc);
        this.locPMenu.add(menu);
        this.locList.setSelectionMode(0);
        this.locList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LocationSettingDlg.this.locListSelectionChanged(e);
            }
        });
        this.locList.setCellRenderer(new LocListCellRenderer());
        this.locList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event)) {
                    this.showPopupOfLocList(event);
                }
            }

            private void showPopupOfLocList(MouseEvent event) {
                if (!LocationSettingDlg.this.isReadOnly) {
                    Point point = new Point(event.getX(), event.getY());
                    int index = LocationSettingDlg.this.locList.locationToIndex(point);
                    LocationSettingDlg.this.locList.setSelectedIndex(index);
                    if (index != -1) {
                        LocationObject currentLoc = LocationSettingDlg.this.locList.getSelectedValue();
                        LocationSettingDlg.this.defaultMenu.setSelected(currentLoc.isDefault());
                        LocationSettingDlg.this.locList.add(LocationSettingDlg.this.locPMenu);
                        LocationSettingDlg.this.locPMenu.show(LocationSettingDlg.this.locList, event.getX(), event.getY());
                    }
                }
            }
        });
        this.locList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    LocationSettingDlg.this.deleteLocation(!e.isShiftDown());
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.locList);
        leftPane.add((Component)scrollPane, "Center");
        JPanel rightbottomPane = new JPanel();
        rightbottomPane.setBorder(new EmptyBorder(0, 2, 2, 2));
        GridLayout gLayout = new GridLayout(2, 2);
        gLayout.setHgap(2);
        gLayout.setVgap(2);
        rightbottomPane.setLayout(gLayout);
        rightbottomPane.add(new JButton(this.moveUpLoc));
        rightbottomPane.add(new JButton(this.moveDownLoc));
        rightbottomPane.add(new JButton(this.addLoc));
        rightbottomPane.add(new JButton(this.deleteLoc));
        leftPane.add((Component)rightbottomPane, "South");
        this.setLocListActionStatus();
        return leftPane;
    }

    private void setLocPane() {
        this.locPanel.setLayout(new BorderLayout());
        JPanel topPane = this.getNamePane();
        topPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.locPanel.add((Component)topPane, "North");
        this.autoLocPane = this.getAutoLocPane();
        this.autoLocPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.locPanel.add((Component)this.autoLocPane, "Center");
        this.locPanel.add((Component)this.getQueryTimerPane(), "South");
        this.locPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setLocPanelStatus();
    }

    private JPanel getNamePane() {
        this.enableChk.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.enabledChkChanged();
            }
        });
        this.setDefaultLocationListener = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean trySelect = LocationSettingDlg.this.defaultChkBox.isSelected();
                if (!trySelect) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.toMakeThisLocationANondefaultLocation"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.error"), 0);
                    LocationSettingDlg.this.defaultChkBox.setSelected(true);
                    return;
                }
                LocationSettingDlg.this.setDefaultLocation();
            }
        };
        this.defaultChkBox.addActionListener(this.setDefaultLocationListener);
        RestrictedPlainDocument groupNameDoc = new RestrictedPlainDocument(128);
        this.nameField.setDocument(groupNameDoc);
        groupNameDoc.setValidator("\"/\\*?<>|:", false);
        RestrictedPlainDocument descDoc = new RestrictedPlainDocument(256);
        this.desArea.setDocument(descDoc);
        this.desArea.setWrapStyleWord(true);
        this.desArea.setLineWrap(true);
        this.desArea.setRows(3);
        this.desArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent event) {
                LocationSettingDlg.this.locationDescChanged();
            }
        });
        JPanel panel = new JPanel();
        GridBagLayout gbLayout = new GridBagLayout();
        panel.setLayout(gbLayout);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.anchor = 17;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.insets = new Insets(1, 2, 1, 2);
        panel.add((Component)this.nameLabel, cons);
        cons = new GridBagConstraints();
        cons.gridx = 1;
        cons.gridy = 0;
        cons.anchor = 17;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        cons.fill = 2;
        panel.add((Component)this.nameField, cons);
        cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 1;
        cons.anchor = 18;
        cons.insets = new Insets(1, 2, 1, 2);
        panel.add((Component)this.desLabel, cons);
        cons = new GridBagConstraints();
        cons.gridx = 1;
        cons.gridy = 1;
        cons.anchor = 17;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        cons.insets = new Insets(2, 0, 0, 0);
        cons.fill = 1;
        JScrollPane sPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)sPane, (JTextArea)this.desArea);
        panel.add((Component)sPane, cons);
        cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 2;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.gridwidth = 2;
        cons.anchor = 17;
        cons.fill = 0;
        cons.insets = new Insets(1, 2, 1, 2);
        panel.add((Component)this.enableChk, cons);
        cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 3;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.gridwidth = 2;
        cons.anchor = 17;
        cons.fill = 0;
        cons.insets = new Insets(1, 2, 1, 2);
        panel.add((Component)this.defaultChkBox, cons);
        return panel;
    }

    private JPanel getAutoLocPane() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.sigRoot = new DefaultMutableTreeNode();
        this.signatureModel = new DefaultTreeModel(this.sigRoot);
        this.signatureTree.setModel((TreeModel)this.signatureModel);
        this.signatureTree.setRootVisible(false);
        this.signatureTree.setShowsRootHandles(true);
        HTMLRenderer treeRender = new HTMLRenderer();
        this.signatureTree.setCellRenderer((TreeCellRenderer)treeRender);
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            this.signatureTree.setRowHeight(0);
        }
        this.signatureTree.getSelectionModel().setSelectionMode(1);
        this.signatureTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                LocationSettingDlg.this.sigTreeSelectionChanged();
            }
        });
        this.signatureTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath tp;
                if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                    tp = LocationSettingDlg.this.signatureTree.getSelectionPath();
                    if (tp == null) {
                        return;
                    }
                } else {
                    tp = LocationSettingDlg.this.signatureTree.getPathForLocation(e.getX(), e.getY());
                }
                boolean isLeafNode = LocationSettingDlg.this.signatureModel.isLeaf(tp.getLastPathComponent());
                if (e.getClickCount() == 2 && isLeafNode) {
                    LocationSettingDlg.this.editCondition();
                }
            }

            private void showPopup(MouseEvent e) {
                if (LocationSettingDlg.this.isReadOnly) {
                    return;
                }
                TreePath path = LocationSettingDlg.this.signatureTree.getPathForLocation(e.getX(), e.getY());
                LocationSettingDlg.this.signatureTree.setSelectionPath(path);
                boolean has = PolicyHandler.hasCopiedObject(AlSignatureObject.class) || PolicyHandler.hasCopiedObject(AlSignatureOrObject.class);
                LocationSettingDlg.this.pasteSig.setEnabled(has);
                if (e.isPopupTrigger()) {
                    if (path != null) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                        Object treeObject = node.getUserObject();
                        if (treeObject instanceof AlSignatureObject) {
                            LocationSettingDlg.this.signatureTree.add((Component)LocationSettingDlg.this.andPMenu);
                            LocationSettingDlg.this.andPMenu.show((Component)LocationSettingDlg.this.signatureTree, e.getX(), e.getY());
                        } else {
                            LocationSettingDlg.this.signatureTree.add((Component)LocationSettingDlg.this.orPMenu);
                            LocationSettingDlg.this.orPMenu.show((Component)LocationSettingDlg.this.signatureTree, e.getX(), e.getY());
                        }
                        LocationSettingDlg.this.copySig.setEnabled(true);
                    } else {
                        if (PolicyHandler.hasCopiedObject(AlSignatureObject.class)) {
                            LocationSettingDlg.this.pasteSig.setEnabled(true);
                        }
                        LocationSettingDlg.this.copySig.setEnabled(false);
                        LocationSettingDlg.this.signatureTree.add((Component)LocationSettingDlg.this.andPMenu);
                        LocationSettingDlg.this.andPMenu.show((Component)LocationSettingDlg.this.signatureTree, e.getX(), e.getY());
                    }
                } else if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                    LocationSettingDlg.this.andPMenu.setVisible(false);
                    LocationSettingDlg.this.orPMenu.setVisible(false);
                }
            }
        });
        JScrollPane sPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)sPane, (JTree)this.signatureTree);
        panel.add((Component)sPane, "Center");
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        this.exclusive = new JCheckBox(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.excludedFromAutoLocation"));
        this.exclusive.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.exclusiveChanged();
            }
        });
        this.exclusiveDescLabel = new JLabel(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.ifEnabledThisLocationWillNotBeIncluded"));
        this.exclusiveDescLabel.setBorder(BorderFactory.createEmptyBorder(1, 20, 1, 0));
        JLabel criteriaLbl = new JLabel(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.switchToThisLocationWhen"));
        panel.add((Component)criteriaLbl, "North");
        JButton[] buttons = new JButton[5];
        this.addSig = new AbstractAction(UIText.get(8)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.addSignature(e);
            }
        };
        buttons[0] = new JButton(this.addSig);
        this.addBtn = buttons[0];
        this.editSig = new AbstractAction(UIText.get(1024)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.editCondition();
            }
        };
        buttons[1] = new JButton(this.editSig);
        this.deleteSig = new AbstractAction(UIText.get(769)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.deleteCondition();
            }
        };
        buttons[2] = new JButton(this.deleteSig);
        this.moveUpSig = new AbstractAction(UIText.get(3075)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.moveUpCondition();
            }
        };
        buttons[3] = new JButton(this.moveUpSig);
        this.moveDownSig = new AbstractAction(UIText.get(3074)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.moveDownCondition();
            }
        };
        buttons[4] = new JButton(this.moveDownSig);
        ButtonPane bPane = new ButtonPane(buttons, true, false);
        this.addSigAnd = new AbstractAction(UIText.get(14)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.addSigAndCondition();
            }
        };
        this.addSigOr = new AbstractAction(UIText.get(4618)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int childCnt = LocationSettingDlg.this.sigRoot.getChildCount();
                if (childCnt == 0) {
                    LocationSettingDlg.this.addSigAndCondition();
                } else {
                    LocationSettingDlg.this.addSigOrCondition();
                }
            }
        };
        this.copySig = new AbstractAction(UIText.get(520)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.copySigCondition();
            }
        };
        this.pasteSig = new AbstractAction(UIText.get(3840)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.pasteSigCondition();
            }
        };
        JMenuItem mItem = new JMenuItem(this.addSigAnd);
        this.addPMenu.add(mItem);
        mItem = new JMenuItem(this.addSigOr);
        this.addPMenu.add(mItem);
        JMenu menu = new JMenu(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.addMenu"));
        mItem = new JMenuItem(this.addSigAnd);
        menu.add(mItem);
        mItem = new JMenuItem(this.addSigOr);
        menu.add(mItem);
        this.andPMenu.add(menu);
        this.addMenuForAnd = menu;
        JMenuItem deleteMenu = new JMenuItem(this.deleteSig);
        this.andPMenu.add(deleteMenu);
        this.andPMenu.addSeparator();
        JMenuItem copyMenu = new JMenuItem(this.copySig);
        this.andPMenu.add(copyMenu);
        JMenuItem pasteMenu = new JMenuItem(this.pasteSig);
        this.andPMenu.add(pasteMenu);
        menu = new JMenu(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.addMenu"));
        mItem = new JMenuItem(this.addSigAnd);
        menu.add(mItem);
        mItem = new JMenuItem(this.addSigOr);
        menu.add(mItem);
        this.orPMenu.add(menu);
        this.addMenuForOr = menu;
        deleteMenu = new JMenuItem(this.deleteSig);
        this.orPMenu.add(deleteMenu);
        this.orPMenu.add(new JMenuItem(this.editSig));
        this.orPMenu.add(new JMenuItem(this.moveUpSig));
        this.orPMenu.add(new JMenuItem(this.moveDownSig));
        this.orPMenu.addSeparator();
        copyMenu = new JMenuItem(this.copySig);
        this.orPMenu.add(copyMenu);
        pasteMenu = new JMenuItem(this.pasteSig);
        this.orPMenu.add(pasteMenu);
        bPane.setBorder(BorderFactory.createEmptyBorder(0, 15, 15, 15));
        panel.add((Component)bPane, "East");
        panel.setBorder(BorderFactory.createEtchedBorder());
        return panel;
    }

    private void showAddMenu(ActionEvent e) {
        if (this.isReadOnly) {
            return;
        }
        JButton button = (JButton)e.getSource();
        button.add(this.addPMenu);
        this.addPMenu.show(button, button.getX(), button.getY());
    }

    private void deleteCondition() {
        Object treeObj;
        TreePath path = this.signatureTree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode currentSigNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (currentSigNode != null && (treeObj = currentSigNode.getUserObject()) instanceof DeletableObjInt) {
            Object[] choice = new String[]{MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.yes"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.no")};
            int result = JOptionPane.showOptionDialog(Manager.getFrame(), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.youAreABoutToDeleteACondition"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.deleteLocation"), 0, 3, null, choice, choice[1]);
            if (result == 0) {
                DefaultMutableTreeNode nextNode;
                AlSignatureObject alAndObj;
                DeletableObjInt alObj = (DeletableObjInt)treeObj;
                alObj.delete();
                if (treeObj instanceof AlSignatureObject && (alAndObj = (AlSignatureObject)treeObj).isFirst() && (nextNode = currentSigNode.getNextSibling()) != null) {
                    AlSignatureObject nextObj = (AlSignatureObject)nextNode.getUserObject();
                    nextObj.setToFirst();
                }
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)currentSigNode.getParent();
                this.signatureModel.removeNodeFromParent(currentSigNode);
                this.resetChildreanNumber(parentNode);
                this.addLog(this.selectedLoc.getName());
            }
        }
    }

    private void editCondition() {
        if (!this.locationNameChanged()) {
            return;
        }
        try {
            TreePath path = this.signatureTree.getSelectionPath();
            if (path == null) {
                JOptionPane.showMessageDialog(this, MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.youNeedToSelectTree"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.error"), 0);
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object treeItem = node.getUserObject();
            if (!(treeItem instanceof AlSignatureOrObject)) {
                JOptionPane.showMessageDialog(this, MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.onlyORObjectCanBeEdited"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.error"), 0);
                return;
            }
            DefaultMutableTreeNode andNode = (DefaultMutableTreeNode)node.getParent();
            AlSignatureOrObject thisObj = (AlSignatureOrObject)treeItem;
            AlSignatureObject andObj = (AlSignatureObject)andNode.getUserObject();
            int singleConditionStatus = andObj.getSigleConditionStatus();
            AlSignatureConditionDlg dlg = new AlSignatureConditionDlg(Manager.getFrame(), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.defineLocationCriteria"), true);
            AlSignatureOrObject newObj = thisObj.getClone();
            dlg.setObject(newObj);
            dlg.setSingleConditionStatus(singleConditionStatus);
            dlg.setVisible(true);
            if (!dlg.isOk()) {
                return;
            }
            int index = andNode.getIndex(node);
            this.signatureModel.removeNodeFromParent(node);
            DefaultMutableTreeNode newNode = this.generateConditionNode(newObj);
            this.signatureModel.insertNodeInto(newNode, andNode, index);
            this.resetChildreanNumber(andNode);
            TreePath newPath = new TreePath(newNode.getPath());
            this.signatureTree.scrollPathToVisible(newPath);
            this.signatureTree.expandPath(newPath);
            this.signatureTree.setSelectionPath(newPath);
            this.signatureModel.nodeChanged(newNode);
            andObj.replace(thisObj, newObj);
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.consoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void moveUpCondition() {
        if (!this.locationNameChanged()) {
            return;
        }
        TreePath selectedPath = this.signatureTree.getSelectionPath();
        if (selectedPath == null) {
            JOptionPane.showMessageDialog(this, MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.noItemIsSelected"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.error"), 0);
            return;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)selectedPath.getLastPathComponent();
        Object treeItem = selectedNode.getUserObject();
        if (!(treeItem instanceof AlSignatureOrObject)) {
            JOptionPane.showMessageDialog(this, MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.onlyORObjectCanBeMovedUp"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.error"), 0);
            return;
        }
        TreeNode[] allNodes = selectedNode.getPath();
        if (allNodes.length < 2) {
            JOptionPane.showMessageDialog(this, MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.theSignatureTreeIsNotCorrect"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.error"), 0);
            Manager.getFrame().showLoginPanel();
            return;
        }
        DefaultMutableTreeNode andNode = (DefaultMutableTreeNode)allNodes[1];
        DefaultMutableTreeNode preAndNode = andNode.getPreviousSibling();
        if (preAndNode == null) {
            JOptionPane.showMessageDialog(this, MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.thereIsNoPlaceToMoveUp"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.error"), 0);
            return;
        }
        AlSignatureOrObject orObj = (AlSignatureOrObject)treeItem;
        this.signatureModel.removeNodeFromParent(selectedNode);
        DefaultMutableTreeNode parentNode = preAndNode;
        int childCnt = parentNode.getChildCount();
        this.signatureModel.insertNodeInto(selectedNode, parentNode, childCnt);
        TreePath newPath = new TreePath(selectedNode.getPath());
        this.signatureTree.scrollPathToVisible(newPath);
        this.signatureTree.expandPath(newPath);
        this.signatureTree.setSelectionPath(newPath);
        AlSignatureObject andObj = (AlSignatureObject)andNode.getUserObject();
        AlSignatureObject preAndObj = (AlSignatureObject)preAndNode.getUserObject();
        andObj.removeAnCondition(orObj);
        preAndObj.addAnCondition(orObj);
        this.addLog(this.selectedLoc.getName());
        this.resetChildreanNumber(andNode);
        this.resetChildreanNumber(preAndNode);
    }

    private void moveDownCondition() {
        if (!this.locationNameChanged()) {
            return;
        }
        TreePath selectedPath = this.signatureTree.getSelectionPath();
        if (selectedPath == null) {
            JOptionPane.showMessageDialog(this, MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.noItemIsSelected"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.error"), 0);
            return;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)selectedPath.getLastPathComponent();
        Object treeItem = selectedNode.getUserObject();
        if (!(treeItem instanceof AlSignatureOrObject)) {
            JOptionPane.showMessageDialog(this, MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.onlyORObjectCanBeMovedUp"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.error"), 0);
            return;
        }
        TreeNode[] allNodes = selectedNode.getPath();
        if (allNodes.length < 2) {
            JOptionPane.showMessageDialog(this, MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.theSignatureTreeIsNotCorrect"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.error"), 0);
            Manager.getFrame().showLoginPanel();
            return;
        }
        DefaultMutableTreeNode andNode = (DefaultMutableTreeNode)allNodes[1];
        DefaultMutableTreeNode nextAndNode = andNode.getNextSibling();
        if (nextAndNode == null) {
            JOptionPane.showMessageDialog(this, MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.thereIsNoPlaceToMoveDown"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.error"), 0);
            return;
        }
        AlSignatureOrObject orObj = (AlSignatureOrObject)treeItem;
        this.signatureModel.removeNodeFromParent(selectedNode);
        DefaultMutableTreeNode parentNode = nextAndNode;
        int childCnt = parentNode.getChildCount();
        this.signatureModel.insertNodeInto(selectedNode, parentNode, childCnt);
        TreePath newPath = new TreePath(selectedNode.getPath());
        this.signatureTree.scrollPathToVisible(newPath);
        this.signatureTree.expandPath(newPath);
        this.signatureTree.setSelectionPath(newPath);
        AlSignatureObject andObj = (AlSignatureObject)andNode.getUserObject();
        AlSignatureObject nextAndObj = (AlSignatureObject)nextAndNode.getUserObject();
        andObj.removeAnCondition(orObj);
        nextAndObj.addAnCondition(orObj);
        this.addLog(this.selectedLoc.getName());
        this.resetChildreanNumber(andNode);
        this.resetChildreanNumber(nextAndNode);
    }

    private void moveUpLocation() {
        if (!this.locationNameChanged()) {
            return;
        }
        int curIndex = this.locList.getSelectedIndex();
        if (curIndex != -1) {
            LocationObject locObj = (LocationObject)this.locListModel.remove(curIndex);
            this.locListModel.add(curIndex - 1, locObj);
            this.autoLocObj.moveUpLoc(locObj);
            this.locList.setSelectedIndex(curIndex - 1);
        }
    }

    private void moveDownLocation() {
        if (!this.locationNameChanged()) {
            return;
        }
        int curIndex = this.locList.getSelectedIndex();
        if (curIndex != -1) {
            LocationObject locObj = (LocationObject)this.locListModel.remove(curIndex);
            this.locListModel.add(curIndex + 1, locObj);
            this.autoLocObj.moveDownLoc(locObj);
            this.locList.setSelectedIndex(curIndex + 1);
        }
    }

    private void addLocation() {
        if (!this.locationNameChanged()) {
            return;
        }
        LocationNameDlg dlg = new LocationNameDlg(Manager.getFrame(), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.newLocation"), true);
        dlg.setObject(this.autoLocObj);
        dlg.setVisible(true);
        if (!dlg.isOk()) {
            return;
        }
        LocationObject newLocObj = dlg.getAddedLocation();
        this.autoLocObj.addANewLocation(newLocObj);
        this.locListModel.addElement(newLocObj);
        this.locList.setSelectedValue(newLocObj, true);
        this.newLocs.add(newLocObj);
    }

    private void updateNewLocs() {
        int i = this.newLocs.size();
        while (--i >= 0) {
            LocationObject locObj = this.newLocs.get(i);
            try {
                this.gpObj.copyAppliedPoliciesToLocation(this.defaultLocAppliedPolicies, locObj);
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
                Object[] args = new Object[]{locObj.getName()};
                String msg = MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.addLocationFailed");
                JOptionPane.showMessageDialog(Manager.getFrame(), new DescriptionTextArea(MessageFormat.format(msg, new Object[]{args})), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.errorMessage"), 0);
                this.newLocs.remove(i);
            }
        }
    }

    private void removeFromNewLocs(LocationObject deleted) {
        Iterator<LocationObject> i = this.newLocs.iterator();
        while (i.hasNext()) {
            LocationObject lo = i.next();
            if (!lo.getId().equals(deleted.getId())) continue;
            i.remove();
            break;
        }
    }

    private void deleteLocation() {
        this.deleteLocation(true);
    }

    private void deleteLocation(boolean confirmDelete) {
        this.dontcheck = true;
        try {
            LocationObject currentLoc = this.locList.getSelectedValue();
            if (currentLoc != null) {
                if (currentLoc.isDefault()) {
                    throw new GUICheckException(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.cannotDeleteDefaultLocation"), null);
                }
                if (!this.autoLocObj.isOtherLocationsDisconnectToServer(currentLoc.getId())) {
                    throw new GUICheckException(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.youCannotDeleteThisLocation"), null);
                }
                int result = 0;
                if (confirmDelete) {
                    Object[] choice = new String[]{MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.yes"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.no")};
                    Object[] obj = new Object[]{currentLoc.getName()};
                    String str = MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.youAreAboutToDeleteTheLocation");
                    String fm = MessageFormat.format(str, obj);
                    result = JOptionPane.showOptionDialog(Manager.getFrame(), fm, MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.deleteLocation"), 0, 3, null, choice, choice[1]);
                }
                if (result == 0) {
                    this.autoLocObj.deleteLocation(currentLoc);
                    int delIndex = this.locList.getSelectedIndex();
                    this.locListModel.removeElement(currentLoc);
                    this.removeFromNewLocs(currentLoc);
                    if (this.locListModel.getSize() > 0) {
                        if (delIndex == this.locListModel.getSize()) {
                            this.locList.setSelectedIndex(delIndex - 1);
                        } else {
                            this.locList.setSelectedIndex(delIndex);
                        }
                    }
                }
            }
        }
        catch (GUICheckException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.error"), 0);
        }
        this.dontcheck = false;
    }

    private void copyLocation() {
        if (!this.locationNameChanged()) {
            return;
        }
        LocationObject currentLoc = this.locList.getSelectedValue();
        if (currentLoc != null) {
            PolicyHandler.copyObject(currentLoc);
            this.pasteLoc.setEnabled(true);
            this.pasteSig.setEnabled(false);
        }
    }

    private void pasteLocation() {
        if (!this.locationNameChanged()) {
            return;
        }
        try {
            LocationObject newLocObj = (LocationObject)PolicyHandler.getPastedObject(LocationObject.class);
            if (newLocObj == null) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.thereIsNoLocationInClipboard"));
                return;
            }
            this.autoLocObj.addANewLocation(newLocObj, true);
            this.locListModel.addElement(newLocObj);
            this.locList.setSelectedValue(newLocObj, true);
            if (newLocObj.hasNoAppliedPolicy()) {
                this.newLocs.add(newLocObj);
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.errorMessage"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void setDefaultLocation() {
        LocationObject currentLoc = this.locList.getSelectedValue();
        if (currentLoc != null) {
            this.autoLocObj.setDefaultLocation(currentLoc);
            if (!this.defaultChkBox.isSelected()) {
                this.defaultChkBox.setSelected(true);
            }
            this.locList.updateUI();
            this.setLocListActionStatus();
            this.setEnableActionStatus();
            this.addLog(this.selectedLoc.getName());
        }
    }

    private JPanel getNotificationPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints g1 = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 0, 0), 0, 0);
        GridBagConstraints g2 = new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 20, 0, 0), 0, 0);
        GridBagConstraints g3 = new GridBagConstraints(0, 2, 2, 3, 1.0, 0.0, 17, 1, new Insets(0, 20, 10, 0), 0, 0);
        if (this.enableLocationCheckBox == null) {
            this.enableLocationCheckBox = new JCheckBox(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.EnableLocation"));
            this.enableLocationCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LocationSettingDlg.this.enableLocationCheckBox.isSelected()) {
                        LocationSettingDlg.this.notificationMessageTextArea.setEnabled(true);
                        LocationSettingDlg.this.notificationLabel.setEnabled(true);
                    } else {
                        LocationSettingDlg.this.notificationMessageTextArea.setEnabled(false);
                        LocationSettingDlg.this.notificationLabel.setEnabled(false);
                    }
                }
            });
        }
        panel.add((Component)this.enableLocationCheckBox, g1);
        if (this.notificationLabel == null) {
            String notificationLabelString = MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.NotificationLabel");
            this.notificationLabel = new JLabel(MessageFormat.format(notificationLabelString, locationPlaceHolderStrings));
            this.notificationLabel.setEnabled(false);
        }
        panel.add((Component)this.notificationLabel, g2);
        if (this.notificationMessageTextArea == null) {
            this.notificationMessageTextArea = new JTextArea(new RestrictedPlainDocument(255));
            String notificationMessageString = MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.NotificationMessage");
            this.notificationMessageTextArea.setText(MessageFormat.format(notificationMessageString, locationPlaceHolderStrings));
            this.notificationMessageTextArea.setLineWrap(true);
            this.notificationMessageTextArea.setEnabled(false);
        }
        JScrollPane jsp = new JScrollPane(this.notificationMessageTextArea);
        this.notificationMessageTextArea.setRows(4);
        jsp.setPreferredSize(this.notificationMessageTextArea.getPreferredSize());
        this.notificationMessageTextArea.setBorder(CustomLookAndFeel.SIMPLE_BORDER);
        panel.add((Component)jsp, g3);
        return panel;
    }

    private JComponent getBottomPane() {
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(10, 5, 0, 5);
        constraints.anchor = 17;
        this.frequencyLabel = new JLabel(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.agentLocationCheckFrequency"));
        bottomPanel.add((Component)this.frequencyLabel, constraints);
        constraints.gridx = 1;
        this.frequencyControl = new JTextField(5);
        this.frequencyControl.setDocument(new NumberPlainDocument(1L, Integer.MAX_VALUE, true));
        bottomPanel.add((Component)this.frequencyControl, constraints);
        constraints.gridx = 2;
        this.secondsLabel = new JLabel(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.second"));
        bottomPanel.add((Component)this.secondsLabel, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 3;
        constraints.gridheight = 3;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 5, 0, 5);
        constraints.fill = 2;
        bottomPanel.add((Component)this.getNotificationPanel(), constraints);
        this.commandControl = new JTextField();
        return bottomPanel;
    }

    private void setFrequencyActionStatus() {
        this.frequencyControl.setEnabled(!this.isReadOnly);
        this.frequencyLabel.setEnabled(!this.isReadOnly);
        this.notificationLabel.setEnabled(!this.isReadOnly);
        this.enableLocationCheckBox.setEnabled(!this.isReadOnly);
        this.notificationMessageTextArea.setEnabled(!this.isReadOnly);
    }

    private void locListSelectionChanged(ListSelectionEvent e) {
        if (!this.dontcheck && !this.locationNameChanged()) {
            this.selectedLoc = this.locList.getSelectedValue();
            this.setLocListActionStatus();
            this.updateLocPanel();
            this.updateQueryTimer();
            return;
        }
        if (!e.getValueIsAdjusting()) {
            this.selectedLoc = this.locList.getSelectedValue();
            this.setLocListActionStatus();
            this.updateLocPanel();
            this.updateQueryTimer();
        }
    }

    private void setLocListActionStatus() {
        if (this.isReadOnly) {
            this.deleteLoc.setEnabled(false);
            this.moveUpLoc.setEnabled(false);
            this.moveDownLoc.setEnabled(false);
            this.addLoc.setEnabled(false);
            this.setDefaultLoc.setEnabled(false);
            this.copyLoc.setEnabled(false);
            this.pasteLoc.setEnabled(false);
            return;
        }
        int index = this.locList.getSelectedIndex();
        LocationObject currentLoc = this.locList.getSelectedValue();
        if (index == -1) {
            this.deleteLoc.setEnabled(false);
            this.moveUpLoc.setEnabled(false);
            this.moveDownLoc.setEnabled(false);
        } else {
            if (!currentLoc.isEnabled()) {
                this.setDefaultLoc.setEnabled(false);
            } else {
                this.setDefaultLoc.setEnabled(true);
            }
            if (!currentLoc.isDefault()) {
                this.deleteLoc.setEnabled(true);
            } else {
                this.deleteLoc.setEnabled(false);
            }
            if (index == 0) {
                this.moveUpLoc.setEnabled(false);
            } else {
                this.moveUpLoc.setEnabled(true);
            }
            if (index == this.locListModel.getSize() - 1) {
                this.moveDownLoc.setEnabled(false);
            } else {
                this.moveDownLoc.setEnabled(true);
            }
        }
    }

    private void setEnableActionStatus() {
        if (this.isReadOnly) {
            this.enableChk.setEnabled(false);
            return;
        }
        if (this.selectedLoc != null) {
            if (this.selectedLoc.isDefault()) {
                this.enableChk.setEnabled(false);
            } else {
                this.enableChk.setEnabled(true);
            }
        }
    }

    private void changeICMPQueryValue() {
        if (this.selectedLoc == null) {
            return;
        }
        boolean isEnabled = this.icmpRequestChk.isSelected();
        this.setTimerEnabled(isEnabled, ICMP);
        int unit = this.icmpUnitCombobox.getSelectedIndex();
        int inputValue = (Integer)this.icmpSpinner.getValue();
        int checkedValue = this.checkQueryTimer(unit, inputValue);
        this.icmpSpinner.setValue(checkedValue);
        this.selectedLoc.setICMPQuery(isEnabled, this.getTimerFrequenceAsSeconds(ICMP));
    }

    private void changeDnsQueryValue() {
        if (this.selectedLoc == null) {
            return;
        }
        boolean isEnabled = this.dnsQueryChk.isSelected();
        this.setTimerEnabled(isEnabled, DNS);
        int unit = this.dnsUnitCombobox.getSelectedIndex();
        int inputValue = (Integer)this.dnsSpinner.getValue();
        int checkedValue = this.checkQueryTimer(unit, inputValue);
        this.dnsSpinner.setValue(checkedValue);
        this.selectedLoc.setDnsQuery(isEnabled, this.getTimerFrequenceAsSeconds(DNS));
    }

    private void enabledChkChanged() {
        boolean isChecked = this.enableChk.isSelected();
        if (this.selectedLoc != null) {
            this.selectedLoc.setEnabled(isChecked);
            this.locList.updateUI();
            this.addLog(this.selectedLoc.getName());
        }
        this.setLocPanelStatus();
    }

    private void setLocPanelStatus() {
        boolean isChecked = this.enableChk.isSelected();
        boolean status = isChecked && !this.isReadOnly;
        UIUtilities.setContainerStatus(this.locPanel, status);
        this.synchronizeButtonAction(status);
        this.setEnableActionStatus();
        this.setSignatureActionStatus();
    }

    private void updateLocPanel() {
        if (this.selectedLoc == null) {
            return;
        }
        this.nameField.setText(this.selectedLoc.getName());
        this.desArea.setText(this.selectedLoc.getDescription());
        this.desArea.setCaretPosition(0);
        this.enableChk.setSelected(this.selectedLoc.isEnabled());
        this.exclusive.setSelected(this.selectedLoc.getExcludedAutoLoc());
        this.defaultChkBox.setSelected(this.selectedLoc.isDefault());
        this.generateSignatureTreeModel();
        this.setLocPanelStatus();
        if (this.resetNameField) {
            Document doc = this.nameField.getDocument();
            int length = doc.getLength();
            this.nameField.setSelectionStart(0);
            this.nameField.setSelectionEnd(length);
            this.resetNameField = false;
        }
    }

    private void updateQueryTimer() {
        if (this.selectedLoc == null) {
            return;
        }
        this.icmpRequestChk.setSelected(this.selectedLoc.isICMPQueryEnabled());
        this.setTimerFrequence(this.selectedLoc.getICMPQueryFreq(), ICMP);
        this.setTimerEnabled(this.icmpRequestChk.isEnabled() && this.icmpRequestChk.isSelected(), ICMP);
        this.dnsQueryChk.setSelected(this.selectedLoc.isDnsQueryEnabled());
        this.setTimerFrequence(this.selectedLoc.getDnsQueryFreq(), DNS);
        this.setTimerEnabled(this.dnsQueryChk.isEnabled() && this.dnsQueryChk.isSelected(), DNS);
    }

    private boolean locationNameChanged() {
        if (!this.isVisible()) {
            return true;
        }
        String newName = this.nameField.getText().trim();
        if (this.selectedLoc != null) {
            if (newName.length() == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.locationNameCannotBeBlank"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.error"), 0);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LocationSettingDlg.this.nameField.requestFocus();
                    }
                });
                return false;
            }
            if (newName.equals(this.selectedLoc.getName())) {
                return true;
            }
            if (!this.autoLocObj.setLocNewName(this.selectedLoc, newName)) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.theLocationNameCannotBeDuplicated"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.error"), 0);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LocationSettingDlg.this.nameField.requestFocus();
                    }
                });
                return false;
            }
            this.addLog(this.selectedLoc.getName());
            int index = this.locListModel.indexOf(this.selectedLoc);
            if (index != -1) {
                this.locListModel.dataChanged(index);
            }
        }
        return true;
    }

    private void locationDescChanged() {
        if (this.selectedLoc != null && !this.selectedLoc.getDescription().equals(this.desArea.getText())) {
            this.selectedLoc.setDescription(this.desArea.getText());
            this.addLog(this.selectedLoc.getName());
        }
    }

    private void exclusiveChanged() {
        int locSize;
        boolean isExclusive = this.exclusive.isSelected();
        if (isExclusive && (locSize = this.autoLocObj.getAutoLocationSize()) <= 1) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.theOnlyUsableLocationCannotBeExcluded"));
            this.exclusive.setSelected(false);
            return;
        }
        if (this.selectedLoc != null) {
            this.selectedLoc.setExcludedAutoLoc(isExclusive);
            this.addLog(this.selectedLoc.getName());
        }
    }

    private void generateSignatureTreeModel() {
        this.sigRoot.removeAllChildren();
        DefaultMutableTreeNode curAndNode = null;
        AlSignatureObject[] alSigs = this.selectedLoc.getSignatures();
        for (int i = 0; i < alSigs.length; ++i) {
            curAndNode = new DefaultMutableTreeNode(alSigs[i]);
            this.sigRoot.add(curAndNode);
            alSigs[i].setCountNumber(i);
            this.generateAddressOrCondition(curAndNode, alSigs[i]);
        }
        this.signatureModel = new DefaultTreeModel(this.sigRoot);
        this.signatureTree.setModel((TreeModel)this.signatureModel);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.signatureModel.getRoot();
        UIUtilities.expandTreeByDepth((JTree)this.signatureTree, root, 2);
    }

    private void generateAddressOrCondition(DefaultMutableTreeNode curAndNode, AlSignatureObject alSig) {
        AlSignatureOrObject[] localIPs = alSig.getLocalHostAddress();
        this.generateAddressOrCondition(curAndNode, localIPs);
        localIPs = alSig.getGatewayAddress();
        this.generateAddressOrCondition(curAndNode, localIPs);
        localIPs = alSig.getWinsAddress();
        this.generateAddressOrCondition(curAndNode, localIPs);
        localIPs = alSig.getDnsAddress();
        this.generateAddressOrCondition(curAndNode, localIPs);
        localIPs = alSig.getDhcpAddress();
        this.generateAddressOrCondition(curAndNode, localIPs);
        localIPs = alSig.getNetworkCondition();
        this.generateAddressOrCondition(curAndNode, localIPs);
        AlSignatureOrObject connection = alSig.getCmsCondition();
        this.generateAddressOrCondition(curAndNode, connection);
        localIPs = alSig.getTpmDevice();
        this.generateAddressOrCondition(curAndNode, localIPs);
        localIPs = alSig.getDnsResolve();
        this.generateAddressOrCondition(curAndNode, localIPs);
        localIPs = alSig.getAlRegistry();
        this.generateAddressOrCondition(curAndNode, localIPs);
        localIPs = alSig.getWirelessSSID();
        this.generateAddressOrCondition(curAndNode, localIPs);
        localIPs = alSig.getNICDescription();
        this.generateAddressOrCondition(curAndNode, localIPs);
        localIPs = alSig.getRemoteDeviceComm();
        this.generateAddressOrCondition(curAndNode, localIPs);
        localIPs = alSig.getDomainName();
        this.generateAddressOrCondition(curAndNode, localIPs);
        localIPs = alSig.getICMPReqAddress();
        this.generateAddressOrCondition(curAndNode, localIPs);
        localIPs = alSig.getLocalHostName();
        this.generateAddressOrCondition(curAndNode, localIPs);
        localIPs = alSig.getUserName();
        this.generateAddressOrCondition(curAndNode, localIPs);
        localIPs = alSig.getFileExists();
        this.generateAddressOrCondition(curAndNode, localIPs);
        localIPs = alSig.getOSVersion();
        this.generateAddressOrCondition(curAndNode, localIPs);
    }

    private void generateAddressOrCondition(DefaultMutableTreeNode curNode, AlSignatureOrObject[] allAddresses) {
        if (allAddresses.length == 0) {
            return;
        }
        for (int i = 0; i < allAddresses.length; ++i) {
            AlSignatureOrObject curAddress = allAddresses[i];
            DefaultMutableTreeNode orNode = this.generateConditionNode(curAddress);
            curNode.add(orNode);
            curAddress.setCountNumber(curNode.getIndex(orNode));
        }
    }

    private void generateAddressOrCondition(DefaultMutableTreeNode curNode, AlSignatureOrObject connection) {
        if (connection == null) {
            return;
        }
        DefaultMutableTreeNode orNode = this.generateConditionNode(connection);
        curNode.add(orNode);
        connection.setCountNumber(curNode.getIndex(orNode));
    }

    private void sigTreeSelectionChanged() {
        this.setSignatureActionStatus();
    }

    private void synchronizeButtonAction(boolean isChecked) {
        this.addSig.setEnabled(isChecked);
        this.deleteSig.setEnabled(isChecked);
        this.editSig.setEnabled(isChecked);
        this.moveUpSig.setEnabled(isChecked);
        this.moveDownSig.setEnabled(isChecked);
    }

    private void setSignatureActionStatus() {
        LicenseObject licenseObj = LicenseObject.getInstance();
        boolean enableAutoLoc = licenseObj.isAdaptiveLocation();
        this.addMenuForAnd.setEnabled(enableAutoLoc);
        this.addMenuForOr.setEnabled(enableAutoLoc);
        this.addBtn.setEnabled(enableAutoLoc);
        this.deleteSig.setEnabled(false);
        this.editSig.setEnabled(false);
        this.moveUpSig.setEnabled(false);
        this.moveDownSig.setEnabled(false);
        if (this.isReadOnly) {
            this.addBtn.setEnabled(false);
            this.addSigOr.setEnabled(false);
            this.addSigAnd.setEnabled(false);
            this.copySig.setEnabled(false);
            this.pasteSig.setEnabled(false);
            return;
        }
        boolean isEnabledLoc = this.enableChk.isSelected();
        if (!isEnabledLoc) {
            this.addSigAnd.setEnabled(false);
            this.addSigOr.setEnabled(false);
            this.pasteSig.setEnabled(false);
            return;
        }
        this.addSigAnd.setEnabled(true);
        this.addSigOr.setEnabled(true);
        DefaultMutableTreeNode currentSigNode = null;
        TreePath path = this.signatureTree.getSelectionPath();
        if (path != null) {
            currentSigNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        }
        if (currentSigNode != null) {
            Object currentTreeItem = currentSigNode.getUserObject();
            this.addSigOr.setEnabled(true);
            if (currentTreeItem instanceof DeletableObjInt) {
                this.deleteSig.setEnabled(true);
            }
            if (currentTreeItem instanceof AlSignatureOrObject) {
                DefaultMutableTreeNode nextAnd;
                this.editSig.setEnabled(true);
                TreeNode[] subpath = currentSigNode.getPath();
                DefaultMutableTreeNode preAnd = ((DefaultMutableTreeNode)subpath[1]).getPreviousSibling();
                if (preAnd != null) {
                    this.moveUpSig.setEnabled(true);
                }
                if ((nextAnd = ((DefaultMutableTreeNode)subpath[1]).getNextSibling()) != null) {
                    this.moveDownSig.setEnabled(true);
                }
            }
        }
    }

    private void addSigAndCondition() {
        if (!this.locationNameChanged()) {
            return;
        }
        int andCount = this.sigRoot.getChildCount();
        AlSignatureObject newObj = new AlSignatureObject(andCount == 0);
        DefaultMutableTreeNode aAndNode = new DefaultMutableTreeNode(newObj);
        Map<String, Serializable> retValue = this.addOrCondition(aAndNode, newObj);
        boolean isCanceled = (Boolean)retValue.get(CANCEL_VALUE);
        if (!isCanceled) {
            this.selectedLoc.addAlSignature(newObj);
            this.signatureModel.insertNodeInto(aAndNode, this.sigRoot, andCount);
            this.resetChildreanNumber(this.sigRoot);
            this.signatureModel.nodeChanged(aAndNode);
            DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)retValue.get(NODE_VALUE);
            TreePath newPath = new TreePath(newNode.getPath());
            this.signatureTree.scrollPathToVisible(newPath);
            this.signatureTree.expandPath(newPath);
            this.signatureTree.setSelectionPath(newPath);
            this.signatureModel.nodeChanged(newNode);
            this.addLog(this.selectedLoc.getName());
        }
    }

    private void addSigOrCondition() {
        DefaultMutableTreeNode andNode;
        if (!this.locationNameChanged()) {
            return;
        }
        TreePath path = this.signatureTree.getSelectionPath();
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            TreeNode[] allNodes = node.getPath();
            if (allNodes.length < 2) {
                JOptionPane.showMessageDialog(this, MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.theSignatureTreeIsNotCorrect"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.error"), 0);
                Manager.getFrame().showLoginPanel();
                return;
            }
            andNode = (DefaultMutableTreeNode)allNodes[1];
        } else {
            andNode = (DefaultMutableTreeNode)this.sigRoot.getLastChild();
        }
        AlSignatureObject parent = (AlSignatureObject)andNode.getUserObject();
        Map<String, Serializable> retValue = this.addOrCondition(andNode, parent);
        boolean isCanceled = (Boolean)retValue.get(CANCEL_VALUE);
        if (!isCanceled) {
            DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)retValue.get(NODE_VALUE);
            TreePath newPath = new TreePath(newNode.getPath());
            this.signatureTree.scrollPathToVisible(newPath);
            this.signatureTree.expandPath(newPath);
            this.signatureTree.setSelectionPath(newPath);
            this.signatureModel.nodeChanged(newNode);
            this.addLog(this.selectedLoc.getName());
        }
    }

    private Map<String, Serializable> addOrCondition(DefaultMutableTreeNode andNode, AlSignatureObject andObj) {
        HashMap<String, Serializable> retMap = new HashMap<String, Serializable>();
        int singleConditionStatus = this.getConditionStatus(andObj);
        AlSignatureConditionDlg dlg = new AlSignatureConditionDlg(Manager.getFrame(), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.defineLocationCriteria"), true);
        AlSignatureOrObject newObj = new AlSignatureOrObject(0);
        dlg.setObject(newObj);
        dlg.setSingleConditionStatus(singleConditionStatus);
        dlg.setVisible(true);
        if (!dlg.isOk()) {
            retMap.put(CANCEL_VALUE, Boolean.TRUE);
            return retMap;
        }
        andObj.addAnCondition(newObj);
        DefaultMutableTreeNode newNode = this.generateConditionNode(newObj);
        int child = andNode.getChildCount();
        this.signatureModel.insertNodeInto(newNode, andNode, child);
        this.resetChildreanNumber(andNode);
        retMap.put(CANCEL_VALUE, Boolean.FALSE);
        retMap.put(NODE_VALUE, newNode);
        return retMap;
    }

    private JSpinner getTimerSpinner(String timer) {
        JSpinner timerSpinner = null;
        if (ICMP.equals(timer)) {
            timerSpinner = this.icmpSpinner;
        } else if (DNS.equals(timer)) {
            timerSpinner = this.dnsSpinner;
        } else {
            return null;
        }
        if (timerSpinner == null) {
            timerSpinner = new JSpinner(new SpinnerNumberModel(1.0, 1.0, 2.147483647E9, 1.0));
        }
        return timerSpinner;
    }

    private void setTimerFrequence(int seconds, String timer) {
        JSpinner timerSpinner = this.getTimerSpinner(timer);
        JComboBox<Object> unitCombobox = this.getUnitCombobox(timer);
        int unit = 0;
        int displayvalue = seconds;
        if (0 == seconds % 3600) {
            unit = 2;
            displayvalue = seconds / 3600;
        } else if (0 == seconds % 60) {
            unit = 1;
            displayvalue = seconds / 60;
        } else {
            unit = 0;
        }
        timerSpinner.setModel(new SpinnerNumberModel(this.checkQueryTimer(unit, displayvalue), 1, this.getMaxValueForUnit(unit), 1));
        unitCombobox.setSelectedIndex(unit);
        UIUtilities.enableOnlyValidEdits(timerSpinner);
    }

    private ItemListener getTimerIntervalListener() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    LocationSettingDlg.this.updateQueryTimerWhenUnitChanged(event.getSource());
                }
            }
        };
    }

    private Object[] getUnits() {
        return new String[]{seconds, minutes, hours};
    }

    private JComboBox<Object> getUnitCombobox(String timer) {
        DefaultComboBoxModel<Object> interval = null;
        if (ICMP.equals(timer)) {
            if (null == this.icmpUnitCombobox) {
                interval = new DefaultComboBoxModel<Object>(this.getUnits());
                this.icmpUnitCombobox = new JComboBox<Object>(interval);
                this.icmpUnitCombobox.setPreferredSize(this.icmpUnitCombobox.getPreferredSize());
                this.icmpUnitCombobox.addItemListener(this.getTimerIntervalListener());
            }
            return this.icmpUnitCombobox;
        }
        if (DNS.equals(timer)) {
            if (null == this.dnsUnitCombobox) {
                interval = new DefaultComboBoxModel<Object>(this.getUnits());
                this.dnsUnitCombobox = new JComboBox<Object>(interval);
                this.dnsUnitCombobox.setPreferredSize(this.dnsUnitCombobox.getPreferredSize());
                this.dnsUnitCombobox.addItemListener(this.getTimerIntervalListener());
            }
            return this.dnsUnitCombobox;
        }
        return null;
    }

    private void setTimerEnabled(boolean enable, String timer) {
        if (DNS.equals(timer)) {
            this.dnsSpinner.setEnabled(enable);
            this.dnsUnitCombobox.setEnabled(enable);
        } else if (ICMP.equals(timer)) {
            this.icmpSpinner.setEnabled(enable);
            this.icmpUnitCombobox.setEnabled(enable);
        }
    }

    private int getSecondsforUnit(int unit) {
        int second = 1;
        switch (unit) {
            case 1: {
                second = 60;
                break;
            }
            case 2: {
                second = 3600;
                break;
            }
        }
        return second;
    }

    private Integer getTimerFrequenceAsSeconds(String timer) {
        return this.getTimerFrequenceForUnit(timer) * this.getSecondsforUnit(this.getUnitForTimer(timer));
    }

    private int getUnitForTimer(String timer) {
        int unit = 0;
        if (DNS.equals(timer)) {
            unit = this.dnsUnitCombobox.getSelectedIndex();
        } else if (ICMP.equals(timer)) {
            unit = this.icmpUnitCombobox.getSelectedIndex();
        }
        return unit;
    }

    private int getTimerFrequenceForUnit(String timer) {
        JSpinner timerSpinner = null;
        if (DNS.equals(timer)) {
            timerSpinner = this.dnsSpinner;
        } else if (ICMP.equals(timer)) {
            timerSpinner = this.icmpSpinner;
        }
        if (null != timerSpinner) {
            return Double.valueOf(timerSpinner.getValue().toString()).intValue();
        }
        return -1;
    }

    private int getMaxValueForUnit(int unit) {
        int max = 0;
        switch (unit) {
            case 0: {
                max = 3600000;
                break;
            }
            case 1: {
                max = 60000;
                break;
            }
            default: {
                max = 1000;
            }
        }
        return max;
    }

    private int getMinValueForUnit(int unit) {
        int min = 5;
        switch (unit) {
            case 0: {
                min = 5;
                break;
            }
            case 1: 
            case 2: {
                min = 1;
                break;
            }
        }
        return min;
    }

    private int checkQueryTimer(int unit, int value) {
        int max = this.getMaxValueForUnit(unit);
        int min = this.getMinValueForUnit(unit);
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        return value;
    }

    private void updateQueryTimerWhenUnitChanged(Object eventSource) {
        String timer = "";
        if (this.icmpUnitCombobox.equals(eventSource)) {
            timer = ICMP;
        } else if (this.dnsUnitCombobox.equals(eventSource)) {
            timer = DNS;
        } else {
            return;
        }
        JSpinner spinner = this.getTimerSpinner(timer);
        int unit = this.getUnitCombobox(timer).getSelectedIndex();
        spinner.setModel(new SpinnerNumberModel(this.checkQueryTimer(unit, this.getTimerFrequenceForUnit(timer)), 1, this.getMaxValueForUnit(unit), 1));
        UIUtilities.enableOnlyValidEdits(spinner);
    }

    private JPanel getQueryTimerPane() {
        JPanel pane = new JPanel(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        this.dnsQueryChk = new JCheckBox(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.DNSTimerPrefix"));
        this.dnsQueryChk.setSelected(true);
        this.dnsQueryChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.changeDnsQueryValue();
            }
        });
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.gridwidth = 1;
        cons.insets = new Insets(1, 2, 1, 2);
        cons.anchor = 17;
        cons.fill = 0;
        pane.add((Component)this.dnsQueryChk, cons);
        cons.gridx = 1;
        cons.gridy = 0;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.gridwidth = 1;
        cons.insets = new Insets(0, 0, 0, 0);
        cons.anchor = 17;
        cons.fill = 1;
        JSpinner timerSpinner = this.getTimerSpinner(DNS);
        timerSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LocationSettingDlg.this.changeDnsQueryValue();
            }
        });
        pane.add((Component)timerSpinner, cons);
        cons.gridx = 2;
        cons.gridy = 0;
        cons.weightx = 0.5;
        cons.weighty = 0.0;
        cons.gridwidth = 1;
        cons.insets = new Insets(0, 2, 0, 0);
        cons.anchor = 17;
        cons.fill = 0;
        JComboBox<Object> unitComboBox = this.getUnitCombobox(DNS);
        unitComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.changeDnsQueryValue();
            }
        });
        pane.add(unitComboBox, cons);
        cons.gridx = 3;
        cons.gridy = 0;
        cons.weightx = 10.0;
        cons.weighty = 0.0;
        cons.gridwidth = 1;
        cons.insets = new Insets(0, 2, 0, 0);
        cons.anchor = 17;
        cons.fill = 0;
        pane.add((Component)this.dnsRangeLabel, cons);
        this.icmpRequestChk = new JCheckBox(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.ICMPTimerPrefix"));
        this.icmpRequestChk.setSelected(true);
        this.icmpRequestChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.changeICMPQueryValue();
            }
        });
        cons.gridx = 0;
        cons.gridy = 1;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.gridwidth = 1;
        cons.insets = new Insets(1, 2, 1, 2);
        cons.anchor = 17;
        cons.fill = 0;
        pane.add((Component)this.icmpRequestChk, cons);
        cons.gridx = 1;
        cons.gridy = 1;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.gridwidth = 1;
        cons.insets = new Insets(0, 0, 0, 0);
        cons.anchor = 17;
        cons.fill = 1;
        timerSpinner = this.getTimerSpinner(ICMP);
        timerSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LocationSettingDlg.this.changeICMPQueryValue();
            }
        });
        pane.add((Component)timerSpinner, cons);
        cons.gridx = 2;
        cons.gridy = 1;
        cons.weightx = 0.5;
        cons.weighty = 0.0;
        cons.gridwidth = 1;
        cons.insets = new Insets(0, 2, 0, 0);
        cons.anchor = 17;
        cons.fill = 0;
        unitComboBox = this.getUnitCombobox(ICMP);
        unitComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationSettingDlg.this.changeICMPQueryValue();
            }
        });
        pane.add(unitComboBox, cons);
        cons.gridx = 3;
        cons.gridy = 1;
        cons.weightx = 10.0;
        cons.weighty = 0.0;
        cons.gridwidth = 1;
        cons.insets = new Insets(0, 2, 0, 0);
        cons.anchor = 17;
        cons.fill = 0;
        pane.add((Component)this.icmpRangeLabel, cons);
        cons.gridx = 4;
        cons.gridy = 1;
        return pane;
    }

    private int getConditionStatus(AlSignatureObject andObj) {
        int ret = 0;
        ret = andObj.getSigleConditionStatus();
        return ret;
    }

    private void resetChildreanNumber(DefaultMutableTreeNode andNode) {
        Enumeration<TreeNode> en = andNode.children();
        int cnt = 0;
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            Object obj = node.getUserObject();
            if (!(obj instanceof CountableInt)) continue;
            CountableInt cObj = (CountableInt)obj;
            cObj.setCountNumber(cnt++);
        }
    }

    private void copySigCondition() {
        if (!this.locationNameChanged()) {
            return;
        }
        TreePath path = this.signatureTree.getSelectionPath();
        if (path == null) {
            JOptionPane.showMessageDialog(this, MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.youNeedToSelectTreeBeforeCopy"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.error"), 0);
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object treeItem = node.getUserObject();
        PolicyHandler.copyObject((CopitableObject)treeItem);
        this.pasteLoc.setEnabled(false);
    }

    private void pasteSigCondition() {
        if (!this.locationNameChanged()) {
            return;
        }
        try {
            CopitableObject pastedObj = PolicyHandler.getPastedObject();
            if (pastedObj instanceof AlSignatureObject) {
                int andCount = this.sigRoot.getChildCount();
                AlSignatureObject newObj = (AlSignatureObject)pastedObj;
                this.selectedLoc.addAlSignature(newObj);
                DefaultMutableTreeNode aAndNode = new DefaultMutableTreeNode(newObj);
                this.signatureModel.insertNodeInto(aAndNode, this.sigRoot, andCount);
                this.resetChildreanNumber(this.sigRoot);
                TreePath pathToIt = new TreePath(aAndNode.getPath());
                this.signatureTree.scrollPathToVisible(pathToIt);
                this.signatureTree.setSelectionPath(pathToIt);
                this.generateAddressOrCondition(aAndNode, newObj);
                this.signatureTree.expandPath(pathToIt);
            } else {
                DefaultMutableTreeNode andNode;
                TreePath path = this.signatureTree.getSelectionPath();
                if (path != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    TreeNode[] allNodes = node.getPath();
                    if (allNodes.length < 2) {
                        JOptionPane.showMessageDialog(this, MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.signatureTreeIsNotCorrect"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.error"), 0);
                        Manager.getFrame().showLoginPanel();
                        return;
                    }
                    andNode = (DefaultMutableTreeNode)allNodes[1];
                } else {
                    andNode = (DefaultMutableTreeNode)this.sigRoot.getLastChild();
                }
                AlSignatureObject parent = (AlSignatureObject)andNode.getUserObject();
                AlSignatureOrObject newObj = (AlSignatureOrObject)pastedObj;
                int singleConditionStatus = parent.getSigleConditionStatus();
                int addressType = newObj.getType();
                if (addressType == 5 && (singleConditionStatus & 1) == 1) {
                    JOptionPane.showMessageDialog(this, MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.networkConnectionConditionHasExisted"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.error"), 0);
                    return;
                }
                if (addressType == 6 && (singleConditionStatus & 2) == 2) {
                    JOptionPane.showMessageDialog(this, MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.CMSConnectionConditionHasExisted"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.error"), 0);
                    return;
                }
                parent.addAnCondition(newObj);
                DefaultMutableTreeNode newNode = this.generateConditionNode(newObj);
                int child = andNode.getChildCount();
                this.signatureModel.insertNodeInto(newNode, andNode, child);
                this.resetChildreanNumber(andNode);
                TreePath newPath = new TreePath(newNode.getPath());
                this.signatureTree.scrollPathToVisible(newPath);
                this.signatureTree.expandPath(newPath);
                this.signatureTree.setSelectionPath(newPath);
                this.signatureModel.nodeChanged(newNode);
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.consoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        this.addLog(this.selectedLoc.getName());
    }

    private DefaultMutableTreeNode generateConditionNode(AlSignatureOrObject orObj) {
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(orObj);
        return parent;
    }

    private JPanel getReadOnlyTitlePane(boolean isInherit) {
        String desc = isInherit ? MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.locationsAreInheritedNoModificationAllowd") : MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.groupIsReadOnlyNoModificationAllowd");
        JPanel pane = new JPanel(new BorderLayout());
        DescriptionTextArea descArea = new DescriptionTextArea(true);
        descArea.setText(desc);
        pane.add(descArea);
        descArea.setBorder(BorderFactory.createEmptyBorder(3, 4, 5, 4));
        return pane;
    }

    private void addLog(String locName) {
        if (this.lastLocName == null || !this.lastLocName.equals(locName)) {
            this.autoLocObj.addLog(2, MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.editLocation") + locName);
            this.lastLocName = locName;
        }
    }

    public void setObject(GroupPolicyObject gpObj) throws ConsoleException {
        Integer frequency;
        this.gpObj = gpObj;
        this.defaultLocAppliedPolicies = gpObj.getDefaultLocationAppliedPolicy();
        this.autoLocObj = gpObj.getAutoLocation().getClone();
        List<LocationObject> locations = this.autoLocObj.getLocations();
        this.locListModel.clear();
        for (int i = 0; i < locations.size(); ++i) {
            this.locListModel.addElement(locations.get(i));
        }
        if (this.locListModel.getSize() > 0) {
            this.locList.setSelectedIndex(0);
        }
        if ((frequency = this.autoLocObj.getLocationCheckFrequency()) == null) {
            frequency = this.autoLocObj.getDefLocationCheckFrequency();
        }
        this.frequencyControl.setText(Integer.toString(frequency));
        String command = this.autoLocObj.getCommandToRun();
        if (command != null) {
            this.commandControl.setText(command);
        }
        this.enableLocationCheckBox.setSelected(this.autoLocObj.getEnableNotification());
        if (this.enableLocationCheckBox.isSelected()) {
            this.notificationMessageTextArea.setText(this.autoLocObj.getNotificationMessage());
            this.notificationMessageTextArea.setEnabled(true);
            this.notificationLabel.setEnabled(true);
        }
    }

    public void setSelectLoc(LocationObject curLoc) {
        String locName = curLoc.getName();
        ListModel<LocationObject> model = this.locList.getModel();
        int size = model.getSize();
        for (int index = 0; index < size; ++index) {
            if (!locName.equals(model.getElementAt(index).getName())) continue;
            this.locList.setSelectedIndex(index);
            break;
        }
    }

    public void setSelectLoc(LocationObject curLoc, boolean resetNameField) {
        this.resetNameField = resetNameField;
        this.locList.setSelectedValue(curLoc, true);
    }

    @Override
    public void setReadOnly(boolean isInherit) {
        JPanel readOnlyTitle = this.getReadOnlyTitlePane(isInherit);
        this.panel1.add((Component)readOnlyTitle, "North");
        this.isReadOnly = true;
        UIUtilities.setContainerStatus(this.leftPane, false);
        UIUtilities.setContainerStatus(this.locPanel, false);
        this.jBOk.setEnabled(false);
        this.jBOk.setToolTipText(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.locationsAreInheritedYouCannotChangeThem"));
        this.setFrequencyActionStatus();
    }

    static class MyListModel
    extends DefaultListModel<LocationObject> {
        private static final long serialVersionUID = 1L;

        MyListModel() {
        }

        public void dataChanged(int index) {
            this.fireContentsChanged(this, index, index);
        }
    }

    static class HTMLRenderer
    extends JLabel
    implements TreeCellRenderer {
        private static final long serialVersionUID = 1L;

        public HTMLRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setText(value == null ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.91") : value.toString());
            if (selected) {
                this.setBackground(UIManager.getColor("Tree.selectionBackground"));
                this.setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("Tree.background"));
                this.setForeground(UIManager.getColor("Tree.textForeground"));
            }
            return this;
        }
    }
}

