/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AutoLocationObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.LocationObject;
import com.sygate.scm.console.ui.policy.dialog.LocationHandler;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class LocationNamePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String POLICYDIALOG = "com.sygate.scm.console.ui.policy.dialog.policydialog";
    private JLabel Name = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationNamePanel.name"));
    private JTextField NameField = new JTextField();
    private JLabel Desc = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationNamePanel.description"));
    private JTextArea DescArea = new JTextArea(5, 40);
    private GroupObject grpObj = null;
    private GroupPolicyObject apObj = null;
    private AutoLocationObject autoLocObj = null;

    public LocationNamePanel() {
        this.initPanel();
    }

    private void initPanel() {
        String title = MSGRES.getString(POLICYDIALOG, "LocationNamePanel.title");
        String content = MSGRES.getString(POLICYDIALOG, "LocationNamePanel.titleDesc");
        JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
        RestrictedPlainDocument doc = new RestrictedPlainDocument(128);
        doc.setValidator("\"/\\*?<>|:;", false);
        this.NameField.setDocument(doc);
        this.DescArea.setDocument(new RestrictedPlainDocument(256));
        JScrollPane jScrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)jScrollPane, (JTextArea)this.DescArea);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 80, 10, 80));
        panel.add((Component)this.Name, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.NameField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.Desc, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        panel.add((Component)jScrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new VerticalFlowLayout(0, 0));
        this.add(headPanel);
        this.add(panel);
    }

    public void setName() {
        if (this.NameField.getText().length() == 0) {
            try {
                this.grpObj = LocationHandler.getInstance().getGroupObj();
                this.apObj = PolicyHandler.getGroupPolicyByGroup(this.grpObj);
                this.autoLocObj = this.apObj.getAutoLocation();
                this.NameField.setText(this.autoLocObj.getNewLocName());
            }
            catch (Exception e) {
                LoggerUtilities.logException((Throwable)e);
                JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MSGRES.getString(POLICYDIALOG, "LocationNamePanel.error"), 0);
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    public boolean isValidData() {
        try {
            String newName = this.NameField.getText().trim();
            if (newName.length() == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(POLICYDIALOG, "LocationNamePanel.locationNameCannotBeBlank"), MSGRES.getString(POLICYDIALOG, "LocationNamePanel.error"), 0);
                this.NameField.requestFocusInWindow();
                return false;
            }
            if (!this.autoLocObj.isNewNameValid(newName)) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(POLICYDIALOG, "LocationNamePanel.theLocationNameCannotBeDuplicated"), MSGRES.getString(POLICYDIALOG, "LocationNamePanel.error"), 0);
                this.NameField.requestFocusInWindow();
                return false;
            }
            LocationHandler.getInstance().setLocDetails(newName, this.DescArea.getText());
            LocationObject newLoc = new LocationObject(newName, this.autoLocObj.getAutoLocation());
            newLoc.setDescription(this.DescArea.getText());
            LocationHandler.getInstance().setLocObj(newLoc);
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MSGRES.getString(POLICYDIALOG, "LocationNamePanel.error"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return true;
    }
}

