/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AutoLocationObject;
import com.sygate.scm.console.logicobject.LocationObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class LocationNameDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JTextField nameField = new JTextField();
    JTextArea descArea = new JTextArea();
    private AutoLocationObject autoLocObj;
    private LocationObject newLoc;

    public LocationNameDlg(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
            UiUtilities.centerComponent((Component)this);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.getContentPane().add(this.panel1);
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.panel1.add((Component)this.getTopPane(), "North");
        this.panel1.add(this.getCentralPane());
    }

    private JPanel getTopPane() {
        JPanel pane = new JPanel(new FlowLayout(0));
        JLabel desc = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationNameDlg.enterTheNewLocationNameAndDescription"));
        pane.add(desc);
        Border outer = BorderFactory.createEmptyBorder(2, 3, 5, 3);
        pane.setBorder(outer);
        return pane;
    }

    private JPanel getCentralPane() {
        JPanel pane = new JPanel();
        GridBagLayout gbLayout = new GridBagLayout();
        pane.setLayout(gbLayout);
        RestrictedPlainDocument groupNameDoc = new RestrictedPlainDocument(128);
        this.nameField.setDocument(groupNameDoc);
        groupNameDoc.setValidator("\"/\\*?<>|:;", false);
        RestrictedPlainDocument descDoc = new RestrictedPlainDocument(256);
        this.descArea.setDocument(descDoc);
        JScrollPane sPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)sPane, (JTextArea)this.descArea);
        sPane.setPreferredSize(new Dimension(300, 50));
        JComponent[][] comps = new JComponent[2][2];
        comps[0][0] = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationNameDlg.name"));
        comps[0][1] = this.nameField;
        comps[1][0] = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationNameDlg.description"));
        comps[1][1] = sPane;
        GridBagConstraints cons = new GridBagConstraints();
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 2; ++col) {
                cons.gridx = col;
                cons.gridy = row;
                cons.insets = row == 0 ? (col == 0 ? new Insets(8, 8, 2, 2) : new Insets(8, 3, 2, 8)) : (col == 0 ? new Insets(2, 8, 8, 2) : new Insets(2, 3, 8, 8));
                cons.weighty = 0.5;
                if (col == 0) {
                    cons.anchor = row == 0 ? 13 : 12;
                    cons.weightx = 0.0;
                    cons.fill = 0;
                } else {
                    cons.anchor = 17;
                    cons.weightx = 0.5;
                    cons.fill = row == 0 ? 2 : 1;
                }
                pane.add((Component)comps[row][col], cons);
            }
        }
        Border outer = BorderFactory.createEmptyBorder(2, 8, 5, 8);
        Border inner = BorderFactory.createEtchedBorder();
        pane.setBorder(BorderFactory.createCompoundBorder(outer, inner));
        return pane;
    }

    @Override
    protected boolean isValidate() {
        try {
            String newName = this.nameField.getText();
            if (newName.trim().length() == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationNameDlg.locationNameCannotBeBlank"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationNameDlg.error"), 0);
                this.nameField.requestFocusInWindow();
                return false;
            }
            if (!this.autoLocObj.isNewNameValid(newName)) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationNameDlg.theLocationNameCannotBeDuplicated"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationNameDlg.error"), 0);
                this.nameField.requestFocusInWindow();
                return false;
            }
            this.newLoc = new LocationObject(newName, this.autoLocObj.getAutoLocation());
            this.newLoc.setDescription(this.descArea.getText());
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationNameDlg.error"), 0);
            Manager.getFrame().showLoginPanel();
            return false;
        }
        return true;
    }

    public LocationObject getAddedLocation() {
        return this.newLoc;
    }

    public void setObject(AutoLocationObject auto) {
        this.autoLocObj = auto;
        this.nameField.requestFocus();
    }

    @Override
    protected boolean isHelpButtonShown() {
        return false;
    }
}

