/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.schema.EthernetExclusionCondition;
import com.sygate.scm.common.configobject.schema.LocationCriteriaCondition;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.dialog.ConditionsPanelBase;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class LocationCriteriaConditionsPanel
extends ConditionsPanelBase {
    private static final long serialVersionUID = 1L;
    private JTextComponent editor;
    private String editorTitle;
    private String editorFieldHeading;
    private boolean isForEthernetExclusionConditions;
    private boolean isForLocalHostName = false;
    private boolean isForDomainName = false;
    private static final MessageResources MRS = MessageResources.getInstance();

    LocationCriteriaConditionsPanel(String conditionTitle, String equalMessage, String notEqualMessage, String editorTitle, String editorFieldHeading, boolean isSingleLineEdit, boolean isValidationRequired, boolean isHostName) {
        this(conditionTitle, equalMessage, notEqualMessage, editorTitle, editorFieldHeading, isSingleLineEdit, isValidationRequired);
        this.isForLocalHostName = isHostName;
        if (isValidationRequired && isHostName) {
            RestrictedPlainDocument localHostNameDoc = new RestrictedPlainDocument(255);
            localHostNameDoc.setValidator("~!@#$^&()+{}|:\"<>`=[]\\;'/", false);
            this.editor.setDocument(localHostNameDoc);
        }
    }

    LocationCriteriaConditionsPanel(String conditionTitle, String equalMessage, String notEqualMessage, String editorTitle, String editorFieldHeading, boolean isSingleLineEdit, boolean isValidationRequired) {
        this(conditionTitle, equalMessage, notEqualMessage, editorTitle, editorFieldHeading, isSingleLineEdit);
        if (isValidationRequired) {
            RestrictedPlainDocument domainNameDoc = new RestrictedPlainDocument(255);
            domainNameDoc.setValidator("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-.*", true);
            this.editor.setDocument(domainNameDoc);
            this.isForDomainName = true;
        }
    }

    LocationCriteriaConditionsPanel(String conditionTitle, String equalMessage, String notEqualMessage, String editorTitle, String editorFieldHeading, boolean isSingleLineEdit) {
        super(conditionTitle, equalMessage, notEqualMessage);
        this.editorTitle = editorTitle;
        this.editorFieldHeading = editorFieldHeading;
        this.editor = isSingleLineEdit ? new JTextField() : new JTextArea();
    }

    @Override
    String getCellText(Object value) {
        String text = null;
        text = this.isForEthernetExclusionConditions ? ((EthernetExclusionCondition)value).getCondition() : ((LocationCriteriaCondition)value).getCondition();
        return text;
    }

    @Override
    Object[] getConditions() {
        int count = this.listModel.size();
        Object[] conditions = null;
        conditions = this.isForEthernetExclusionConditions ? new EthernetExclusionCondition[count] : new LocationCriteriaCondition[count];
        for (int index = 0; index < count; ++index) {
            conditions[index] = this.listModel.get(index);
        }
        return conditions;
    }

    @Override
    void showEditor(boolean isNew) {
        new EditorDialog(Manager.getFrame(), this, this.editorTitle, true, isNew);
    }

    private class EditorDialog
    extends DialogBase {
        private static final long serialVersionUID = 1L;
        boolean isNew;

        public EditorDialog(JFrame parent, JPanel relativePanel, String title, boolean modal, boolean isNew) {
            super(parent, title, modal);
            this.isNew = isNew;
            this.initialize(relativePanel);
        }

        private void initialize(JPanel relativePanel) {
            Container container = this.getContentPane();
            GridBagConstraints constraints = new GridBagConstraints();
            JPanel centralpanel = new JPanel(new GridBagLayout());
            constraints.anchor = 17;
            constraints.insets = new Insets(3, 15, 3, 15);
            constraints.weightx = 1.0;
            centralpanel.add((Component)new JLabel(LocationCriteriaConditionsPanel.this.editorFieldHeading), constraints);
            constraints.gridy = 1;
            constraints.fill = 2;
            if (LocationCriteriaConditionsPanel.this.editor instanceof JTextArea) {
                constraints.weighty = 1.0;
                constraints.fill = 1;
                centralpanel.add((Component)new JScrollPane(LocationCriteriaConditionsPanel.this.editor), constraints);
            } else {
                centralpanel.add((Component)LocationCriteriaConditionsPanel.this.editor, constraints);
            }
            container.add(centralpanel);
            String editorText = "";
            if (!this.isNew) {
                editorText = LocationCriteriaConditionsPanel.this.isForEthernetExclusionConditions ? ((EthernetExclusionCondition)LocationCriteriaConditionsPanel.this.conditionsList.getSelectedValue()).getCondition() : ((LocationCriteriaCondition)LocationCriteriaConditionsPanel.this.conditionsList.getSelectedValue()).getCondition();
            }
            LocationCriteriaConditionsPanel.this.editor.setText(editorText);
            container.add((Component)this.getButtonPanel(), "South");
            this.setSize(300, 150);
            this.setLocationRelativeTo(relativePanel);
            this.setVisible(true);
        }

        @Override
        protected boolean isHelpButtonShown() {
            return false;
        }

        @Override
        protected boolean isValidate() {
            String conditionText = LocationCriteriaConditionsPanel.this.editor.getText().trim();
            if (conditionText.length() < 1) {
                JOptionPane.showMessageDialog(this, MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AlSignatureConditionDlg.noCondition"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AlSignatureConditionDlg.error"), 0);
                return false;
            }
            if (conditionText.startsWith(".") && (LocationCriteriaConditionsPanel.this.isForLocalHostName || LocationCriteriaConditionsPanel.this.isForDomainName)) {
                JOptionPane.showMessageDialog(this, MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", LocationCriteriaConditionsPanel.this.isForLocalHostName ? "AlSignatureConditionDlg.invalidLocalHostNameError" : "AlSignatureConditionDlg.invalidDomainError"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AlSignatureConditionDlg.error"), 0);
                return false;
            }
            return true;
        }

        @Override
        protected void commit() {
            EthernetExclusionCondition condition = null;
            String conditionText = LocationCriteriaConditionsPanel.this.editor.getText().trim();
            if (LocationCriteriaConditionsPanel.this.isForEthernetExclusionConditions) {
                EthernetExclusionCondition ethernetExclusionCondition = this.isNew ? new EthernetExclusionCondition() : (EthernetExclusionCondition)LocationCriteriaConditionsPanel.this.conditionsList.getSelectedValue();
                ethernetExclusionCondition.setCondition(conditionText);
                condition = ethernetExclusionCondition;
            } else {
                LocationCriteriaCondition locationCriteriaCondition = this.isNew ? new LocationCriteriaCondition() : (LocationCriteriaCondition)LocationCriteriaConditionsPanel.this.conditionsList.getSelectedValue();
                locationCriteriaCondition.setCondition(conditionText);
                condition = locationCriteriaCondition;
            }
            if (this.isNew) {
                LocationCriteriaConditionsPanel.this.addCondition(condition);
            }
            this.dispose();
            LocationCriteriaConditionsPanel.this.conditionsList.updateUI();
        }
    }
}

