/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.HostAddressObject;
import com.sygate.scm.console.logicobject.ServerBlockObject;
import com.sygate.scm.console.ui.policy.dialog.ServerListEditorDlg;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class HostAddressDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private HostAddressObject hostObj;
    private JPanel jContentPane = null;
    private JPanel jPanel = null;
    private JTextArea jTextArea = null;
    private JLabel jLabel = null;
    private JTextField hostField = null;
    private JCheckBox httpChkBox = null;
    private JCheckBox httpsChkBox = null;
    private JTextField httpField = null;
    private JTextField httpsField = null;
    private ServerBlockObject bObj;

    public HostAddressDlg(JFrame frame, String title, boolean modal, ServerBlockObject bObj) {
        super(frame, title, modal);
        this.bObj = bObj;
        this.initialize();
    }

    protected void httpChkBoxChanged() {
        boolean httpChked = this.getHttpChkBox().isSelected();
        this.getHttpField().setEnabled(httpChked);
    }

    protected void httpsChkBoxChanged() {
        boolean checked = this.getHttpsChkBox().isSelected();
        this.getHttpsField().setEnabled(checked);
    }

    @Override
    protected boolean isValidate() {
        String address = this.hostField.getText().trim();
        if (address.length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.serverAddressCannotBeEmpty"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.error"), 0);
            return false;
        }
        if (!Utility.isValidIPAddressOrHostName((String)address.replaceFirst("[?(.+)]?", "$0"))) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.invalidServerAddress"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.error"), 0);
            return false;
        }
        if (Utility.isLinkLocalAddress((String)address)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.linkLocalNotSupported"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.error"), 0);
            return false;
        }
        if (StringUtilities.isLocalHostAddress((String)address)) {
            String msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.cannotAddLocalHost"), address);
            JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.error"), 0);
            return false;
        }
        if (!address.equals(this.hostObj.getAddress())) {
            HostAddressObject hao = new HostAddressObject();
            hao.setAddress(address);
            if (ServerListEditorDlg.duplicateHostExists(this.bObj, hao)) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.dupeHostInBlock"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.error"), 0);
                return false;
            }
        }
        boolean customHttp = this.httpChkBox.isSelected();
        boolean customHttps = this.httpsChkBox.isSelected();
        String strHttp = this.httpField.getText().trim();
        String strHttps = this.httpsField.getText().trim();
        if (customHttp && strHttp.length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.HTTPPortCannotBeEmpty"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.error"), 0);
            return false;
        }
        if (customHttps && strHttps.length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.HTTPSPortCannotBeEmpty"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.error"), 0);
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        String address = this.hostField.getText().trim();
        boolean customHttp = this.httpChkBox.isSelected();
        boolean customHttps = this.httpsChkBox.isSelected();
        String strHttp = this.httpField.getText().trim();
        String strHttps = this.httpsField.getText().trim();
        if (customHttp) {
            this.hostObj.setHttpPort(Integer.parseInt(strHttp));
        } else {
            this.hostObj.setHttpPort(null);
        }
        if (customHttps) {
            this.hostObj.setHttpsPort(Integer.parseInt(strHttps));
        } else {
            this.hostObj.setHttpsPort(null);
        }
        address = address.replace("[", "").replace("]", "");
        this.hostObj.setAddress(address);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_endpoint_security_manager_list_edit_add_host";
    }

    private void initialize() {
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getJContentPane());
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel(), "Center");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getJTextArea(), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.jPanel.add((Component)this.getJLabel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
            this.jPanel.add((Component)this.getHostField(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.jPanel.add((Component)this.getHttpChkBox(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
            this.jPanel.add((Component)this.getHttpsChkBox(), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
            this.jPanel.add((Component)this.getHttpField(), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 100, 0));
            this.jPanel.add((Component)this.getHttpsField(), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 100, 0));
        }
        return this.jPanel;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new DescriptionTextArea();
            this.jTextArea.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.pleaseSpecifyAServerIPAddressOr"));
        }
        return this.jTextArea;
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.serverAddress"), 2);
        }
        return this.jLabel;
    }

    private JTextField getHostField() {
        if (this.hostField == null) {
            this.hostField = new JTextField();
            RestrictedPlainDocument doc = new RestrictedPlainDocument(255);
            this.hostField.setDocument(doc);
        }
        return this.hostField;
    }

    private JCheckBox getHttpChkBox() {
        if (this.httpChkBox == null) {
            this.httpChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.customizeHTTPPortNumber"));
            this.httpChkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HostAddressDlg.this.httpChkBoxChanged();
                }
            });
        }
        return this.httpChkBox;
    }

    private JCheckBox getHttpsChkBox() {
        if (this.httpsChkBox == null) {
            this.httpsChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "HostAddressDlg.customizeHTTPSPortNumber"));
            this.httpsChkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HostAddressDlg.this.httpsChkBoxChanged();
                }
            });
        }
        return this.httpsChkBox;
    }

    private JTextField getHttpField() {
        if (this.httpField == null) {
            this.httpField = new JTextField();
            NumberPlainDocument doc = new NumberPlainDocument(65535L);
            this.httpField.setDocument(doc);
            String port = String.valueOf(ScmProperties.getWebServerPort());
            this.httpField.setText(port);
        }
        return this.httpField;
    }

    private JTextField getHttpsField() {
        if (this.httpsField == null) {
            this.httpsField = new JTextField();
            NumberPlainDocument doc = new NumberPlainDocument(65535L);
            this.httpsField.setDocument(doc);
            String port = String.valueOf(ScmProperties.getWebServerPortHttps());
            this.httpsField.setText(port);
        }
        return this.httpsField;
    }

    private void updatePanel() {
        this.hostField.setText(this.hostObj.getAddress());
        Integer httpPort = this.hostObj.getHttpPort();
        if (httpPort != null) {
            this.httpField.setText(httpPort.toString());
        }
        this.httpChkBox.setSelected(httpPort != null);
        Integer httpsPort = this.hostObj.getHttpsPort();
        if (httpsPort != null) {
            this.httpsField.setText(httpsPort.toString());
        }
        this.httpsChkBox.setSelected(httpsPort != null);
        this.httpChkBoxChanged();
        this.httpsChkBoxChanged();
        this.hostField.requestFocusInWindow();
    }

    public void setObject(HostAddressObject hObj) {
        this.hostObj = hObj;
        this.updatePanel();
    }
}

