/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.schema.OptimizationSettings;
import com.sygate.scm.common.configobject.schema.PerformanceSettings;
import com.sygate.scm.common.configobject.schema.PrivateInsightServer;
import com.sygate.scm.common.configobject.schema.RebootOptions;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.SemClientHandler;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.AgentLogObject;
import com.sygate.scm.console.logicobject.AppAuthenticationObject;
import com.sygate.scm.console.logicobject.AutoLocationObject;
import com.sygate.scm.console.logicobject.CommunicationObject;
import com.sygate.scm.console.logicobject.ComputerLockdownProtectionObject;
import com.sygate.scm.console.logicobject.EnforcerNotificationObject;
import com.sygate.scm.console.logicobject.ExternalCommunicationObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.IDSObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.dialog.AdditionalTextDialog;
import com.sygate.scm.console.ui.policy.dialog.AppAuthenticationPanel;
import com.sygate.scm.console.ui.policy.dialog.CommunicationPanel;
import com.sygate.scm.console.ui.policy.dialog.ExternalCommunicationPanel;
import com.sygate.scm.console.ui.policy.dialog.LockDownPanel;
import com.sygate.scm.console.ui.policy.dialog.RebootOptionsPanel;
import com.sygate.scm.console.ui.policy.dialog.TamperProtectionPanel;
import com.sygate.scm.console.ui.policy.ids.IdsLibraryPanel;
import com.sygate.scm.console.ui.util.CreateOSLabelUtil;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.JPanelWithIconBorder;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.i18n.ConsoleMessageResourcesFile;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class GlobalSettingDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final String AUTOMATION_BUTTON_OK = "ButtonOK";
    private static final String AUTOMATION_ID_SYSTEM_LOCKDOWN_PANEL = "SystemLockdownPanel";
    private static final MessageResourcesFile MSGRES = new ConsoleMessageResourcesFile("com.sygate.scm.console.ui.policy.dialog.policydialog");
    private static final long maxUploadLimit = 500L;
    public static final String APPLICATION_AUTHENTICATION = "application authentication";
    public static final String LOCKDOWN = "Lockdown";
    public static final String INTRUSION_PREVENTION = "Intrusion Prevention";
    public static final String LOGS = "logs";
    public static final String COMMUNICATION = "Communication";
    public static final String EXTERNAL_COMMUNICATION = "ExternalCommunication";
    public static final String SUBMISSONS = "Submissions";
    public static final String SECURITY = MSGRES.getString("GlobalSettingDlg.securitySettings");
    public static final String TAMPER_PROTECTION = MSGRES.getString("GlobalSettingDlg.tamperProtection");
    private static final int DAMPER_PERIOD_MAX = 99999;
    public static final String LOGTAB = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.logs");
    public static final String REBOOT_TAB = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.rebootSettings");
    public static final String OTHERTAB = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.generalSettings");
    public static final String APPTAB = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.applicationAuthentication");
    public static final String IDSTAB = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.intrusionPrevention");
    public static final String COMTAB = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.communication");
    public static final String OVERFLOWTAB = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.overflowProtection");
    public static final String LOCKDOWNTAB = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.systemLockdown");
    public static final String KEY_LOGTAB = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.logs");
    public static final String KEY_OTHERTAB = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.generalSettings");
    public static final String KEY_APPTAB = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.applicationAuthentication");
    public static final String KEY_IDSTAB = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.intrusionPrevention");
    public static final String KEY_COMTAB = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.communication");
    public static final String KEY_OVERFLOWTAB = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.overflowProtection");
    public static final String KEY_LOCKDOWNTAB = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.lockdown");
    private final JButton extraTextBtn = new JButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.setAdditionalText_"));
    private final JCheckBox blockAllChkBox = new JCheckBox();
    private final JCheckBox allowInitChkBox = new JCheckBox();
    private final JCheckBox preventKillChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.preventAgentFromBeingStopped"));
    private final JCheckBox enableCertVerifyChkBox = new JCheckBox();
    private final JCheckBox rememberLocChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.rememberLastSelectedLocation"));
    private final JCheckBox enableAutoChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.enableAutolocationSwitching"));
    private final JCheckBox enableNACChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.enableNAC"));
    private final JCheckBox enforceChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.enablePopupMessageBox"));
    private final JCheckBox enableEAPChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.enableIEEE802"));
    private final JCheckBox enableTransparentChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.useAgentAs802Supplicant"));
    private final JRadioButton jRBDefaultMode = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.symantecTransparentMode"));
    private final JRadioButton jRBAuthProtocol = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.authenticationProtocol"));
    private final JCheckBox enableNPWaitTimeoutChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.enableNPWaitTimeout"));
    private final JTextField jTFNPWaitTimeout = new JTextField(new NumberPlainDocument(1L, 120L, true), "", 5);
    private final JLabel jLSeconds = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.seconds"));
    private RebootOptionsPanel mRebootOptionsPanel;
    private final DescriptionTextArea additionTxtLbl = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.specifyAdditionTextForMessageBox"));
    private final DescriptionTextArea selectedClientsTxtLabel = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.ifSelectedBlockedClientsReceiveAMessage"));
    private final JCheckBox enableAlternateEnforcerCommsChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.enableFastNetworkAuthentication"));
    private final JCheckBox enableNapChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.enableNapEnforce"));
    private final JTextField maxUploadField = new JTextField(10);
    private final JTextField securityThresholdField = new JTextField(10);
    private final JTextField securityRiskThresholdField = new JTextField(10);
    private final JTextField systemThresholdField = new JTextField(10);
    private final JTextField trafficThresholdField = new JTextField(10);
    private final JTextField packetThresholdField = new JTextField(10);
    private final JTextField processThresholdField = new JTextField(10);
    private final JTextField securityExpireField = new JTextField(10);
    private final JTextField securityRiskExpireField = new JTextField(10);
    private final JTextField systemExpireField = new JTextField(10);
    private final JTextField trafficExpireField = new JTextField(10);
    private final JTextField packetExpireField = new JTextField(10);
    private final JTextField processExpireField = new JTextField(10);
    private final JTextField securityPeriodField = new JTextField(10);
    private final JTextField securityRiskPeriodField = new JTextField(10);
    private final JTextField systemPeriodField = new JTextField(10);
    private final JTextField trafficPeriodField = new JTextField(10);
    private final JTextField packetPeriodField = new JTextField(10);
    private final JTextField processPeriodField = new JTextField(10);
    private final JTextField securityIdleField = new JTextField(10);
    private final JTextField securityRiskIdleField = new JTextField(10);
    private final JTextField systemIdleField = new JTextField(10);
    private final JTextField trafficIdleField = new JTextField(10);
    private final JTextField packetIdleField = new JTextField(10);
    private final JTextField processIdleField = new JTextField(10);
    private final JCheckBox securityUploadChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.uploadToPolicyManager"));
    private final JCheckBox securityRiskUploadChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.uploadToPolicyManager"));
    private final JCheckBox systemUploadChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.uploadToPolicyManager"));
    private final JCheckBox trafficUploadChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.uploadToPolicyManager"));
    private final JCheckBox packetUploadChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.uploadToPolicyManager"));
    private final JCheckBox processUploadChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.uploadToPolicyManager"));
    private final DescriptionTextArea blockAllLbl = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.blockAllTrafficWhileAgentIsNotRunning"));
    private final DescriptionTextArea allowInitLbl = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.allowInitialDHCPAndNetbiosTraffic"));
    private final DescriptionTextArea autoLocLbl = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.byEnablingThisFunctionAgentCanAutomaticalyDetermine"));
    private JPanel trafficLogPanel;
    private JPanel packetLogPanel;
    private JPanel behaviorLogPanel;
    private final JPanel securityPane = new JPanel(new GridBagLayout());
    private final JTabbedPane tabPane = new JTabbedPane();
    private JComponent policySettingPane;
    private JComponent rebootPane;
    private JComponent logPane;
    private AppAuthenticationPanel appPane;
    private IdsLibraryPanel idsPane;
    private CommunicationPanel comPane;
    private ExternalCommunicationPanel externalSubmissionPane;
    private LockDownPanel lockdownPane;
    private TamperProtectionPanel tamperProtectionPanel;
    private GroupPolicyObject gpObj;
    private AutoLocationObject autoObj;
    private AgentLogObject logObj;
    private AppAuthenticationObject appObj;
    private IDSObject idsObj;
    private EnforcerNotificationObject enforceObj;
    private CommunicationObject comObj;
    private ExternalCommunicationObject externalComObj;
    private ComputerLockdownProtectionObject lockdownObj;
    public RebootOptions rebootOptObject;
    private OptimizationSettings opSettingsObject;
    private boolean isReadOnly = false;
    private boolean showAppAuthentication = true;
    private boolean showIds = true;
    private boolean showLockdown = true;
    private final LicenseObject myLicenseObj = LicenseObject.getInstance();
    private JComponent mainPane = null;
    private JPanel securitySettingPane;
    private final JCheckBox enableSpiffyStartChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.enableSpiffyStart"));
    private final String mainPanelName;
    private final JCheckBox disableLaunchSmcGuiChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "PerformanceSettingDlg.disableLaunchSmcGui"));
    private PerformanceSettings performanceSettingsObj;

    public GlobalSettingDlg(String title, String aspectName) {
        super(Manager.getFrame(), title, true);
        this.mainPanelName = aspectName;
        System.out.println("GlobalSettingDlg >>> mainPanelName: " + this.mainPanelName);
        if (this.mainPanelName == null || !this.mainPanelName.equals(LOCKDOWN)) {
            this.showLockdown = false;
        }
        this.initialize(aspectName);
        if (INTRUSION_PREVENTION.equals(aspectName)) {
            UiUtilities.centerComponent((Component)this, (Container)this.getParent());
        } else {
            UiUtilities.centerComponent((Component)this);
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        if (this.mainPanelName == null) {
            JPanel panel = (JPanel)this.tabPane.getSelectedComponent();
            if (panel == this.securitySettingPane) {
                return "sesm_computersnusers_policies_general_setting_security";
            }
            if (panel == this.tamperProtectionPanel) {
                return "sesm_clients_policies_general_setting_tamper_protection";
            }
            if (panel == this.rebootPane) {
                return "sesm_computersnusers_policies_restart_settings";
            }
            return "sesm_computersnusers_policies_general_settings";
        }
        if (this.mainPanelName.trim().equals(APPLICATION_AUTHENTICATION)) {
            return "sesm_computersnusers_policies_application_authentication";
        }
        if (this.mainPanelName.trim().equals(COMMUNICATION)) {
            return "sesm_computersnusers_policies_communication";
        }
        if (this.mainPanelName.trim().equals(LOCKDOWN)) {
            return "sesm_computersnusers_policies_system_lockdown";
        }
        if (this.mainPanelName.trim().equals(LOGS)) {
            return "sesm_computersnusers_policies_logs";
        }
        if (this.mainPanelName.trim().equals(INTRUSION_PREVENTION)) {
            return "sesm_computersnusers_policies_ips_libraries";
        }
        if (this.mainPanelName.trim().equals(EXTERNAL_COMMUNICATION)) {
            return this.externalSubmissionPane.getContentSensitiveHelpToken();
        }
        return null;
    }

    @Override
    protected boolean isValidate() {
        if (!this.savePolicySetting()) {
            return false;
        }
        if (!this.saveLogPane()) {
            return false;
        }
        if (this.showAppAuthentication && !this.appPane.savePane()) {
            return false;
        }
        if (!this.saveComPane()) {
            return false;
        }
        if (!this.saveExternalComPane()) {
            return false;
        }
        if (this.showLockdown && !this.lockdownPane.savePane()) {
            return false;
        }
        if (this.tamperProtectionPanel != null) {
            if (!this.tamperProtectionPanel.isDataValid()) {
                return false;
            }
            this.tamperProtectionPanel.saveData();
        }
        this.gpObj.setCommunicationObject(this.comPane.getCommunicationObject());
        this.gpObj.setExternalCommunicationObject(this.externalSubmissionPane.getExternalCommunicationObject());
        if (this.showAppAuthentication) {
            this.gpObj.setAppAuthentication(this.appPane.getAppAuthenticationObject());
        }
        if (this.showIds) {
            this.gpObj.setIDS(this.idsPane.getIDSObject());
        }
        if (this.showLockdown) {
            this.gpObj.setComputerLockdownProtectionObject(this.lockdownPane.getLockdownObject());
        }
        return true;
    }

    private void initialize(String aspectName) {
        UIUtilities.setName(this.getOkButton(), "clientPage", UIUtilities.ComponentType.BUTTON, AUTOMATION_BUTTON_OK);
        this.mainPane = this.getMainPane(aspectName);
        this.getContentPane().add((Component)this.mainPane, "Center");
        this.getContentPane().add((Component)UIUtilities.createScrollPaneWithoutBoard(this.mainPane), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
        if (this.mainPane instanceof CommunicationPanel) {
            this.pack();
        }
    }

    private JComponent getMainPane(String aspectName) {
        this.policySettingPane = this.getPolicySettingTab();
        this.rebootPane = this.getRebootTab();
        this.securitySettingPane = this.getSecuritySettingsPanel();
        this.logPane = this.getLogTab();
        this.appPane = new AppAuthenticationPanel();
        this.idsPane = new IdsLibraryPanel();
        this.idsPane.setPreferredSize(new Dimension(500, 300));
        this.comPane = new CommunicationPanel();
        this.lockdownPane = new LockDownPanel();
        this.externalSubmissionPane = new ExternalCommunicationPanel();
        UIUtilities.setName(this.lockdownPane, "clientPage", UIUtilities.ComponentType.JPANEL, AUTOMATION_ID_SYSTEM_LOCKDOWN_PANEL);
        if (aspectName == null) {
            this.tabPane.add((Component)this.rebootPane, REBOOT_TAB);
            this.tabPane.add((Component)this.policySettingPane, OTHERTAB);
            this.tabPane.add((Component)this.securitySettingPane, SECURITY);
            if (this.myLicenseObj.isTamperProtection()) {
                this.tamperProtectionPanel = new TamperProtectionPanel();
                this.tabPane.add((Component)this.tamperProtectionPanel, TAMPER_PROTECTION);
            }
            return this.tabPane;
        }
        if (aspectName.trim().equals(LOGS)) {
            return this.logPane;
        }
        if (aspectName.trim().equals(APPLICATION_AUTHENTICATION)) {
            return this.appPane;
        }
        if (aspectName.trim().equals(INTRUSION_PREVENTION)) {
            return this.idsPane;
        }
        if (aspectName.trim().equals(COMMUNICATION)) {
            return this.comPane;
        }
        if (aspectName.trim().equals(EXTERNAL_COMMUNICATION)) {
            return this.externalSubmissionPane;
        }
        if (aspectName.trim().equals(LOCKDOWN)) {
            return this.lockdownPane;
        }
        return null;
    }

    private JPanel getRebootTab() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.mRebootOptionsPanel = new RebootOptionsPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        panel.add((Component)this.mRebootOptionsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 5, 0), 0, 0));
        return panel;
    }

    private JPanel getPolicySettingTab() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        panel.add((Component)this.getLocationPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getOptimizationPanel();
        panel.add((Component)this.getPerformancePanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(15, 0, 5, 0), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.add((Component)panel, "North");
        return wrapPanel;
    }

    private JPanel getLocationPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.advancedLocationSettings")));
        panel.add((Component)this.rememberLocChkBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        panel.add((Component)new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.ifSelectedAgentsWillStartInTheSameLocation")), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 32, 0, 10), 0, 0));
        panel.add((Component)this.enableAutoChkBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        panel.add((Component)this.autoLocLbl, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 32, 5, 0), 0, 0));
        return panel;
    }

    private JPanel getEnforcePanel() {
        this.enableNACChkBox.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                GlobalSettingDlg.this.enableNACChkBoxIsChanged();
            }
        });
        this.enforceChkBox.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                GlobalSettingDlg.this.enforceChkBoxIsChanged();
            }
        });
        this.extraTextBtn.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AdditionalTextDialog dlg = new AdditionalTextDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.setAdditionalText"), GlobalSettingDlg.this.enforceObj.getAddtionTxt(), 300);
                if (dlg.isOk()) {
                    GlobalSettingDlg.this.enforceObj.setAdditionTxt(dlg.getAdditionalText());
                }
                dlg.dispose();
            }
        });
        this.enableEAPChkBox.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalSettingDlg.this.enableEAPChkBoxIsChanged();
            }
        });
        this.enableTransparentChkBox.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalSettingDlg.this.enableTransparentChanged();
            }
        });
        this.enableNPWaitTimeoutChkBox.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalSettingDlg.this.enableNPWaitTimeoutChanged();
            }
        });
        this.enableNapChkBox.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalSettingDlg.this.enableNapChanged();
            }
        });
        this.jTFNPWaitTimeout.setHorizontalAlignment(4);
        ButtonGroup bGroup = new ButtonGroup();
        bGroup.add(this.jRBDefaultMode);
        bGroup.add(this.jRBAuthProtocol);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.enforceClient")));
        int column = 0;
        panel.add((Component)this.enableNACChkBox, new GridBagConstraints(0, column, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        panel.add((Component)this.enforceChkBox, new GridBagConstraints(0, ++column, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 10), 0, 0));
        panel.add((Component)this.selectedClientsTxtLabel, new GridBagConstraints(0, ++column, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 55, 0, 10), 0, 0));
        panel.add((Component)this.additionTxtLbl, new GridBagConstraints(0, ++column, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 55, 0, 10), 0, 0));
        panel.add((Component)this.extraTextBtn, new GridBagConstraints(1, column, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 10), 0, 0));
        panel.add((Component)this.enableEAPChkBox, new GridBagConstraints(0, ++column, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 0, 10), 0, 0));
        panel.add((Component)this.enableTransparentChkBox, new GridBagConstraints(0, ++column, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 55, 5, 10), 0, 0));
        panel.add((Component)this.jRBDefaultMode, new GridBagConstraints(0, ++column, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 80, 5, 10), 0, 0));
        panel.add((Component)this.jRBAuthProtocol, new GridBagConstraints(0, ++column, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 80, 5, 10), 0, 0));
        panel.add((Component)this.enableNPWaitTimeoutChkBox, new GridBagConstraints(0, ++column, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 55, 0, 0), 0, 0));
        panel.add((Component)this.jTFNPWaitTimeout, new GridBagConstraints(1, column, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jLSeconds, new GridBagConstraints(2, column, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.enableAlternateEnforcerCommsChkBox, new GridBagConstraints(0, ++column, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 0, 10), 0, 0));
        panel.add((Component)this.enableNapChkBox, new GridBagConstraints(0, ++column, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 0, 10), 0, 0));
        return panel;
    }

    private JPanel getSecurityPanel() {
        this.securityPane.setLayout(new GridBagLayout());
        this.securityPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.securitySettings")));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.insets.top = 5;
        constraints.insets.left = 10;
        constraints.fill = 2;
        if (!this.myLicenseObj.isSNACOnlyProduct() && AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x23")) {
            this.blockAllChkBox.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent event) {
                    GlobalSettingDlg.this.blockAllChkBox_isClicked();
                }
            });
            this.allowInitLbl.setWrapStyleWord(true);
            this.allowInitLbl.setLineWrap(true);
            this.blockAllLbl.setWrapStyleWord(true);
            this.blockAllLbl.setLineWrap(true);
            this.securityPane.add((Component)this.blockAllChkBox, constraints);
            constraints.gridx = 1;
            constraints.weightx = 1.0;
            constraints.gridwidth = 2;
            constraints.insets.left = 0;
            this.securityPane.add((Component)this.blockAllLbl, constraints);
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.weightx = 0.0;
            this.securityPane.add((Component)this.allowInitChkBox, constraints);
            constraints.gridx = 2;
            constraints.weightx = 1.0;
            this.securityPane.add((Component)this.allowInitLbl, constraints);
        }
        constraints.gridy = 2;
        constraints.gridx = 0;
        constraints.weightx = 0.0;
        constraints.insets.top = 5;
        constraints.insets.left = 10;
        constraints.anchor = 18;
        this.securityPane.add((Component)this.enableCertVerifyChkBox, constraints);
        DescriptionTextArea verificationLbl = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.enableCertVerification"));
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.gridwidth = 2;
        constraints.insets.top = 8;
        constraints.insets.left = 0;
        constraints.insets.bottom = 10;
        constraints.anchor = 17;
        this.securityPane.add((Component)verificationLbl, constraints);
        return this.securityPane;
    }

    private void enableNACChkBoxIsChanged() {
        if (!this.isReadOnly) {
            boolean isSelected = this.enableNACChkBox.isSelected();
            this.enforceChkBox.setEnabled(isSelected);
            this.enableEAPChkBox.setEnabled(isSelected);
            this.enableNapChkBox.setEnabled(isSelected);
            this.enableAlternateEnforcerCommsChkBox.setEnabled(isSelected);
            this.enforceChkBoxIsChanged();
            this.enableEAPChkBoxIsChanged();
        }
    }

    private void enforceChkBoxIsChanged() {
        if (this.isReadOnly) {
            return;
        }
        boolean isSelected = this.enforceChkBox.isSelected();
        boolean isEnabled = this.enforceChkBox.isEnabled();
        this.extraTextBtn.setEnabled(isSelected && isEnabled);
        this.additionTxtLbl.setEnabled(isSelected && isEnabled);
        this.selectedClientsTxtLabel.setEnabled(isEnabled);
    }

    private void enableEAPChkBoxIsChanged() {
        if (!this.isReadOnly) {
            boolean isSelected = this.enableEAPChkBox.isSelected();
            boolean isEnabled = this.enableEAPChkBox.isEnabled();
            this.enableTransparentChkBox.setEnabled(isSelected && isEnabled);
            this.enableNPWaitTimeoutChkBox.setEnabled(isSelected && isEnabled);
            this.enableTransparentChanged();
            this.enableNPWaitTimeoutChanged();
            if (isSelected && this.enableNapChkBox.isSelected()) {
                this.enableNapChkBox.doClick();
            }
        }
    }

    private void enableTransparentChanged() {
        if (!this.isReadOnly) {
            boolean isChkBoxSelectedAndEnabled = this.enableTransparentChkBox.isSelected() && this.enableTransparentChkBox.isEnabled();
            this.jRBDefaultMode.setEnabled(isChkBoxSelectedAndEnabled);
            this.jRBAuthProtocol.setEnabled(isChkBoxSelectedAndEnabled);
        }
    }

    private void enableNPWaitTimeoutChanged() {
        if (!this.isReadOnly) {
            boolean isChkBoxSelectedAndEnabled = this.enableNPWaitTimeoutChkBox.isEnabled() && this.enableNPWaitTimeoutChkBox.isSelected();
            this.jTFNPWaitTimeout.setEnabled(isChkBoxSelectedAndEnabled);
            this.jLSeconds.setEnabled(isChkBoxSelectedAndEnabled);
        }
    }

    private void enableNapChanged() {
        boolean isSelected;
        if (!this.isReadOnly && (isSelected = this.enableNapChkBox.isSelected()) && this.enableEAPChkBox.isSelected()) {
            this.enableEAPChkBox.doClick();
        }
    }

    private JPanel getLogTab() {
        int MAX_VALUE = 0xF00000;
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.setLayout(new BoxLayout(panel, 1));
        NumberPlainDocument numDoc = new NumberPlainDocument(15360L);
        JTextArea descLbl = new JTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.logsTrackAgentActivity"));
        descLbl.setEditable(false);
        descLbl.setOpaque(false);
        descLbl.setLineWrap(true);
        descLbl.setWrapStyleWord(true);
        descLbl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add(descLbl);
        this.maxUploadField.setHorizontalAlignment(4);
        this.securityThresholdField.setHorizontalAlignment(4);
        this.securityExpireField.setHorizontalAlignment(4);
        this.securityPeriodField.setHorizontalAlignment(4);
        this.securityIdleField.setHorizontalAlignment(4);
        this.securityRiskThresholdField.setHorizontalAlignment(4);
        this.securityRiskExpireField.setHorizontalAlignment(4);
        this.securityRiskPeriodField.setHorizontalAlignment(4);
        this.securityRiskIdleField.setHorizontalAlignment(4);
        this.systemThresholdField.setHorizontalAlignment(4);
        this.systemExpireField.setHorizontalAlignment(4);
        this.systemPeriodField.setHorizontalAlignment(4);
        this.systemIdleField.setHorizontalAlignment(4);
        this.trafficThresholdField.setHorizontalAlignment(4);
        this.trafficExpireField.setHorizontalAlignment(4);
        this.trafficPeriodField.setHorizontalAlignment(4);
        this.trafficIdleField.setHorizontalAlignment(4);
        this.packetThresholdField.setHorizontalAlignment(4);
        this.packetExpireField.setHorizontalAlignment(4);
        this.packetPeriodField.setHorizontalAlignment(4);
        this.packetIdleField.setHorizontalAlignment(4);
        this.processThresholdField.setHorizontalAlignment(4);
        this.processExpireField.setHorizontalAlignment(4);
        this.processPeriodField.setHorizontalAlignment(4);
        this.processIdleField.setHorizontalAlignment(4);
        numDoc = new NumberPlainDocument(15360L);
        this.systemThresholdField.setDocument(numDoc);
        numDoc = new NumberPlainDocument(1L, 65536L, false);
        this.systemExpireField.setDocument(numDoc);
        numDoc = new NumberPlainDocument();
        this.systemPeriodField.setDocument(numDoc);
        numDoc = new NumberPlainDocument();
        this.systemIdleField.setDocument(numDoc);
        JComponent[] objList = new JComponent[]{this.systemThresholdField, this.systemExpireField, this.systemPeriodField, this.systemIdleField, this.systemUploadChkBox};
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        panel.add(this.getLogPane(objList, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.systemLog"), true, false, true, false, false));
        numDoc = new NumberPlainDocument(15360L);
        this.securityRiskThresholdField.setDocument(numDoc);
        numDoc = new NumberPlainDocument(1L, 65536L, false);
        this.securityRiskExpireField.setDocument(numDoc);
        numDoc = new NumberPlainDocument();
        this.securityRiskPeriodField.setDocument(numDoc);
        numDoc = new NumberPlainDocument();
        this.securityRiskIdleField.setDocument(numDoc);
        objList = new JComponent[]{this.securityRiskThresholdField, this.securityRiskExpireField, this.securityRiskPeriodField, this.securityRiskIdleField, this.securityRiskUploadChkBox};
        if (!this.myLicenseObj.isSNACOnlyProduct()) {
            JPanel pnl = this.getLogPane(objList, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.securityRiskLog"), true, false, false, false, false);
            if (AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x22")) {
                panel.add(Box.createRigidArea(new Dimension(0, 5)));
                panel.add(pnl);
            }
        }
        numDoc = new NumberPlainDocument(15360L);
        this.securityThresholdField.setDocument(numDoc);
        numDoc = new NumberPlainDocument(1L, 65536L, false);
        this.securityExpireField.setDocument(numDoc);
        numDoc = new NumberPlainDocument(99999L, true);
        this.securityPeriodField.setDocument(numDoc);
        numDoc = new NumberPlainDocument();
        this.securityIdleField.setDocument(numDoc);
        objList = new JComponent[]{this.securityThresholdField, this.securityExpireField, this.securityPeriodField, this.securityIdleField, this.securityUploadChkBox};
        if (this.myLicenseObj.isSNACOnlyProduct()) {
            objList[0] = this.securityRiskThresholdField;
            objList[1] = this.securityRiskExpireField;
        }
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        panel.add(this.getLogPane(objList, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.securityLog"), this.myLicenseObj.isSNACOnlyProduct(), true, true, true, true));
        numDoc = new NumberPlainDocument(15360L);
        this.trafficThresholdField.setDocument(numDoc);
        numDoc = new NumberPlainDocument(1L, 65536L, false);
        this.trafficExpireField.setDocument(numDoc);
        numDoc = new NumberPlainDocument(99999L, true);
        this.trafficPeriodField.setDocument(numDoc);
        numDoc = new NumberPlainDocument();
        this.trafficIdleField.setDocument(numDoc);
        objList = new JComponent[]{this.trafficThresholdField, this.trafficExpireField, this.trafficPeriodField, this.trafficIdleField, this.trafficUploadChkBox};
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.trafficLogPanel = this.getLogPane(objList, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.trafficLog"), true, true, true, true, false);
        if (this.myLicenseObj.isFirewallPolicy() && AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x23")) {
            panel.add(this.trafficLogPanel);
        }
        numDoc = new NumberPlainDocument(15360L);
        this.packetThresholdField.setDocument(numDoc);
        numDoc = new NumberPlainDocument(1L, 65536L, false);
        this.packetExpireField.setDocument(numDoc);
        numDoc = new NumberPlainDocument();
        this.packetPeriodField.setDocument(numDoc);
        numDoc = new NumberPlainDocument();
        this.packetIdleField.setDocument(numDoc);
        objList = new JComponent[]{this.packetThresholdField, this.packetExpireField, this.packetPeriodField, this.packetIdleField, this.packetUploadChkBox};
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.packetLogPanel = this.getLogPane(objList, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.packetLog"), true, false, true, true, false);
        if (this.myLicenseObj.isFirewallPolicy() && AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x23")) {
            panel.add(this.packetLogPanel);
        }
        numDoc = new NumberPlainDocument(15360L);
        this.processThresholdField.setDocument(numDoc);
        numDoc = new NumberPlainDocument(1L, 65536L, false);
        this.processExpireField.setDocument(numDoc);
        numDoc = new NumberPlainDocument();
        this.processPeriodField.setDocument(numDoc);
        numDoc = new NumberPlainDocument();
        this.processIdleField.setDocument(numDoc);
        objList = new JComponent[]{this.processThresholdField, this.processExpireField, this.processPeriodField, this.processIdleField, this.processUploadChkBox};
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.behaviorLogPanel = this.getLogPane(objList, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.behaviorLog"), true, false, true, true, false);
        if (this.myLicenseObj.isOSPretectionPolicy() && AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x25")) {
            panel.add(this.behaviorLogPanel);
        }
        numDoc = new NumberPlainDocument(500L, true);
        this.maxUploadField.setDocument(numDoc);
        JPanel firstLine = new JPanel(new FlowLayout(0));
        firstLine.add(new JLabel("  " + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.uploadMaximumSize")));
        firstLine.add(this.maxUploadField);
        firstLine.add(new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.record")));
        panel.add(firstLine);
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    private JPanel getLogPane(JComponent[] objList, String title, boolean showLimit, boolean showDampener, boolean showUpload, boolean isShowWinIcon, boolean isShowMacIcon) {
        int i;
        ArrayList<JLabel> iconLabelList = new ArrayList<JLabel>();
        if (isShowWinIcon) {
            iconLabelList.add(CreateOSLabelUtil.createWinLabel());
        }
        if (isShowMacIcon) {
            iconLabelList.add(CreateOSLabelUtil.createMacLabel());
        }
        JPanelWithIconBorder panel = new JPanelWithIconBorder(title, iconLabelList);
        panel.setLayout(new GridBagLayout());
        JComponent[][] comp = new JComponent[2][6];
        comp[0][0] = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.maximumSize"), 4);
        comp[0][1] = objList[0];
        comp[0][2] = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.kbytes"));
        comp[0][3] = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.retainFor"), 4);
        comp[0][4] = objList[1];
        comp[0][5] = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.days"));
        comp[1][0] = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.damperPeriod"), 4);
        comp[1][1] = objList[2];
        comp[1][2] = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.seconds"));
        comp[1][3] = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.damperIdle"), 4);
        comp[1][4] = objList[3];
        comp[1][5] = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.seconds"));
        int allLine = 2;
        for (int row = 0; row < allLine; ++row) {
            for (int col = 0; col < 6; ++col) {
                GridBagConstraints cons = new GridBagConstraints();
                cons.gridx = col;
                cons.gridy = row;
                if (col == 3) {
                    cons.anchor = 13;
                } else if (col == 0 || col == 2 || col == 5) {
                    cons.anchor = 17;
                }
                cons.weightx = 0.5;
                cons.insets = !showDampener ? new Insets(0, 0, 0, 0) : (col == 1 ? new Insets(5, 20, 5, 5) : new Insets(5, 5, 5, 5));
                if (col == 3) {
                    cons.ipadx = 10;
                }
                panel.add((Component)comp[row][col], cons);
            }
        }
        if (!showLimit) {
            for (i = 0; i < 6; ++i) {
                comp[0][i].setVisible(false);
            }
        }
        if (!showDampener) {
            for (i = 0; i < 6; ++i) {
                comp[1][i].setVisible(false);
            }
        }
        if (showUpload) {
            GridBagConstraints cons = new GridBagConstraints();
            cons.gridx = 0;
            cons.gridy = allLine;
            cons.gridwidth = 6;
            cons.insets = new Insets(2, 2, 2, 2);
            cons.anchor = 17;
            cons.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)objList[4], cons);
        }
        return panel;
    }

    public boolean savePolicySetting() {
        this.autoObj.setRememberLastLocation(this.rememberLocChkBox.isSelected());
        this.autoObj.setEnableAutoLocationSwitch(this.enableAutoChkBox.isSelected());
        this.rebootOptObject = this.mRebootOptionsPanel.saveSettings(this.rebootOptObject);
        this.opSettingsObject.getSpiffyStart().setOptEnabled(Boolean.valueOf(this.enableSpiffyStartChkBox.isSelected()));
        this.performanceSettingsObj.setOptDisableLaunchSmcGui(Boolean.valueOf(this.disableLaunchSmcGuiChkBox.isSelected()));
        return this.validSecuritySetting();
    }

    private boolean saveLogPane() {
        String strNumber = this.maxUploadField.getText();
        int number = -1;
        try {
            if (strNumber.trim().length() > 0) {
                number = Integer.parseInt(strNumber);
                if (number < 0) {
                    throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.maximumUploadSizeCannotBeNegative"), this.maxUploadField);
                }
                if (number == 0 && LOGS.equals(this.mainPanelName)) {
                    JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.maximumUploadSizeZeroWaring"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.waring"), 2);
                    this.maxUploadField.requestFocus();
                }
            }
            this.logObj.setMaxUploadSize(number);
            strNumber = this.securityRiskThresholdField.getText().trim();
            if (strNumber.length() == 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.thresholdFieldCannotBeBlank"), this.securityRiskThresholdField);
            }
            number = Integer.parseInt(strNumber);
            if (number < 64) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theMinimumNumberForThreshold"), this.securityRiskThresholdField);
            }
            this.logObj.setSecurityLogMaxSize(number);
            strNumber = this.securityRiskExpireField.getText().trim();
            if (strNumber.length() == 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.expiringDayFieldCannotBeBlank"), this.securityRiskExpireField);
            }
            number = Integer.parseInt(strNumber);
            if (number <= 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theExpiringDayCannotBeNegative"), this.securityRiskExpireField);
            }
            this.logObj.setSecurityLogMaxDays(number);
            strNumber = this.securityPeriodField.getText().trim();
            if (strNumber.length() == 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.damperPeriodFieldCannotBeBlank"), this.securityPeriodField);
            }
            number = Integer.parseInt(strNumber);
            if (number < 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theDamperPeriodCannotBeNegative"), this.securityPeriodField);
            }
            this.logObj.setSecurityLogDamperPeriod(number);
            strNumber = this.securityIdleField.getText().trim();
            if (strNumber.length() == 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.damperIdleTimeFieldCannotBeBlank"), this.securityIdleField);
            }
            number = Integer.parseInt(strNumber);
            if (number < 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theDamperIdleTimeCannotBeNegative"), this.securityIdleField);
            }
            this.logObj.setSecurityLogDamperIdle(number);
            this.logObj.setSecurityLogUpload(this.securityUploadChkBox.isSelected());
            strNumber = this.systemThresholdField.getText().trim();
            if (strNumber.length() == 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.thresholdFieldCannotBeBlank"), this.systemThresholdField);
            }
            number = Integer.parseInt(strNumber);
            if (number < 64) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theMinimumNumberForThresholdIs64"), this.systemThresholdField);
            }
            this.logObj.setSystemLogMaxSize(number);
            strNumber = this.systemExpireField.getText().trim();
            if (strNumber.length() == 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.expiringDayFieldCannotBeBlank"), this.systemExpireField);
            }
            number = Integer.parseInt(strNumber);
            if (number <= 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theExpiringDayCannotBeNegative"), this.systemExpireField);
            }
            this.logObj.setSystemLogMaxDays(number);
            strNumber = this.systemPeriodField.getText().trim();
            if (strNumber.length() == 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.damperPeriodFieldCannotBeBlank"), this.systemPeriodField);
            }
            number = Integer.parseInt(strNumber);
            if (number < 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theDamperPeriodCannotBeNegative"), this.systemPeriodField);
            }
            this.logObj.setSystemLogDamperPeriod(number);
            strNumber = this.systemIdleField.getText().trim();
            if (strNumber.length() == 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.damperIdleTimeCannotBeNegative"), this.systemIdleField);
            }
            number = Integer.parseInt(strNumber);
            if (number < 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theDamperIdleTimeCannotBeNegative"), this.systemIdleField);
            }
            this.logObj.setSystemLogDamperIdle(number);
            this.logObj.setSystemLogUpload(this.systemUploadChkBox.isSelected());
            strNumber = this.trafficThresholdField.getText().trim();
            if (strNumber.length() == 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.thresholdFieldCannotBeBlank"), this.trafficThresholdField);
            }
            number = Integer.parseInt(strNumber);
            if (number < 64) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theMinimunNumberForThresholdIs64"), this.trafficThresholdField);
            }
            this.logObj.setTrafficLogMaxSize(number);
            strNumber = this.trafficExpireField.getText().trim();
            if (strNumber.length() == 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.expiringDayFieldCannotBeBlank"), this.trafficExpireField);
            }
            number = Integer.parseInt(strNumber);
            if (number <= 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theExpiringDayCannotBeNegative"), this.trafficExpireField);
            }
            this.logObj.setTrafficLogMaxDays(number);
            strNumber = this.trafficPeriodField.getText().trim();
            if (strNumber.length() == 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.DamperPeriodFieldCannotBeBlank"), this.trafficPeriodField);
            }
            number = Integer.parseInt(strNumber);
            if (number < 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theDamperPeriodCannotBeNegative"), this.trafficPeriodField);
            }
            this.logObj.setTrafficLogDamperPeriod(number);
            strNumber = this.trafficIdleField.getText().trim();
            if (strNumber.length() == 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.damperIdleTimeFieldCannotBeBlank"), this.trafficIdleField);
            }
            number = Integer.parseInt(strNumber);
            if (number < 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theDamperIdleTimeCannotBeNegative"), this.trafficIdleField);
            }
            this.logObj.setTrafficLogDamperIdle(number);
            this.logObj.setTrafficLogUpload(this.trafficUploadChkBox.isSelected());
            strNumber = this.packetThresholdField.getText().trim();
            if (strNumber.length() == 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.thresholdFieldCannotBeBlank"), this.packetThresholdField);
            }
            number = Integer.parseInt(strNumber);
            if (number < 128) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theMinimunNumberForThresholdIs128"), this.packetThresholdField);
            }
            this.logObj.setPacketLogMaxSize(number);
            strNumber = this.packetExpireField.getText().trim();
            if (strNumber.length() == 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.expiringDayFieldCannotBeBlank"), this.packetExpireField);
            }
            number = Integer.parseInt(strNumber);
            if (number <= 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theExpiringDayCannotBeNegative"), this.packetExpireField);
            }
            this.logObj.setPacketLogMaxDays(number);
            strNumber = this.packetPeriodField.getText().trim();
            if (strNumber.length() == 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.damperPeriodFieldCannotBeBlank"), this.packetPeriodField);
            }
            number = Integer.parseInt(strNumber);
            if (number < 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theDamperPeriodCannotBeNegative"), this.packetPeriodField);
            }
            this.logObj.setPacketLogDamperPeriod(number);
            strNumber = this.packetIdleField.getText().trim();
            if (strNumber.length() == 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.DamperIdleTimeFieldCannotBeBlank"), this.packetIdleField);
            }
            number = Integer.parseInt(strNumber);
            if (number < 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theDamperIdleTimeCannotBeNegative"), this.packetIdleField);
            }
            this.logObj.setPacketLogDamperIdle(number);
            this.logObj.setPacketLogUpload(this.packetUploadChkBox.isSelected());
            strNumber = this.processThresholdField.getText().trim();
            if (strNumber.length() == 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.thresholdFieldCannotBeBlank"), this.processThresholdField);
            }
            number = Integer.parseInt(strNumber);
            if (number < 64) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theMinimunNumberForThresholdIs64"), this.processThresholdField);
            }
            this.logObj.setBehaviorLogMaxSize(number);
            strNumber = this.processExpireField.getText().trim();
            if (strNumber.length() == 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.expiringDayFieldCannotBeBlank"), this.processExpireField);
            }
            number = Integer.parseInt(strNumber);
            if (number <= 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theExpiringDayCAnnotBeNegative"), this.processExpireField);
            }
            this.logObj.setBehaviorLogMaxDays(number);
            strNumber = this.processPeriodField.getText().trim();
            if (strNumber.length() == 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.damperPeriodFieldCannotBeBlank"), this.processPeriodField);
            }
            number = Integer.parseInt(strNumber);
            if (number < 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theDamperPeriodCannotBeNegative"), this.processPeriodField);
            }
            this.logObj.setBehaviorLogDamperPeriod(number);
            strNumber = this.processIdleField.getText().trim();
            if (strNumber.length() == 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.damperIdleTimeFieldCannotBeBlank"), this.processIdleField);
            }
            number = Integer.parseInt(strNumber);
            if (number < 0) {
                throw new MyException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theDamperIdleTimeCannotBeNegative"), this.processIdleField);
            }
            this.logObj.setBehaviorLogDamperIdle(number);
            this.logObj.setBehaviorLogUpload(this.processUploadChkBox.isSelected());
            return true;
        }
        catch (MyException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.error"), 0);
            ex.errorCom.requestFocus();
            return false;
        }
    }

    private boolean saveComPane() {
        Boolean saveComPane = this.comPane.saveChanges();
        if (!saveComPane.booleanValue()) {
            return false;
        }
        return !this.isShortHeartBeat();
    }

    private boolean isShortHeartBeat() {
        boolean isShort = false;
        Object[] choice = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.HeartBeatOK"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.HeartBeatCancel")};
        int clientNum = 0;
        try {
            clientNum = SemClientHandler.getCountByGroupId(this.gpObj.getGroupObject().getId(), -1);
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.consoleError"), 0);
        }
        long heartBeat = this.comPane.getCommunicationObject().getHeartbeat();
        if (heartBeat < 60L || heartBeat % 60L != 0L) {
            return true;
        }
        int standardHB = 60;
        int standardClientNum = 1000;
        if ((long)(clientNum * standardHB) > (long)standardClientNum * heartBeat) {
            int recommendedHB_minutes = clientNum / standardClientNum;
            if (clientNum % standardClientNum > 0) {
                ++recommendedHB_minutes;
            }
            Object[] obj = new Object[]{clientNum, recommendedHB_minutes};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.HeartBeatWarning");
            String fm = MessageFormat.format(str, obj);
            int result = JOptionPane.showOptionDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.HeartBeatWarningTitle"), 0, 3, null, choice, choice[1]);
            if (result == 1) {
                isShort = true;
            }
        }
        return isShort;
    }

    private boolean saveExternalComPane() {
        return this.externalSubmissionPane.saveChanges();
    }

    private JPanel getReadOnlyTitlePane(boolean isInherit) {
        String desc = (isInherit ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theGlobalSettingsAreInherited") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theGroupIsReadOnly")) + " " + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.noModificationIsAllowed");
        DescriptionTextArea descArea = new DescriptionTextArea(true);
        descArea.setText(desc);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(UIColorUtilities.WARNING_BACKGROUND);
        panel.add(descArea);
        descArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return panel;
    }

    private void updatePanel() {
        boolean rememberLoc = this.autoObj.isRememberLastLocation();
        this.rememberLocChkBox.setSelected(rememberLoc);
        boolean enableAutoLoc = this.autoObj.isEnableAutoLocationSwitch();
        if (!this.myLicenseObj.isAdaptiveLocation() && !enableAutoLoc) {
            this.enableAutoChkBox.setVisible(false);
            this.autoLocLbl.setVisible(false);
        } else {
            this.enableAutoChkBox.setVisible(true);
            this.autoLocLbl.setVisible(true);
            this.enableAutoChkBox.setSelected(enableAutoLoc);
        }
        this.mRebootOptionsPanel.updateSettings(this.rebootOptObject);
        this.updateOptimizationPanel();
        this.updatePerformancePanel();
        this.updateSecuritySettings();
    }

    private void blockAllChkBox_isClicked() {
        if (this.isReadOnly) {
            return;
        }
        this.allowInitChkBox.setEnabled(this.blockAllChkBox.isSelected());
    }

    private JPanel getSecuritySettingsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        if (!this.myLicenseObj.isSAVOnlyProduct()) {
            panel.add((Component)this.getEnforcePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        }
        JPanel securityPanel = this.getSecurityPanel();
        panel.add((Component)securityPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.add((Component)panel, "North");
        return wrapPanel;
    }

    private void updateSecuritySettings() {
        NumberPlainDocument numDoc;
        int maxUpload;
        boolean showBlock = true;
        boolean enableBlockTraffic = this.gpObj.getBlockTrafficBeforeStart();
        if (!this.myLicenseObj.isFirewallPolicy() && !enableBlockTraffic) {
            this.blockAllChkBox.setVisible(false);
            this.allowInitChkBox.setVisible(false);
            this.blockAllLbl.setVisible(false);
            this.allowInitLbl.setVisible(false);
            showBlock = false;
        } else {
            this.blockAllChkBox.setVisible(true);
            this.allowInitChkBox.setVisible(true);
            this.blockAllLbl.setVisible(true);
            this.allowInitLbl.setVisible(true);
            this.blockAllChkBox.setSelected(enableBlockTraffic);
            this.allowInitChkBox.setSelected(this.gpObj.getAllowInitTraffic());
        }
        boolean preventKill = this.gpObj.getPreventFromKill();
        if (this.myLicenseObj.isSNACOnlyProduct() && !preventKill) {
            if (showBlock) {
                this.preventKillChkBox.setVisible(false);
            } else {
                this.securityPane.setVisible(false);
            }
        } else {
            this.securityPane.setVisible(true);
            this.preventKillChkBox.setVisible(true);
            this.preventKillChkBox.setSelected(preventKill);
        }
        if (this.enforceObj != null) {
            boolean enforce = this.enforceObj.isEnabled();
            this.enforceChkBox.setSelected(enforce);
        } else {
            this.enforceChkBox.setSelected(true);
        }
        this.enableCertVerifyChkBox.setSelected(this.gpObj.getValidateServerCertificate());
        if (this.enforceObj != null) {
            this.enableEAPChkBox.setSelected(this.enforceObj.getEnableEapAuthentication());
            this.enableTransparentChkBox.setSelected(this.enforceObj.getEnableSupplicantMode());
            this.enableNPWaitTimeoutChkBox.setSelected(this.enforceObj.getEnableNPWaitTimeoutMode());
            this.jTFNPWaitTimeout.setText(String.valueOf(this.enforceObj.getNPWaitTimeout()));
            this.enableNACChkBox.setSelected(this.enforceObj.getEnableNetworkAccessControl());
            this.enableAlternateEnforcerCommsChkBox.setSelected(this.enforceObj.getEnableAlternateEnforcerCommunication());
            this.enableNapChkBox.setSelected(this.enforceObj.getEnableNapEnforcer());
            boolean isDefaultMode = !this.enforceObj.getEnableSupplicant();
            this.jRBDefaultMode.setSelected(isDefaultMode);
            this.jRBAuthProtocol.setSelected(!isDefaultMode);
        }
        if ((maxUpload = this.logObj.getMaxUploadSize()) != -1) {
            this.maxUploadField.setText("" + maxUpload);
        }
        this.securityRiskThresholdField.setText("" + this.logObj.getSecurityLogMaxSize());
        if (this.logObj.getSecurityLogMaxDays() == 0) {
            numDoc = new NumberPlainDocument(65536L, false);
            this.securityRiskExpireField.setDocument(numDoc);
        }
        this.securityRiskExpireField.setText("" + this.logObj.getSecurityLogMaxDays());
        this.securityPeriodField.setText("" + this.logObj.getSecurityLogDamperPeriod());
        this.securityIdleField.setText("" + this.logObj.getSecurityLogDamperIdle());
        this.securityUploadChkBox.setSelected(this.logObj.isSecurityLogUpload());
        if (this.logObj.getSystemLogMaxDays() == 0) {
            numDoc = new NumberPlainDocument(65536L, false);
            this.systemExpireField.setDocument(numDoc);
        }
        this.systemThresholdField.setText("" + this.logObj.getSystemLogMaxSize());
        this.systemExpireField.setText("" + this.logObj.getSystemLogMaxDays());
        this.systemPeriodField.setText("" + this.logObj.getSystemLogDamperPeriod());
        this.systemIdleField.setText("" + this.logObj.getSystemLogDamperIdle());
        this.systemUploadChkBox.setSelected(this.logObj.isSystemLogUpload());
        if (!this.myLicenseObj.isFirewallPolicy() && !this.logObj.isTrafficLogUpload()) {
            this.trafficLogPanel.setVisible(false);
        } else {
            this.trafficLogPanel.setVisible(true);
        }
        if (this.logObj.getTrafficLogMaxDays() == 0) {
            numDoc = new NumberPlainDocument(65536L, false);
            this.trafficExpireField.setDocument(numDoc);
        }
        this.trafficThresholdField.setText("" + this.logObj.getTrafficLogMaxSize());
        this.trafficExpireField.setText("" + this.logObj.getTrafficLogMaxDays());
        this.trafficPeriodField.setText("" + this.logObj.getTrafficLogDamperPeriod());
        this.trafficIdleField.setText("" + this.logObj.getTrafficLogDamperIdle());
        this.trafficUploadChkBox.setSelected(this.logObj.isTrafficLogUpload());
        if (!this.myLicenseObj.isFirewallPolicy() && !this.logObj.isPacketLogUpload()) {
            this.packetLogPanel.setVisible(false);
        } else {
            this.packetLogPanel.setVisible(true);
        }
        if (this.logObj.getPacketLogMaxDays() == 0) {
            numDoc = new NumberPlainDocument(65536L, false);
            this.packetExpireField.setDocument(numDoc);
        }
        this.packetThresholdField.setText("" + this.logObj.getPacketLogMaxSize());
        this.packetExpireField.setText("" + this.logObj.getPacketLogMaxDays());
        this.packetPeriodField.setText("" + this.logObj.getPacketLogDamperPeriod());
        this.packetIdleField.setText("" + this.logObj.getPacketLogDamperIdle());
        this.packetUploadChkBox.setSelected(this.logObj.isPacketLogUpload());
        if (!this.myLicenseObj.isOSPretectionPolicy() && !this.logObj.isBehaviorLogUpload()) {
            this.behaviorLogPanel.setVisible(false);
        } else {
            this.behaviorLogPanel.setVisible(true);
        }
        if (this.logObj.getBehaviorLogMaxDays() == 0) {
            numDoc = new NumberPlainDocument(65536L, false);
            this.processExpireField.setDocument(numDoc);
        }
        this.processThresholdField.setText("" + this.logObj.getBehaviorLogMaxSize());
        this.processExpireField.setText("" + this.logObj.getBehaviorLogMaxDays());
        this.processPeriodField.setText("" + this.logObj.getBehaviorLogDamperPeriod());
        this.processIdleField.setText("" + this.logObj.getBehaviorLogDamperIdle());
        this.processUploadChkBox.setSelected(this.logObj.isBehaviorLogUpload());
        this.blockAllChkBox_isClicked();
        this.enableNACChkBoxIsChanged();
    }

    private boolean validSecuritySetting() {
        this.gpObj.setBlockTrafficBeforeStart(this.blockAllChkBox.isSelected());
        this.gpObj.setAllowInitTraffic(this.allowInitChkBox.isSelected());
        if (this.tamperProtectionPanel != null) {
            this.gpObj.setPreventFromKill(this.tamperProtectionPanel.isTamperProtectionEnabled());
        }
        this.gpObj.setValidateServerCertificate(this.enableCertVerifyChkBox.isSelected());
        if (this.enforceObj == null) {
            this.enforceObj = new EnforcerNotificationObject();
        }
        this.enforceObj.setEnabled(this.enforceChkBox.isSelected());
        this.enforceObj.setEnableEapAuthentication(this.enableEAPChkBox.isSelected());
        this.enforceObj.setEnableSupplicantMode(this.enableTransparentChkBox.isSelected());
        this.enforceObj.setEnableSupplicant(!this.jRBDefaultMode.isSelected());
        this.enforceObj.setEnableNPWaitTimeoutMode(this.enableNPWaitTimeoutChkBox.isSelected());
        this.enforceObj.setEnableNetworkAccessControl(this.enableNACChkBox.isSelected());
        this.enforceObj.setEnableAlternateEnforcerCommunication(this.enableAlternateEnforcerCommsChkBox.isSelected());
        this.enforceObj.setEnableNapEnforcer(this.enableNapChkBox.isSelected());
        try {
            if (this.enableNPWaitTimeoutChkBox.isEnabled() && this.enableNPWaitTimeoutChkBox.isSelected()) {
                String timeToHoldWindowsLogonValue = this.jTFNPWaitTimeout.getText();
                if (timeToHoldWindowsLogonValue == null || timeToHoldWindowsLogonValue.trim().length() == 0) {
                    throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.maxTimeToHoldWindowsLogonCannotBeBlank"), this.jTFNPWaitTimeout);
                }
                this.enforceObj.setNPWaitTimeout(Integer.parseInt(timeToHoldWindowsLogonValue.trim()));
            } else {
                this.enforceObj.setNPWaitTimeout(this.enforceObj.getNPWaitTimeout());
            }
            this.gpObj.setEnforcerNotificationObject(this.enforceObj);
        }
        catch (GUICheckException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.error"), 0);
            JComponent com = e.getErrorComponent();
            if (com != null) {
                com.requestFocusInWindow();
            }
            return false;
        }
        return true;
    }

    private JPanel getOptimizationPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.OptimizationOptions")));
        panel.add((Component)this.enableSpiffyStartChkBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        panel.add((Component)new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.describeEnableSpiffyStart")), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 32, 5, 10), 0, 0));
        return panel;
    }

    private void updateOptimizationPanel() {
        boolean enableSpiffyStart = this.opSettingsObject.getSpiffyStart().getOptEnabled() == null ? this.opSettingsObject.getSpiffyStart().getDefEnabled().booleanValue() : this.opSettingsObject.getSpiffyStart().getOptEnabled().booleanValue();
        this.enableSpiffyStartChkBox.setSelected(enableSpiffyStart);
    }

    private void updatePerformancePanel() {
        boolean disableLaunchSmcGui = this.performanceSettingsObj.getOptDisableLaunchSmcGui() != null ? this.performanceSettingsObj.getOptDisableLaunchSmcGui() : this.performanceSettingsObj.getDefDisableLaunchSmcGui();
        this.disableLaunchSmcGuiChkBox.setSelected(disableLaunchSmcGui);
    }

    private JPanel getPerformancePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "PerformanceSettingDlg.performanceSettings")));
        panel.add((Component)this.disableLaunchSmcGuiChkBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        panel.add((Component)new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "PerformanceSettingDlg.disableLaunchSmcGuiDesc")), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 32, 5, 10), 0, 0));
        return panel;
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public void setVisible(boolean visible) {
        this.setSize(this.getPreferredSize());
        super.setVisible(visible);
    }

    @Override
    public void setReadOnly(boolean isInherit) {
        if (!this.isReadOnly) {
            this.getContentPane().add((Component)this.getReadOnlyTitlePane(isInherit), "North");
            this.isReadOnly = true;
            UIUtilities.setContainerStatus(this.rebootPane, false);
            UIUtilities.setContainerStatus(this.policySettingPane, false);
            UIUtilities.setContainerStatus(this.securitySettingPane, false);
            if (this.tamperProtectionPanel != null) {
                UIUtilities.setContainerStatus(this.tamperProtectionPanel, false);
            }
            UIUtilities.setContainerStatus(this.logPane, false);
            UIUtilities.setContainerStatus(this.appPane, false);
            UIUtilities.setContainerStatus(this.idsPane, false);
            this.appPane.setReadOnly();
            this.comPane.setReadOnly();
            this.idsPane.setReadOnly();
            this.externalSubmissionPane.setReadOnly();
            this.lockdownPane.setReadOnly();
            this.jBOk.setEnabled(false);
            this.jBOk.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theGroupSettingsAreInheritedYouCannotChange"));
            this.invalidate();
            this.pack();
        }
    }

    public void setObject(GroupPolicyObject gpObj) {
        try {
            this.gpObj = gpObj;
            this.enforceObj = gpObj.getEnforcerNotificationObj();
            this.autoObj = gpObj.getAutoLocation();
            this.logObj = gpObj.getAgentLogObject();
            this.appObj = gpObj.getAppAuthenticationObject();
            this.showAppAuthentication = this.appObj.isShowAppAuthentication();
            this.rebootOptObject = gpObj.getRebootOptions();
            this.mRebootOptionsPanel.updateSettings(this.rebootOptObject);
            if (this.showAppAuthentication) {
                this.appPane.setObject(this.appObj);
            }
            this.idsObj = gpObj.getIDSObject();
            this.showIds = this.idsObj.isShowIds();
            if (this.showIds) {
                this.idsPane.setObject(this.idsObj);
            }
            this.comObj = gpObj.getCommunicationObject();
            this.comPane.setObject(this.comObj, gpObj.getTamperProtectionPolicy());
            this.externalComObj = gpObj.getExternalCommunicationObject();
            String groupId = gpObj.getGroupObject() != null ? gpObj.getGroupObject().getId() : null;
            SemClientGroup clientGrp = gpObj.getClientGroup() != null ? gpObj.getClientGroup() : null;
            this.externalSubmissionPane.setObject(this.externalComObj, gpObj.getTamperProtectionPolicy(), null, clientGrp, false);
            this.lockdownObj = gpObj.getComputerLockdownProtectionObject();
            this.showLockdown = this.lockdownObj.isShowLockdown();
            if (this.mainPanelName == null || !this.mainPanelName.equals(LOCKDOWN)) {
                System.out.println("GlobalSettingDlg >>> Skip loading LockDownPanel.");
                this.showLockdown = false;
            }
            if (this.showLockdown) {
                this.lockdownPane.setObject(this.lockdownObj, PolicyHandler.getAllInheritedGroupId(gpObj.getGroupObject()));
            }
            this.opSettingsObject = gpObj.getOptimizationSettings();
            this.performanceSettingsObj = gpObj.getPerformanceSettings();
            this.updatePanel();
            if (this.tamperProtectionPanel != null) {
                this.tamperProtectionPanel.setData(gpObj.getTamperProtectionPolicy());
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.consoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    @Override
    protected boolean ok() {
        boolean okResult = super.ok();
        try {
            if ("sesm_policies_dialog_av_private_submission".equals(this.getContentSensitiveHelpToken())) {
                PrivateInsightServer siteInsightServer;
                String siteId = Manager.getCurrentSiteId();
                SemSite site = DataobjectManager.getInstance().getSemSite(siteId);
                if (site != null && (siteInsightServer = site.getOptPrivateInsightServer()) != null && this.externalComObj.hasPrivateInsightServer() && siteInsightServer.getOptEnable() != null && siteInsightServer.getOptEnable().booleanValue() && this.externalComObj.isPrivateInsightServerEnable()) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "SubmissionPanel.groupPrivateServer.overrideWarning"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.waring"), 2);
                }
            }
        }
        catch (ConsoleException ex) {
            System.out.println("Exception " + ex.getMessage());
            LoggerUtilities.logException((Throwable)ex);
        }
        return okResult;
    }

    static class MyException
    extends Exception {
        private static final long serialVersionUID = 1L;
        JComponent errorCom;

        MyException(String msg, JComponent com) {
            super(msg);
            this.errorCom = com;
        }
    }
}

