/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.GupRuleSets;
import com.sygate.scm.common.configobject.schema.IPAddressesHostNames;
import com.sygate.scm.common.configobject.schema.OperatingSystems;
import com.sygate.scm.common.configobject.schema.RegistryEntries;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJTree;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AddressObject;
import com.sygate.scm.console.logicobject.CountableInt;
import com.sygate.scm.console.logicobject.DeletableObjInt;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.OperatingSystemNameObject;
import com.sygate.scm.console.logicobject.RegistryObject;
import com.sygate.scm.console.logicobject.RuleSetObject;
import com.sygate.scm.console.logicobject.RuleSetOrObject;
import com.sygate.scm.console.logicobject.RuleSetRootObject;
import com.sygate.scm.console.ui.policy.OSPanel;
import com.sygate.scm.console.ui.policy.common.ButtonPane;
import com.sygate.scm.console.ui.policy.dialog.GUPConditionDlg;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GUPSettingDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final String CANCEL_VALUE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.cancel");
    private static final String NODE_VALUE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "LocationSettingDlg.newnode");
    private static final String DLG = "com.sygate.scm.console.ui.policy.dialog.policydialog";
    private static int MAX_HOSTNAME_LENGTH = 255;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    String disallowCharacters = "`~!@#$^&()[]{}\\+=|:;\"'/<>,";
    RestrictedPlainDocument nameDoc = new RestrictedPlainDocument(MAX_HOSTNAME_LENGTH, this.disallowCharacters.replace(".", ""), false);
    private DefaultMutableTreeNode rulesetRoot;
    private DefaultTreeModel rulesetModel;
    private RuleSetRootObject ruleSetsRootObject;
    private OSPanel osPanel;
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel locPanel = new JPanel();
    JCheckBoxMenuItem defaultMenu;
    HtmlEnabledJTree rulesetTree = null;
    JPanel rulesetPane;
    Action addRuelSet;
    Action deleteRuelSet;
    Action editRuelSet;
    Action addRuelSetAnd;
    Action addRuelSetOr;
    JPopupMenu andPMenu = new JPopupMenu();
    JPopupMenu orPMenu = new JPopupMenu();
    JPopupMenu addPMenu = new JPopupMenu();
    JPopupMenu rootMenu = new JPopupMenu();
    private boolean enableAddRule = true;
    private JMenuItem addMenuForAnd;
    private JMenuItem addMenuForOr;
    private JButton addBtn;
    ActionListener setDefaultLocationListener;

    public GUPSettingDlg(JFrame frame, String title, RuleSetRootObject rulesetsObject, boolean modal, String address) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.setRuleSetsObject(rulesetsObject);
            this.pack();
            UiUtilities.centerComponent((Component)this);
            if (this.isReadOnly()) {
                this.resetOKButton(false);
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public GUPSettingDlg(JFrame frame, String title, RuleSetRootObject rulesetsObject, boolean modal) {
        this(frame, title, rulesetsObject, modal, "");
    }

    protected void addRuleSet(ActionEvent e) {
        int childCnt = this.rulesetRoot.getChildCount();
        if (childCnt == 0) {
            this.addRuleSetOrCondition();
        } else {
            this.showAddMenu(e);
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_computersnusers_policies_gup_rule_set_setting";
    }

    @Override
    protected boolean isValidate() {
        return true;
    }

    private void jbInit() {
        this.panel1.setLayout(this.borderLayout1);
        this.getContentPane().add(this.panel1);
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        JComponent centralPane = this.getCentralPane();
        this.panel1.add((Component)centralPane, "Center");
    }

    private JComponent getCentralPane() {
        this.locPanel.setLayout(new BorderLayout());
        this.rulesetPane = this.getRulesetPane();
        this.locPanel.add((Component)this.rulesetPane, "Center");
        return this.locPanel;
    }

    private JPanel getRulesetPane() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.rulesetRoot = new DefaultMutableTreeNode(this.ruleSetsRootObject);
        this.rulesetModel = new DefaultTreeModel(this.rulesetRoot);
        this.rulesetTree = new HtmlEnabledJTree();
        this.rulesetTree.setModel((TreeModel)this.rulesetModel);
        this.rulesetTree.setRootVisible(true);
        this.rulesetTree.setShowsRootHandles(true);
        HTMLRenderer treeRender = new HTMLRenderer();
        this.rulesetTree.setCellRenderer((TreeCellRenderer)treeRender);
        this.rulesetTree.getSelectionModel().setSelectionMode(1);
        this.rulesetTree.addTreeSelectionListener(event -> this.rulesetTreeSelectionChanged());
        this.rulesetTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private void showPopup(MouseEvent e) {
                TreePath path = GUPSettingDlg.this.rulesetTree.getPathForLocation(e.getX(), e.getY());
                GUPSettingDlg.this.rulesetTree.setSelectionPath(path);
                if (e.isPopupTrigger()) {
                    if (path != null) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                        Object treeObject = node.getUserObject();
                        GUPSettingDlg.this.enableAddRule = true;
                        if (treeObject instanceof RuleSetOrObject) {
                            GUPSettingDlg.this.rulesetTree.add((Component)GUPSettingDlg.this.andPMenu);
                            if (((RuleSetOrObject)treeObject).getTypeNotPresent() == null) {
                                GUPSettingDlg.this.enableAddRule = false;
                            }
                            GUPSettingDlg.this.addRuelSetAnd.setEnabled(GUPSettingDlg.this.enableAddRule);
                            GUPSettingDlg.this.andPMenu.show((Component)GUPSettingDlg.this.rulesetTree, e.getX(), e.getY());
                        } else if (treeObject instanceof RuleSetRootObject) {
                            GUPSettingDlg.this.rulesetTree.add((Component)GUPSettingDlg.this.rootMenu);
                            GUPSettingDlg.this.rootMenu.show((Component)GUPSettingDlg.this.rulesetTree, e.getX(), e.getY());
                        } else if (treeObject instanceof RuleSetObject) {
                            GUPSettingDlg.this.rulesetTree.add((Component)GUPSettingDlg.this.orPMenu);
                            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                            if (parent != null && ((RuleSetOrObject)parent.getUserObject()).getTypeNotPresent() == null) {
                                GUPSettingDlg.this.enableAddRule = false;
                            }
                            GUPSettingDlg.this.addRuelSetAnd.setEnabled(GUPSettingDlg.this.enableAddRule);
                            GUPSettingDlg.this.orPMenu.show((Component)GUPSettingDlg.this.rulesetTree, e.getX(), e.getY());
                        } else {
                            GUPSettingDlg.this.rulesetTree.add((Component)GUPSettingDlg.this.orPMenu);
                            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent().getParent();
                            if (parent != null && ((RuleSetOrObject)parent.getUserObject()).getTypeNotPresent() == null) {
                                GUPSettingDlg.this.enableAddRule = false;
                            }
                            GUPSettingDlg.this.addRuelSetAnd.setEnabled(GUPSettingDlg.this.enableAddRule);
                            GUPSettingDlg.this.orPMenu.show((Component)GUPSettingDlg.this.rulesetTree, e.getX(), e.getY());
                        }
                    } else {
                        GUPSettingDlg.this.rulesetTree.add((Component)GUPSettingDlg.this.rootMenu);
                        GUPSettingDlg.this.rootMenu.show((Component)GUPSettingDlg.this.rulesetTree, e.getX(), e.getY());
                    }
                }
            }
        });
        JScrollPane sPane = new JScrollPane((Component)this.rulesetTree);
        sPane.setPreferredSize(new Dimension(380, 350));
        panel.add((Component)sPane, "Center");
        DescriptionTextArea criteriaTextArea = new DescriptionTextArea(MSGRES.getString(DLG, "GUPSettingDlg.label.criteria"));
        criteriaTextArea.setEditable(false);
        criteriaTextArea.setWrapStyleWord(true);
        criteriaTextArea.setLineWrap(true);
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BorderLayout());
        descPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 100));
        descPanel.add((Component)criteriaTextArea, "Center");
        panel.add((Component)descPanel, "North");
        JButton[] buttons = new JButton[3];
        this.addRuelSet = new AbstractAction(UIText.get(8)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GUPSettingDlg.this.addRuleSet(e);
            }
        };
        buttons[0] = new JButton(this.addRuelSet);
        this.addBtn = buttons[0];
        this.editRuelSet = new AbstractAction(UIText.get(1024)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GUPSettingDlg.this.editCondition();
            }
        };
        buttons[1] = new JButton(this.editRuelSet);
        this.deleteRuelSet = new AbstractAction(UIText.get(769)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GUPSettingDlg.this.deleteRuleSet();
            }
        };
        buttons[2] = new JButton(this.deleteRuelSet);
        ButtonPane bPane = new ButtonPane(buttons, true, false);
        this.addRuelSetAnd = new AbstractAction(UIText.get(20)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GUPSettingDlg.this.addRuleSetAndCondition();
            }
        };
        this.addRuelSetOr = new AbstractAction(UIText.get(3586)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GUPSettingDlg.this.addRuleSetOrCondition();
            }
        };
        JMenuItem mItem = new JMenuItem(this.addRuelSetOr);
        this.addPMenu.add(mItem);
        mItem = new JMenuItem(this.addRuelSetAnd);
        this.addPMenu.add(mItem);
        JMenu menu = new JMenu(MSGRES.getString(DLG, "GUPSettingDlg.addMenu"));
        mItem = new JMenuItem(this.addRuelSetOr);
        menu.add(mItem);
        mItem = new JMenuItem(this.addRuelSetAnd);
        menu.add(mItem);
        this.andPMenu.add(menu);
        this.addMenuForAnd = menu;
        JMenuItem deleteMenu = new JMenuItem(this.deleteRuelSet);
        this.andPMenu.add(deleteMenu);
        this.andPMenu.addSeparator();
        mItem = new JMenuItem(this.addRuelSetOr);
        this.rootMenu.add(mItem);
        menu = new JMenu(MSGRES.getString(DLG, "GUPSettingDlg.addMenu"));
        mItem = new JMenuItem(this.addRuelSetOr);
        menu.add(mItem);
        mItem = new JMenuItem(this.addRuelSetAnd);
        menu.add(mItem);
        this.orPMenu.add(menu);
        this.addMenuForOr = menu;
        deleteMenu = new JMenuItem(this.deleteRuelSet);
        this.orPMenu.add(deleteMenu);
        this.orPMenu.add(new JMenuItem(this.editRuelSet));
        this.orPMenu.addSeparator();
        bPane.setBorder(BorderFactory.createEmptyBorder(0, 15, 15, 15));
        panel.add((Component)bPane, "East");
        panel.setBorder(BorderFactory.createEtchedBorder());
        return panel;
    }

    private void showAddMenu(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        this.addRuelSetAnd.setEnabled(this.enableAddRule);
        button.add(this.addPMenu);
        this.addPMenu.show(button, button.getX(), button.getY());
    }

    private void deleteRuleSet() {
        TreePath path = this.rulesetTree.getSelectionPath();
        if (path == null) {
            return;
        }
        this.removeNodeFromPath(path);
    }

    private void removeNodeFromPath(TreePath path) {
        Object treeObj;
        DefaultMutableTreeNode currentRuleSetNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (currentRuleSetNode != null && (treeObj = currentRuleSetNode.getUserObject()) instanceof DeletableObjInt) {
            Object[] choice = new String[]{MSGRES.getString(DLG, "GUPSettingDlg.yes"), MSGRES.getString(DLG, "GUPSettingDlg.no")};
            String promptMessage = "";
            String title = "";
            if (treeObj instanceof RuleSetOrObject) {
                promptMessage = MSGRES.getString(DLG, "GUPSettingDlg.youAreAboutToDeleteARuleSet");
                title = MSGRES.getString(DLG, "GUPSettingDlg.deleteRuleSet");
            } else if (treeObj instanceof RuleSetObject) {
                promptMessage = MSGRES.getString(DLG, "GUPSettingDlg.youAreAboutToDeleteARule");
                title = MSGRES.getString(DLG, "GUPSettingDlg.deleteRule");
            }
            int result = JOptionPane.showOptionDialog(Manager.getFrame(), promptMessage, title, 0, 3, null, choice, choice[1]);
            if (result == 0) {
                if (treeObj instanceof RuleSetOrObject) {
                    this.removeNodeFromTree(currentRuleSetNode);
                } else if (treeObj instanceof RuleSetObject) {
                    DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)currentRuleSetNode.getParent();
                    this.removeNodeFromTree(currentRuleSetNode);
                    if (parentNode != null && parentNode.getChildCount() == 0) {
                        this.removeNodeFromTree(parentNode);
                    }
                }
            }
        }
    }

    private void removeNodeFromTree(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode nextNode;
        RuleSetOrObject alAndObj;
        Object treeObj = node.getUserObject();
        if (treeObj == null) {
            return;
        }
        DeletableObjInt alObj = (DeletableObjInt)treeObj;
        alObj.delete();
        if (treeObj instanceof RuleSetOrObject && (alAndObj = (RuleSetOrObject)treeObj).isFirst() && (nextNode = node.getNextSibling()) != null) {
            RuleSetOrObject nextObj = (RuleSetOrObject)nextNode.getUserObject();
            nextObj.setToFirst();
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
        this.rulesetModel.removeNodeFromParent(node);
        if (parentNode != null) {
            this.resetChildreanNumber(parentNode);
            if (parentNode.getChildCount() > 0) {
                DefaultMutableTreeNode firstChild = (DefaultMutableTreeNode)parentNode.getFirstChild();
                this.rulesetTree.setSelectionPath(new TreePath(firstChild.getPath()));
            } else {
                this.rulesetTree.setSelectionPath(new TreePath(parentNode.getPath()));
            }
        }
    }

    private void editCondition() {
        block7: {
            try {
                TreePath path = this.rulesetTree.getSelectionPath();
                if (path == null) {
                    JOptionPane.showMessageDialog(this, MSGRES.getString(DLG, "GUPSettingDlg.youNeedToSelectTree"), MSGRES.getString(DLG, "GUPSettingDlg.error"), 0);
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object treeItem = node.getUserObject();
                if (!(treeItem instanceof RuleSetObject)) {
                    JOptionPane.showMessageDialog(this, MSGRES.getString(DLG, "GUPSettingDlg.onlyORObjectCanBeEdited"), MSGRES.getString(DLG, "GUPSettingDlg.error"), 0);
                    return;
                }
                DefaultMutableTreeNode andNode = (DefaultMutableTreeNode)node.getParent();
                RuleSetObject thisObj = (RuleSetObject)treeItem;
                RuleSetOrObject andObj = (RuleSetOrObject)andNode.getUserObject();
                String[] types = andObj.getTypesAppearInEdit(thisObj);
                GUPConditionDlg dlg = new GUPConditionDlg((JFrame)Manager.getFrame(), MSGRES.getString(DLG, "GUPSettingDlg.defineRuleCriteria"), types, true);
                RuleSetObject newObj = thisObj.getClone();
                dlg.setObject(newObj);
                dlg.setVisible(true);
                if (!dlg.isOk()) {
                    return;
                }
                int index = andNode.getIndex(node);
                DefaultMutableTreeNode newNode = this.generateConditionNode(newObj);
                if (newObj.getType() == thisObj.getType()) {
                    this.rulesetModel.removeNodeFromParent(node);
                    andObj.replace(thisObj, newObj);
                } else {
                    andObj.addAnCondition(newObj);
                }
                this.rulesetModel.insertNodeInto(newNode, andNode, index);
                this.resetChildreanNumber(andNode);
                TreePath newPath = new TreePath(newNode.getPath());
                this.rulesetTree.scrollPathToVisible(newPath);
                this.rulesetTree.expandPath(newPath);
                this.rulesetTree.setSelectionPath(newPath);
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString(DLG, "GUPSettingDlg.consoleError"), 0);
                if (!ex.needRelogin()) break block7;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private void rulesetTreeSelectionChanged() {
        this.setRuleSetActionStatus();
    }

    private void setRuleSetActionStatus() {
        if (this.isReadOnly()) {
            this.addBtn.setEnabled(false);
            this.editRuelSet.setEnabled(false);
            this.deleteRuelSet.setEnabled(false);
            return;
        }
        LicenseObject licenseObj = LicenseObject.getInstance();
        boolean enableAutoLoc = licenseObj.isAdaptiveLocation();
        this.addMenuForAnd.setEnabled(enableAutoLoc);
        this.addMenuForOr.setEnabled(enableAutoLoc);
        this.addBtn.setEnabled(enableAutoLoc);
        this.deleteRuelSet.setEnabled(false);
        this.editRuelSet.setEnabled(false);
        this.addRuelSetAnd.setEnabled(true);
        this.addRuelSetOr.setEnabled(true);
        DefaultMutableTreeNode currentSigNode = null;
        TreePath path = this.rulesetTree.getSelectionPath();
        this.addRuelSet.setEnabled(false);
        this.enableAddRule = true;
        if (path != null) {
            currentSigNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        }
        if (currentSigNode != null) {
            DefaultMutableTreeNode parent;
            this.addRuelSet.setEnabled(true);
            Object currentTreeItem = currentSigNode.getUserObject();
            this.addRuelSetOr.setEnabled(true);
            if (currentTreeItem instanceof RuleSetRootObject) {
                this.enableAddRule = false;
            } else if (currentTreeItem instanceof RuleSetObject) {
                this.editRuelSet.setEnabled(true);
                DefaultMutableTreeNode parent2 = (DefaultMutableTreeNode)currentSigNode.getParent();
                if (((RuleSetOrObject)parent2.getUserObject()).getTypeNotPresent() == null) {
                    this.enableAddRule = false;
                }
            } else if (!(currentTreeItem instanceof RuleSetOrObject) && (parent = (DefaultMutableTreeNode)currentSigNode.getParent().getParent()) != null && ((RuleSetOrObject)parent.getUserObject()).getTypeNotPresent() == null) {
                this.enableAddRule = false;
            }
            if (currentTreeItem instanceof DeletableObjInt) {
                this.deleteRuelSet.setEnabled(true);
                if (currentTreeItem instanceof RuleSetOrObject && ((RuleSetOrObject)currentTreeItem).getTypeNotPresent() == null) {
                    this.enableAddRule = false;
                }
            }
        }
    }

    private void addRuleSetOrCondition() {
        int orCount = this.rulesetRoot.getChildCount();
        RuleSetOrObject newObj = new RuleSetOrObject(orCount == 0);
        DefaultMutableTreeNode aOrNode = new DefaultMutableTreeNode(newObj);
        Map<String, Serializable> retValue = this.addAndCondition(aOrNode, newObj);
        boolean isCanceled = (Boolean)retValue.get(CANCEL_VALUE);
        if (!isCanceled) {
            ((RuleSetRootObject)this.rulesetRoot.getUserObject()).addRuleSetOrObject(newObj);
            this.rulesetModel.insertNodeInto(aOrNode, this.rulesetRoot, orCount);
            this.resetChildreanNumber(this.rulesetRoot);
            this.rulesetModel.nodeChanged(aOrNode);
            DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)retValue.get(NODE_VALUE);
            TreePath newPath = new TreePath(newNode.getPath());
            this.rulesetTree.scrollPathToVisible(newPath);
            this.rulesetTree.expandPath(newPath);
            this.rulesetTree.setSelectionPath(newPath);
            this.rulesetModel.nodeChanged(newNode);
        }
    }

    private void addRuleSetAndCondition() {
        DefaultMutableTreeNode orNode;
        TreePath path = this.rulesetTree.getSelectionPath();
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            TreeNode[] allNodes = node.getPath();
            if (allNodes.length < 2) {
                JOptionPane.showMessageDialog(this, MSGRES.getString(DLG, "LocationSettingDlg.therulesetTreeIsNotCorrect"), MSGRES.getString(DLG, "LocationSettingDlg.error"), 0);
                Manager.getFrame().showLoginPanel();
                return;
            }
            orNode = (DefaultMutableTreeNode)allNodes[1];
        } else {
            orNode = (DefaultMutableTreeNode)this.rulesetRoot.getLastChild();
        }
        RuleSetOrObject parent = (RuleSetOrObject)orNode.getUserObject();
        Map<String, Serializable> retValue = this.addAndCondition(orNode, parent);
        boolean isCanceled = (Boolean)retValue.get(CANCEL_VALUE);
        if (!isCanceled) {
            DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)retValue.get(NODE_VALUE);
            TreePath newPath = new TreePath(newNode.getPath());
            this.rulesetTree.scrollPathToVisible(newPath);
            this.rulesetTree.expandPath(newPath);
            this.rulesetTree.setSelectionPath(newPath);
            this.rulesetModel.nodeChanged(newNode);
        }
    }

    private Map<String, Serializable> addAndCondition(DefaultMutableTreeNode orNode, RuleSetOrObject orObj) {
        HashMap<String, Serializable> retMap = new HashMap<String, Serializable>();
        String[] types = orObj.getTypeNotPresent();
        if (types == null) {
            return retMap;
        }
        GUPConditionDlg dlg = new GUPConditionDlg((JFrame)Manager.getFrame(), MSGRES.getString(DLG, "GUPSettingDlg.defineRuleCriteria"), types, true);
        int type = 0;
        if (orObj.getLocalHostAddress() == null) {
            type = 0;
        } else if (orObj.getAlRegistry() == null) {
            type = 1;
        } else if (orObj.getOperatingSystems() == null) {
            type = 2;
        }
        RuleSetObject newObj = new RuleSetObject(type);
        dlg.setObject(newObj);
        dlg.setVisible(true);
        if (!dlg.isOk()) {
            retMap.put(CANCEL_VALUE, Boolean.TRUE);
            return retMap;
        }
        orObj.addAnCondition(newObj);
        orNode.setUserObject(orObj);
        DefaultMutableTreeNode newNode = this.generateConditionNode(newObj);
        int child = orNode.getChildCount();
        this.rulesetModel.insertNodeInto(newNode, orNode, child);
        this.resetChildreanNumber(orNode);
        retMap.put(CANCEL_VALUE, Boolean.FALSE);
        retMap.put(NODE_VALUE, newNode);
        return retMap;
    }

    private void resetChildreanNumber(DefaultMutableTreeNode andNode) {
        Enumeration<TreeNode> en = andNode.children();
        int cnt = 0;
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            Object obj = node.getUserObject();
            if (!(obj instanceof CountableInt)) continue;
            CountableInt cObj = (CountableInt)obj;
            cObj.setCountNumber(cnt++);
        }
    }

    private DefaultMutableTreeNode generateConditionNode(RuleSetObject obj) {
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(obj);
        int type = obj.getType();
        switch (type) {
            case 0: {
                AddressObject[] addresses = obj.getAddress();
                for (int i = 0; i < addresses.length; ++i) {
                    DefaultMutableTreeNode leafNode = new DefaultMutableTreeNode(addresses[i]);
                    int child = parent.getChildCount();
                    this.rulesetModel.insertNodeInto(leafNode, parent, child);
                }
                break;
            }
            case 1: {
                List<RegistryObject> allRegistryData = obj.getRegistryData();
                int size = allRegistryData.size();
                for (int i = 0; i < size; ++i) {
                    DefaultMutableTreeNode leafNode = new DefaultMutableTreeNode(allRegistryData.get(i));
                    int child = parent.getChildCount();
                    this.rulesetModel.insertNodeInto(leafNode, parent, child);
                }
                break;
            }
            case 2: {
                List<OperatingSystemNameObject> osNameObject = obj.getOperatingSystemNameObject();
                int osSize = osNameObject.size();
                for (int i = 0; i < osSize; ++i) {
                    DefaultMutableTreeNode leafNode = new DefaultMutableTreeNode(osNameObject.get(i));
                    int child = parent.getChildCount();
                    this.rulesetModel.insertNodeInto(leafNode, parent, child);
                }
                break;
            }
        }
        this.resetChildreanNumber(parent);
        return parent;
    }

    private void formTreeFromGUPRuleSetsObject() {
        this.rulesetRoot.setUserObject(this.ruleSetsRootObject);
        this.rulesetTree.setSelectionPath(new TreePath(this.rulesetRoot.getPath()));
        GupRuleSets ruleSets = this.ruleSetsRootObject.getGUPRuleSets();
        if (ruleSets != null) {
            Vector guplist = ruleSets.getGupRuleSet();
            int size = guplist.size();
            for (int index = 0; index < size; ++index) {
                OperatingSystems operatingSystems;
                RegistryEntries registrys;
                RuleSetOrObject ruleSetOrObj = new RuleSetOrObject((ConfigObject)ruleSets.getGupRuleSet(index), index == 0);
                DefaultMutableTreeNode ruleSetOrNode = new DefaultMutableTreeNode(ruleSetOrObj);
                IPAddressesHostNames ipHostNames = ruleSets.getGupRuleSet(index).getOptIPAddressesHostNames();
                if (ipHostNames != null) {
                    RuleSetObject ruleSetObj = new RuleSetObject(0, (ConfigObject)ipHostNames);
                    ruleSetOrObj.addAnCondition(ruleSetObj);
                    DefaultMutableTreeNode ruleSetNode = this.generateConditionNode(ruleSetObj);
                    int child = ruleSetOrNode.getChildCount();
                    this.rulesetModel.insertNodeInto(ruleSetNode, ruleSetOrNode, child);
                    this.resetChildreanNumber(ruleSetOrNode);
                }
                if ((registrys = ruleSets.getGupRuleSet(index).getOptRegistryEntries()) != null) {
                    RuleSetObject ruleSetObj = new RuleSetObject(1, (ConfigObject)registrys);
                    ruleSetOrObj.addAnCondition(ruleSetObj);
                    DefaultMutableTreeNode ruleSetNode = this.generateConditionNode(ruleSetObj);
                    int child = ruleSetOrNode.getChildCount();
                    this.rulesetModel.insertNodeInto(ruleSetNode, ruleSetOrNode, child);
                    this.resetChildreanNumber(ruleSetOrNode);
                }
                if ((operatingSystems = ruleSets.getGupRuleSet(index).getOptOperatingSystems()) != null) {
                    if (this.osPanel == null) {
                        this.osPanel = new OSPanel("", 0);
                    }
                    RuleSetObject ruleSetObj = new RuleSetObject(2, (ConfigObject)operatingSystems);
                    String operatingSystemNames = this.osPanel.getOperatingSystemNamesFromCode(ruleSetObj.getOperatingSystemCode());
                    ruleSetObj.setOperatingSystemNames(operatingSystemNames);
                    ruleSetOrObj.addAnCondition(ruleSetObj);
                    DefaultMutableTreeNode ruleSetNode = this.generateConditionNode(ruleSetObj);
                    int child = ruleSetOrNode.getChildCount();
                    this.rulesetModel.insertNodeInto(ruleSetNode, ruleSetOrNode, child);
                    this.resetChildreanNumber(ruleSetOrNode);
                }
                this.rulesetModel.insertNodeInto(ruleSetOrNode, this.rulesetRoot, index);
                this.resetChildreanNumber(this.rulesetRoot);
                this.rulesetModel.nodeChanged(ruleSetOrNode);
                this.rulesetRoot.add(ruleSetOrNode);
                TreePath newPath = new TreePath(ruleSetOrNode.getPath());
                this.rulesetTree.scrollPathToVisible(newPath);
                this.rulesetTree.expandPath(newPath);
                this.rulesetTree.setSelectionPath(newPath);
                this.rulesetModel.nodeChanged(ruleSetOrNode);
            }
        }
    }

    public RuleSetRootObject getRuleSetsObject() {
        if (this.ruleSetsRootObject != null && this.ruleSetsRootObject.getGUPRuleSets() != null) {
            GupRuleSets ruleSets = this.ruleSetsRootObject.getGUPRuleSets();
            if (ruleSets.getGupRuleSetCount() == 0) {
                return null;
            }
            return this.ruleSetsRootObject;
        }
        return null;
    }

    public void setRuleSetsObject(RuleSetRootObject ruleSets) {
        this.ruleSetsRootObject = ruleSets;
        this.rulesetRoot.setUserObject(ruleSets);
        this.rulesetModel.setRoot(this.rulesetRoot);
        if (this.ruleSetsRootObject.getGUPRuleSets() == null) {
            this.ruleSetsRootObject.setGUPRuleSets(new GupRuleSets());
        }
        this.formTreeFromGUPRuleSetsObject();
    }

    static class HTMLRenderer
    extends JLabel
    implements TreeCellRenderer {
        private static final long serialVersionUID = 1L;

        public HTMLRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setText(value == null ? MessageResources.getInstance().getString(GUPSettingDlg.DLG, "LocationSettingDlg.91") : value.toString());
            if (selected) {
                this.setBackground(UIManager.getColor("Tree.selectionBackground"));
                this.setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("Tree.background"));
                this.setForeground(UIManager.getColor("Tree.textForeground"));
            }
            return this;
        }
    }
}

