/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.logicobject.AddressObject;
import com.sygate.scm.console.ui.policy.common.HostNamePane;
import com.sygate.scm.console.ui.policy.common.IPPane;
import com.sygate.scm.console.ui.policy.common.IPv6Pane;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GUPRuleAddressDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final int PREFERRED_IPVERSION_WIDTH = 60;
    private static final int PREFERRED_WIDTH = 310;
    private static final int PREFERRED_LABEL_WIDTH = 60;
    private static final int ID_IP_TYPE_V4 = 0;
    private static final int ID_IP_TYPE_V6 = 1;
    private static final String ADDRESS_IP_V4 = "IPV4";
    private static final String ADDRESS_IP_V6 = "IPV6";
    private static final String ADDRESS_HOSTNAME = "HostName";
    private static final String[] addressTypes = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.IPAddress"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.hostNmae")};
    private static final String[] IP_VERSIONS = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "IPv.four"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "IPv.six")};
    private JComboBox<String> ipVerCombo;
    private AddressObject myObj;
    private Map<Integer, Integer> typeIndexMap = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> indexTypeMap = new HashMap<Integer, Integer>();
    private JPanel contentPanel = new JPanel(new BorderLayout(10, 10));
    private JPanel centerPanel = new JPanel();
    private JPanel comboPane = new JPanel();
    private JPanel mainPane = new JPanel();
    private JLabel addressLabel = new JLabel();
    private JComboBox<String> typeCmbBox = new JComboBox<String>(addressTypes);
    private IPPane ipPane = new IPPane(60, 0, -30, 310);
    private IPv6Pane ipv6Pane = new IPv6Pane(60, 0, -30, 310);
    private HostNamePane hostPane = new HostNamePane(60, 0, -30, 310, true);

    public GUPRuleAddressDlg(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.setResizable(false);
            UiUtilities.centerComponent((Component)this);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public void typeChanged() {
        this.updateDisplay();
    }

    @Override
    protected boolean isValidate() {
        int addressType = this.getHostObjectTypeFromComboSelections();
        switch (addressType) {
            case 0: {
                if (this.ipPane.isValidValue()) break;
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.wrongIPAddress"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.error"), 0);
                this.ipPane.requestFocus();
                return false;
            }
            case 7: {
                if (this.ipv6Pane.isValidValue()) break;
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.wrongIPAddress"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.error"), 0);
                this.ipv6Pane.requestFocus();
                return false;
            }
            case 4: {
                if (this.hostPane.isValidValue()) break;
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.wrongHostName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.error"), 0);
                this.hostPane.requestFocus();
                return false;
            }
        }
        return true;
    }

    @Override
    protected void commit() {
        int addressType = this.getHostObjectTypeFromComboSelections();
        this.myObj.setType(addressType);
        switch (addressType) {
            case 0: {
                this.myObj.setIPAddress(this.ipPane.getText());
                break;
            }
            case 7: {
                this.myObj.setIPAddress(this.ipv6Pane.getText());
                break;
            }
            case 4: {
                this.myObj.setHostName(this.hostPane.getText());
                break;
            }
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_computersnusers_policies_gup_rule_set_edit_add_address";
    }

    private void jbInit() throws Exception {
        this.ipVerCombo = new JComboBox<String>(IP_VERSIONS);
        this.ipVerCombo.setPreferredSize(new Dimension(60, this.ipVerCombo.getPreferredSize().height));
        this.ipVerCombo.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ev) {
                GUPRuleAddressDlg.this.typeChanged();
            }
        });
        this.typeCmbBox.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent exc) {
                GUPRuleAddressDlg.this.typeChanged();
            }
        });
        this.addressLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.type"));
        this.addressLabel.setPreferredSize(new Dimension(60, this.addressLabel.getPreferredSize().height));
        this.comboPane.setLayout(new BorderLayout(20, 10));
        this.comboPane.add((Component)this.addressLabel, "West");
        this.comboPane.add(this.typeCmbBox, "Center");
        this.comboPane.add(this.ipVerCombo, "East");
        this.mainPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mainPane.setLayout(new CardLayout());
        this.mainPane.add((Component)this.ipPane, ADDRESS_IP_V4);
        this.mainPane.add((Component)this.ipv6Pane, ADDRESS_IP_V6);
        this.mainPane.add((Component)this.hostPane, ADDRESS_HOSTNAME);
        this.centerPanel.setLayout(new GridBagLayout());
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.centerPanel.add((Component)this.comboPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 12, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.centerPanel.add((Component)this.mainPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 16, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.typeIndexMap.put(0, 0);
        this.typeIndexMap.put(4, 1);
        this.typeIndexMap.put(7, 0);
        this.indexTypeMap.put(0, 0);
        this.indexTypeMap.put(1, 4);
        this.typeCmbBox.setSelectedIndex(0);
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 30));
        this.contentPanel.add((Component)this.centerPanel, "Center");
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
    }

    private void updatePanel() {
        if (this.myObj != null) {
            int type = this.myObj.getType();
            int index = this.typeIndexMap.get(type);
            this.typeCmbBox.setSelectedIndex(index);
            switch (type) {
                case 0: {
                    this.ipPane.setText(this.myObj.getIP().trim());
                    this.ipVerCombo.setSelectedIndex(0);
                    break;
                }
                case 7: {
                    this.ipv6Pane.setText(this.myObj.getIP().trim());
                    this.ipVerCombo.setSelectedIndex(1);
                    break;
                }
                case 4: {
                    this.hostPane.setText(this.myObj.getHostName());
                    break;
                }
            }
            this.updateDisplay();
        }
    }

    private int getHostObjectTypeFromComboSelections() {
        int addressType = this.indexTypeMap.get(this.typeCmbBox.getSelectedIndex());
        if (0 == addressType && 1 == this.ipVerCombo.getSelectedIndex()) {
            addressType = 7;
        }
        return addressType;
    }

    private void updateDisplay() {
        CardLayout cd = (CardLayout)this.mainPane.getLayout();
        int type = this.getHostObjectTypeFromComboSelections();
        this.ipVerCombo.setVisible(false);
        switch (type) {
            case 4: {
                cd.show(this.mainPane, ADDRESS_HOSTNAME);
                break;
            }
            case 0: {
                this.ipVerCombo.setVisible(true);
                cd.show(this.mainPane, ADDRESS_IP_V4);
                break;
            }
            case 7: {
                this.ipVerCombo.setVisible(true);
                cd.show(this.mainPane, ADDRESS_IP_V6);
                break;
            }
        }
        this.pack();
    }

    public void setTypeModel(int type) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(addressTypes);
        this.typeCmbBox.setModel(model);
    }

    public void setObject(AddressObject newObj) {
        this.myObj = newObj;
        this.updatePanel();
    }
}

