/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AddressObject;
import com.sygate.scm.console.logicobject.RegistryDataObject;
import com.sygate.scm.console.logicobject.RegistryKeyObject;
import com.sygate.scm.console.logicobject.RegistryObject;
import com.sygate.scm.console.logicobject.RegistryValueObject;
import com.sygate.scm.console.logicobject.RuleSetObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.OSPanel;
import com.sygate.scm.console.ui.policy.common.ButtonPane;
import com.sygate.scm.console.ui.policy.common.IPPane;
import com.sygate.scm.console.ui.policy.dialog.GUPRuleAddressDlg;
import com.sygate.scm.console.ui.policy.dialog.RegistryDlg;
import com.sygate.scm.console.ui.policy.hi.logicobject.OSObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GUPConditionDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final String DLG = "com.sygate.scm.console.ui.policy.dialog.policydialog";
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String[] typeList = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPConditionDlg.computerIPAddressHostName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPConditionDlg.registryKeys"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPConditionDlg.operationSystem")};
    private static final String[] addressTableTitle = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPConditionDlg.type"), MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPConditionDlg.content")};
    private static final String[] registryTableTitle = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPConditionDlg.type"), MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPConditionDlg.tableHeader.condition")};
    private RuleSetObject myObj;
    private Map<Integer, Integer> typeIndexMap = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> indexTypeMap = new HashMap<Integer, Integer>();
    private Map<Integer, SortableTableModel> tableModelMap = new HashMap<Integer, SortableTableModel>();
    private Map<SortableTableModel, JTable> modelTableMap = new HashMap<SortableTableModel, JTable>();
    private OSPanel osPanel = new OSPanel("", 0, false);
    String[] types = new String[0];
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JComboBox<String> typeCmbBox = null;
    SortableTableModel localAddressModel = new SortableTableModel();
    SortableTableModel registryModel = new SortableTableModel();
    JTable localAddressTable = new StripesTable();
    JTable registryTable = new StripesTable();
    Action addAddress;
    Action deleteAddress;
    Action editAddress;
    Action addRegistryAddress;
    Action deleteRegistryAddress;
    Action editRegistryAddress;
    JPanel mainPane;
    JPopupMenu pLocalAddressMenu = new JPopupMenu();
    JPopupMenu pRegistryMenu = new JPopupMenu();
    JTextField nameField = new JTextField(18);
    IPPane ipField = new IPPane();

    public GUPConditionDlg(JFrame frame, String title, boolean modal) {
        this(frame, title, typeList, modal);
    }

    public GUPConditionDlg(JFrame frame, String title, String[] types, boolean modal) {
        super(frame, title, modal);
        try {
            this.setTypes(types);
            this.jbInit();
            this.pack();
            UiUtilities.centerComponent((Component)this);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    @Override
    protected boolean isValidate() {
        int index = this.typeCmbBox.getSelectedIndex();
        int addressType = this.indexTypeMap.get(index);
        switch (addressType) {
            case 0: {
                if (this.validatePanel(addressType)) break;
                JOptionPane.showMessageDialog(this, MSGRES.getString(DLG, "GUPConditionDlg.addAddressesBeforeClickingOK"), MSGRES.getString(DLG, "GUPConditionDlg.error"), 0);
                return false;
            }
            case 1: {
                if (this.validatePanel(addressType)) break;
                JOptionPane.showMessageDialog(this, MSGRES.getString(DLG, "GUPConditionDlg.addRegistryBeforeClickingOK"), MSGRES.getString(DLG, "GUPConditionDlg.error"), 0);
                return false;
            }
            case 2: {
                OSObject osObject = this.osPanel.getOSObject();
                int[] arr = osObject.getOSSet().toArray();
                if (arr != null && arr.length >= 1) break;
                JOptionPane.showMessageDialog(this, MSGRES.getString(DLG, "GUPConditionDlg.addOperatingSystemsBeforeClickingOK"), MSGRES.getString(DLG, "GUPConditionDlg.error"), 0);
                return false;
            }
        }
        return true;
    }

    @Override
    protected void commit() {
        int index = this.typeCmbBox.getSelectedIndex();
        int addressType = this.indexTypeMap.get(index);
        int oldType = this.myObj.getType();
        if (oldType != addressType) {
            this.myObj.setType(addressType);
        }
        switch (addressType) {
            case 0: {
                this.myObj.setNewAddresses((List)Cast.cast(this.localAddressModel.getAllRows()));
                break;
            }
            case 1: {
                this.myObj.setRegistryData((List)Cast.cast(this.registryModel.getAllRows()));
                break;
            }
            case 2: {
                this.myObj.setOperatingSystemCode(this.osPanel.getOperatingSystemCodes());
                this.myObj.setOperatingSystemNames(this.osPanel.getOperatingSystemNames());
                break;
            }
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_computersnusers_policies_gup_rule_set_edit_add_rule";
    }

    private void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.getContentPane().add(this.panel1);
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        JPanel topPane = new JPanel();
        topPane.setLayout(new BoxLayout(topPane, 1));
        JPanel secondLine = new JPanel(new FlowLayout(0));
        JLabel typeLabel = new JLabel(MSGRES.getString(DLG, "GUPConditionDlg.check"));
        secondLine.add(typeLabel);
        secondLine.add(Box.createRigidArea(new Dimension(10, 0)));
        this.typeCmbBox = new JComboBox<String>(this.types);
        if (this.types.length == 1) {
            this.typeCmbBox.setEditable(false);
        }
        this.typeCmbBox.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                GUPConditionDlg.this.typeChanged();
            }
        });
        secondLine.add(this.typeCmbBox);
        topPane.add(secondLine);
        this.panel1.add((Component)topPane, "North");
        this.addAddress = new AbstractAction(UIText.get(5)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                GUPConditionDlg.this.addAnAddress();
            }
        };
        this.deleteAddress = new AbstractAction(UIText.get(769)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                GUPConditionDlg.this.deleteAnAddress();
            }
        };
        this.editAddress = new AbstractAction(UIText.get(1024)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                GUPConditionDlg.this.editAnAddress();
            }
        };
        this.addRegistryAddress = new AbstractAction(UIText.get(5)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                GUPConditionDlg.this.addAnRegistryAddress();
            }
        };
        this.deleteRegistryAddress = new AbstractAction(UIText.get(769)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                GUPConditionDlg.this.deleteAnRegistryAddress();
            }
        };
        this.editRegistryAddress = new AbstractAction(UIText.get(1024)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                GUPConditionDlg.this.editAnRegistryAddress();
            }
        };
        this.mainPane = new JPanel();
        this.mainPane.setLayout(new CardLayout());
        this.mainPane.add((Component)this.getLocalHostPane(), typeList[0]);
        this.mainPane.add((Component)this.getRegistryPane(), typeList[1]);
        this.mainPane.add((Component)this.getOperatingSystemPane(), typeList[2]);
        this.panel1.add((Component)this.mainPane, "Center");
        this.initalMap();
        this.localAddressTable.setSelectionMode(0);
        this.localAddressTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GUPConditionDlg.this.tableSelectionChanged(e);
            }
        });
        this.localAddressTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GUPConditionDlg.this.editAnAddress();
                }
                GUPConditionDlg.this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GUPConditionDlg.this.editAnAddress();
                }
                GUPConditionDlg.this.showPopup(e);
            }
        });
        this.registryTable.setSelectionMode(0);
        this.registryTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GUPConditionDlg.this.tableSelectionChanged(e);
            }
        });
        this.registryTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GUPConditionDlg.this.editAnAddress();
                }
                GUPConditionDlg.this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GUPConditionDlg.this.editAnAddress();
                }
                GUPConditionDlg.this.showPopup(e);
            }
        });
        JMenuItem menuItem = new JMenuItem(this.addAddress);
        this.pLocalAddressMenu.add(menuItem);
        menuItem = new JMenuItem(this.editAddress);
        this.pLocalAddressMenu.add(menuItem);
        menuItem = new JMenuItem(this.deleteAddress);
        this.pLocalAddressMenu.add(menuItem);
        menuItem = new JMenuItem(this.addRegistryAddress);
        this.pRegistryMenu.add(menuItem);
        menuItem = new JMenuItem(this.editRegistryAddress);
        this.pRegistryMenu.add(menuItem);
        menuItem = new JMenuItem(this.deleteRegistryAddress);
        this.pRegistryMenu.add(menuItem);
    }

    private boolean validatePanel(int addressType) {
        SortableTableModel model = this.tableModelMap.get(addressType);
        int rowCount = model.getRowCount();
        return rowCount != 0;
    }

    private JPanel getLocalHostPane() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.localAddressModel.setColumnNames(addressTableTitle);
        this.localAddressModel.addMouseListenerToHeaderInTable(this.localAddressTable);
        this.localAddressTable.setModel(this.localAddressModel);
        this.modelTableMap.put(this.localAddressModel, this.localAddressTable);
        JScrollPane scrollPane = new JScrollPane(this.localAddressTable);
        scrollPane.setPreferredSize(new Dimension(500, 100));
        scrollPane.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getModifiers() == 4) {
                    GUPConditionDlg.this.localAddressTable.clearSelection();
                    GUPConditionDlg.this.pLocalAddressMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        TitledBorder title = new TitledBorder(BorderFactory.createEtchedBorder(), MSGRES.getString(DLG, "GUPConditionDlg.IPCondition"));
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBorder(title);
        titlePanel.add((Component)scrollPane, "Center");
        panel.add((Component)titlePanel, "Center");
        JButton[] buttons = new JButton[]{new JButton(this.addAddress), new JButton(this.editAddress), new JButton(this.deleteAddress)};
        ButtonPane bPane = new ButtonPane(buttons, 1);
        panel.add((Component)bPane, "South");
        return panel;
    }

    private JPanel getOperatingSystemPane() {
        if (this.osPanel.getOSObject() == null) {
            this.osPanel.setObject(new OSObject(""));
        }
        this.osPanel.setPreferredSize(new Dimension(200, 50));
        return this.osPanel;
    }

    private JPanel getRegistryPane() {
        JPanel outpanel = new JPanel();
        outpanel.setLayout(new BorderLayout());
        this.registryModel.setColumnNames(registryTableTitle);
        this.registryModel.addMouseListenerToHeaderInTable(this.registryTable);
        this.registryTable.setModel(this.registryModel);
        this.modelTableMap.put(this.registryModel, this.registryTable);
        JScrollPane scrollPane = new JScrollPane(this.registryTable);
        scrollPane.setPreferredSize(new Dimension(500, 100));
        scrollPane.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getModifiers() == 4) {
                    GUPConditionDlg.this.registryTable.clearSelection();
                    GUPConditionDlg.this.pRegistryMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        TitledBorder title = new TitledBorder(BorderFactory.createEtchedBorder(), MSGRES.getString(DLG, "GUPConditionDlg.registryCondition"));
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBorder(title);
        titlePanel.add((Component)scrollPane, "Center");
        outpanel.add((Component)titlePanel, "Center");
        JButton[] buttons = new JButton[]{new JButton(this.addRegistryAddress), new JButton(this.editRegistryAddress), new JButton(this.deleteRegistryAddress)};
        ButtonPane bPane = new ButtonPane(buttons, 1);
        outpanel.add((Component)bPane, "South");
        return outpanel;
    }

    private void addAnAddress() {
        int index = this.typeCmbBox.getSelectedIndex();
        int addressType = this.indexTypeMap.get(index);
        GUPRuleAddressDlg dlg = new GUPRuleAddressDlg(Manager.getFrame(), MSGRES.getString(DLG, "GUPConditionDlg.title.IPAddressHostName"), true);
        AddressObject newObj = new AddressObject(0);
        dlg.setObject(newObj);
        dlg.setVisible(true);
        if (!dlg.isOk()) {
            return;
        }
        SortableTableModel model = this.tableModelMap.get(addressType);
        model.addRow(newObj);
    }

    private void deleteAnAddress() {
        int index = this.typeCmbBox.getSelectedIndex();
        int addressType = this.indexTypeMap.get(index);
        SortableTableModel model = this.tableModelMap.get(addressType);
        JTable table = this.modelTableMap.get(model);
        int row = table.getSelectedRow();
        if (row == -1) {
            return;
        }
        int result = UIUtilities.confirmYesNoOptionDialog(MSGRES.getString(DLG, "GUPConditionDlg.youAreAboutToDeleteAnRuleSetCondition"), MSGRES.getString(DLG, "GUPConditionDlg.deleteCondition"));
        if (result == 0) {
            model.removeRow(row);
            this.setActionStatus();
        }
    }

    private void editAnAddress() {
        try {
            int index = this.typeCmbBox.getSelectedIndex();
            int addressType = this.indexTypeMap.get(index);
            SortableTableModel model = this.tableModelMap.get(addressType);
            JTable table = this.modelTableMap.get(model);
            int row = table.getSelectedRow();
            if (row == -1) {
                return;
            }
            AddressObject thisObj = (AddressObject)model.getRow(row);
            GUPRuleAddressDlg dlg = new GUPRuleAddressDlg(Manager.getFrame(), MSGRES.getString(DLG, "GUPConditionDlg.title.IPAddressHostName"), true);
            AddressObject newObj = thisObj.getClone();
            dlg.setObject(newObj);
            dlg.setVisible(true);
            if (!dlg.isOk()) {
                return;
            }
            model.setRow(row, newObj);
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString(DLG, "GUPConditionDlg.consoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void addAnRegistryAddress() {
        int index = this.typeCmbBox.getSelectedIndex();
        int addressType = this.indexTypeMap.get(index);
        RegistryDlg dlg = new RegistryDlg(Manager.getFrame(), MSGRES.getString(DLG, "GUPConditionDlg.title.registryKeyValue"), true);
        dlg.setObject(null);
        dlg.setVisible(true);
        if (!dlg.isOk()) {
            return;
        }
        SortableTableModel model = this.tableModelMap.get(addressType);
        model.addRow(dlg.getObject());
    }

    private void deleteAnRegistryAddress() {
        int index = this.typeCmbBox.getSelectedIndex();
        int addressType = this.indexTypeMap.get(index);
        SortableTableModel model = this.tableModelMap.get(addressType);
        JTable table = this.modelTableMap.get(model);
        int row = table.getSelectedRow();
        if (row == -1) {
            return;
        }
        int result = UIUtilities.confirmYesNoOptionDialog(MSGRES.getString(DLG, "GUPConditionDlg.youAreAboutToDeleteAnRuleSetCondition"), MSGRES.getString(DLG, "GUPConditionDlg.deleteCondition"));
        if (result == 0) {
            model.removeRow(row);
            this.setActionStatus();
        }
    }

    private void editAnRegistryAddress() {
        try {
            int index = this.typeCmbBox.getSelectedIndex();
            int addressType = this.indexTypeMap.get(index);
            SortableTableModel model = this.tableModelMap.get(addressType);
            JTable table = this.modelTableMap.get(model);
            int row = table.getSelectedRow();
            if (row == -1) {
                return;
            }
            RegistryDlg dlg = new RegistryDlg(Manager.getFrame(), MSGRES.getString(DLG, "GUPConditionDlg.title.registryKeyValue"), true);
            TableRow thisObj = model.getRow(row);
            RegistryObject newObj = null;
            if (thisObj instanceof RegistryDataObject) {
                newObj = ((RegistryDataObject)thisObj).getClone();
            } else if (thisObj instanceof RegistryKeyObject) {
                newObj = ((RegistryKeyObject)thisObj).getClone();
            } else if (thisObj instanceof RegistryValueObject) {
                newObj = ((RegistryValueObject)thisObj).getClone();
            }
            dlg.setObject(newObj);
            dlg.setVisible(true);
            if (!dlg.isOk()) {
                return;
            }
            model.setRow(row, dlg.getObject());
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString(DLG, "GUPConditionDlg.consoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void typeChanged() {
        String type = (String)this.typeCmbBox.getSelectedItem();
        CardLayout cd = (CardLayout)this.mainPane.getLayout();
        cd.show(this.mainPane, type);
        this.setActionStatus();
    }

    private void updatePanel() {
        int type = this.myObj.getType();
        int index = this.typeIndexMap.get(type);
        this.typeCmbBox.setSelectedIndex(index);
        switch (type) {
            case 0: {
                for (AddressObject addressObject : this.myObj.getAddress()) {
                    this.localAddressModel.addRow(addressObject);
                }
                break;
            }
            case 1: {
                List<RegistryObject> regData = this.myObj.getRegistryData();
                for (int i = 0; i < regData.size(); ++i) {
                    this.registryModel.addRow(regData.get(i));
                }
                break;
            }
            case 2: {
                String allOS = this.myObj.getOperatingSystemCode() == null ? "" : this.myObj.getOperatingSystemCode();
                this.osPanel.setObjestByNames(allOS);
                break;
            }
        }
    }

    private void tableSelectionChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (!lsm.isSelectionEmpty()) {
            this.deleteAddress.setEnabled(true);
            this.editAddress.setEnabled(true);
            this.deleteRegistryAddress.setEnabled(true);
            this.editRegistryAddress.setEnabled(true);
        } else {
            this.deleteAddress.setEnabled(false);
            this.editAddress.setEnabled(false);
            this.deleteRegistryAddress.setEnabled(false);
            this.editRegistryAddress.setEnabled(false);
        }
    }

    private void setActionStatus() {
        int index = this.typeCmbBox.getSelectedIndex();
        int addressType = this.indexTypeMap.get(index);
        SortableTableModel model = this.tableModelMap.get(addressType);
        if (model == null) {
            if (index == 0) {
                this.addAddress.setEnabled(false);
                this.deleteAddress.setEnabled(false);
                this.editAddress.setEnabled(false);
            } else if (index == 1) {
                this.deleteRegistryAddress.setEnabled(false);
                this.editRegistryAddress.setEnabled(false);
                this.addRegistryAddress.setEnabled(false);
            }
            return;
        }
        JTable table = this.modelTableMap.get(model);
        int row = table.getSelectedRow();
        switch (addressType) {
            case 0: {
                this.addAddress.setEnabled(true);
                if (row != -1) {
                    this.deleteAddress.setEnabled(true);
                    this.editAddress.setEnabled(true);
                    break;
                }
                this.deleteAddress.setEnabled(false);
                this.editAddress.setEnabled(false);
                break;
            }
            case 1: {
                this.addRegistryAddress.setEnabled(true);
                if (row != -1) {
                    this.deleteRegistryAddress.setEnabled(true);
                    this.editRegistryAddress.setEnabled(true);
                    break;
                }
                this.deleteRegistryAddress.setEnabled(false);
                this.editRegistryAddress.setEnabled(false);
                break;
            }
        }
    }

    private void showPopup(MouseEvent e) {
        Point p;
        int index = this.typeCmbBox.getSelectedIndex();
        int addressType = this.indexTypeMap.get(index);
        JTable table = (JTable)e.getSource();
        int row = table.rowAtPoint(p = e.getPoint());
        if (row != -1) {
            table.setRowSelectionInterval(row, row);
        }
        if (e.isPopupTrigger()) {
            switch (addressType) {
                case 0: {
                    table.add(this.pLocalAddressMenu);
                    this.pLocalAddressMenu.show(table, e.getX(), e.getY());
                    break;
                }
                case 1: {
                    table.add(this.pRegistryMenu);
                    this.pRegistryMenu.show(table, e.getX(), e.getY());
                    break;
                }
            }
        }
    }

    private void setTypes(String[] types) {
        this.types = types;
    }

    private void initalMap() {
        int size = this.types.length;
        for (int i = 0; i < size; ++i) {
            if (this.types[i].equals(MessageResources.getInstance().getString(DLG, "GUPConditionDlg.computerIPAddressHostName"))) {
                this.typeIndexMap.put(0, i);
                this.indexTypeMap.put(i, 0);
                this.tableModelMap.put(0, this.localAddressModel);
            }
            if (this.types[i].equals(MessageResources.getInstance().getString(DLG, "GUPConditionDlg.registryKeys"))) {
                this.typeIndexMap.put(1, i);
                this.indexTypeMap.put(i, 1);
                this.tableModelMap.put(1, this.registryModel);
            }
            if (!this.types[i].equals(MessageResources.getInstance().getString(DLG, "GUPConditionDlg.operationSystem"))) continue;
            this.typeIndexMap.put(2, i);
            this.indexTypeMap.put(i, 2);
        }
    }

    public void setObject(RuleSetObject obj) {
        this.myObj = obj;
        this.updatePanel();
    }
}

