/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FilenameVerifierDialog
extends DialogBase {
    private JPanel jPanel;
    private JPanel textPanel;
    private JTextField textField;
    private JLabel validationMessage;
    private JLabel description;
    private boolean bVerified = false;
    private static final long serialVersionUID = 1L;

    public FilenameVerifierDialog(String current) {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", StringUtilities.isEmpty((String)current) ? "FilenameVerifierDialog.add.title" : "FilenameVerifierDialog.edit.title"), true, false);
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getJPanel());
        if (current != null) {
            this.getTextField().setText(current);
        }
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    public String getContents() {
        return this.getTextField().getText().trim();
    }

    @Override
    protected boolean isValidate() {
        return this.bVerified;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getDescription(), "North");
            this.jPanel.add((Component)this.getTextPanel(), "Center");
            this.jPanel.add((Component)this.getButtonPanel(), "South");
            this.jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
        return this.jPanel;
    }

    private JLabel getDescription() {
        if (this.description == null) {
            this.description = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "FilenameVerifierDialog.description"), 2);
            this.description.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        }
        return this.description;
    }

    private JPanel getTextPanel() {
        if (this.textPanel == null) {
            this.textPanel = new JPanel();
            this.textPanel.setLayout(new VerticalFlowLayout());
            this.validationMessage = new JLabel("xxx");
            Dimension dim = new Dimension(50, this.validationMessage.getPreferredSize().height * 2);
            this.validationMessage.setPreferredSize(dim);
            this.validationMessage.setMinimumSize(dim);
            this.validationMessage.setText("");
            this.validationMessage.setForeground(Color.RED);
            this.validationMessage.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.textPanel.add(this.validationMessage);
            this.textPanel.add(this.getTextField());
            this.textPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        }
        return this.textPanel;
    }

    private JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField(50);
            this.textField.setInputVerifier(new FilenameInputVerifier());
            this.textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((JComponent)e.getSource()).getInputVerifier().verify((JComponent)e.getSource());
                    FilenameVerifierDialog.this.ok();
                }
            });
        }
        return this.textField;
    }

    private class FilenameInputVerifier
    extends InputVerifier {
        private final char[] badChars = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|'};
        private static final int MAX_PATH = 255;
        private String badCharsRegex;

        public FilenameInputVerifier() {
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            for (char token : this.badChars) {
                if (sb.length() != 1) {
                    sb.append('|');
                }
                sb.append('\\');
                sb.append(token);
            }
            sb.append(')');
            this.badCharsRegex = sb.toString();
        }

        @Override
        public boolean verify(JComponent input) {
            JTextField textField = (JTextField)input;
            String text = textField.getText();
            if (text == null || text.trim().length() == 0) {
                FilenameVerifierDialog.this.validationMessage.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "FilenameVerifierDialog.validation.errBlank"));
                FilenameVerifierDialog.this.bVerified = false;
            } else {
                String[] arr = text.split(this.badCharsRegex, 2);
                if (text.length() > 255) {
                    FilenameVerifierDialog.this.bVerified = false;
                    FilenameVerifierDialog.this.validationMessage.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "FilenameVerifierDialog.validation.errTooLong"));
                } else if (arr.length > 1) {
                    FilenameVerifierDialog.this.bVerified = false;
                    FilenameVerifierDialog.this.validationMessage.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "FilenameVerifierDialog.validation.errBadChars"));
                } else {
                    FilenameVerifierDialog.this.validationMessage.setText("");
                    FilenameVerifierDialog.this.bVerified = true;
                }
            }
            return FilenameVerifierDialog.this.bVerified;
        }
    }
}

