/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.schema.LocationCriteriaCondition;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.common.FileExistPanel;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.dialog.ConditionsPanelBase;
import com.sygate.scm.console.ui.util.DialogBase;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class FileExistConditionsPanel
extends ConditionsPanelBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MRS = MessageResources.getInstance();
    private FileExistPanel editor = new FileExistPanel("Windows");
    private String editorTitle;

    FileExistConditionsPanel(String conditionTitle, String equalMessage, String notEqualMessage, String editorTitle) {
        super(conditionTitle, equalMessage, notEqualMessage);
        this.editorTitle = editorTitle;
    }

    @Override
    String getCellText(Object value) {
        return ((LocationCriteriaCondition)value).getCondition();
    }

    @Override
    Object[] getConditions() {
        int count = this.listModel.size();
        Object[] conditions = null;
        conditions = new LocationCriteriaCondition[count];
        for (int index = 0; index < count; ++index) {
            conditions[index] = this.listModel.get(index);
        }
        return conditions;
    }

    @Override
    void showEditor(boolean isNew) {
        new EditorDialog(Manager.getFrame(), this, this.editorTitle, true, isNew);
    }

    private class EditorDialog
    extends DialogBase {
        private static final long serialVersionUID = 1L;
        boolean isNew;

        public EditorDialog(JFrame parent, JPanel relativePanel, String title, boolean modal, boolean isNew) {
            super(parent, title, modal);
            this.isNew = isNew;
            this.initialize(relativePanel);
        }

        private void initialize(JPanel relativePanel) {
            Container container = this.getContentPane();
            GridBagConstraints constraints = new GridBagConstraints();
            JPanel centralpanel = new JPanel(new GridBagLayout());
            constraints.anchor = 17;
            constraints.insets = new Insets(3, 15, 3, 15);
            constraints.weightx = 1.0;
            constraints.gridy = 1;
            constraints.fill = 1;
            centralpanel.add((Component)FileExistConditionsPanel.this.editor, constraints);
            container.add(centralpanel);
            if (!this.isNew) {
                LocationCriteriaCondition fileName = (LocationCriteriaCondition)FileExistConditionsPanel.this.conditionsList.getSelectedValue();
                FileExistConditionsPanel.this.editor.setFileName(fileName.getCondition());
            }
            container.add((Component)this.getButtonPanel(), "South");
            this.setSize(480, 320);
            this.setLocationRelativeTo(relativePanel);
            this.setVisible(true);
        }

        @Override
        protected boolean isHelpButtonShown() {
            return false;
        }

        @Override
        protected boolean isValidate() {
            try {
                return FileExistConditionsPanel.this.editor.validateInput();
            }
            catch (GUICheckException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AlSignatureConditionDlg.error"), 0);
                return false;
            }
        }

        @Override
        protected void commit() {
            String fileName = FileExistConditionsPanel.this.editor.getFileName();
            if (this.isNew) {
                LocationCriteriaCondition condition = new LocationCriteriaCondition();
                condition.setCondition(fileName);
                FileExistConditionsPanel.this.addCondition(condition);
            } else {
                LocationCriteriaCondition condition = (LocationCriteriaCondition)FileExistConditionsPanel.this.conditionsList.getSelectedValue();
                condition.setCondition(fileName);
            }
            this.dispose();
            FileExistConditionsPanel.this.conditionsList.updateUI();
        }
    }
}

