/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.TamperProtectionPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.ExternalCommunicationObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.dialog.CloudSettingsPanel;
import com.sygate.scm.console.ui.policy.dialog.PrivateCloudPanel;
import com.sygate.scm.console.ui.policy.dialog.SubmissionPanel;
import com.sygate.scm.console.ui.policy.lu.MacProxyServerPanel;
import com.sygate.scm.console.ui.policy.lu.ProxyServerPanel;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.CodeManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;

public class ExternalCommunicationPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private SubmissionPanel submissionPanel;
    private PrivateCloudPanel privateCloudPanel;
    private CloudSettingsPanel cloudSettingsPanel;
    public static final int MACPANEL_INDEX = 2;
    private ProxyServerPanel proxyServerPanel;
    private MacProxyServerPanel macProxyServerPanel;
    private final JTabbedPane extCommSettingTabPane;
    private TamperProtectionPolicy tamperProtectionPolicy;
    private ExternalCommunicationObject extComObj;
    private final boolean isSbproduct = LicenseObject.getInstance().isSBProduct();
    private final boolean isAtpenabled;
    private boolean isCloudEnrolled = CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId());

    public ExternalCommunicationPanel() {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(600, 740));
        this.extCommSettingTabPane = new JTabbedPane();
        this.extCommSettingTabPane.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "CommunicationPanel.submissionsSettings"), this.getLocationIndependantSubmissionPanel());
        this.isAtpenabled = CodeManager.isVisible(CodeManager.FeatureType.ATP);
        if (this.isAtpenabled) {
            this.extCommSettingTabPane.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "CommunicationPanel.privateCloudSettings"), this.getLocationIndependantPrivateCloudPanel());
        }
        if (!this.isSbproduct) {
            this.extCommSettingTabPane.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ExternalCommunicationPanel.proxySettings"), this.getLocationIndependentProxyServerPanel());
            this.extCommSettingTabPane.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ExternalCommunicationPanel.proxySettingsMac"), this.getLocationIndependentProxyServerPanelMac());
        }
        if (this.isCloudEnrolled) {
            this.extCommSettingTabPane.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "CloudSettingsPanel.cloudSettings"), this.getCloudSettingsPanel());
        }
        this.add((Component)this.extCommSettingTabPane, "North");
    }

    private JPanel getLocationIndependantSubmissionPanel() {
        this.submissionPanel = new SubmissionPanel();
        return this.submissionPanel;
    }

    private JPanel getCloudSettingsPanel() {
        this.cloudSettingsPanel = new CloudSettingsPanel();
        return this.cloudSettingsPanel;
    }

    private JPanel getLocationIndependantPrivateCloudPanel() {
        this.privateCloudPanel = new PrivateCloudPanel();
        return this.privateCloudPanel;
    }

    private JPanel getLocationIndependentProxyServerPanel() {
        this.proxyServerPanel = new ProxyServerPanel();
        return this.proxyServerPanel;
    }

    private JPanel getLocationIndependentProxyServerPanelMac() {
        this.macProxyServerPanel = new MacProxyServerPanel(this.proxyServerPanel);
        return this.macProxyServerPanel;
    }

    public ExternalCommunicationObject getExternalCommunicationObject() {
        return this.extComObj;
    }

    public void setObject(ExternalCommunicationObject commObj, TamperProtectionPolicy tamperProtectionPolicy, String locationId, SemClientGroup semClientGrp, boolean isLocation) {
        boolean isCloudSettingsAvailable;
        this.extComObj = commObj;
        this.tamperProtectionPolicy = tamperProtectionPolicy;
        String groupId = null;
        if (semClientGrp != null) {
            groupId = semClientGrp.getId() != null ? semClientGrp.getId() : null;
        }
        String groupOrLocationId = isLocation ? locationId : groupId;
        this.submissionPanel.setObject(this.extComObj);
        if (this.isAtpenabled) {
            this.privateCloudPanel.setObject(this.extComObj, groupOrLocationId);
        }
        if (this.isCloudEnrolled && !(isCloudSettingsAvailable = this.cloudSettingsPanel.setObject(this.extComObj, semClientGrp))) {
            this.extCommSettingTabPane.remove(this.cloudSettingsPanel);
        }
        if (!this.isSbproduct) {
            this.proxyServerPanel.setObject(this.extComObj);
            this.macProxyServerPanel.setObject(this.extComObj);
        }
    }

    public boolean saveChanges() {
        this.submissionPanel.save();
        if (this.isAtpenabled) {
            if (!this.privateCloudPanel.isValidate()) {
                return false;
            }
            this.privateCloudPanel.save();
        }
        if (!this.isSbproduct) {
            if (!this.proxyServerPanel.isValidate()) {
                return false;
            }
            this.proxyServerPanel.save();
            if (!this.macProxyServerPanel.isValidate()) {
                return false;
            }
            this.macProxyServerPanel.save();
        }
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        Component panel;
        if (this.extCommSettingTabPane != null && (panel = this.extCommSettingTabPane.getSelectedComponent()) instanceof ContentSensitiveHelpPage) {
            ContentSensitiveHelpPage help = (ContentSensitiveHelpPage)((Object)panel);
            return help.getContentSensitiveHelpToken();
        }
        return null;
    }

    public TamperProtectionPolicy getTamperProtectionPolicy() {
        return this.tamperProtectionPolicy;
    }

    public void setReadOnly() {
        this.submissionPanel.setReadOnly();
        if (this.isAtpenabled) {
            this.privateCloudPanel.setReadOnly();
        }
        if (!this.isSbproduct) {
            this.proxyServerPanel.setReadOnly();
            this.macProxyServerPanel.setReadOnly();
        }
    }
}

