/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.schema.OpDevice;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.UsbDeviceHandler;
import com.sygate.scm.console.logicobject.DeviceObject;
import com.sygate.scm.console.ui.policy.common.ButtonPane;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DeviceSelectDlg
extends JDialog {
    private static final long serialVersionUID = 1L;
    private ArrayList<DeviceObject> selectedDeviceList;
    private ArrayList<DeviceObject> intDeviceList;
    private JTable deviceTable;
    private JScrollPane scrollPane;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private boolean isCancel;
    private String[] tableColumnName;
    private int[] tableColumnMap;
    private float[] tableColumnWidth;
    private String selectType;
    private int selectionModel;
    private transient ListSelectionListener tableSelectionListener;

    public DeviceSelectDlg(String sTitle, String[] tableColumnName, int[] tableColumnMap, float[] tableColumnWidth, ArrayList<DeviceObject> intList, String selectType, int selectionModel) {
        super(Manager.getFrame(), sTitle, true);
        this.intDeviceList = intList;
        this.tableColumnMap = tableColumnMap == null ? null : (int[])tableColumnMap.clone();
        this.tableColumnName = tableColumnName == null ? null : (String[])tableColumnName.clone();
        this.tableColumnWidth = tableColumnWidth == null ? null : (float[])tableColumnWidth.clone();
        this.selectType = selectType;
        if (!("Class".equals(selectType) || "Instance".equals(selectType) || "ALL".equals(selectType))) {
            selectType = "ALL";
        }
        this.selectionModel = selectionModel;
        this.init();
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getScrollPaneTable(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setSize(new Dimension(600, 500));
        this.setDefaultCloseOperation(2);
        UiUtilities.centerComponent((Component)this);
        this.refreshData();
        this.okButton.setEnabled(false);
        this.setVisible(true);
    }

    private JScrollPane getScrollPaneTable() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
        }
        if (this.deviceTable == null) {
            this.deviceTable = new StripesTable();
            SortableTableModel model = new SortableTableModel();
            model.setColumnNames(this.tableColumnName);
            model.setColumnMapping(this.tableColumnMap);
            model.addMouseListenerToHeaderInTable(this.deviceTable);
            this.deviceTable.setModel(model);
            this.deviceTable.getSelectionModel().addListSelectionListener(this.getTableSelectionListener());
            this.deviceTable.getSelectionModel().setSelectionMode(this.selectionModel);
            UIUtilities.resizeColumns(this.deviceTable, this.tableColumnWidth, this.scrollPane.getWidth());
        }
        UiUtilities.setupScrollPane((JScrollPane)this.scrollPane, (JTable)this.deviceTable);
        return this.scrollPane;
    }

    protected void refreshData() {
        try {
            SortableTableModel model = (SortableTableModel)this.deviceTable.getModel();
            model.removeAll();
            ArrayList<OpDevice> list = UsbDeviceHandler.getPooledDevicesByPlatform(OpDevice.WINDOWS);
            for (int i = 0; i < list.size(); ++i) {
                DeviceObject deviceObject = new DeviceObject(list.get(i));
                String id = deviceObject.getId();
                String deviceInsanceId = deviceObject.getDeviceInstanceId();
                if (deviceInsanceId == null) {
                    deviceInsanceId = "";
                }
                if (this.selectType.equals("Class") && !"".equals(deviceInsanceId) || this.selectType.equals("Instance") && "".equals(deviceInsanceId)) continue;
                boolean find = false;
                if (this.intDeviceList != null) {
                    for (int i2 = 0; i2 < this.intDeviceList.size(); ++i2) {
                        DeviceObject deviceObjectInt = this.intDeviceList.get(i2);
                        String id2 = deviceObjectInt.getId();
                        if (!id.equals(id2)) continue;
                        find = true;
                        break;
                    }
                }
                if (find) continue;
                model.addRow(deviceObject);
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.okButton = new JButton(UIText.get(3584));
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceSelectDlg.this.this_okAction(e);
                    DeviceSelectDlg.this.dispose();
                }
            });
            this.cancelButton = new JButton(UIText.get(512));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceSelectDlg.this.isCancel = true;
                    DeviceSelectDlg.this.dispose();
                }
            });
            JButton[] buttons = new JButton[]{this.okButton, this.cancelButton};
            this.buttonPanel = new ButtonPane(buttons, 4);
        }
        return this.buttonPanel;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    private void this_okAction(ActionEvent e) {
        try {
            if (this.selectedDeviceList == null) {
                this.selectedDeviceList = new ArrayList();
            }
            int[] iSelectedRow = this.deviceTable.getSelectedRows();
            for (int i = 0; i < iSelectedRow.length; ++i) {
                String deviceName = String.valueOf(this.deviceTable.getValueAt(iSelectedRow[i], 0));
                DeviceObject deviceObject = UsbDeviceHandler.getDeviceByName(deviceName);
                if (deviceObject == null) continue;
                this.selectedDeviceList.add(deviceObject);
            }
            this.isCancel = false;
            this.dispose();
        }
        catch (Exception e1) {
            LoggerUtilities.logException((Throwable)e1);
            JOptionPane.showMessageDialog(Manager.getFrame(), e1.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.osprotect.osprotect", "DeviceSelectDlg.error.title"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private ListSelectionListener getTableSelectionListener() {
        if (this.tableSelectionListener == null) {
            this.tableSelectionListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    DeviceSelectDlg.this.okButton.setEnabled(true);
                }
            };
        }
        return this.tableSelectionListener;
    }

    public ArrayList<DeviceObject> getSelection() {
        if (this.selectedDeviceList == null && AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            this.selectedDeviceList = new ArrayList();
        }
        return this.selectedDeviceList;
    }
}

