/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.UserInterfaceObject;
import com.sygate.scm.console.ui.policy.dialog.AgentGUIDlg;
import com.sygate.scm.console.ui.policy.dialog.ArbitrationSettingDlg;
import com.sygate.scm.console.ui.policy.dialog.PolicyDialog;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class ControlModeDlg
extends PolicyDialog {
    private static final long serialVersionUID = 1L;
    private boolean isCancel = true;
    private boolean isReadOnly = false;
    private boolean isInheritReadOnly;
    private UserInterfaceObject uiObj = null;
    private JPanel jContentPane = null;
    private JPanel dlgPanel = null;
    private JRadioButton clientRdBtn = null;
    private JTextArea jTextArea = null;
    private JRadioButton powerRdBtn = null;
    private JTextArea jTextField = null;
    private JRadioButton serverRdBtn = null;
    private JTextArea jTextField1 = null;
    private JButton arbiBtn = null;
    private JButton agentGUIBtn = null;
    private JTextArea dlgDescTextArea = null;

    public ControlModeDlg(JFrame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.initialize();
    }

    private void initialize() {
        this.getContentPane().add((Component)this.getDlgPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setResizable(true);
    }

    private JPanel getDlgPanel() {
        if (this.dlgPanel == null) {
            this.dlgPanel = new JPanel();
            this.dlgPanel.setLayout(new GridBagLayout());
            this.dlgPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            this.dlgDescTextArea = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ControlModeDlg.desc"));
            this.dlgPanel.add((Component)this.dlgDescTextArea, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 10, 5), 30, 0));
            this.dlgPanel.add((Component)this.getServerRdBtn(), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(15, 10, 0, 0), 0, 0));
            this.dlgPanel.add((Component)this.getAgentGUIBtn(), new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 20), 0, 0));
            this.dlgPanel.add((Component)this.getJTextField1(), new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 33, 0, 20), 0, 10));
            this.dlgPanel.add((Component)this.getClientRdBtn(), new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 2, new Insets(15, 10, 0, 20), 0, 0));
            this.dlgPanel.add((Component)this.getJTextArea(), new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 17, 2, new Insets(10, 33, 0, 20), 0, 10));
            this.dlgPanel.add((Component)this.getPowerRdBtn(), new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 2, new Insets(15, 10, 0, 0), 0, 0));
            this.dlgPanel.add((Component)this.getArbiBtn(), new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 20), 0, 0));
            this.dlgPanel.add((Component)this.getJTextField(), new GridBagConstraints(0, 6, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 33, 0, 20), 0, 10));
            ButtonGroup group = new ButtonGroup();
            group.add(this.clientRdBtn);
            group.add(this.serverRdBtn);
            group.add(this.powerRdBtn);
        }
        return this.dlgPanel;
    }

    private JRadioButton getClientRdBtn() {
        if (this.clientRdBtn == null) {
            this.clientRdBtn = new JRadioButton();
            this.clientRdBtn.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ControlModeDlg.clientControl"));
            this.clientRdBtn.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlModeDlg.this.setButtonStatus();
                }
            });
        }
        return this.clientRdBtn;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new DescriptionTextArea();
            this.jTextArea.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ControlModeDlg.underClientControlEndUsersHave"));
        }
        return this.jTextArea;
    }

    private JRadioButton getPowerRdBtn() {
        if (this.powerRdBtn == null) {
            this.powerRdBtn = new JRadioButton();
            this.powerRdBtn.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ControlModeDlg.powerUser"));
            this.powerRdBtn.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlModeDlg.this.setButtonStatus();
                }
            });
        }
        return this.powerRdBtn;
    }

    private JTextArea getJTextField() {
        if (this.jTextField == null) {
            this.jTextField = new DescriptionTextArea();
            this.jTextField.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ControlModeDlg.powerUsersHaveSomeControlOverTheSecuritySettings"));
        }
        return this.jTextField;
    }

    private JRadioButton getServerRdBtn() {
        if (this.serverRdBtn == null) {
            this.serverRdBtn = new JRadioButton();
            this.serverRdBtn.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ControlModeDlg.serverControl"));
            this.serverRdBtn.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlModeDlg.this.setButtonStatus();
                }
            });
        }
        return this.serverRdBtn;
    }

    private JTextArea getJTextField1() {
        if (this.jTextField1 == null) {
            this.jTextField1 = new DescriptionTextArea();
            this.jTextField1.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ControlModeDlg.underSeverControlEndUsersHaveLimitedControl"));
        }
        return this.jTextField1;
    }

    private JButton getArbiBtn() {
        if (this.arbiBtn == null) {
            this.arbiBtn = new JButton();
            this.arbiBtn.setText(UIText.get(523));
            this.arbiBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlModeDlg.this.arbutrationBtnIsClicked();
                }
            });
        }
        return this.arbiBtn;
    }

    private JButton getAgentGUIBtn() {
        if (this.agentGUIBtn == null) {
            this.agentGUIBtn = new JButton();
            this.agentGUIBtn.setText(UIText.get(523));
            this.agentGUIBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlModeDlg.this.agentGUIBtnIsClicked();
                }
            });
        }
        return this.agentGUIBtn;
    }

    private void arbutrationBtnIsClicked() {
        try {
            ArbitrationSettingDlg dlg = new ArbitrationSettingDlg(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ControlModeDlg.arbitrationRuleSetting"), true);
            UserInterfaceObject newObj = this.uiObj.getClone();
            dlg.setObject(newObj);
            if (this.isReadOnly) {
                dlg.setReadOnly(this.isInheritReadOnly);
            }
            dlg.setVisible(true);
            if (dlg.isOk()) {
                this.uiObj.setUserInterface(newObj);
            }
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ControlModeDlg.consoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void agentGUIBtnIsClicked() {
        try {
            AgentGUIDlg dlg = new AgentGUIDlg((JFrame)Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ControlModeDlg.agentGUISetting"), true, this.getMode());
            UserInterfaceObject newObj = this.uiObj.getClone();
            dlg.setObject(newObj);
            if (this.isReadOnly) {
                dlg.setReadOnly(this.isInheritReadOnly);
            }
            dlg.setVisible(true);
            if (dlg.isOk()) {
                this.uiObj.setUserInterface(newObj);
            }
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ControlModeDlg.consoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    @Override
    protected void commit() {
        this.uiObj.setMode(this.getMode());
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_computersnusers_policies_advsettings_sc_edit";
    }

    @Override
    public void setReadOnly(boolean isInherit) {
        JPanel readOnlyTitle = this.getReadOnlyTitlePane(isInherit);
        this.jContentPane = new JPanel(new BorderLayout());
        this.jContentPane.add((Component)readOnlyTitle, "North");
        this.isReadOnly = true;
        this.isInheritReadOnly = isInherit;
        this.getContentPane().add((Component)this.jContentPane, "North");
        UIUtilities.setContainerStatus(this.dlgPanel, false);
        this.setButtonStatus();
        this.arbiBtn.setEnabled(false);
        this.agentGUIBtn.setEnabled(false);
        this.jBOk.setEnabled(false);
        this.jBOk.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ControlModeDlg.theControlModeSettingsAreInheritedYouCannotChange"));
        int dlgWidth = this.getSize().width;
        int dlgHeight = this.getSize().height;
        this.setSize(dlgWidth, dlgHeight + 50);
    }

    private JPanel getReadOnlyTitlePane(boolean isInherit) {
        String desc = isInherit ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ControlModeDlg.theControlModeSettingsAreInheritedNoModificationAllowed") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ControlModeDlg.readOnlyGroupNoModificationAllowed");
        JPanel pane = new JPanel(new BorderLayout());
        DescriptionTextArea descArea = new DescriptionTextArea(true);
        descArea.setText(desc);
        pane.setBackground(UIColorUtilities.WARNING_BACKGROUND);
        pane.add(descArea);
        descArea.setBorder(BorderFactory.createEmptyBorder(3, 4, 5, 4));
        return pane;
    }

    @Override
    public void setObject(AbstractUIObject uiObj) {
        this.uiObj = (UserInterfaceObject)uiObj;
        this.updatePanel();
    }

    private void updatePanel() {
        int mode = this.uiObj.getMode();
        switch (mode) {
            case 1: {
                this.serverRdBtn.setSelected(true);
                break;
            }
            case 0: {
                this.clientRdBtn.setSelected(true);
                break;
            }
            case 2: {
                this.powerRdBtn.setSelected(true);
                break;
            }
        }
        this.setButtonStatus();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    private void setButtonStatus() {
        if (this.clientRdBtn.isSelected()) {
            this.arbiBtn.setEnabled(false);
            this.agentGUIBtn.setEnabled(false);
        } else if (this.serverRdBtn.isSelected()) {
            this.agentGUIBtn.setEnabled(true);
            this.arbiBtn.setEnabled(false);
        } else {
            this.arbiBtn.setEnabled(true);
            this.agentGUIBtn.setEnabled(false);
        }
    }

    public int getMode() {
        int mode = 1;
        if (this.clientRdBtn.isSelected()) {
            mode = 0;
        } else if (this.powerRdBtn.isSelected()) {
            mode = 2;
        }
        return mode;
    }
}

