/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class ConditionsPanelBase
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JRadioButton equalRadioButton;
    private JRadioButton notEqualRadioButton;
    JList<Object> conditionsList;
    DefaultListModel<Object> listModel;
    private JButton addButton;
    private JButton deleteButton;
    private JButton editButton;
    private static final MessageResources MRS = MessageResources.getInstance();

    ConditionsPanelBase(String conditionTitle, String equalMessage, String notEqualMessage) {
        final AbstractAction addAction = new AbstractAction(UIText.get(5)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                ConditionsPanelBase.this.showEditor(true);
            }
        };
        final AbstractAction deleteAction = new AbstractAction(UIText.get(769)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                int res = UIUtilities.confirmYesNoOptionDialog(MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AlSignatureConditionDlg.youAreAboutToDeleteAnAddressCondition"), MRS.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AlSignatureConditionDlg.deleteLocation"));
                if (res == 0) {
                    ConditionsPanelBase.this.listModel.removeElementAt(ConditionsPanelBase.this.conditionsList.getSelectedIndex());
                }
            }
        };
        final AbstractAction editAction = new AbstractAction(UIText.get(1024)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                ConditionsPanelBase.this.showEditor(false);
            }
        };
        this.setLayout(new BorderLayout());
        if (equalMessage.trim().length() != 0) {
            this.equalRadioButton = new JRadioButton(equalMessage);
            this.equalRadioButton.setSelected(true);
            this.notEqualRadioButton = new JRadioButton(notEqualMessage);
            ButtonGroup radioButtonGroup = new ButtonGroup();
            radioButtonGroup.add(this.equalRadioButton);
            radioButtonGroup.add(this.notEqualRadioButton);
            JPanel radioButtonPanel = new JPanel(new GridLayout(2, 1));
            radioButtonPanel.add(this.equalRadioButton);
            radioButtonPanel.add(this.notEqualRadioButton);
            this.add((Component)radioButtonPanel, "North");
        }
        this.listModel = new DefaultListModel();
        this.conditionsList = new JList<Object>(this.listModel);
        this.conditionsList.setSelectionMode(0);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(0, 10, 4, 10);
        constraints.anchor = 11;
        constraints.weighty = 0.0;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.gridy = 0;
        this.addButton = new JButton(addAction);
        buttonPanel.add((Component)this.addButton, constraints);
        constraints.insets.top = 4;
        constraints.gridy = 1;
        this.editButton = new JButton(editAction);
        buttonPanel.add((Component)this.editButton, constraints);
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        this.deleteButton = new JButton(deleteAction);
        buttonPanel.add((Component)this.deleteButton, constraints);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), conditionTitle));
        centerPanel.add(new JScrollPane(this.conditionsList));
        centerPanel.add((Component)buttonPanel, "East");
        this.add(centerPanel);
        this.conditionsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                if (ev.getClickCount() == 2) {
                    ConditionsPanelBase.this.showEditor(false);
                }
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                ConditionsPanelBase.this.showMouseClicked(evt, addAction, deleteAction, editAction);
            }
        });
        this.conditionsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting()) {
                    ConditionsPanelBase.this.updateEnabledState();
                }
            }
        });
        DefaultListCellRenderer listCellRenderer = new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel renderer = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                String text = ConditionsPanelBase.this.getCellText(value);
                renderer.setText(text);
                return renderer;
            }
        };
        this.conditionsList.setCellRenderer(listCellRenderer);
        this.updateEnabledState();
    }

    abstract String getCellText(Object var1);

    private void showMouseClicked(MouseEvent evt, Action addAction, Action deleteAction, Action editAction) {
        if ((evt.getModifiers() & 4) == 0) {
            return;
        }
        JPopupMenu menu = new JPopupMenu();
        menu.add(addAction);
        menu.add(editAction);
        menu.add(deleteAction);
        boolean enable = this.conditionsList.getSelectedIndex() > -1;
        editAction.setEnabled(enable);
        deleteAction.setEnabled(enable);
        menu.show(this.conditionsList, evt.getX(), evt.getY());
    }

    boolean isEqual() {
        return this.equalRadioButton.isSelected();
    }

    void setEqualSelected(boolean isSelect) {
        this.equalRadioButton.setSelected(isSelect);
        this.notEqualRadioButton.setSelected(!isSelect);
    }

    abstract Object[] getConditions();

    void setConditions(Object[] conditions) {
        this.listModel.clear();
        if (conditions != null) {
            for (int index = 0; index < conditions.length; ++index) {
                this.listModel.addElement(conditions[index]);
            }
        }
        this.conditionsList.updateUI();
        this.updateEnabledState();
    }

    void addCondition(Object newCondition) {
        this.listModel.addElement(newCondition);
        this.conditionsList.updateUI();
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        boolean enable = this.conditionsList.getSelectedIndex() > -1;
        this.deleteButton.setEnabled(enable);
        this.editButton.setEnabled(enable);
    }

    abstract void showEditor(boolean var1);
}

