/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.schema.TamperProtectionPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AutoLocationObject;
import com.sygate.scm.console.logicobject.CommunicationObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.ServerListObject;
import com.sygate.scm.console.logicobject.ServerListPool;
import com.sygate.scm.console.ui.policy.PolicyHelper;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.JPanelGB;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class CommunicationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int TIME_AMOUNT_CHAR_WIDTH = 7;
    private static final String[] TIMEUNITS = new String[]{CommunicationPanel._getString("CommunicationPanel.hours"), CommunicationPanel._getString("CommunicationPanel.minutes")};
    private static final int[] UNITVALUE = new int[]{3600, 60};
    private boolean isReadOnly = false;
    private boolean isConnectToServer = true;
    private CommunicationObject comObj;
    private AutoLocationObject autoLocObj;
    private String curLocId;
    JPanelGB mainPanel = new JPanelGB();
    JCheckBox enableCommCB = new JCheckBox(CommunicationPanel._getString("CommunicationPanel.enableCommunication"));
    JPanelGB topIndentPanel = new JPanelGB();
    JLabel cautionL = new JLabel(CommunicationPanel._getString("CommunicationPanel.caution"));
    DescriptionTextArea enableCommTA = new DescriptionTextArea(CommunicationPanel._getString("CommunicationPanel.descriptionOfEnableCommunication"));
    JPanelGB policyManagerListPanel = new JPanelGB();
    JComboBox<ObjInfoObject> policyManagerCB = new JComboBox();
    JPanelGB downloadPanel = new JPanelGB();
    JCheckBox enableDownloadCB = new JCheckBox(CommunicationPanel._getString("CommunicationPanel.enableDownloading"));
    JPanelGB downloadIndentPanel = new JPanelGB();
    JRadioButton pushModeRB = new JRadioButton(CommunicationPanel._getString("CommunicationPanel.pushMode"));
    DescriptionTextArea pushModeTA = new DescriptionTextArea(CommunicationPanel._getString("CommunicationPanel.descriptionOfPushMode"));
    JRadioButton pullModeRB = new JRadioButton(CommunicationPanel._getString("CommunicationPanel.pullMode"));
    JLabel heartbeatL = new JLabel(CommunicationPanel._getString("CommunicationPanel.heartbeat"));
    private static final int MAX_MINUTES_FOR_HEARTBEAT = 2880;
    private SpinnerNumberModel heartbeatNumberModel = new SpinnerNumberModel(5, 1, 2880, 1);
    private JSpinner heartbeatTF = new JSpinner(this.heartbeatNumberModel);
    JComboBox<String> heartbeatCBB = new JComboBox<String>(TIMEUNITS);
    DescriptionTextArea pullModeTA = new DescriptionTextArea(CommunicationPanel._getString("CommunicationPanel.descriptionOfPullMode"));
    JPanelGB uploadPanel = new JPanelGB();
    JCheckBox learnedAppsCB = new JCheckBox(CommunicationPanel._getString("CommunicationPanel.uploadLearnedApplications"));
    JLabel logHeartbeatL = new JLabel(CommunicationPanel._getString("CommunicationPanel.logUploadingHeartbeat"));
    JTextField logHeartbeatTF = new JTextField(7);
    JComboBox<String> logHeartbeatCBB = new JComboBox<String>(TIMEUNITS);
    JLabel opStateHeartbeatL = new JLabel(CommunicationPanel._getString("CommunicationPanel.operationStateUploadingHeartbeat"));
    JTextField opStateHeartbeatTF = new JTextField(7);
    JComboBox<String> opStateHeartbeatCBB = new JComboBox<String>(TIMEUNITS);
    JLabel cmdStateHeartbeatL = new JLabel(CommunicationPanel._getString("CommunicationPanel.commandStateUploadingHeartbeat"));
    JTextField cmdStateHeartbeatTF = new JTextField(7);
    JComboBox<String> cmdStateHeartbeatCBB = new JComboBox<String>(TIMEUNITS);
    JLabel heartbeatUploadPollL = new JLabel(CommunicationPanel._getString("CommunicationPanel.HeartbeatUploadPullModeDownload"));
    DescriptionTextArea heartbeatUploadPollLDesc = new DescriptionTextArea(CommunicationPanel._getString("CommunicationPanel.HeartbeatUploadPullModeDownloadDesc"));
    private String NO_GROUP_DISCONNECT = CommunicationPanel._getString("CommunicationPanel.youCanOnlydisconnectAgentsFromThePolicyManager");
    JPanelGB heartbeatPanel = new JPanelGB();
    JPanelGB descriptionPanel = new JPanelGB();
    DescriptionTextArea descriptionText = new DescriptionTextArea(CommunicationPanel._getString("CommunicationPanel.uploadLearnedApplicationsDescription"));
    DescriptionTextArea managementServerDescText = new DescriptionTextArea(CommunicationPanel._getString("ServerListEditorDlg.desc"));
    protected DefaultComboBoxModel<ObjInfoObject> serverModel = new DefaultComboBoxModel();
    private ServerListPool pool;
    private DescriptionTextArea randomDescText = new DescriptionTextArea(CommunicationPanel._getString("CommunicationPanel.label.randomizationDesc"));
    private JCheckBox jChkRandomize = new JCheckBox(CommunicationPanel._getString("CommunicationPanel.checkbox.randomize"));
    private SpinnerNumberModel randomRangeNumberModel = new SpinnerNumberModel(5, 1, 60, 1);
    private JSpinner jSpnRandomRange = new JSpinner(this.randomRangeNumberModel);
    private JComboBox<String> randomFrequencyCBB = new JComboBox<String>(TIMEUNITS);
    private JPanel randomPanel = new JPanel();
    private JPanelGB rememberStatusPanel = new JPanelGB();
    private DescriptionTextArea rememberStatusDescText = new DescriptionTextArea(CommunicationPanel._getString("CommunicationPanel.label.rememberCummunicationStatus.description"));
    JCheckBox rememberGroupCB = new JCheckBox(CommunicationPanel._getString("CommunicationPanel.checkbox.rememberCurrentGroup"));
    JCheckBox rememberPolicyModeCB = new JCheckBox(CommunicationPanel._getString("CommunicationPanel.checkbox.rememberCurrentPolicyMode"));
    private JCheckBox jcbAllowClientUploadCriticalEventImmediately = new JCheckBox(CommunicationPanel._getString("CommunicationPanel.allowClientUploadCriticalEventImmediately"));

    public CommunicationPanel() {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        JPanelGB commSettingTabPane = this.getMainPanel();
        this.add((Component)commSettingTabPane, "North");
        this.setData();
    }

    private JPanelGB getMainPanel() {
        this.enableCommCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (CommunicationPanel.this.enableCommCB.isSelected()) {
                    CommunicationPanel.this.updateAllUI();
                } else {
                    boolean canAllowDisable = CommunicationPanel.this.isCommunicationDisableAllowed();
                    if (canAllowDisable) {
                        CommunicationPanel.this.updateAllUI();
                    } else if (CommunicationPanel.this.isConnectToServer) {
                        CommunicationPanel.this.enableCommCB.setSelected(true);
                    } else {
                        CommunicationPanel.this.enableCommCB.setSelected(false);
                    }
                }
            }
        });
        this.cautionL.setForeground(Color.red);
        this.cautionL.setFont(this.cautionL.getFont().deriveFont(1));
        this.mainPanel.constrain(this.enableCommCB, 0, 0, 1, 1, 18, 2, 0, 5, 0, 5);
        this.mainPanel.constrain(this.topIndentPanel, 0, 1, 1, 1, 18, 2, 0, 5, 0, 5);
        this.topIndentPanel.constrain(this.cautionL, 0, 0, 1, 1, 18, 0, 0, 2, 0, 5);
        this.topIndentPanel.constrain(this.enableCommTA, 1, 0, 1, 1, 18, 2, 0, 5, 0, 0);
        this.topIndentPanel.constrain(this.getPolicyManagerListPanel(), 0, 1, 2, 1, 18, 2, 0, 0, 0, 0);
        this.topIndentPanel.constrain(this.getDownloadPanel(), 0, 2, 2, 1, 18, 2, 0, 0, 0, 0);
        this.topIndentPanel.constrain(this.getUploadPanel(), 0, 3, 2, 1, 18, 2, 0, 0, 0, 0);
        this.topIndentPanel.constrain(this.getHeartbeatPanel(), 0, 4, 3, 1, 18, 2, 0, 0, 0, 0);
        this.topIndentPanel.constrain(this.getRandomizationPanel(), 0, 5, 3, 1, 18, 2, 0, 0, 0, 0);
        this.topIndentPanel.constrain(this.getRememberStatusPanel(), 0, 6, 3, 1, 18, 2, 0, 0, 0, 0);
        return this.mainPanel;
    }

    private JPanelGB getPolicyManagerListPanel() {
        this.policyManagerListPanel.setBorder(new TitledBorder(CommunicationPanel._getString("CommunicationPanel.policyManagerList")));
        this.policyManagerCB.setEditable(false);
        JPanelGB p = this.policyManagerListPanel;
        p.constrain(this.managementServerDescText, 0, 0, 1, 1, 17, 2, 0, 5, 0, 5);
        p.constrain(this.policyManagerCB, 0, 1, 1, 1, 17, 2, 0, 5, 0, 5);
        return this.policyManagerListPanel;
    }

    private JPanelGB getDownloadPanel() {
        this.downloadPanel.setBorder(new TitledBorder(CommunicationPanel._getString("CommunicationPanel.download")));
        UIUtilities.groupButtons(this.pushModeRB, this.pullModeRB);
        this.enableDownloadCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommunicationPanel.this.updateDownloadUI(CommunicationPanel.this.enableCommCB.isSelected());
            }
        });
        ActionListener downloadModeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommunicationPanel.this.updateDownloadUI(CommunicationPanel.this.enableCommCB.isSelected());
            }
        };
        this.pushModeRB.addActionListener(downloadModeListener);
        this._updateDownloadPanel();
        this.downloadIndentPanel.constrain(this.pushModeRB, 0, 1, 4, 1, 18, 0, 0, 0, 0, 0);
        this.downloadIndentPanel.constrain(this.pushModeTA, 0, 2, 4, 1, 18, 2, 0, 22, 0, 0);
        this.downloadIndentPanel.constrain(this.pullModeRB, 0, 3, 1, 1, 17, 2, 0, 0, 0, 5);
        this.downloadIndentPanel.constrain(this.pullModeTA, 0, 4, 4, 1, 18, 2, 0, 22, 0, 0);
        return this.downloadPanel;
    }

    private void _updateDownloadPanel() {
        this.downloadPanel.removeAll();
        if (this.enableDownloadCB.isVisible()) {
            this.downloadPanel.constrain(this.enableDownloadCB, 0, 0, 1, 1, 18, 0, 0, 5, 0, 5);
            this.downloadPanel.constrain(this.downloadIndentPanel, 0, 1, 1, 1, 18, 2, 0, 23, 0, 5);
        } else {
            this.downloadPanel.constrain(this.downloadIndentPanel, 0, 0, 1, 1, 18, 2, 0, 5, 0, 5);
        }
    }

    private JPanelGB getUploadPanel() {
        this.uploadPanel.setBorder(new TitledBorder(CommunicationPanel._getString("CommunicationPanel.upload")));
        this.logHeartbeatTF.setDocument(new NumberPlainDocument(596523L));
        this.logHeartbeatTF.setHorizontalAlignment(4);
        this.opStateHeartbeatTF.setDocument(new NumberPlainDocument(596523L));
        this.opStateHeartbeatTF.setHorizontalAlignment(4);
        this.cmdStateHeartbeatTF.setDocument(new NumberPlainDocument(596523L));
        this.cmdStateHeartbeatTF.setHorizontalAlignment(4);
        this.uploadPanel.constrain(UIUtilities.appendOSIcon(this.learnedAppsCB, true, false), 0, 0, 2, 1, 18, 0, 0, 5, 0, 0);
        this.uploadPanel.constrain(this.descriptionText, 0, 1, 3, 1, 18, 2, 0, 27, 0, 5);
        return this.uploadPanel;
    }

    private static String _getString(String propertyKey) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", propertyKey);
    }

    protected boolean isCommunicationDisableAllowed() {
        if (this.autoLocObj == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.NO_GROUP_DISCONNECT);
            return false;
        }
        int ret = JOptionPane.showConfirmDialog(Manager.getFrame(), CommunicationPanel._getString("CommunicationPanel.areYouSureYouWantThisGroupOrLocationToDisconnect"), CommunicationPanel._getString("CommunicationPanel.confirmation"), 2);
        return ret != 2;
    }

    private void updateAllUI() {
        if (this.isReadOnly) {
            return;
        }
        boolean enableComm = this.enableCommCB.isSelected();
        this.policyManagerCB.setEnabled(enableComm);
        this.managementServerDescText.setEnabled(enableComm);
        this.updateDownloadUI(enableComm);
        this.updateUploadUI(enableComm);
        this.updateHeartbeatUI(enableComm);
        this.updateRememberStatusUI(enableComm);
    }

    private void updateDownloadUI(boolean enableComm) {
        if (this.isReadOnly) {
            return;
        }
        boolean enable = enableComm && (this.enableDownloadCB.isSelected() || !this.enableDownloadCB.isVisible());
        this.enableDownloadCB.setEnabled(enableComm);
        this.pushModeRB.setEnabled(enable);
        this.pushModeTA.setEnabled(enable);
        this.pullModeRB.setEnabled(enable);
        this.pullModeTA.setEnabled(enable);
    }

    private void updateUploadUI(boolean enableComm) {
        if (this.isReadOnly) {
            return;
        }
        this.learnedAppsCB.setEnabled(enableComm);
        this.logHeartbeatL.setEnabled(enableComm);
        this.logHeartbeatTF.setEnabled(enableComm);
        this.logHeartbeatCBB.setEnabled(enableComm);
        this.opStateHeartbeatL.setEnabled(enableComm);
        this.opStateHeartbeatTF.setEnabled(enableComm);
        this.opStateHeartbeatCBB.setEnabled(enableComm);
        this.cmdStateHeartbeatL.setEnabled(enableComm);
        this.cmdStateHeartbeatTF.setEnabled(enableComm);
        this.cmdStateHeartbeatCBB.setEnabled(enableComm);
    }

    public boolean saveChanges() {
        try {
            if (!LicenseObject.getInstance().isSEPSBProduct()) {
                boolean isConnect;
                ObjInfoObject objInfo = (ObjInfoObject)this.policyManagerCB.getSelectedItem();
                if (!objInfo.getId().equals(this.comObj.getServerListId())) {
                    this.comObj.setServerList(PolicyHelper.getServerListObject(objInfo));
                }
                if (isConnect = this.enableCommCB.isSelected()) {
                    if (!this.enableDownloadCB.isVisible() || this.enableDownloadCB.isVisible() && this.enableDownloadCB.isSelected()) {
                        if (this.pushModeRB.isSelected()) {
                            this.comObj.setMode(0);
                        } else {
                            this.comObj.setMode(1);
                        }
                    }
                    this.comObj.setHeartbeat(this.saveChangesAndGetHeartbeatSeconds(this.heartbeatTF, this.heartbeatCBB, true).intValue());
                    this.comObj.setLogUploadHeartbeat(this.saveChangesAndGetHeartbeatSeconds(this.logHeartbeatTF, this.logHeartbeatCBB, true).intValue());
                    this.comObj.setOperationStateUploadHeartbeat(this.saveChangesAndGetHeartbeatSeconds(this.opStateHeartbeatTF, this.opStateHeartbeatCBB, true).intValue());
                    this.comObj.setCommandStateUploadHeartbeat(this.saveChangesAndGetHeartbeatSeconds(this.cmdStateHeartbeatTF, this.cmdStateHeartbeatCBB, true).intValue());
                } else {
                    if (this.autoLocObj == null) {
                        throw new GUICheckException(this.NO_GROUP_DISCONNECT, this.enableCommCB);
                    }
                    if (!this.autoLocObj.isOtherLocationsDisconnectToServer(this.curLocId)) {
                        this.enableCommCB.doClick();
                        throw new GUICheckException(CommunicationPanel._getString("CommunicationPanel.youCannotDisconnectThisLocationFromPM"), this.enableCommCB);
                    }
                }
                this.comObj.setConnectToServer(isConnect);
                this.comObj.setAppUploadFlag(this.learnedAppsCB.isSelected());
                this.comObj.setDownloadProfile(this.enableDownloadCB.isSelected());
                this.comObj.setRandomizationEnabled(this.jChkRandomize.isSelected());
                Integer range = (Integer)this.jSpnRandomRange.getModel().getValue();
                if (this.isHoursSelected(this.randomFrequencyCBB)) {
                    this.comObj.setRandomizationFrequency(1);
                    this.comObj.setRandomizationRange(range * 3600);
                } else {
                    this.comObj.setRandomizationFrequency(0);
                    this.comObj.setRandomizationRange(range * 60);
                }
            }
            this.comObj.setRememberCurrentGroup(this.rememberGroupCB.isSelected());
            this.comObj.setRememberCurrentPolicyMode(this.rememberPolicyModeCB.isSelected());
            this.comObj.setAllowClientUploadCriticalEventImmediately(this.jcbAllowClientUploadCriticalEventImmediately.isSelected());
            return true;
        }
        catch (RuntimeException ex) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(CommunicationPanel._getString("CommunicationPanel.errorSaveFailedRuntimeException"), ex.getMessage()), CommunicationPanel._getString("CommunicationPanel.error"), 0);
            return false;
        }
        catch (Exception ex) {
            JComponent errCom;
            JOptionPane.showMessageDialog(this, MessageFormat.format(CommunicationPanel._getString("CommunicationPanel.errorSaveFailed"), ex.getMessage()), CommunicationPanel._getString("CommunicationPanel.error"), 0);
            if (ex instanceof GUICheckException && (errCom = ((GUICheckException)ex).getErrorComponent()) != null) {
                errCom.requestFocus();
            }
            return false;
        }
    }

    private Integer saveChangesAndGetHeartbeatSeconds(JTextField textField, JComboBox<String> unitsComboBox, boolean allowThrowException) throws GUICheckException {
        if (textField == null || unitsComboBox == null) {
            return null;
        }
        return this.checkAndcalculateSeconds(textField, unitsComboBox, allowThrowException, textField.getText());
    }

    private Integer saveChangesAndGetHeartbeatSeconds(JSpinner spinner, JComboBox<String> unitsComboBox, boolean allowThrowException) throws GUICheckException {
        if (spinner == null || unitsComboBox == null) {
            return null;
        }
        String minsOrHoursValue = StringUtilities.toStringSafety((Object)spinner.getModel().getValue());
        return this.checkAndcalculateSeconds(spinner, unitsComboBox, allowThrowException, minsOrHoursValue);
    }

    private Integer checkAndcalculateSeconds(JComponent component, JComboBox<String> unitsComboBox, boolean allowThrowException, String value) throws GUICheckException {
        try {
            if (StringUtilities.isEmpty((String)value)) {
                if (allowThrowException) {
                    throw new GUICheckException(CommunicationPanel._getString("CommunicationPanel.heartbeatFieldCannotBeBlank"), component);
                }
                return null;
            }
            int seconds = this.calculateSeconds(unitsComboBox, Integer.valueOf(value));
            if (seconds < 10) {
                if (allowThrowException) {
                    throw new GUICheckException(CommunicationPanel._getString("CommunicationPanel.heartbeatCannotBeShorter"), component);
                }
                return null;
            }
            return seconds;
        }
        catch (NumberFormatException exc) {
            if (allowThrowException) {
                throw new GUICheckException(CommunicationPanel._getString("CommunicationPanel.heartbeatMustBeAValidNumber"), component);
            }
            return null;
        }
    }

    private int calculateSeconds(JComboBox<String> unitsComboBox, Integer number) {
        return number * UNITVALUE[unitsComboBox.getSelectedIndex()];
    }

    public void setReadOnly() {
        this.isReadOnly = true;
        UIUtilities.setContainerStatus(this, false);
    }

    public void setObject(CommunicationObject commObj, TamperProtectionPolicy tamperProtectionPolicy) {
        this.comObj = commObj;
        if (!LicenseObject.getInstance().isSEPSBProduct()) {
            this.updatePanel();
        }
    }

    private void updatePanel() {
        try {
            LicenseObject myLicenseObj = LicenseObject.getInstance();
            this.isConnectToServer = this.comObj.isConnectToServer();
            this.enableCommCB.setSelected(this.isConnectToServer);
            int mode = this.comObj.getMode();
            if (mode == 1) {
                this.pullModeRB.setSelected(true);
            } else {
                this.pushModeRB.setSelected(true);
            }
            this.updateHeartbeatPanel();
            this.enableDownloadCB.setSelected(this.comObj.getDownloadProfile());
            boolean enableAppUpload = this.comObj.getAppUploadFlag();
            this.uploadPanel.setVisible(myLicenseObj.isFirewallPolicy());
            this.learnedAppsCB.setSelected(enableAppUpload);
            long logUploadHeartbeat = this.comObj.getLogUploadHeartbeat();
            int logUploadSelectedIndex = logUploadHeartbeat % 3600L == 0L ? 0 : 1;
            this.logHeartbeatTF.setText("" + logUploadHeartbeat / (long)UNITVALUE[logUploadSelectedIndex]);
            this.logHeartbeatCBB.setSelectedIndex(logUploadSelectedIndex);
            long operationStateUploadHeartbeat = this.comObj.getOperationStateUploadHeartbeat();
            int operationStateUploadSelectedIndex = operationStateUploadHeartbeat % 3600L == 0L ? 0 : 1;
            this.opStateHeartbeatTF.setText("" + operationStateUploadHeartbeat / (long)UNITVALUE[operationStateUploadSelectedIndex]);
            this.opStateHeartbeatCBB.setSelectedIndex(operationStateUploadSelectedIndex);
            long commandStateUploadHeartbeat = this.comObj.getCommandStateUploadHeartbeat();
            int commandStateUploadSelectedIndex = commandStateUploadHeartbeat % 3600L == 0L ? 0 : 1;
            this.cmdStateHeartbeatTF.setText("" + commandStateUploadHeartbeat / (long)UNITVALUE[commandStateUploadSelectedIndex]);
            this.cmdStateHeartbeatCBB.setSelectedIndex(commandStateUploadSelectedIndex);
            boolean validServerList = false;
            ServerListObject serverObj = this.comObj.getServerList();
            if (serverObj != null) {
                for (int i = 0; i < this.serverModel.getSize(); ++i) {
                    ObjInfoObject obj = this.serverModel.getElementAt(i);
                    if (!obj.getId().equals(serverObj.getId())) continue;
                    this.policyManagerCB.setSelectedItem(obj);
                    validServerList = true;
                    break;
                }
            }
            if (!validServerList) {
                if (this.isReadOnly) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), CommunicationPanel._getString("CommunicationPanel.ParentGroupInvalidServerList.msg"), CommunicationPanel._getString("CommunicationPanel.invalidServerList.title"), 0);
                } else {
                    JOptionPane.showMessageDialog(Manager.getFrame(), CommunicationPanel._getString("CommunicationPanel.invalidServerList.msg"), CommunicationPanel._getString("CommunicationPanel.invalidServerList.title"), 0);
                }
            }
            this.setRandomEnabled(this.comObj.getRandomizationEnabled());
            int range = this.comObj.getRandomizationRange();
            if (this.comObj.getRandomizationFrequency() == 0) {
                this.selectMinutesItem(this.randomFrequencyCBB);
                this.jSpnRandomRange.getModel().setValue(range / 60);
            } else if (this.comObj.getRandomizationFrequency() == 1) {
                this.selectHoursItem(this.randomFrequencyCBB);
                this.jSpnRandomRange.getModel().setValue(range / 3600);
            }
            this.rememberGroupCB.setSelected(this.comObj.getRememberCurrentGroup());
            this.rememberPolicyModeCB.setSelected(this.comObj.getRememberCurrentPolicyMode());
            this.jcbAllowClientUploadCriticalEventImmediately.setSelected(this.comObj.getAllowClientUploadCriticalEventImmediately());
            this.updateAllUI();
            this.updateVisibleState();
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(CommunicationPanel._getString("CommunicationPanel.errorUpdateUIFailed"), e.getMessage()), CommunicationPanel._getString("CommunicationPanel.error"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void updateHeartbeatPanel() {
        long heartbeat = this.comObj.getHeartbeat();
        if (heartbeat % 3600L == 0L) {
            this.selectHoursItem(this.heartbeatCBB);
            this.heartbeatTF.getModel().setValue(heartbeat / 3600L);
        } else {
            this.selectMinutesItem(this.heartbeatCBB);
            this.heartbeatTF.getModel().setValue(heartbeat / 60L);
        }
        this.jcbAllowClientUploadCriticalEventImmediately.setSelected(this.comObj.getAllowClientUploadCriticalEventImmediately());
    }

    private void setData() {
        try {
            this.serverModel.removeAllElements();
            this.pool = ServerListPool.getServerListPool();
            ObjInfoObject[] infoObj = this.pool.getInfoObjectList();
            for (int i = 0; i < infoObj.length; ++i) {
                this.serverModel.addElement(infoObj[i]);
            }
            this.policyManagerCB.setModel(this.serverModel);
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListSelectDlg.error"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    public CommunicationObject getCommunicationObject() {
        return this.comObj;
    }

    public void setBackgroundObject(AutoLocationObject autoObj, String locId) {
        this.autoLocObj = autoObj;
        this.curLocId = locId;
        this.updateVisibleState();
    }

    void hideNoDownloadProfile() {
        this.enableDownloadCB.setVisible(false);
        this._updateDownloadPanel();
    }

    private JPanelGB getHeartbeatPanel() {
        this.heartbeatCBB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommunicationPanel.this.switch2DefaultValue(CommunicationPanel.this.heartbeatNumberModel, (JComboBox)e.getSource(), 2880);
            }
        });
        UIUtilities.enableOnlyValidEdits(this.heartbeatTF);
        this.heartbeatPanel.setBorder(new TitledBorder(CommunicationPanel._getString("CommunicationPanel.HeartbeatTitle")));
        this.heartbeatPanel.constrain(this.heartbeatUploadPollLDesc, 0, 0, 3, 1, 18, 2, 2, 5, 0, 5);
        this.heartbeatPanel.constrain(this.heartbeatUploadPollL, 0, 1, 1, 1, 18, 0, 2, 5, 0, 5);
        this.heartbeatPanel.constrain(this.heartbeatTF, 1, 1, 1, 1, 18, 0, 0, 0, 0, 5);
        this.heartbeatPanel.constrain(this.heartbeatCBB, 2, 1, 1, 1, 18, 0, 0, 0, 0, 0);
        this.heartbeatPanel.constrain(UIUtilities.appendOSIcon(this.jcbAllowClientUploadCriticalEventImmediately, true, false), 0, 2, 3, 1, 18, 0, 0, 0, 0, 0);
        return this.heartbeatPanel;
    }

    private void updateHeartbeatUI(boolean enableComm) {
        if (this.isReadOnly) {
            return;
        }
        this.heartbeatUploadPollL.setEnabled(enableComm);
        this.heartbeatTF.setEnabled(enableComm);
        this.heartbeatCBB.setEnabled(enableComm);
        this.jcbAllowClientUploadCriticalEventImmediately.setEnabled(enableComm);
    }

    private void updateRememberStatusUI(boolean enableComm) {
        if (this.isReadOnly) {
            return;
        }
        this.rememberGroupCB.setEnabled(enableComm);
        this.rememberPolicyModeCB.setEnabled(enableComm);
    }

    private void updateVisibleState() {
        boolean isVisible = this.autoLocObj != null;
        this.cautionL.setVisible(isVisible);
        this.enableCommCB.setVisible(isVisible);
        this.enableCommTA.setVisible(isVisible);
        boolean isVisibleGroup = this.autoLocObj == null;
        this.rememberStatusPanel.setVisible(isVisibleGroup);
    }

    public boolean getRandomEnabled() {
        return this.jChkRandomize.isSelected();
    }

    public void setRandomEnabled(boolean value) {
        if (value) {
            this.jChkRandomize.setSelected(true);
            if (this.jChkRandomize.isEnabled()) {
                this.randomFrequencyCBB.setEnabled(true);
                this.jSpnRandomRange.setEnabled(true);
            }
        } else {
            this.jChkRandomize.setSelected(false);
            this.randomFrequencyCBB.setEnabled(false);
            this.jSpnRandomRange.setEnabled(false);
        }
    }

    private JPanel getRandomizationPanel() {
        this.randomFrequencyCBB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommunicationPanel.this.switch2DefaultValue(CommunicationPanel.this.randomRangeNumberModel, (JComboBox)e.getSource(), 60);
            }
        });
        this.jChkRandomize.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    CommunicationPanel.this.jSpnRandomRange.setEnabled(false);
                    CommunicationPanel.this.randomFrequencyCBB.setEnabled(false);
                } else if (CommunicationPanel.this.jChkRandomize.isEnabled()) {
                    CommunicationPanel.this.jSpnRandomRange.setEnabled(true);
                    CommunicationPanel.this.randomFrequencyCBB.setEnabled(true);
                }
            }
        });
        UIUtilities.enableOnlyValidEdits(this.jSpnRandomRange);
        this.randomPanel.setBorder(new TitledBorder(CommunicationPanel._getString("CommunicationPanel.label.randomization")));
        this.randomPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 18;
        c.weightx = 1.0;
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 5, 0, 0);
        this.randomPanel.add((Component)this.randomDescText, c);
        c.fill = 2;
        c.anchor = 18;
        c.weightx = 0.0;
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.randomPanel.add((Component)this.jChkRandomize, c);
        JPanel panelWithOsIcon = new JPanel();
        FlowLayout flowLayout = new FlowLayout(0);
        panelWithOsIcon.setLayout(flowLayout);
        flowLayout.setHgap(0);
        flowLayout.setVgap(0);
        panelWithOsIcon.add(new JLabel(CommunicationPanel._getString("CommunicationPanel.label.randomizationWindow")));
        panelWithOsIcon.add(this.jSpnRandomRange);
        panelWithOsIcon.add(new JLabel(" "));
        panelWithOsIcon.add(UIUtilities.appendOSIcon(this.randomFrequencyCBB, true, true));
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(0, 20, 0, 0);
        this.randomPanel.add((Component)panelWithOsIcon, c);
        return this.randomPanel;
    }

    private void switch2DefaultValue(SpinnerNumberModel spinnerNumberModel, JComboBox<?> jcb, int maxMinutes) {
        if (this.isMinutesSelected(jcb)) {
            spinnerNumberModel.setMinimum(Integer.valueOf(1));
            spinnerNumberModel.setValue(5);
            spinnerNumberModel.setMaximum(Integer.valueOf(maxMinutes));
        } else {
            spinnerNumberModel.setMinimum(Integer.valueOf(1));
            spinnerNumberModel.setValue(1);
            spinnerNumberModel.setMaximum(Integer.valueOf(48));
        }
    }

    private boolean isMinutesSelected(JComboBox<?> jcb) {
        return ((String)jcb.getSelectedItem()).equals(CommunicationPanel._getString("CommunicationPanel.minutes"));
    }

    private boolean isHoursSelected(JComboBox<?> jcb) {
        return ((String)jcb.getSelectedItem()).equals(CommunicationPanel._getString("CommunicationPanel.hours"));
    }

    private void selectMinutesItem(JComboBox<String> comboBox) {
        comboBox.setSelectedItem(CommunicationPanel._getString("CommunicationPanel.minutes"));
    }

    private void selectHoursItem(JComboBox<String> comboBox) {
        comboBox.setSelectedItem(CommunicationPanel._getString("CommunicationPanel.hours"));
    }

    private JPanel getRememberStatusPanel() {
        this.rememberStatusPanel.setBorder(new TitledBorder(CommunicationPanel._getString("CommunicationPanel.label.rememberCummunicationStatus.title")));
        this.rememberStatusPanel.constrain(this.rememberStatusDescText, 0, 0, 3, 1, 18, 2, 0, 5, 0, 5);
        this.rememberStatusPanel.constrain(this.rememberGroupCB, 0, 1, 3, 1, 18, 2, 0, 5, 0, 5);
        this.rememberStatusPanel.constrain(UIUtilities.appendOSIcon(this.rememberPolicyModeCB, true, false), 0, 2, 3, 1, 18, 2, 0, 0, 0, 0);
        return this.rememberStatusPanel;
    }
}

