/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.schema.AmlLowBandwidth;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.CloudPolicyHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.ExternalCommunicationObject;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.GUID;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class CloudSettingsPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private JCheckBox jCbxLowBandwidthEnabled = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "CloudSettingsPanel.isLowBandwidthMode"));
    boolean cloudEnrolled = CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId());
    Boolean isLowBandwidthEnabled = new AmlLowBandwidth().getDefEnableLowBandwidth();

    public CloudSettingsPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        if (this.isLowBandwidthEnabled != null && this.isLowBandwidthEnabled.booleanValue()) {
            this.jCbxLowBandwidthEnabled.setSelected(true);
        }
        this.jCbxLowBandwidthEnabled.setEnabled(false);
        panel.add(this.jCbxLowBandwidthEnabled);
        return panel;
    }

    public boolean setObject(ExternalCommunicationObject extComObj, SemClientGroup clientGroup) {
        CloudPolicyHandler cloudHandler = CloudPolicyHandler.getInstance();
        this.isLowBandwidthEnabled = cloudHandler.isEnableLowBandwidth(clientGroup, new GUID(Manager.getCurrentDomainId()));
        if (this.isLowBandwidthEnabled == null) {
            return false;
        }
        ConsoleLogger.log("Updating EndpointRestrictionsPanel");
        this.removeAll();
        this.initialize();
        this.validate();
        this.repaint();
        ConsoleLogger.log("Updating EndpointRestrictionsPanel done");
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_client_policies_ext_comm_cloud_settings";
    }
}

