/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.PasswordWidget;
import com.sygate.scm.common.ui.SEPMPasswordField;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.i18n.ConsoleMessageResourcesFile;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ClientPasswordSettingsDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResourcesFile MSGRES = new ConsoleMessageResourcesFile("com.sygate.scm.console.ui.policy.dialog.policydialog");
    public static final String PASSWORD_STATUS_LABEL = "PASSWORD_WIDGET";
    private JRadioButton jrUseDefaultPasswd = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.useDefaultPasswd"));
    private JRadioButton jrUseGroupPasswd = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.useClientPasswd"));
    private JLabel passwordLabel;
    private JLabel confirmPasswordLabel;
    private final JPasswordField pwdConfirmField = new SEPMPasswordField(16);
    private final CardLayout cardLayout = new CardLayout();
    private final JPasswordField pwdField = new SEPMPasswordField(16);
    private final PasswordWidget jLPwdStatus = new PasswordWidget(true, false);
    private final JCheckBox pwdAgentGuiChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.requirePasswordToOpenAgentGUI"));
    private final JCheckBox pwdCleanwipeChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.requirePasswordToCleanwipe"));
    private JCheckBox pwdProfileChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.requirePasswordToImportOrExport"));
    private JCheckBox pwdExitChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.requirePasswordToStopAgentService"));
    private JCheckBox pwdUninstallChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.requirePasswordToUninstallAgent"));
    public static final String PREDEFINED_PASSWD_HASH = "6D0B6C38A24100185F747205406A346D";
    public static final String PREDEFINED_PASSWD2_HASH = "01B7C62D689D8EC84BFAC10C192D4B6EB8BFD3207ED2B721801593AC437DCFD64024A4460DAE92E2E5C7747B754F17C5F020EF95ED3D36108DD6D44295617803A1";
    public static final String PREDEFINED_PASSWD3_HASH = "010704CBB867E9F9B139BC77C7FB1CFAE7A16A905B82D3695D1912689E96DA8CEB8B8C9AE1AF5BAA1EA806230290C825B11802210C40C0A0066565A8A9D688085A";
    private GroupPolicyObject gpObj;
    private JPanel securitySettingPane;

    public ClientPasswordSettingsDlg(String title, GroupPolicyObject groupObject) {
        super(Manager.getFrame(), title, true);
        this.gpObj = groupObject;
        this.initialize();
        UiUtilities.centerComponent((Component)this);
    }

    public ClientPasswordSettingsDlg(String title) {
        super(Manager.getFrame(), title, true);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_computersnusers_policies_password";
    }

    private void initialize() {
        this.setupUI();
    }

    private JComponent getMainPane() {
        this.securitySettingPane = this.getSecuritySettingsPanel();
        JPanel mainPanel = new JPanel();
        mainPanel.add(this.securitySettingPane);
        return mainPanel;
    }

    private JPanel getPasswordPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.jrUseDefaultPasswd);
        bg.add(this.jrUseGroupPasswd);
        RadioButtonListener listener = new RadioButtonListener();
        this.jrUseDefaultPasswd.addActionListener(listener);
        this.jrUseGroupPasswd.addActionListener(listener);
        int row = 0;
        panel.add((Component)this.jrUseDefaultPasswd, new GridBagConstraints(0, row++, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        panel.add((Component)this.jrUseGroupPasswd, new GridBagConstraints(0, row++, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        PwdFocusListener pwdFocusListener = new PwdFocusListener();
        this.pwdField.addFocusListener(pwdFocusListener);
        this.pwdConfirmField.addFocusListener(pwdFocusListener);
        this.passwordLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.password"));
        panel.add((Component)this.passwordLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 32, 0, 0), 0, 0));
        panel.add((Component)this.pwdField, new GridBagConstraints(1, row++, 2, 1, 0.0, 0.0, 13, 0, new Insets(3, 0, 0, 10), 0, 0));
        this.confirmPasswordLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.confirmPassword"));
        panel.add((Component)this.confirmPasswordLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 32, 0, 0), 0, 0));
        panel.add((Component)this.pwdConfirmField, new GridBagConstraints(1, row++, 2, 1, 0.0, 0.0, 13, 0, new Insets(3, 0, 0, 10), 0, 0));
        JPanel statusPanel = new JPanel(this.cardLayout);
        statusPanel.add((Component)this.jLPwdStatus, PASSWORD_STATUS_LABEL);
        panel.add((Component)statusPanel, new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 13, 2, new Insets(5, 50, 0, 10), 0, 0));
        panel.add((Component)this.pwdAgentGuiChkBox, new GridBagConstraints(0, row++, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        panel.add((Component)this.pwdCleanwipeChkBox, new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.pwdCleanwipeChkBox.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.enableByDefaultTips"));
        panel.add((Component)this.pwdUninstallChkBox, new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.pwdUninstallChkBox.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.enableByDefaultTips"));
        panel.add((Component)this.pwdExitChkBox, new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.pwdExitChkBox.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.enableByDefaultTips"));
        panel.add((Component)this.pwdProfileChkBox, new GridBagConstraints(0, row++, 3, 2, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.pwdProfileChkBox.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.enableByDefaultTips"));
        this.pwdField.getDocument().addDocumentListener(new PasswordDocumentListener());
        return panel;
    }

    void handleListenerEvent() {
        SwingUtilities.invokeLater(() -> {
            char[] pwd = this.pwdField.getPassword();
            if (this.gpObj.getPasswordHash() != null && this.gpObj.getPasswordHash().equals(String.valueOf(pwd))) {
                this.jLPwdStatus.setEnabled(false);
                return;
            }
            if (pwd.length == 0) {
                this.jLPwdStatus.setEnabled(false);
                return;
            }
            this.jLPwdStatus.setEnabled(true);
            this.jLPwdStatus.analyzeStrength(pwd, Utility.checkPasswdDefaultLength((char[])pwd));
            Arrays.fill(pwd, '0');
        });
    }

    private JPanel getSecuritySettingsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getPasswordPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.add((Component)panel, "North");
        return wrapPanel;
    }

    private void updateSecuritySettings() {
        boolean enabled;
        this.pwdAgentGuiChkBox.setSelected(this.gpObj.getAskPwdOpenGui());
        this.pwdExitChkBox.setSelected(true);
        this.pwdExitChkBox.setEnabled(false);
        this.pwdProfileChkBox.setSelected(true);
        this.pwdProfileChkBox.setEnabled(false);
        this.pwdUninstallChkBox.setSelected(true);
        this.pwdUninstallChkBox.setEnabled(false);
        this.pwdCleanwipeChkBox.setSelected(true);
        this.pwdCleanwipeChkBox.setEnabled(false);
        String lastPasswdHash = this.gpObj.getPasswordHash();
        boolean bl = enabled = this.gpObj.getAskPwdOpenGui() || this.gpObj.getAskPwdExit() || this.gpObj.getAskPwdProfile() || this.gpObj.getAskPwdUninstall() || this.gpObj.getAskPwdCleanwipe();
        if (!StringUtilities.isEmpty((String)lastPasswdHash) && !PREDEFINED_PASSWD3_HASH.equals(this.gpObj.getPassword3Hash()) && enabled) {
            this.jrUseDefaultPasswd.setSelected(false);
            this.jrUseGroupPasswd.setSelected(true);
            this.pwdField.setText(lastPasswdHash);
            this.pwdConfirmField.setText(lastPasswdHash);
            this.passwordLabel.setEnabled(true);
            this.confirmPasswordLabel.setEnabled(true);
        } else {
            this.jrUseDefaultPasswd.setSelected(true);
            this.jrUseGroupPasswd.setSelected(false);
            this.pwdField.setEnabled(false);
            this.pwdConfirmField.setEnabled(false);
            this.passwordLabel.setEnabled(false);
            this.confirmPasswordLabel.setEnabled(false);
        }
        this.jLPwdStatus.setEnabled(false);
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    protected boolean isValidate() {
        return this.validateSecuritySettings();
    }

    @Override
    public void setVisible(boolean visible) {
        this.setSize(this.getPreferredSize());
        super.setVisible(visible);
    }

    @Override
    public void setReadOnly(boolean isInherit) {
        this.readOnly = true;
        super.setReadOnly(true);
        this.getContentPane().add((Component)this.getReadOnlyTitlePane(isInherit), "North");
        UIUtilities.setContainerStatus(this.securitySettingPane, false);
        this.invalidate();
        this.pack();
    }

    public void setObject(GroupPolicyObject gpObj) {
        this.gpObj = gpObj;
        this.setupUI();
        UiUtilities.centerComponent((Component)this);
    }

    private void setupUI() {
        JComponent mainPane = this.getMainPane();
        this.getContentPane().add((Component)mainPane, "Center");
        this.getContentPane().add((Component)UIUtilities.createScrollPaneWithoutBoard(mainPane), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
        this.setPreferredSize(new Dimension(this.getWidth() + 10, this.getHeight() + 25));
        this.updateSecuritySettings();
    }

    public String getAskPwdOpenGui() {
        return String.valueOf(this.pwdAgentGuiChkBox.isSelected());
    }

    public String getAskPwdCleanwipe() {
        return String.valueOf(this.pwdCleanwipeChkBox.isSelected());
    }

    public String getPasswordHash() {
        String passwordHash;
        String password = this.gpObj.getPasswordHash();
        char[] pwd = this.pwdField.getPassword();
        if (pwd.length == 0 || this.useDefaultPassSelected()) {
            return PREDEFINED_PASSWD_HASH;
        }
        if (this.caculateNewHash(pwd, password)) {
            passwordHash = Utility.calculateHash((byte[])Utility.charToBytes((char[])pwd));
            Arrays.fill(pwd, '0');
        } else {
            passwordHash = password;
        }
        return passwordHash;
    }

    public String getPassword2Hash() {
        String password2Hash = null;
        String password = this.gpObj.getPasswordHash();
        char[] pwd = this.pwdField.getPassword();
        if (pwd.length == 0 || this.useDefaultPassSelected()) {
            return PREDEFINED_PASSWD2_HASH;
        }
        if (this.caculateNewHash(pwd, password)) {
            try {
                password2Hash = Utility.calculateHashLatest_DefaultSaltLength_byteInput((byte[])Utility.charToBytes((char[])pwd));
                Arrays.fill(pwd, '0');
            }
            catch (Exception e) {
                LoggerUtilities.logException((Throwable)e);
            }
        } else {
            password2Hash = this.gpObj.getPasswordProtection().getOptPassword2Hash();
        }
        return password2Hash;
    }

    public String getPassword3Hash() {
        String password3Hash = null;
        String password = this.gpObj.getPasswordHash();
        char[] pwd = this.pwdField.getPassword();
        if (pwd.length == 0 || this.useDefaultPassSelected()) {
            return PREDEFINED_PASSWD3_HASH;
        }
        if (this.caculateNewHash(pwd, password)) {
            try {
                password3Hash = Utility.calculatePKDBF2Hash_DefaultSaltLengthDefaultWorkFactor((String)String.valueOf(pwd));
                Arrays.fill(pwd, '0');
            }
            catch (Exception e) {
                LoggerUtilities.logException((Throwable)e);
            }
        } else {
            password3Hash = this.gpObj.getPasswordProtection().getOptPassword3Hash();
        }
        return password3Hash;
    }

    public String getApplyToSubGroups() {
        return String.valueOf(false);
    }

    JPasswordField getSEPMPasswordField() {
        return this.pwdField;
    }

    JPasswordField getSEPMConfirmPasswordField() {
        return this.pwdConfirmField;
    }

    protected boolean caculateNewHash(char[] pwd, String password) {
        return !StringUtilities.isEmpty((String)password) && pwd.length > 0 && !password.equals(String.valueOf(pwd)) || StringUtilities.isEmpty((String)password) && pwd.length > 0;
    }

    boolean validateSecuritySettings() {
        try {
            char[] pass = this.pwdField.getPassword();
            char[] confirm = this.pwdConfirmField.getPassword();
            String strPass = String.valueOf(pass);
            String strConfirm = String.valueOf(confirm);
            if (this.useDefaultPassSelected()) {
                return true;
            }
            if (!strPass.equals(strConfirm)) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.passwordAndConfirmFieldsMustHave"), this.pwdConfirmField);
            }
            if (!Utility.isValidClientPassword((JFrame)Manager.getFrame(), (String)MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.clientPasswd"), (char[])pass, (char[])confirm)) {
                this.pwdField.requestFocus();
                Arrays.fill(pass, '0');
                Arrays.fill(confirm, '0');
                return false;
            }
            if (!Utility.isPasswordCharAllowedForClientPassword((JFrame)Manager.getFrame(), (char[])pass)) {
                return false;
            }
        }
        catch (GUICheckException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.error"), 0);
            JComponent com = e.getErrorComponent();
            if (com != null) {
                com.requestFocusInWindow();
            }
            return false;
        }
        return true;
    }

    private JPanel getReadOnlyTitlePane(boolean isInherit) {
        String desc = (isInherit ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theGlobalSettingsAreInherited") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.theGroupIsReadOnly")) + " " + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.noModificationIsAllowed");
        DescriptionTextArea descArea = new DescriptionTextArea(true);
        descArea.setText(desc);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(UIColorUtilities.WARNING_BACKGROUND);
        panel.add(descArea);
        descArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return panel;
    }

    boolean useDefaultPassSelected() {
        return this.jrUseDefaultPasswd.isSelected();
    }

    void useDefaultPasswdChanged() {
        if (this.useDefaultPassSelected()) {
            this.getSEPMPasswordField().setEnabled(false);
            this.getSEPMConfirmPasswordField().setEnabled(false);
            this.passwordLabel.setEnabled(false);
            this.confirmPasswordLabel.setEnabled(false);
            this.jLPwdStatus.setEnabled(false);
        } else {
            this.getSEPMPasswordField().setEnabled(true);
            this.getSEPMConfirmPasswordField().setEnabled(true);
            this.passwordLabel.setEnabled(true);
            this.confirmPasswordLabel.setEnabled(true);
            String pwd = String.valueOf(this.pwdField.getPassword());
            if (!pwd.equals(this.gpObj.getPasswordHash())) {
                this.jLPwdStatus.setEnabled(true);
            }
        }
    }

    class PwdFocusListener
    implements FocusListener {
        PwdFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            String pwd = String.valueOf(ClientPasswordSettingsDlg.this.pwdField.getPassword());
            if (pwd.equals(ClientPasswordSettingsDlg.this.gpObj.getPasswordHash())) {
                ClientPasswordSettingsDlg.this.pwdField.setText("");
                ClientPasswordSettingsDlg.this.pwdConfirmField.setText("");
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            String lastPasswdHash = ClientPasswordSettingsDlg.this.gpObj.getPasswordHash();
            String pwd = String.valueOf(ClientPasswordSettingsDlg.this.pwdField.getPassword());
            String pwdConfirm = String.valueOf(ClientPasswordSettingsDlg.this.pwdConfirmField.getPassword());
            if (pwd.isEmpty() && pwdConfirm.isEmpty() && !ClientPasswordSettingsDlg.PREDEFINED_PASSWD_HASH.equals(ClientPasswordSettingsDlg.this.gpObj.getPasswordHash()) && ClientPasswordSettingsDlg.this.gpObj.getPassword3Hash() != null) {
                ClientPasswordSettingsDlg.this.pwdField.setText(lastPasswdHash);
                ClientPasswordSettingsDlg.this.pwdConfirmField.setText(lastPasswdHash);
                if (ClientPasswordSettingsDlg.this.getOkButton() == e.getOppositeComponent()) {
                    ClientPasswordSettingsDlg.this.setAllowSave(false);
                    this.showClientPasswdUnchangedDialog();
                }
            } else {
                ClientPasswordSettingsDlg.this.setAllowSave(true);
            }
        }

        public void showClientPasswdUnchangedDialog() {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GlobalSettingDlg.clientPasswdUnchanged"), Manager.getFrame().getTitle(), 1);
        }
    }

    class RadioButtonListener
    implements ActionListener {
        RadioButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClientPasswordSettingsDlg.this.useDefaultPasswdChanged();
        }
    }

    class PasswordDocumentListener
    implements DocumentListener {
        PasswordDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ClientPasswordSettingsDlg.this.handleListenerEvent();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ClientPasswordSettingsDlg.this.handleListenerEvent();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

