/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.DnsHost;
import com.sygate.scm.common.configobject.schema.FileExists;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.IpRange;
import com.sygate.scm.common.configobject.schema.Ipv6Address;
import com.sygate.scm.common.configobject.schema.Ipv6Range;
import com.sygate.scm.common.configobject.schema.Ipv6SubNet;
import com.sygate.scm.common.configobject.schema.LocalHostName;
import com.sygate.scm.common.configobject.schema.LocationCriteriaCondition;
import com.sygate.scm.common.configobject.schema.OS;
import com.sygate.scm.common.configobject.schema.OSVersion;
import com.sygate.scm.common.configobject.schema.SubNet;
import com.sygate.scm.common.configobject.schema.UserName;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AddressObject;
import com.sygate.scm.console.logicobject.AlSignatureObject;
import com.sygate.scm.console.logicobject.AlSignatureOrObject;
import com.sygate.scm.console.ui.policy.common.FileExistPanel;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.common.HostGroupLinkPane;
import com.sygate.scm.console.ui.policy.common.ICMPHostNamePane;
import com.sygate.scm.console.ui.policy.common.IPPane;
import com.sygate.scm.console.ui.policy.common.IPv6Pane;
import com.sygate.scm.console.ui.policy.common.OSPanel;
import com.sygate.scm.console.ui.policy.dialog.AddressTypeICMPPingComboBoxModel;
import com.sygate.scm.console.ui.policy.dialog.AlSignatureConditionDlg;
import com.sygate.scm.console.ui.policy.dialog.AutoLocationUsageTypeComboBoxModel;
import com.sygate.scm.console.ui.policy.dialog.IPTypeComboBoxModel;
import com.sygate.scm.console.ui.policy.dialog.LocationHandler;
import com.sygate.scm.console.ui.policy.hostgroup.HostGroupObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.IPField;
import com.sygate.scm.console.ui.util.IPv6Field;
import com.sygate.scm.console.ui.util.IPv6RangePane;
import com.sygate.scm.console.ui.util.IPv6SubnetPane;
import com.sygate.scm.console.ui.util.IpRangePane;
import com.sygate.scm.console.ui.util.NetworkPane;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class AutoLocationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String POLICYDIALOG = "com.sygate.scm.console.ui.policy.dialog.policydialog";
    private AutoLocationUsageTypeComboBoxModel autoLocUsageModel = new AutoLocationUsageTypeComboBoxModel();
    private JComboBox<?> autoLocUsageCmbBox = new JComboBox<AutoLocationUsageTypeComboBoxModel.UsageComboBoxItem>(this.autoLocUsageModel);
    private JPanel addressCompPanel;
    private IpRangePane ipRangePane;
    private IPv6RangePane ipv6RangePane;
    private NetworkPane networkPane;
    private IPv6SubnetPane ipv6NetworkPane;
    private IPField DNSServer;
    private IPv6Field ipv6DNSServer;
    private JLabel ipVerLabel = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "IPv.description"));
    private IPTypeComboBoxModel ipVerComboModel = new IPTypeComboBoxModel();
    private JComboBox<IPTypeComboBoxModel.IPTypeComboBoxItem> ipVerCombo = new JComboBox<IPTypeComboBoxModel.IPTypeComboBoxItem>(this.ipVerComboModel);
    private IPTypeComboBoxModel ipVerIcmpComboModel = new IPTypeComboBoxModel();
    private JComboBox<IPTypeComboBoxModel.IPTypeComboBoxItem> ipVerCombo_Icmp = new JComboBox<IPTypeComboBoxModel.IPTypeComboBoxItem>(this.ipVerIcmpComboModel);
    JRadioButton connectRdBtn = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AutoLocationPanel.connectedToPolicyManager"));
    JRadioButton notConnectRdBtn = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AutoLocationPanel.notConnectedToPolicyManager"));
    JComboBox<String> networkCmbBox = new JComboBox<String>(AlSignatureConditionDlg.networkType);
    JTextField nameField = new JTextField(20);
    JTextField localHostNameField = new JTextField(20);
    JTextField userNameField = new JTextField(20);
    FileExistPanel fileExistsPanel = new FileExistPanel("Windows");
    JTextField ipv6NameField = new JTextField(20);
    IPField ipField;
    IPv6Field ipv6Field;
    private ICMPHostNamePane icmphostNamePane = new ICMPHostNamePane();
    private IPPane icmpIpPane = new IPPane();
    private IPv6Pane icmpIpv6Pane = new IPv6Pane();
    private HostGroupLinkPane hostGroupLink = new HostGroupLinkPane();
    private AddressTypeICMPPingComboBoxModel icmpCmbBoxModel = new AddressTypeICMPPingComboBoxModel();
    private JComboBox<String> icmpCmbBox = new JComboBox<String>(this.icmpCmbBoxModel);
    private JPanel icmpCardPane = null;
    private OSPanel osVersionPane = new OSPanel();

    public AutoLocationPanel() {
        this.initPanel();
    }

    private void initPanel() {
        this.ipVerLabel.setVisible(false);
        this.ipVerCombo.setVisible(false);
        this.autoLocUsageCmbBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AutoLocationUsageTypeComboBoxModel.UsageComboBoxItem index = AutoLocationPanel.this.autoLocUsageModel.getSelectedItem();
                IPTypeComboBoxModel.IPTypeComboBoxItem ipVersion = AutoLocationPanel.this.ipVerComboModel.getSelectedItem();
                AutoLocationPanel.this.showSelectedPanel(index, ipVersion);
            }
        });
        this.icmpCmbBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AddressTypeICMPPingComboBoxModel.AddressTypeICMPPingEnum index = AutoLocationPanel.this.icmpCmbBoxModel.getSelectedPingType();
                IPTypeComboBoxModel.IPTypeComboBoxItem ipVersion = AutoLocationPanel.this.ipVerIcmpComboModel.getSelectedItem();
                AutoLocationPanel.this.showSelectedICMPPanel(index, ipVersion.type());
            }
        });
        this.ipVerCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AutoLocationUsageTypeComboBoxModel.UsageComboBoxItem index = AutoLocationPanel.this.autoLocUsageModel.getSelectedItem();
                IPTypeComboBoxModel.IPTypeComboBoxItem ipVersion = AutoLocationPanel.this.ipVerComboModel.getSelectedItem();
                AutoLocationPanel.this.showSelectedPanel(index, ipVersion);
                if (index.type() == AutoLocationUsageTypeComboBoxModel.UsageTypeEnum.ICMPRequest) {
                    AddressTypeICMPPingComboBoxModel.AddressTypeICMPPingEnum icmpIndex = AutoLocationPanel.this.icmpCmbBoxModel.getSelectedPingType();
                    AutoLocationPanel.this.showSelectedICMPPanel(icmpIndex, ipVersion.type());
                }
            }
        });
        this.addressCompPanel = this.createAddressCompPanel();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 80, 10, 80));
        panel.add((Component)new DescriptionTextArea(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.whenToUseThisLocation")), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        panel.add(this.autoLocUsageCmbBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 10), 0, 0));
        panel.add(this.ipVerCombo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 10), 0, 0));
        panel.add((Component)this.addressCompPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(20, 0, 0, 0), 0, 0));
        this.setLayout(new VerticalFlowLayout(0, 0));
        String title = MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.title");
        String content = MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.titleDesc");
        JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
        this.add(headPanel);
        this.add(panel);
    }

    private JPanel createAddressCompPanel() {
        JPanel panel = new JPanel(new CardLayout());
        panel.add((Component)new DescriptionTextArea(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.thisLocationCanBeSelectedManually")), AutoLocationUsageTypeComboBoxModel.UsageTypeEnum.NoSpecificCondition.name());
        panel.add((Component)this.getIPRangePanel(), AutoLocationUsageTypeComboBoxModel.UsageTypeEnum.IPRange.name());
        panel.add((Component)this.getNetworkPanel(), AutoLocationUsageTypeComboBoxModel.UsageTypeEnum.SubNetwork.name());
        panel.add((Component)this.getDNSServerPanel(), AutoLocationUsageTypeComboBoxModel.UsageTypeEnum.DNSServer.name());
        panel.add((Component)this.getDNSResolvePanel(), AutoLocationUsageTypeComboBoxModel.UsageTypeEnum.DNSResolve.name());
        panel.add((Component)this.getConnectionPanel(), AutoLocationUsageTypeComboBoxModel.UsageTypeEnum.PolicyManagerConnection.name());
        panel.add((Component)this.getConnectionTypePanel(), AutoLocationUsageTypeComboBoxModel.UsageTypeEnum.NetworkConnectionType.name());
        panel.add((Component)this.getICMPRequestPanel(), AutoLocationUsageTypeComboBoxModel.UsageTypeEnum.ICMPRequest.name());
        panel.add((Component)this.getIPv6RangePanel(), AutoLocationUsageTypeComboBoxModel.UsageTypeEnum.IPv6Range.name());
        panel.add((Component)this.getIPv6NetworkPanel(), AutoLocationUsageTypeComboBoxModel.UsageTypeEnum.IPv6SubNetwork.name());
        panel.add((Component)this.getIPv6DNSServerPanel(), AutoLocationUsageTypeComboBoxModel.UsageTypeEnum.IPv6DNSServer.name());
        panel.add((Component)this.getIPv6DNSResolvePanel(), AutoLocationUsageTypeComboBoxModel.UsageTypeEnum.IPv6DNSResolve.name());
        panel.add((Component)this.getLocalHostNamePanel(), AutoLocationUsageTypeComboBoxModel.UsageTypeEnum.LocalHostName.name());
        panel.add((Component)this.getUserNamePanel(), AutoLocationUsageTypeComboBoxModel.UsageTypeEnum.UserName.name());
        panel.add((Component)this.getFileExistsPanel(), AutoLocationUsageTypeComboBoxModel.UsageTypeEnum.FileExists.name());
        panel.add((Component)this.getOSVersionPanel(), AutoLocationUsageTypeComboBoxModel.UsageTypeEnum.OSVersion.name());
        return panel;
    }

    private JPanel getICMPRequestPanel() {
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)this.getICMPReqCardPane(), "West");
        pane.add((Component)new DescriptionTextArea(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.ICMPDescription")), "South");
        return pane;
    }

    private JPanel getICMPReqCardPane() {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 1.0;
        cons.weighty = 0.0;
        cons.anchor = 17;
        cons.fill = 2;
        cons.insets = new Insets(0, 0, 0, 0);
        JPanel pane = new JPanel(new GridBagLayout());
        pane.add((Component)this.getICMPTypePanel(), cons);
        this.icmpCardPane = new JPanel(new CardLayout());
        this.icmpCardPane.add((Component)this.icmpIpPane, AddressTypeICMPPingComboBoxModel.AddressTypeICMPPingEnum.IPAddress.name());
        this.icmpCardPane.add((Component)this.icmpIpv6Pane, AddressTypeICMPPingComboBoxModel.AddressTypeICMPPingEnum.IPAddressV6.name());
        this.icmpCardPane.add((Component)this.icmphostNamePane, AddressTypeICMPPingComboBoxModel.AddressTypeICMPPingEnum.HostName.name());
        this.icmpCardPane.add((Component)this.hostGroupLink, AddressTypeICMPPingComboBoxModel.AddressTypeICMPPingEnum.HostGroup.name());
        cons.gridx = 0;
        cons.gridy = 1;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 1.0;
        cons.weighty = 0.0;
        cons.anchor = 17;
        cons.fill = 2;
        cons.insets = new Insets(10, 0, 0, 0);
        pane.add((Component)this.icmpCardPane, cons);
        return pane;
    }

    private JPanel getICMPTypePanel() {
        JPanel pane = new JPanel(new GridBagLayout());
        pane.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 0.8;
        cons.weighty = 0.0;
        cons.anchor = 17;
        cons.fill = 2;
        cons.insets = new Insets(0, 0, 0, 0);
        pane.add((Component)new JLabel(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.type")), cons);
        cons.gridx = 1;
        cons.gridy = 0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 0.2;
        cons.weighty = 0.0;
        cons.anchor = 17;
        cons.fill = 2;
        cons.insets = new Insets(0, 20, 0, 0);
        pane.add(this.icmpCmbBox, cons);
        this.ipVerCombo_Icmp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AddressTypeICMPPingComboBoxModel.AddressTypeICMPPingEnum index = AutoLocationPanel.this.icmpCmbBoxModel.getSelectedPingType();
                IPTypeComboBoxModel.IPTypeComboBoxItem ipVersion = (IPTypeComboBoxModel.IPTypeComboBoxItem)AutoLocationPanel.this.ipVerCombo_Icmp.getSelectedItem();
                AutoLocationPanel.this.showSelectedICMPPanel(index, ipVersion.type());
            }
        });
        cons.gridx = 2;
        cons.gridy = 0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.anchor = 17;
        cons.fill = 0;
        cons.insets = new Insets(0, 20, 0, 0);
        pane.add(this.ipVerCombo_Icmp, cons);
        return pane;
    }

    private JPanel getIPRangePanel() {
        this.ipRangePane = new IpRangePane();
        JPanel panel = new JPanel(new BorderLayout(0, 20));
        panel.add((Component)this.ipRangePane, "West");
        panel.add((Component)new DescriptionTextArea(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.ipRangePanelDesc")), "South");
        return panel;
    }

    private JPanel getIPv6RangePanel() {
        this.ipv6RangePane = new IPv6RangePane();
        JPanel panel = new JPanel(new BorderLayout(0, 20));
        panel.add((Component)this.ipv6RangePane, "West");
        panel.add((Component)new DescriptionTextArea(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.ipRangePanelDesc")), "South");
        return panel;
    }

    private JPanel getNetworkPanel() {
        this.networkPane = new NetworkPane();
        JPanel panel = new JPanel(new BorderLayout(0, 20));
        panel.add((Component)this.networkPane, "West");
        panel.add((Component)new DescriptionTextArea(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.networkPanelDesc")), "South");
        return panel;
    }

    private JPanel getIPv6NetworkPanel() {
        this.ipv6NetworkPane = new IPv6SubnetPane();
        JPanel panel = new JPanel(new BorderLayout(0, 20));
        panel.add((Component)this.ipv6NetworkPane, "West");
        panel.add((Component)new DescriptionTextArea(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.networkPanelDesc")), "South");
        return panel;
    }

    private JPanel getDNSServerPanel() {
        this.DNSServer = new IPField();
        this.DNSServer.setMaximumSize(new Dimension(200, 20));
        this.DNSServer.setMinimumSize(new Dimension(150, 20));
        this.DNSServer.setPreferredSize(new Dimension(150, 20));
        JLabel label = new JLabel(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.DNSServerAddress"));
        JPanel middlePane = new JPanel(new GridBagLayout());
        middlePane.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        middlePane.add((Component)this.DNSServer, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new BorderLayout(0, 20));
        panel.add((Component)middlePane, "West");
        panel.add((Component)new DescriptionTextArea(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.dnsServerPanelDesc")), "South");
        return panel;
    }

    private JPanel getIPv6DNSServerPanel() {
        this.ipv6DNSServer = new IPv6Field(false);
        this.ipv6DNSServer.setMaximumSize(new Dimension(400, 30));
        this.ipv6DNSServer.setMinimumSize(new Dimension(300, 30));
        this.ipv6DNSServer.setPreferredSize(new Dimension(300, 30));
        JPanel middlePane = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.DNSServerAddress"));
        middlePane.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        middlePane.add((Component)this.ipv6DNSServer, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new BorderLayout(0, 20));
        panel.add((Component)middlePane, "West");
        panel.add((Component)new DescriptionTextArea(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.dnsServerPanelDesc")), "South");
        return panel;
    }

    private JPanel getDNSResolvePanel() {
        JLabel nameLabel = new JLabel(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.name"));
        JLabel ipLabel = new JLabel(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.DNSResolveAddress"));
        this.ipField = new IPField();
        this.ipField.setMaximumSize(new Dimension(200, 26));
        this.ipField.setMinimumSize(new Dimension(150, 26));
        this.ipField.setPreferredSize(new Dimension(150, 26));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.nameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 22, 0));
        panel.add((Component)ipLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        panel.add((Component)this.ipField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 10, 0, 0), 0, 0));
        JPanel dnspanel = new JPanel(new BorderLayout(0, 20));
        dnspanel.add((Component)panel, "West");
        dnspanel.add((Component)new DescriptionTextArea(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.dnsResolvePanelDesc")), "South");
        return dnspanel;
    }

    private JPanel getIPv6DNSResolvePanel() {
        JLabel ipLabel = new JLabel(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.DNSResolveAddress"));
        JLabel nameLabel = new JLabel(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.name"));
        this.ipv6Field = new IPv6Field(false);
        this.ipv6Field.setMaximumSize(new Dimension(400, 30));
        this.ipv6Field.setMinimumSize(new Dimension(300, 30));
        this.ipv6Field.setPreferredSize(new Dimension(300, 30));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.ipv6NameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 22, 0));
        panel.add((Component)ipLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        panel.add((Component)this.ipv6Field, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        JPanel dnspanel = new JPanel(new BorderLayout(0, 20));
        dnspanel.add((Component)panel, "West");
        dnspanel.add((Component)new DescriptionTextArea(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.dnsResolvePanelDesc")), "South");
        return dnspanel;
    }

    private JPanel getConnectionPanel() {
        JPanel middlePane = new JPanel();
        middlePane.setLayout(new BoxLayout(middlePane, 1));
        middlePane.add(this.connectRdBtn);
        middlePane.add(Box.createRigidArea(new Dimension(0, 4)));
        middlePane.add(this.notConnectRdBtn);
        middlePane.add(Box.createRigidArea(new Dimension(0, 4)));
        ButtonGroup group = new ButtonGroup();
        group.add(this.connectRdBtn);
        group.add(this.notConnectRdBtn);
        this.connectRdBtn.setSelected(true);
        JPanel panel = new JPanel(new BorderLayout(0, 20));
        panel.add((Component)middlePane, "West");
        panel.add((Component)new DescriptionTextArea(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.connectionPanelDesc")), "South");
        return panel;
    }

    private JPanel getConnectionTypePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JLabel label = new JLabel(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.connectionType"));
        panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(this.networkCmbBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        JPanel middlePane = new JPanel(new BorderLayout(0, 20));
        middlePane.add((Component)panel, "West");
        middlePane.add((Component)new DescriptionTextArea(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.connectionTypePanelDesc")), "South");
        return middlePane;
    }

    public boolean isValidData() {
        try {
            AlSignatureOrObject myObj = null;
            AddressObject addObj = null;
            ArrayList<AddressObject> addressList = new ArrayList<AddressObject>(2);
            AutoLocationUsageTypeComboBoxModel.UsageComboBoxItem selectedUsage = this.autoLocUsageModel.getSelectedItem();
            AutoLocationUsageTypeComboBoxModel.UsageTypeEnum selectedIndex = selectedUsage.type();
            IPTypeComboBoxModel.IPTypeComboBoxItem ipVersion = (IPTypeComboBoxModel.IPTypeComboBoxItem)this.ipVerCombo.getSelectedItem();
            if (IPTypeComboBoxModel.IPTypeEnum.V6 == ipVersion.type()) {
                selectedIndex = selectedUsage.ipV6Type();
            }
            switch (selectedIndex) {
                case NoSpecificCondition: {
                    LocationHandler.getInstance().setAlSignatureObject(null);
                    return true;
                }
                case IPRange: {
                    if (!this.ipRangePane.isValidValue()) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), this.ipRangePane.getErrorMessage(), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
                        return false;
                    }
                    myObj = new AlSignatureOrObject(0);
                    IpRange ipRangeObj = new IpRange();
                    ipRangeObj.setStart(this.ipRangePane.getFromIP());
                    ipRangeObj.setEnd(this.ipRangePane.getToIP());
                    addObj = new AddressObject(1, (ConfigObject)ipRangeObj);
                    addressList.add(addObj);
                    myObj.setNewAddresses(addressList);
                    break;
                }
                case SubNetwork: {
                    if (!this.networkPane.isValidValue()) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), this.networkPane.getErrorMessage(), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
                        return false;
                    }
                    myObj = new AlSignatureOrObject(0);
                    SubNet subNetObj = new SubNet();
                    subNetObj.setNetAddr(this.networkPane.getIPAddress());
                    subNetObj.setNetMask(this.networkPane.getMaskAddress());
                    addObj = new AddressObject(2, (ConfigObject)subNetObj);
                    addressList.add(addObj);
                    myObj.setNewAddresses(addressList);
                    break;
                }
                case DNSServer: {
                    if (!this.DNSServer.isValid()) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.enterAValidDNSServerAddress"), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
                        return false;
                    }
                    myObj = new AlSignatureOrObject(3);
                    IpAddress ipObj = new IpAddress();
                    ipObj.setContent(this.DNSServer.getText());
                    addObj = new AddressObject(0, (ConfigObject)ipObj);
                    addressList.add(addObj);
                    myObj.setNewAddresses(addressList);
                    break;
                }
                case DNSResolve: {
                    String nameFieldValue = this.getSafeText(this.nameField);
                    if (nameFieldValue.length() <= 0) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.enterNameForDNSResolve"), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
                        return false;
                    }
                    if (!this.ipField.isValid()) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.enterAValidDNSResolveAddress"), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
                        return false;
                    }
                    myObj = new AlSignatureOrObject(9);
                    IpAddress ipObj1 = new IpAddress();
                    ipObj1.setContent(this.ipField.getText());
                    addObj = new AddressObject(0, (ConfigObject)ipObj1);
                    addObj.setName(nameFieldValue);
                    addressList.add(addObj);
                    myObj.setNewAddresses(addressList);
                    break;
                }
                case PolicyManagerConnection: {
                    myObj = new AlSignatureOrObject(6);
                    boolean isConnect = this.connectRdBtn.isSelected();
                    myObj.setCmsType(isConnect);
                    break;
                }
                case NetworkConnectionType: {
                    myObj = new AlSignatureOrObject(5);
                    String selectType = (String)this.networkCmbBox.getSelectedItem();
                    myObj.setNetworkType(selectType);
                    break;
                }
                case ICMPRequest: {
                    myObj = new AlSignatureOrObject(15);
                    int selectIndex = this.icmpCmbBox.getSelectedIndex();
                    if (selectIndex == 0) {
                        IPTypeComboBoxModel.IPTypeComboBoxItem icmpIPType = (IPTypeComboBoxModel.IPTypeComboBoxItem)this.ipVerCombo_Icmp.getSelectedItem();
                        if (IPTypeComboBoxModel.IPTypeEnum.V6 == icmpIPType.type()) {
                            if (!this.icmpIpv6Pane.isValidValue()) {
                                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.invalidIPv6Address"), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
                                return false;
                            }
                            Ipv6Address ipv6Address = new Ipv6Address();
                            ipv6Address.setContent(this.icmpIpv6Pane.getText());
                            addObj = new AddressObject(7, (ConfigObject)ipv6Address);
                            myObj.addAddress(addObj);
                            break;
                        }
                        if (!this.icmpIpPane.isValidValue()) {
                            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.invalidateIPAddress"), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
                            return false;
                        }
                        IpAddress ipAdress = new IpAddress();
                        ipAdress.setContent(this.icmpIpPane.getText());
                        addObj = new AddressObject(0, (ConfigObject)ipAdress);
                        myObj.addAddress(addObj);
                        break;
                    }
                    if (selectIndex == 1) {
                        if (!this.icmphostNamePane.isValidValue()) {
                            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.invalidateICMPHostName"), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
                            return false;
                        }
                        DnsHost dnHost = new DnsHost();
                        dnHost.setContent(this.icmphostNamePane.getText());
                        addObj = new AddressObject(6, (ConfigObject)dnHost);
                        myObj.addAddress(addObj);
                        break;
                    }
                    if (!this.hostGroupLink.isValidValue()) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.invalidateHostGroup"), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
                        return false;
                    }
                    HostGroupObject group = this.hostGroupLink.getSelectedHostGroup();
                    addObj = new AddressObject(5, (ConfigObject)group.getHostGroup());
                    myObj.addAddress(addObj);
                    break;
                }
                case IPv6Range: {
                    if (!this.ipv6RangePane.isValidValue()) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), this.ipv6RangePane.getErrorMessage(), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
                        this.ipv6RangePane.requestFocus();
                        return false;
                    }
                    myObj = new AlSignatureOrObject(0);
                    Ipv6Range ipv6RangeObj = new Ipv6Range();
                    ipv6RangeObj.setStart(this.ipv6RangePane.getFromIP());
                    ipv6RangeObj.setEnd(this.ipv6RangePane.getToIP());
                    addObj = new AddressObject(8, (ConfigObject)ipv6RangeObj);
                    addressList.add(addObj);
                    myObj.setNewAddresses(addressList);
                    break;
                }
                case IPv6SubNetwork: {
                    if (!this.ipv6NetworkPane.isValidValue()) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), this.ipv6NetworkPane.getErrorMessage(), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
                        this.ipv6NetworkPane.requestFocus();
                        return false;
                    }
                    myObj = new AlSignatureOrObject(0);
                    Ipv6SubNet ipv6SubNetObj = new Ipv6SubNet();
                    ipv6SubNetObj.setContent(this.ipv6NetworkPane.getText());
                    addObj = new AddressObject(9, (ConfigObject)ipv6SubNetObj);
                    addressList.add(addObj);
                    myObj.setNewAddresses(addressList);
                    break;
                }
                case IPv6DNSServer: {
                    if (!this.ipv6DNSServer.isValidValue()) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.enterAValidIPv6DNSServerAddress"), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
                        this.ipv6DNSServer.requestFocus();
                        return false;
                    }
                    myObj = new AlSignatureOrObject(3);
                    Ipv6Address ipv6Obj = new Ipv6Address();
                    ipv6Obj.setContent(this.ipv6DNSServer.getText());
                    addObj = new AddressObject(7, (ConfigObject)ipv6Obj);
                    addressList.add(addObj);
                    myObj.setNewAddresses(addressList);
                    break;
                }
                case IPv6DNSResolve: {
                    String ipv6NameValue = this.getSafeText(this.ipv6NameField);
                    if (ipv6NameValue.length() <= 0) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.enterNameForDNSResolve"), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
                        this.ipv6NameField.requestFocus();
                        return false;
                    }
                    if (!this.ipv6Field.isValidValue()) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.enterAValidIPv6DNSResolveAddress"), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
                        this.ipv6Field.requestFocus();
                        return false;
                    }
                    myObj = new AlSignatureOrObject(9);
                    Ipv6Address ipv6DNSAddress = new Ipv6Address();
                    ipv6DNSAddress.setContent(this.ipv6Field.getText());
                    addObj = new AddressObject(7, (ConfigObject)ipv6DNSAddress);
                    addObj.setName(ipv6NameValue);
                    addressList.add(addObj);
                    myObj.setNewAddresses(addressList);
                    break;
                }
                case LocalHostName: {
                    String localHostNameValue = this.getSafeText(this.localHostNameField);
                    if (localHostNameValue.length() <= 0) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.enterNameForLocalHostName"), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
                        return false;
                    }
                    if (localHostNameValue.startsWith(".")) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(POLICYDIALOG, "AlSignatureConditionDlg.invalidLocalHostNameError"), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
                        return false;
                    }
                    myObj = new AlSignatureOrObject(16);
                    LocationCriteriaCondition locationCriteriaCondition = new LocationCriteriaCondition();
                    locationCriteriaCondition.setCondition(localHostNameValue);
                    myObj.setOperator(LocalHostName.EQUAL);
                    myObj.setLocationCriteriaConditions(new LocationCriteriaCondition[]{locationCriteriaCondition});
                    break;
                }
                case UserName: {
                    String userNameValue = this.getSafeText(this.userNameField);
                    if (userNameValue.length() <= 0) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.enterNameForUserName"), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
                        return false;
                    }
                    myObj = new AlSignatureOrObject(17);
                    LocationCriteriaCondition locationCriteriaConditionUserName = new LocationCriteriaCondition();
                    locationCriteriaConditionUserName.setCondition(userNameValue);
                    myObj.setOperator(UserName.EQUAL);
                    myObj.setLocationCriteriaConditions(new LocationCriteriaCondition[]{locationCriteriaConditionUserName});
                    break;
                }
                case FileExists: {
                    try {
                        if (!this.fileExistsPanel.validateInput()) {
                            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.enterNameForFileExists"), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
                            return false;
                        }
                    }
                    catch (GUICheckException e) {
                        JOptionPane.showMessageDialog(this, e.getMessage(), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
                        return false;
                    }
                    String fileExistsValue = this.fileExistsPanel.getFileName();
                    myObj = new AlSignatureOrObject(18);
                    LocationCriteriaCondition locationCriteriaConditionFileExists = new LocationCriteriaCondition();
                    locationCriteriaConditionFileExists.setCondition(fileExistsValue);
                    myObj.setOperator(FileExists.EQUAL);
                    myObj.setLocationCriteriaConditions(new LocationCriteriaCondition[]{locationCriteriaConditionFileExists});
                    break;
                }
                case OSVersion: {
                    OS os = this.osVersionPane.getOS();
                    if (os == null) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.enterNameForOSVersion"), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
                        return false;
                    }
                    myObj = new AlSignatureOrObject(19);
                    myObj.setOperator(OSVersion.EQUAL);
                    myObj.setOSs(new OS[]{os});
                    break;
                }
            }
            if (myObj == null) {
                return false;
            }
            AlSignatureObject newObj = new AlSignatureObject(true);
            newObj.addAnCondition(myObj);
            LocationHandler.getInstance().setAlSignatureObject(newObj);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.error"), 0);
            Manager.getFrame().showLoginPanel();
            return false;
        }
        return true;
    }

    private void showSelectedPanel(AutoLocationUsageTypeComboBoxModel.UsageComboBoxItem index, IPTypeComboBoxModel.IPTypeComboBoxItem ipVersion) {
        boolean ipVersionControlVisible = true;
        AutoLocationUsageTypeComboBoxModel.UsageTypeEnum displayPanel = index.type();
        if (ipVersion.type() == IPTypeComboBoxModel.IPTypeEnum.V6) {
            displayPanel = index.ipV6Type();
        }
        switch (index.type()) {
            case IPRange: 
            case SubNetwork: 
            case DNSServer: 
            case DNSResolve: {
                break;
            }
            default: {
                displayPanel = index.type();
                ipVersionControlVisible = false;
            }
        }
        ((CardLayout)this.addressCompPanel.getLayout()).show(this.addressCompPanel, displayPanel.name());
        this.ipVerLabel.setVisible(ipVersionControlVisible);
        this.ipVerCombo.setVisible(ipVersionControlVisible);
    }

    private void showSelectedICMPPanel(AddressTypeICMPPingComboBoxModel.AddressTypeICMPPingEnum index, IPTypeComboBoxModel.IPTypeEnum ipVersion) {
        AddressTypeICMPPingComboBoxModel.AddressTypeICMPPingEnum displayPanel = index;
        this.ipVerCombo_Icmp.setVisible(true);
        switch (index) {
            case IPAddress: {
                if (IPTypeComboBoxModel.IPTypeEnum.V6 != ipVersion) break;
                displayPanel = AddressTypeICMPPingComboBoxModel.AddressTypeICMPPingEnum.IPAddressV6;
                break;
            }
            default: {
                this.ipVerCombo_Icmp.setVisible(false);
            }
        }
        ((CardLayout)this.icmpCardPane.getLayout()).show(this.icmpCardPane, displayPanel.name());
    }

    private JPanel getLocalHostNamePanel() {
        JLabel nameLabel = new JLabel(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.name"));
        JPanel localHostNamePanel = new JPanel(new GridBagLayout());
        localHostNamePanel.add((Component)nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        localHostNamePanel.add((Component)this.localHostNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 22, 0));
        RestrictedPlainDocument localHostNameDoc = new RestrictedPlainDocument(255);
        localHostNameDoc.setValidator("~!@#$^&()+{}|:\"<>`=[]\\;'/", false);
        this.localHostNameField.setDocument(localHostNameDoc);
        JPanel panel = new JPanel(new BorderLayout(0, 20));
        panel.add((Component)localHostNamePanel, "West");
        panel.add((Component)new DescriptionTextArea(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.localHostNamePanelDesc")), "South");
        return panel;
    }

    private JPanel getUserNamePanel() {
        JLabel nameLabel = new JLabel(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.username"));
        JPanel userNamePanel = new JPanel(new GridBagLayout());
        userNamePanel.add((Component)nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        userNamePanel.add((Component)this.userNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 22, 0));
        JPanel panel = new JPanel(new BorderLayout(0, 20));
        panel.add((Component)userNamePanel, "West");
        panel.add((Component)new DescriptionTextArea(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.userNamePanelDesc")), "South");
        return panel;
    }

    private JPanel getFileExistsPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 20));
        panel.add((Component)this.fileExistsPanel, "Center");
        panel.add((Component)new DescriptionTextArea(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.fileExistsPanelDesc")), "South");
        return panel;
    }

    private JPanel getOSVersionPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 20));
        panel.add((Component)this.osVersionPane, "Center");
        panel.add((Component)new DescriptionTextArea(MSGRES.getString(POLICYDIALOG, "AutoLocationPanel.osVersionPanelDesc")), "South");
        return panel;
    }

    private String getSafeText(JTextField field) {
        String txt = field.getText();
        return txt == null ? "" : txt.trim();
    }
}

