/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.UserInterfaceObject;
import com.sygate.scm.console.ui.policy.dialog.AgentGUIDlg;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.BadFormatException;
import com.sygate.scm.util.IntegerRange;
import com.sygate.scm.util.IntegerSet;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ArbitrationSettingDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.policy.dialog.policydialog");
    private static final String[][] TITLE = new String[][]{{MSG_RES.getString("ArbitrationSettingDlg.selectServerSettings"), "0x22"}, {MSG_RES.getString("ArbitrationSettingDlg.lockOrUnlockSettingsOnClient"), null}, {MSG_RES.getString("ArbitrationSettingDlg.firewallPolicy"), "0x23"}, {MSG_RES.getString("ArbitrationSettingDlg.intrusionPreventionPolicy"), "0x24"}, {MSG_RES.getString("ArbitrationSettingDlg.ntrPolicy"), "0x30"}};
    private static final String[][] SUBTITLE = new String[][]{null, {MSG_RES.getString("ArbitrationSettingDlg.antivirusPolicy"), "0x22"}, null, {MSG_RES.getString("ArbitrationSettingDlg.clientUserInterface"), null}, {MSG_RES.getString("ArbitrationSettingDlg.agentLoggingOptions"), null}, {MSG_RES.getString("ArbitrationSettingDlg.firewall"), "0x23"}, {MSG_RES.getString("ArbitrationSettingDlg.titleUnmatchedIPTrafficSettings"), "0x23"}, null, {MSG_RES.getString("ArbitrationSettingDlg.smartTrafficFiltering"), "0x23"}, {MSG_RES.getString("ArbitrationSettingDlg.trafficAndStealthSettings"), "0x23"}, null, {MSG_RES.getString("ArbitrationSettingDlg.intrusionPreventionPolicy.settings"), "0x24"}, {MSG_RES.getString("ArbitrationSettingDlg.intrusionPreventionPolicy.notifications"), "0x24"}, null, {MSG_RES.getString("ArbitrationSettingDlg.ntrPolicy.settings"), "0x30"}};
    private static final ArbiFeature[] FEATURE = new ArbiFeature[]{null, new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.avAutoProtect"), 393217, "0x22"), new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.avHPS"), 393218, "0x22"), new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.avSubmissions"), 393220, "0x22"), new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.avGeneral"), 393216, "0x22"), null, new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.hideTrayIcon"), 329216), null, new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.configureLogs"), 196608), null, new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.blockAll"), 327936, "0x23"), new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.blockTrafficBeforeServiceStarts"), 132864, "0x23"), new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.disableButton"), 329728, "0x23"), new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.securityTestButton"), 329472, "0x23"), null, new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.configUnmatchedIPTrafficSettings"), 135680, "0x23"), null, new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.smartDHCP"), 134656, "0x23"), new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.smartDNS"), 134400, "0x23"), new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.smartWINS"), 134912, "0x23"), new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.tokenRingTraffice"), 135424, "0x23"), null, new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.netbiosProtection"), 134144, "0x23"), new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.antiMACSpoofing"), 133376, "0x23"), new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.stealthModeBrowsing"), 132096, "0x23"), new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.antiIPSpoofing"), 133632, "0x23"), new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.networkApplicationMonitoring"), 136192, "0x23"), new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.OSFingerprintMasquerading"), 133888, "0x23"), new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.denialOfServiceDetection"), 132352, "0x23"), new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.portscanDetection"), 131584, "0x23"), new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.blockAttackersIP"), 132608, "0x23"), null, new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.intrusionPreventionSystem"), 131328, "0x24"), new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.browserProtection"), 131840, "0x24"), new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.proactiveExploitPrevention"), 136448, "0x24"), null, new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.userNotification"), 330752, "0x24"), null, new ArbiFeature(MSG_RES.getString("ArbitrationSettingDlg.ntrPolicy.enableNtr"), 139264, "0x30")};
    private UserInterfaceObject uiObj;
    private JPanel jPanel = null;
    private JPanel jPanel1 = null;
    private JPanel jLabel = null;
    private JPanel jLabel1 = null;
    private JPanel jLabel2 = null;
    Vector<Integer> index = new Vector();
    private ArrayList<JRadioButton> serverRadioList = new ArrayList();
    private ArrayList<JRadioButton> clientRadioList = new ArrayList();
    private JTabbedPane jTabbedPane = null;
    private JPanel serverPanel = null;
    private AgentGUIDlg serverdlg = null;
    private HashMap<Integer, JRadioButton> clientMap = new HashMap();

    public ArbitrationSettingDlg(JFrame frame, String string, boolean modal) {
        super(frame, string, modal);
        this.setPreferredSize(new Dimension(700, 690));
        this.initialize();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        if (this.jTabbedPane.getSelectedIndex() == 0) {
            return "sesm_computersnusers_policies_advsettings_sc_edit_arbitration_rule_set";
        }
        return "sesm_computersnusers_policies_advsettings_sc_edit_agentgui";
    }

    @Override
    protected boolean isValidate() {
        return this.serverdlg.isValidate();
    }

    @Override
    protected void commit() {
        this.serverdlg.commit();
        IntegerSet intSet = new IntegerSet();
        int index = 0;
        for (int i = 0; i < FEATURE.length; ++i) {
            if (FEATURE[i] == null) continue;
            JRadioButton server = this.serverRadioList.get(index);
            if (server.isSelected()) {
                intSet.add(new IntegerRange(ArbitrationSettingDlg.FEATURE[i].feature), false);
                if (ArbitrationSettingDlg.FEATURE[i].feature == 135680) {
                    intSet.add(135936, false);
                }
            }
            ++index;
        }
        String strFeature = intSet.toString(16);
        this.uiObj.setArbitrationFeature(strFeature);
    }

    private void initialize() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add(this.getJTabbedPane());
        this.getContentPane().add(panel);
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setResizable(false);
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.add((Component)this.getClientControlPane(), MSG_RES.getString("ArbitrationSettingDlg.arbitrationSettings"));
            this.jTabbedPane.add((Component)this.getServerControlPane(), MSG_RES.getString("ArbitrationSettingDlg.agentGUISettings"));
            this.jTabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent event) {
                    int index;
                    if (event.getSource() instanceof JTabbedPane && (index = ArbitrationSettingDlg.this.jTabbedPane.getSelectedIndex()) == 1) {
                        ArbitrationSettingDlg.this.initializeServerControlPanel();
                    }
                }
            });
        }
        return this.jTabbedPane;
    }

    private JPanel getClientControlPane() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)new DescriptionTextArea(MSG_RES.getString("ArbitrationSettingDlg.selectServerControlIf")), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.jPanel.add((Component)this.getJPanel1(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        }
        return this.jPanel;
    }

    private JPanel getServerControlPane() {
        if (this.serverPanel == null) {
            this.serverdlg = new AgentGUIDlg((JFrame)Manager.getFrame(), MSG_RES.getString("ArbitrationSettingDlg.agentGUISetting"), true, 2);
            this.serverPanel = this.serverdlg.getJPanel();
        }
        return this.serverPanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel(new BorderLayout());
            this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
            GridBagLayout gridBagLayout = new GridBagLayout();
            JPanel headerPanel = new JPanel();
            headerPanel.setLayout(gridBagLayout);
            headerPanel.add((Component)this.getHeaderPanelCol1JLabel(), this.getHeaderPanelCol1Constraints());
            headerPanel.add((Component)this.getHeaderPanelCol2JLabel(), this.getHeaderPanelCol2Constraints());
            headerPanel.add((Component)this.getHeaderPanelCol3JLabel(), this.getHeaderPanelCol3Constraints());
            JPanel tablePanel = new JPanel();
            tablePanel.setLayout(gridBagLayout);
            tablePanel.setOpaque(true);
            this.createTable(tablePanel, this.getHeaderPanelCol2JLabel().getPreferredSize().width, this.getHeaderPanelCol3JLabel().getPreferredSize().width - 16);
            JPanel viewportView = new JPanel();
            viewportView.setBorder(BorderFactory.createEmptyBorder());
            viewportView.setLayout(new BorderLayout());
            viewportView.add((Component)tablePanel, "North");
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(viewportView);
            jScrollPane.setPreferredSize(new Dimension(443, 327));
            this.jPanel1.add((Component)headerPanel, "North");
            this.jPanel1.add((Component)jScrollPane, "Center");
        }
        return this.jPanel1;
    }

    private GridBagConstraints getHeaderPanelCol1Constraints() {
        GridBagConstraints hpCol2Constraints1 = new GridBagConstraints();
        hpCol2Constraints1.weightx = 1.0;
        hpCol2Constraints1.gridx = 0;
        hpCol2Constraints1.gridy = 0;
        hpCol2Constraints1.fill = 2;
        hpCol2Constraints1.ipady = 0;
        hpCol2Constraints1.insets = new Insets(0, 0, 0, 0);
        return hpCol2Constraints1;
    }

    private GridBagConstraints getHeaderPanelCol2Constraints() {
        GridBagConstraints hpCol2Constraints2 = new GridBagConstraints();
        hpCol2Constraints2.fill = 2;
        hpCol2Constraints2.gridx = 1;
        hpCol2Constraints2.gridy = 0;
        hpCol2Constraints2.ipadx = 15;
        hpCol2Constraints2.ipady = 0;
        hpCol2Constraints2.insets = new Insets(0, -1, 0, -1);
        return hpCol2Constraints2;
    }

    private GridBagConstraints getHeaderPanelCol3Constraints() {
        GridBagConstraints hpCol2Constraints3 = new GridBagConstraints();
        hpCol2Constraints3.gridx = 2;
        hpCol2Constraints3.gridy = 0;
        hpCol2Constraints3.fill = 2;
        hpCol2Constraints3.ipadx = 15;
        hpCol2Constraints3.ipady = 0;
        hpCol2Constraints3.insets = new Insets(0, 0, 0, 0);
        return hpCol2Constraints3;
    }

    private JPanel getHeaderPanelCol1JLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JPanel();
            JLabel j = new JLabel();
            j.setText(MSG_RES.getString("ArbitrationSettingDlg.feature"));
            j.setHorizontalAlignment(0);
            this.jLabel.add(j);
            this.jLabel.setBorder(BorderFactory.createEtchedBorder());
        }
        return this.jLabel;
    }

    private JPanel getHeaderPanelCol2JLabel() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JPanel();
            JLabel j = new JLabel();
            j.setText(MSG_RES.getString("ArbitrationSettingDlg.server"));
            j.setHorizontalAlignment(0);
            this.jLabel1.add(j);
            this.jLabel1.setBorder(BorderFactory.createEtchedBorder());
        }
        return this.jLabel1;
    }

    private JPanel getHeaderPanelCol3JLabel() {
        if (this.jLabel2 == null) {
            this.jLabel2 = new JPanel();
            JLabel j = new JLabel();
            j.setText(MSG_RES.getString("ArbitrationSettingDlg.client"));
            j.setHorizontalAlignment(0);
            this.jLabel2.add(j);
            this.jLabel2.setBorder(BorderFactory.createEtchedBorder());
        }
        return this.jLabel2;
    }

    private static GridBagConstraints getTitleConstraints(int y) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = y;
        cons.weightx = 1.0;
        cons.fill = 2;
        cons.gridwidth = 3;
        cons.insets = new Insets(-1, 0, 0, 0);
        return cons;
    }

    private static GridBagConstraints getCol1Constraints(int y) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = y;
        cons.weightx = 1.0;
        cons.fill = 1;
        cons.insets = new Insets(-1, 0, 0, 0);
        return cons;
    }

    private static GridBagConstraints getCol2Constraints(int y) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 1;
        cons.gridy = y;
        cons.ipadx = 15;
        cons.fill = 2;
        cons.insets = new Insets(-1, -1, 0, -1);
        return cons;
    }

    private static GridBagConstraints getCol3Constraints(int y) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 2;
        cons.gridy = y;
        cons.ipadx = 15;
        cons.fill = 2;
        cons.insets = new Insets(-1, 0, 0, 0);
        return cons;
    }

    private static JPanel getTextCell(JTextArea text) {
        text.setLayout(new FlowLayout(0));
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setCaretPosition(0);
        text.setPreferredSize(new Dimension(350, 30));
        text.setEditable(false);
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setPreferredSize(new Dimension(300, 30));
        panel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        panel.add(Box.createRigidArea(new Dimension(10, 0)));
        JScrollPane jScrollPane = new JScrollPane(text);
        jScrollPane.setBorder(BorderFactory.createLineBorder(UIColorUtilities.LIGHT_LINE_COLOR));
        panel.add(jScrollPane);
        return panel;
    }

    private static JPanel getTitleCell(JTextArea text) {
        text.setLayout(new FlowLayout(0));
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setPreferredSize(new Dimension(500, 30));
        text.setCaretPosition(0);
        text.setEditable(false);
        Font font = text.getFont();
        font = font.deriveFont(1);
        text.setFont(font);
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        JScrollPane jScrollPane = new JScrollPane(text);
        jScrollPane.setBorder(BorderFactory.createLineBorder(UIColorUtilities.LIGHT_LINE_COLOR));
        panel.add(jScrollPane);
        return panel;
    }

    private static JPanel getSubTitleCell(JLabel label) {
        label.setHorizontalAlignment(2);
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        panel.add(label);
        return panel;
    }

    private static JPanel getRadioCell(JRadioButton rdBtn) {
        rdBtn.setOpaque(false);
        int width = (int)rdBtn.getPreferredSize().getWidth();
        rdBtn.setPreferredSize(new Dimension(width, 30));
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        panel.add(rdBtn);
        return panel;
    }

    private boolean canAddTitle(String[] title, boolean disallowedAV, boolean disallowedFW, boolean disallowedIP, boolean disallowedNtr) {
        if (title != null && title[1] != null) {
            return this.canAddType(title[1], disallowedAV, disallowedFW, disallowedIP, disallowedNtr);
        }
        return true;
    }

    private boolean canAddFeature(ArbiFeature feature, boolean disallowedAV, boolean disallowedFW, boolean disallowedIP, boolean disallowedNtr) {
        if (feature != null && feature.policyType != null) {
            return this.canAddType(feature.policyType, disallowedAV, disallowedFW, disallowedIP, disallowedNtr);
        }
        return true;
    }

    private boolean canAddType(String policyType, boolean disallowedAV, boolean disallowedFW, boolean disallowedIP, boolean disallowedNtr) {
        if (policyType == null || policyType.trim().length() == 0) {
            return true;
        }
        if (policyType.endsWith("0x22") && disallowedAV) {
            return false;
        }
        if (policyType.endsWith("0x23") && disallowedFW) {
            return false;
        }
        if (policyType.endsWith("0x24") && disallowedIP) {
            return false;
        }
        return !policyType.equals("0x30") || !disallowedNtr;
    }

    private void createTable(JPanel panel, int col2Width, int col3Width) {
        boolean disallowedAV = !AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x22");
        boolean disallowedFW = !AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x23");
        boolean disallowedIP = !AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x24");
        boolean disallowedNtr = !AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x30");
        int tCnt = 0;
        int sCnt = 0;
        int row = 0;
        for (int i = 0; i < FEATURE.length; ++i) {
            if (FEATURE[i] == null) {
                if (SUBTITLE[sCnt] == null) {
                    if (this.canAddTitle(TITLE[tCnt], disallowedAV, disallowedFW, disallowedIP, disallowedNtr)) {
                        JTextArea titleLbl = new JTextArea(TITLE[tCnt][0]);
                        panel.add((Component)ArbitrationSettingDlg.getTitleCell(titleLbl), ArbitrationSettingDlg.getTitleConstraints(row++));
                    }
                    ++tCnt;
                    ++sCnt;
                }
                if (this.canAddTitle(SUBTITLE[sCnt], disallowedAV, disallowedFW, disallowedIP, disallowedNtr)) {
                    JLabel subTitleLbl = new JLabel(SUBTITLE[sCnt][0]);
                    panel.add((Component)ArbitrationSettingDlg.getSubTitleCell(subTitleLbl), ArbitrationSettingDlg.getCol1Constraints(row++));
                }
                ++sCnt;
                continue;
            }
            boolean addFeature = this.canAddFeature(FEATURE[i], disallowedAV, disallowedFW, disallowedIP, disallowedNtr);
            JTextArea featureLbl = new JTextArea(ArbitrationSettingDlg.FEATURE[i].name);
            JPanel textCellPanel = ArbitrationSettingDlg.getTextCell(featureLbl);
            if (addFeature) {
                panel.add((Component)textCellPanel, ArbitrationSettingDlg.getCol1Constraints(row));
            }
            JRadioButton serverRadio = new JRadioButton();
            JRadioButton clientRadio = new JRadioButton();
            ButtonGroup bGroup = new ButtonGroup();
            bGroup.add(serverRadio);
            bGroup.add(clientRadio);
            JPanel col2RadioCell = ArbitrationSettingDlg.getRadioCell(serverRadio);
            Dimension col2Size = new Dimension(col2Width, col2RadioCell.getPreferredSize().height);
            col2RadioCell.setMinimumSize(col2Size);
            col2RadioCell.setPreferredSize(col2Size);
            if (addFeature) {
                panel.add((Component)col2RadioCell, ArbitrationSettingDlg.getCol2Constraints(row));
            }
            JPanel col3RadioCell = ArbitrationSettingDlg.getRadioCell(clientRadio);
            Dimension col3Size = new Dimension(col3Width, col3RadioCell.getPreferredSize().height);
            col3RadioCell.setMinimumSize(col3Size);
            col3RadioCell.setPreferredSize(col3Size);
            if (addFeature) {
                panel.add((Component)col3RadioCell, ArbitrationSettingDlg.getCol3Constraints(row));
            }
            this.serverRadioList.add(serverRadio);
            this.clientRadioList.add(clientRadio);
            if (addFeature) {
                ++row;
            }
            if (!ArbitrationSettingDlg.FEATURE[i].name.equalsIgnoreCase(MSG_RES.getString("ArbitrationSettingDlg.proactiveExploitPrevention")) || !addFeature) continue;
            textCellPanel.setVisible(false);
            col2RadioCell.setVisible(false);
            col3RadioCell.setVisible(false);
        }
    }

    private void updateClientControlPanel() {
        String features = this.uiObj.getArbitrationFeature();
        IntegerSet set = new IntegerSet();
        if (features != null) {
            try {
                set.init(features, 16);
            }
            catch (BadFormatException badFormatException) {
                LoggerUtilities.logException((Throwable)badFormatException);
            }
        } else {
            set.add(new IntegerRange(393217));
            set.add(new IntegerRange(393218));
            set.add(new IntegerRange(393219));
            set.add(new IntegerRange(393221));
            set.add(new IntegerRange(393216));
            set.add(new IntegerRange(393220));
            set.add(new IntegerRange(131328));
            set.add(new IntegerRange(131840));
            set.add(new IntegerRange(136448));
            set.add(new IntegerRange(139264));
        }
        int index = 0;
        for (int i = 0; i < FEATURE.length; ++i) {
            if (FEATURE[i] == null) continue;
            if (set.contains(ArbitrationSettingDlg.FEATURE[i].feature)) {
                JRadioButton server = this.serverRadioList.get(index);
                server.setSelected(true);
            } else {
                JRadioButton client = this.clientRadioList.get(index);
                client.setSelected(true);
            }
            this.clientMap.put(ArbitrationSettingDlg.FEATURE[i].feature, this.serverRadioList.get(index));
            ++index;
        }
    }

    private void updateServerControlPanel() {
        this.uiObj.setShowAgentGui(true);
        this.serverdlg.setObject(this.uiObj);
        this.setAgentGUIMap();
    }

    private void setAgentGUIMap() {
        this.index.add(329216);
        this.index.add(329472);
        this.index.add(329728);
        this.index.add(330752);
        this.index.add(135680);
        this.index.add(135936);
    }

    private void initializeServerControlPanel() {
        Vector<Object> ind = new Vector<Object>();
        Enumeration<Integer> en = this.index.elements();
        while (en.hasMoreElements()) {
            Integer o = en.nextElement();
            if (!this.clientMap.containsKey(o) || !this.clientMap.get(o).isSelected()) continue;
            ind.add(o);
        }
        this.serverdlg.setEnabledIndex(ind);
        this.serverdlg.initializeServerControlPanel();
    }

    public void setObject(UserInterfaceObject uiObj) {
        this.uiObj = uiObj;
        this.updateClientControlPanel();
        this.updateServerControlPanel();
    }

    @Override
    public void setReadOnly(boolean isInherit) {
        UIUtilities.setContainerStatus(this.getJTabbedPane(), false);
        this.jBOk.setEnabled(false);
        this.jBOk.setToolTipText(MSG_RES.getString("ArbitrationSettingDlg.arbitrationSettingsInheritedYouCannotChangeThem"));
        int dlgWidth = this.getSize().width;
        int dlgHeight = this.getSize().height;
        this.setSize(dlgWidth, dlgHeight + 40);
    }

    static class ArbiFeature {
        String name;
        int feature;
        String policyType = null;

        ArbiFeature(String n, int f) {
            this(n, f, null);
        }

        ArbiFeature(String n, int f, String policyType) {
            this.name = n;
            this.feature = f;
            this.policyType = policyType;
        }
    }
}

