/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.logicobject.ApplicationObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ApplicationDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private ApplicationObject appObj;
    private JPanel jPanel = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JTextField nameField = null;
    private JTextField descriptionField = null;
    private JLabel jLabel7 = null;

    public ApplicationDlg(JFrame parent, String title, boolean modal) {
        super(parent, title, modal, false);
        this.initialize();
    }

    private void initialize() {
        this.getContentPane().add(this.getJPanel());
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setResizable(false);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getJLabel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 5, 10), 0, 0));
            this.jPanel.add((Component)this.getJLabel1(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 5, 10), 0, 0));
            this.jPanel.add((Component)this.getNameField(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 50), 0, 0));
            this.jPanel.add((Component)this.getDescriptionField(), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 50), 0, 0));
            this.jPanel.add((Component)this.getJLabel7(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        }
        return this.jPanel;
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setBounds(2, 44, 96, 21);
            this.jLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ApplicationDlg.fileName"));
            this.jLabel.setHorizontalAlignment(4);
        }
        return this.jLabel;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setBounds(2, 73, 96, 21);
            this.jLabel1.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ApplicationDlg.description"));
            this.jLabel1.setHorizontalAlignment(4);
        }
        return this.jLabel1;
    }

    private JTextField getNameField() {
        if (this.nameField == null) {
            this.nameField = new JTextField();
            this.nameField.setBounds(123, 43, 264, 21);
            this.nameField.setText("");
            RestrictedPlainDocument doc = new RestrictedPlainDocument(260);
            doc.setValidator("\"/?<>|", false);
            this.nameField.setDocument(doc);
        }
        return this.nameField;
    }

    private JTextField getDescriptionField() {
        if (this.descriptionField == null) {
            this.descriptionField = new JTextField();
            this.descriptionField.setBounds(123, 74, 264, 21);
            RestrictedPlainDocument doc = new RestrictedPlainDocument(1024);
            this.descriptionField.setDocument(doc);
        }
        return this.descriptionField;
    }

    @Override
    protected boolean isValidate() {
        try {
            String strFileName = this.nameField.getText().trim();
            if (strFileName == null || strFileName.equals("")) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ApplicationDlg.emptyFileName"), this.nameField);
            }
            if (strFileName.equals("*.exe")) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ApplicationDlg.dotExeIsAnInvalidName"), this.nameField);
            }
        }
        catch (GUICheckException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ApplicationDlg.error"), 0);
            ex.getErrorComponent().requestFocus();
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        this.appObj.setFileName(this.nameField.getText().trim());
        this.appObj.setFileDescription(this.descriptionField.getText());
    }

    private JLabel getJLabel7() {
        if (this.jLabel7 == null) {
            this.jLabel7 = new JLabel();
            this.jLabel7.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ApplicationDlg.fileInputExample"));
        }
        return this.jLabel7;
    }

    public void setObject(ApplicationObject appObj) {
        this.appObj = appObj;
        this.updatePanel();
    }

    private void updatePanel() {
        this.nameField.setText(this.appObj.getFileName());
        this.descriptionField.setText(this.appObj.getFileDescription());
    }
}

