/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.schema.Executable;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AppAuthenticationObject;
import com.sygate.scm.console.logicobject.ApplicationObject;
import com.sygate.scm.console.logicobject.LearnedApplicationObject;
import com.sygate.scm.console.ui.dlg.AdditionalMsgDlg;
import com.sygate.scm.console.ui.policy.common.ButtonPane;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.common.LearnedAppTakerInt;
import com.sygate.scm.console.ui.policy.dialog.ApplicationDlg;
import com.sygate.scm.console.ui.policy.dialog.FindApplicationDlg;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AppAuthenticationPanel
extends JPanel
implements LearnedAppTakerInt {
    private static final long serialVersionUID = 1L;
    private static final int INDENT = 16;
    private static final int BREATHSP = 2;
    private static final String[] ACTION_DESC = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.ask"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.dropTheTraffic"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.allowAndLog")};
    private static final int[] ACTION_VALUE = new int[]{0, 2, 1};
    private static final String[] appTableTitle = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.enabled"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.name"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.description")};
    private static final int[] columnMappings = new int[]{0, 1, 2, 3, 4, 5};
    private boolean enabled = false;
    private boolean readOnly = false;
    private AppAuthenticationObject appObj;
    JCheckBox enableAppAuthenChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.enableApplicationAuthentication"));
    JComboBox<Object> actionCmbBox = new JComboBox<String>(ACTION_DESC);
    JCheckBox allowNewChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.detectAnyNewDLL"));
    JCheckBox allowKnownChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.allowAllKnownNewlyLoaded"));
    JCheckBox allowChangeChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.detectAnyDLLOrOCX"));
    JTable appTable = new StripesTable();
    SortableTableModel appModel = new SortableTableModel(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 0) {
                return true;
            }
            return super.isCellEditable(row, col);
        }
    };
    JButton additionalTextBtn = new JButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.addAdditionalText"));
    JPanel mainPane = new JPanel();
    JPanel settingPane = new JPanel();
    Action addApp;
    Action addAppFrom;
    Action deleteApp;
    Action editApp;
    DescriptionTextArea allowKnownDesc;
    JPopupMenu pMenu = new JPopupMenu();
    private String additionalTextMessage = null;

    public AppAuthenticationPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.getNorthPane(), "North");
        this.add((Component)this.getSettingPane(), "Center");
    }

    public boolean savePane() {
        try {
            boolean enableApp = this.enableAppAuthenChkBox.isSelected();
            this.appObj.setEnable(enableApp);
            if (enableApp) {
                int actionIdx = this.actionCmbBox.getSelectedIndex();
                if (actionIdx == -1) {
                    throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.actionHasNotBeenSelected"), this.actionCmbBox);
                }
                this.appObj.setAction(ACTION_VALUE[actionIdx]);
                this.appObj.setAdditionalText(this.additionalTextMessage == null ? "" : this.additionalTextMessage);
                this.appObj.setAllowNew(!this.allowNewChkBox.isSelected());
                this.appObj.setAllowKnownNew(this.allowKnownChkBox.isSelected());
                this.appObj.setAllowChange(!this.allowChangeChkBox.isSelected());
            }
            return true;
        }
        catch (GUICheckException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.error"), 0);
            ex.getErrorComponent().requestFocus();
            return false;
        }
    }

    @Override
    public int addLearnedApplication(LearnedApplicationObject[] allApps) {
        int addedApps = 0;
        for (int i = 0; i < allApps.length; ++i) {
            ApplicationObject aObj = new ApplicationObject(allApps[i]);
            if (this.appObj.isApplicationExist(aObj)) continue;
            this.appModel.addRow(aObj);
            if (this.appExists(aObj, this.appObj)) continue;
            this.appObj.addApplication(aObj);
            ++addedApps;
        }
        return addedApps;
    }

    private JPanel getNorthPane() {
        this.enableAppAuthenChkBox.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                AppAuthenticationPanel.this.enableAppChanged();
            }
        });
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        this.enableAppAuthenChkBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        pane.add(this.enableAppAuthenChkBox);
        DescriptionTextArea desc = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.ifSelectedAllApplicationRunOn"));
        desc.setBorder(BorderFactory.createEmptyBorder(2, 16, 2, 16));
        pane.add(desc);
        return pane;
    }

    private JPanel getSettingPane() {
        this.settingPane.setLayout(new BoxLayout(this.settingPane, 1));
        JPanel dllControlPane = this.getDllControlPane();
        dllControlPane.setAlignmentX(0.5f);
        this.settingPane.add(this.getActionPane());
        this.settingPane.add(this.getAllowAppPane());
        return this.settingPane;
    }

    private JPanel getActionPane() {
        this.actionCmbBox.setSelectedIndex(0);
        this.actionCmbBox.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                AppAuthenticationPanel.this.actionChanged();
            }
        });
        this.additionalTextBtn.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                AppAuthenticationPanel.this.addNotificationMessage();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.whenAnApplicationChangeIsDetected")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 15, 0, 0), 0, 0));
        panel.add(this.actionCmbBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        JPanel addPan = new JPanel();
        addPan.add(new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.additionalTextForThePopupMessage")));
        addPan.add(this.additionalTextBtn);
        panel.add((Component)addPan, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 20), 0, 0));
        return panel;
    }

    private JPanel getDllControlPane() {
        this.allowNewChkBox.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                AppAuthenticationPanel.this.allowNewChanged();
            }
        });
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        pane.add(this.allowNewChkBox);
        this.allowKnownChkBox.setBorder(BorderFactory.createEmptyBorder(2, 16, 2, 16));
        pane.add(this.allowKnownChkBox);
        this.allowKnownDesc = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.agentKeepsAListOf"));
        this.allowKnownDesc.setBorder(BorderFactory.createEmptyBorder(2, 32, 2, 32));
        pane.add(this.allowKnownDesc);
        pane.add(this.allowChangeChkBox);
        TitledBorder title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.DLLAndOCXControl"));
        pane.setBorder(title);
        return pane;
    }

    private JPanel getAllowAppPane() {
        this.appTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AppAuthenticationPanel.this.tableSelectionChanged(e);
            }
        });
        this.appTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AppAuthenticationPanel.this.editApplication();
                }
                AppAuthenticationPanel.this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AppAuthenticationPanel.this.editApplication();
                }
                AppAuthenticationPanel.this.showPopup(e);
            }
        });
        this.appTable.setSelectionMode(2);
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout());
        JLabel label = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.applicationsListedAreNotMonitored"));
        pane.add((Component)label, "North");
        this.appTable.setModel(this.appModel);
        this.appModel.setColumnNames(appTableTitle);
        this.appModel.setColumnMapping(columnMappings);
        this.appModel.addMouseListenerToHeaderInTable(this.appTable);
        Dimension size = this.appTable.getPreferredScrollableViewportSize();
        this.appTable.setPreferredScrollableViewportSize(new Dimension(size.width, (this.appTable.getRowHeight() + this.appTable.getRowMargin()) * 5 * 2));
        JScrollPane sPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)sPane, (JTable)this.appTable);
        pane.add((Component)sPane, "Center");
        sPane.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    AppAuthenticationPanel.this.showPopupFromScrollPane(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    AppAuthenticationPanel.this.showPopupFromScrollPane(e);
                }
            }
        });
        this.addApp = new AbstractAction(UIText.get(5)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                AppAuthenticationPanel.this.addApplication();
            }
        };
        this.addAppFrom = new AbstractAction(UIText.get(6)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                AppAuthenticationPanel.this.addApplicationFrom();
            }
        };
        this.deleteApp = new AbstractAction(UIText.get(769)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                AppAuthenticationPanel.this.deleteApplication();
            }
        };
        this.editApp = new AbstractAction(UIText.get(1024)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                AppAuthenticationPanel.this.editApplication();
            }
        };
        JButton[] buttons = new JButton[]{new JButton(this.addApp), new JButton(this.addAppFrom), new JButton(this.editApp), new JButton(this.deleteApp)};
        ButtonPane bPane = new ButtonPane(buttons, 1);
        pane.add((Component)bPane, "South");
        TitledBorder title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.applicationExceptionList"));
        Border emptyBorder = BorderFactory.createEmptyBorder(2, 16, 2, 16);
        pane.setBorder(BorderFactory.createCompoundBorder(title, emptyBorder));
        JMenuItem menuItem = new JMenuItem(this.addApp);
        this.pMenu.add(menuItem);
        menuItem = new JMenuItem(this.addAppFrom);
        this.pMenu.add(menuItem);
        menuItem = new JMenuItem(this.deleteApp);
        this.pMenu.add(menuItem);
        menuItem = new JMenuItem(this.editApp);
        this.pMenu.add(menuItem);
        return pane;
    }

    private void addApplication() {
        ApplicationObject newObj = new ApplicationObject();
        ApplicationDlg dlg = new ApplicationDlg(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.application.add"), true);
        dlg.setObject(newObj);
        dlg.setVisible(true);
        if (dlg.isOk()) {
            if (this.appExists(newObj, this.appObj)) {
                return;
            }
            this.appModel.addRow(newObj);
            this.appObj.addApplication(newObj);
        }
    }

    private void addApplicationFrom() {
        FindApplicationDlg dlg = new FindApplicationDlg(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.applicationFilter"), true);
        dlg.setLearnedAppTaker(this);
        dlg.setVisible(true);
    }

    private void deleteApplication() {
        int[] indexs = this.appTable.getSelectedRows();
        if (indexs.length == 0) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.youNeedSelectOneline"));
            return;
        }
        int result = -1;
        String msg = "";
        msg = indexs.length > 1 ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.areYouSureToContinueMultipleDeletes") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.areYouSureToContinue");
        result = UIUtilities.confirmYesNoOptionDialog(msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.deleteLocation"));
        if (result == 0) {
            int removed = 0;
            for (int i = 0; i < indexs.length; ++i) {
                ApplicationObject aObj = (ApplicationObject)this.appModel.getRow(indexs[i] - removed);
                aObj.delete();
                this.appModel.removeRow(indexs[i] - removed);
                ++removed;
            }
        }
    }

    private void editApplication() {
        int index = this.appTable.getSelectedRow();
        if (index == -1) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.youNeedSelectOneline"));
            return;
        }
        try {
            ApplicationObject selected = (ApplicationObject)this.appModel.getRow(index);
            ApplicationDlg dlg = new ApplicationDlg(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.application.edit"), true);
            ApplicationObject newObj = selected.getClone();
            dlg.setObject(newObj);
            dlg.setVisible(true);
            if (dlg.isOk()) {
                if (PolicyHandler.compareTwoExecutableObj(selected.getExecutable(), newObj.getExecutable()) || this.appExists(newObj, this.appObj)) {
                    return;
                }
                this.appModel.setRow(index, newObj);
                this.appObj.setApplicationObject(index, newObj);
            }
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.errorInConsole"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void actionChanged() {
        String action = (String)this.actionCmbBox.getSelectedItem();
        if (action == null) {
            action = "";
        }
        this.additionalTextBtn.setEnabled(action.equals(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.ask")) && this.enabled);
    }

    private void enableAppChanged() {
        if (this.readOnly) {
            return;
        }
        this.enabled = this.enableAppAuthenChkBox.isSelected();
        UIUtilities.setContainerStatus(this.settingPane, this.enabled);
        this.synchronizeButtonAction(this.enabled);
        this.actionChanged();
        this.allowNewChanged();
        this.setActionStatus();
    }

    private void allowNewChanged() {
        boolean allNew = this.allowNewChkBox.isSelected();
        this.allowKnownChkBox.setEnabled(allNew && this.enabled);
        this.allowKnownDesc.setEnabled(allNew && this.enabled);
    }

    private void showPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            Point p;
            JTable table = (JTable)e.getSource();
            int row = table.rowAtPoint(p = e.getPoint());
            if (row != -1) {
                table.setRowSelectionInterval(row, row);
            }
            table.add(this.pMenu);
            this.pMenu.show(table, e.getX(), e.getY());
        }
    }

    private void showPopupFromScrollPane(MouseEvent e) {
        Component pane = (Component)e.getSource();
        this.appTable.clearSelection();
        this.pMenu.show(pane, e.getX(), e.getY());
    }

    private void tableSelectionChanged(ListSelectionEvent e) {
        if (this.readOnly || !this.enabled) {
            return;
        }
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.setActionStatus();
    }

    private void setActionStatus() {
        boolean setEnable = this.enabled && !this.readOnly;
        this.addApp.setEnabled(setEnable);
        this.addAppFrom.setEnabled(setEnable);
        int selectIdx = this.appTable.getSelectedRow();
        this.deleteApp.setEnabled(setEnable &= selectIdx != -1);
        this.editApp.setEnabled(setEnable);
    }

    private void synchronizeButtonAction(boolean isChecked) {
        this.addApp.setEnabled(isChecked);
        this.addAppFrom.setEnabled(isChecked);
        this.editApp.setEnabled(isChecked);
        this.deleteApp.setEnabled(isChecked);
    }

    private void updatePane() {
        this.enableAppAuthenChkBox.setSelected(this.appObj.getEnabled());
        this.actionCmbBox.setSelectedIndex(AppAuthenticationPanel.getActionIndex(this.appObj.getAction()));
        this.allowNewChkBox.setSelected(!this.appObj.getAllowNew());
        this.allowKnownChkBox.setSelected(this.appObj.getAllowKnownNew());
        this.allowChangeChkBox.setSelected(!this.appObj.getAllowChange());
        this.additionalTextMessage = this.appObj.getAdditionalText();
        ApplicationObject[] appObjs = this.appObj.getApplications();
        for (int i = 0; i < appObjs.length; ++i) {
            this.appModel.addRow(appObjs[i]);
        }
        this.enableAppChanged();
    }

    private static int getActionIndex(int action) {
        for (int i = 0; i < ACTION_VALUE.length; ++i) {
            if (ACTION_VALUE[i] != action) continue;
            return i;
        }
        return -1;
    }

    private void additionalTextAreaChanged(KeyEvent e) {
        JTextArea additionalTextArea = (JTextArea)e.getSource();
        int linenum = additionalTextArea.getLineCount();
        if (linenum > 2 && e.getKeyChar() != '\b' && e.getKeyChar() != '\u007f') {
            e.setKeyChar('\uffff');
            if (additionalTextArea.getLineCount() > 2) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.noMoreThan2Lines"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.error"), 0);
                try {
                    int off = additionalTextArea.getLineEndOffset(1);
                    String s = additionalTextArea.getText(0, off);
                    additionalTextArea.setText(s);
                }
                catch (Exception ex) {
                    additionalTextArea.setText("");
                }
                additionalTextArea.requestFocus();
            }
        }
    }

    private void addNotificationMessage() {
        String desc;
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.addAdditionalText");
        AdditionalMsgDlg dlg = new AdditionalMsgDlg(title, desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.additionalTextForThePopupMessage"), this.additionalTextMessage, 128, new AddTextListner());
        if (dlg.isOk()) {
            this.additionalTextMessage = dlg.getMessage();
        }
        dlg.dispose();
    }

    public boolean appExists(ApplicationObject obj, AppAuthenticationObject appAuthenObj) {
        ApplicationObject[] apps = appAuthenObj.getApplications();
        Executable exe = obj.getExecutable();
        for (int i = 0; i < apps.length; ++i) {
            if (!PolicyHandler.compareTwoExecutableObj(exe, apps[i].getExecutable())) continue;
            String fileName = exe.getOptFileName();
            Object[] obje = new Object[]{fileName.equals("") ? "" : fileName};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.applicationAlreadyExists");
            String fm = MessageFormat.format(str, obje);
            JOptionPane.showMessageDialog(this, fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AppAuthenticationPanel.error"), 0);
            return true;
        }
        return false;
    }

    public void setReadOnly() {
        this.readOnly = true;
        this.setActionStatus();
    }

    public void setObject(AppAuthenticationObject appObj) {
        this.appObj = appObj;
        this.updatePane();
    }

    public AppAuthenticationObject getAppAuthenticationObject() {
        return this.appObj;
    }

    private class AddTextListner
    implements KeyListener {
        private AddTextListner() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            AppAuthenticationPanel.this.additionalTextAreaChanged(e);
        }
    }
}

