/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.configobject.schema.MasterSwitchButton;
import com.sygate.scm.common.configobject.schema.SecurityEventNotification;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.UserInterfaceObject;
import com.sygate.scm.console.ui.dlg.AdditionalMsgDlg;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.dialog.PolicyDialog;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.BadFormatException;
import com.sygate.scm.util.IntegerSet;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AgentGUIDlg
extends PolicyDialog {
    private static final long serialVersionUID = 1L;
    private static final String[] TIME_UNIT = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.seconds"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.minutes"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.hours")};
    private UserInterfaceObject uiObj;
    private boolean isCancel = true;
    private JPanel jContentPane = null;
    private JPanel showAgentPane = null;
    private JPanel showAgentNotificationPane = null;
    private JPanel jPanel = null;
    private JPanel agentGUIPane = null;
    private JPanel intrusionPane = null;
    private JCheckBox showAgentGuiChkBox = null;
    private JCheckBox showTestButtonChkBox = null;
    private JCheckBox allowDisableAgentChkBox = null;
    private JCheckBox reactiveChkBox = null;
    private JTextField activeTimeField = null;
    private JComboBox<String> activeTimeCmbBox = null;
    private JCheckBox enableBackTraceChkBox = null;
    private JCheckBox hideTrayIconChkBox = null;
    private JPanel jPanel3 = null;
    private JCheckBox soundNotificationChkBox = null;
    private JRadioButton rbAllowIPTraffic = null;
    private JRadioButton rbAllowOnlyAppTraffic = null;
    private JCheckBox cbPromptBeforeAllowAppTraffic = null;
    private JPanel showOthersPane = null;
    private JCheckBox intrusionDetectChkBox = null;
    private JLabel clickLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.whenDisableButtonIsClicked"));
    private JCheckBox onlyAllowChkBox = null;
    private JTextField allowTimesField = null;
    private JPanel readOnlyPanel = null;
    private Vector<Object> enabledIndex = null;
    private HashMap<Integer, Component[]> agentGUIMap = new HashMap();
    private LicenseObject myLicenseObj = LicenseObject.getInstance();
    private JPanel networkThreatPane;
    private JPanel showNotificationPane;
    private JPanel appDevicePane;
    private JLabel whenFirewallIsDisabled = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.firewallIsDisabled"));
    private JRadioButton rbAllowAllUsers = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.rbAllowAllUsers"));
    private JRadioButton rbAllowOnlyWinAdmins = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.rbAllowOnlyWinAdmins"));
    private JRadioButton disableAllTraficRbtn = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.disableAllAgentProtection"));
    private JRadioButton disableOutTraficRbtn = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.allowOutboundTraffic"));
    private JLabel addTextNotificationLbl = null;
    private JButton messageTextBtn = null;
    private String additionalTextMessage = "";
    private int mode;
    private JCheckBox enableAppDeviceChkBox = null;
    private JCheckBox enableMetroNotificationChkBox = null;

    public AgentGUIDlg(JFrame frame, String string, boolean b, int mode) {
        super(frame, string, b);
        this.mode = mode;
        this.initialize();
    }

    public void initializeServerControlPanel() {
        if (this.enabledIndex == null) {
            return;
        }
        this.getShowAgentGuiChkBox().setEnabled(false);
        this.initializeCtrls();
        for (int i = 0; i < this.enabledIndex.size(); ++i) {
            Object key = this.enabledIndex.get(i);
            if (!this.agentGUIMap.containsKey(key)) continue;
            Component[] comp = this.agentGUIMap.get(key);
            for (int j = 0; j < comp.length; ++j) {
                System.out.println(comp[j].toString());
                comp[j].setEnabled(true);
            }
        }
        this.setReactiveStatus();
        this.setIntrusionStatus();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_computersnusers_policies_advsettings_sc_edit_agentgui";
    }

    @Override
    protected boolean isValidate() {
        try {
            String strCancelTimes = this.getAllowTimesField().getText().trim();
            boolean isReactive = this.reactiveChkBox.isSelected();
            boolean isAllow = this.allowDisableAgentChkBox.isSelected();
            if (isAllow) {
                boolean allowTimes;
                if (isReactive) {
                    String strActiveTime = this.activeTimeField.getText().trim();
                    if (strActiveTime.length() == 0) {
                        throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.activeTimeCannotBeBlank"), this.activeTimeField);
                    }
                    int activeTime = Integer.parseInt(strActiveTime);
                    if (activeTime <= 0) {
                        throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.activeTimecannotBeNegative"), this.activeTimeField);
                    }
                }
                if ((allowTimes = this.getOnlyAllowChkBox().isSelected()) && strCancelTimes.length() == 0) {
                    throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.allowingClickingTimesCannotBeEmpty"), this.getAllowTimesField());
                }
            }
        }
        catch (GUICheckException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.error"), 0);
            JComponent errCom = ex.getErrorComponent();
            if (errCom != null) {
                errCom.requestFocus();
            }
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        boolean toAllowClick;
        this.uiObj.setShowAgentGui(this.showAgentGuiChkBox.isSelected());
        this.uiObj.setShowTestButton(this.showTestButtonChkBox.isSelected());
        this.uiObj.setMasterSwitchButton(this.allowDisableAgentChkBox.isSelected());
        this.uiObj.setBackTraceButton(this.enableBackTraceChkBox.isSelected());
        this.uiObj.setHideTrayIcon(!this.hideTrayIconChkBox.isSelected());
        this.uiObj.setAllowAllIpTraffic(this.getRBAllowIPTraffic().isSelected());
        this.uiObj.setClientAskBeforeAllow(this.getCBPromptBeforeAllAppTraffic().isSelected());
        this.uiObj.setAppDeviceCtrlEnable(this.getAppDeviceChkBox().isSelected());
        this.uiObj.setNTPAllowOnlyAdmin(this.rbAllowOnlyWinAdmins.isSelected());
        this.uiObj.setMetroNotificationEnable(this.getMetroNotificationChkBox().isSelected());
        String strCancelTimes = this.getAllowTimesField().getText().trim();
        boolean isReactive = this.getReactiveChkBox().isSelected();
        if (!isReactive) {
            this.uiObj.setActiveTime(0);
        } else {
            String strActiveTime = this.activeTimeField.getText().trim();
            int activeTime = Integer.parseInt(strActiveTime);
            int unit = this.getActiveTimeCmbBox().getSelectedIndex();
            for (int i = 1; i < unit + 1; ++i) {
                activeTime *= 60;
            }
            this.uiObj.setActiveTime(activeTime);
        }
        int allowClickTimes = 0;
        if (strCancelTimes.length() > 0) {
            allowClickTimes = Integer.parseInt(strCancelTimes);
        }
        if (!(toAllowClick = this.getOnlyAllowChkBox().isSelected())) {
            allowClickTimes = 0;
        }
        this.uiObj.setAllowTimes(allowClickTimes);
        Integer allowType = this.disableAllTraficRbtn.isSelected() ? MasterSwitchButton.ALL_TRAFFIC : MasterSwitchButton.OUTBOUND_ONLY;
        this.uiObj.setProtectionType(allowType);
        this.uiObj.setSoundNotification(this.soundNotificationChkBox.isSelected());
        SecurityEventNotification secNotice = this.uiObj.getSecurityEventNotification();
        secNotice.setOptEnable(Boolean.valueOf(this.getIntrusionDetectChkBox().isSelected()));
        secNotice.setOptAdditionalText(this.additionalTextMessage);
        this.uiObj.setSecurityEventNotification(secNotice);
    }

    private void initialize() {
        this.setAgentGUIMap();
        this.getContentPane().add(this.getJContentPane());
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setResizable(false);
        this.setSize(550, 500);
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    private void setAgentGUIMap() {
        Component[] comp = new Component[]{this.getHideTrayIconChkBox()};
        this.agentGUIMap.put(329216, comp);
        comp = new Component[]{this.getMetroNotificationChkBox()};
        this.agentGUIMap.put(331008, comp);
        comp = new Component[]{this.getShowTestButtonChkBox()};
        this.agentGUIMap.put(329472, comp);
        comp = new Component[]{this.getAllowDisableAgentChkBox()};
        this.agentGUIMap.put(329728, comp);
        comp = new Component[]{this.getIntrusionDetectChkBox()};
        this.agentGUIMap.put(330752, comp);
        comp = new Component[]{this.getRBAllowIPTraffic()};
        this.agentGUIMap.put(135680, comp);
        comp = new Component[]{this.getRBAllowOnlyAppTraffic()};
        this.agentGUIMap.put(135936, comp);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getShowAgentPane() {
        if (this.showAgentPane == null) {
            this.showAgentPane = new JPanel();
            GridBagLayout gridBag = new GridBagLayout();
            this.showAgentPane.setLayout(gridBag);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(0, 5, 0, 0);
            c.anchor = 17;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            this.showAgentPane.add((Component)this.getShowAgentGuiChkBox(), c);
            c.fill = 2;
            c.weightx = 1.0;
            c.anchor = 10;
            c.gridx = 5;
            this.showAgentPane.add((Component)this.getMetroNotificationChkBox(), c);
            c.fill = 0;
            c.weightx = 1.0;
            c.anchor = 10;
            c.gridx = 3;
            this.showAgentPane.add((Component)this.getHideTrayIconChkBox(), c);
            this.showAgentPane.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.generalTitle")));
        }
        return this.showAgentPane;
    }

    private JPanel getNetworkThreatPane() {
        if (this.networkThreatPane == null) {
            this.networkThreatPane = new JPanel();
            this.networkThreatPane.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.NetworkThreatProtection")));
            GridBagLayout gridBag = new GridBagLayout();
            this.networkThreatPane.setLayout(gridBag);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(0, 5, 0, 0);
            c.anchor = 17;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.fill = 0;
            c.weightx = 1.0;
            this.networkThreatPane.add((Component)this.getAgentGUIPane(), c);
        }
        return this.networkThreatPane;
    }

    private JPanel getShowNotificationPane() {
        if (this.showNotificationPane == null) {
            this.showNotificationPane = new JPanel();
            this.showNotificationPane.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.notificationsTitle")));
            GridBagLayout gridBag = new GridBagLayout();
            this.showNotificationPane.setLayout(gridBag);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(0, 5, 0, 0);
            c.anchor = 17;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.fill = 0;
            c.weightx = 1.0;
            this.showNotificationPane.add((Component)this.getJPanel3(), c);
        }
        return this.showNotificationPane;
    }

    private JPanel getAppDevicePane() {
        if (this.appDevicePane == null) {
            this.appDevicePane = new JPanel();
            this.appDevicePane.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.appDeviceTitle")));
        }
        GridBagLayout gridBag = new GridBagLayout();
        this.appDevicePane.setLayout(gridBag);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 10, 0, 0);
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 1.0;
        this.appDevicePane.add((Component)this.getAppDeviceChkBox(), c);
        return this.appDevicePane;
    }

    private JCheckBox getAppDeviceChkBox() {
        if (this.enableAppDeviceChkBox == null) {
            this.enableAppDeviceChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.appDeviceChkBox"));
        }
        return this.enableAppDeviceChkBox;
    }

    private JPanel getShowAgentNotificationPane() {
        if (this.showAgentNotificationPane == null) {
            this.showAgentNotificationPane = new JPanel(new GridBagLayout());
            this.showAgentNotificationPane.add((Component)this.getAddTextNotificationLbl(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.showAgentNotificationPane.add((Component)this.getMessageTextBtn(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        }
        return this.showAgentNotificationPane;
    }

    private JPanel getAgentGUIPane() {
        if (this.agentGUIPane == null) {
            this.agentGUIPane = new JPanel();
            this.agentGUIPane.setLayout(new GridBagLayout());
            if (!this.myLicenseObj.isSNACOnlyProduct()) {
                this.agentGUIPane.add((Component)this.getShowTestButtonChkBox(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 2, new Insets(0, 5, 0, 0), 0, 0));
                JPanel allowDisableAgent = UIUtilities.appendOSIcon(this.getAllowDisableAgentChkBox(), true, true);
                this.agentGUIPane.add((Component)allowDisableAgent, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
                ButtonGroup userGp = new ButtonGroup();
                userGp.add(this.rbAllowOnlyWinAdmins);
                userGp.add(this.rbAllowAllUsers);
                ButtonGroup trafficGp = new ButtonGroup();
                trafficGp.add(this.disableAllTraficRbtn);
                trafficGp.add(this.disableOutTraficRbtn);
                JPanel rbtnPanel = new JPanel(new GridBagLayout());
                rbtnPanel.add((Component)UIUtilities.appendOSIcon(this.rbAllowOnlyWinAdmins, true, false), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
                rbtnPanel.add((Component)UIUtilities.appendOSIcon(this.rbAllowAllUsers, true, false), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
                rbtnPanel.add((Component)this.whenFirewallIsDisabled, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
                rbtnPanel.add((Component)this.disableAllTraficRbtn, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
                rbtnPanel.add((Component)this.disableOutTraficRbtn, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
                JPanel subAllowDisablePane = new JPanel();
                subAllowDisablePane.setLayout(new GridBagLayout());
                subAllowDisablePane.add((Component)rbtnPanel, this.getSubAllowConstraints(1, 0));
                this.agentGUIPane.add((Component)subAllowDisablePane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 23, 2, new Insets(0, 10, 0, 0), 0, 0));
                JPanel firstp = new JPanel(new GridBagLayout());
                GridBagConstraints gc = new GridBagConstraints();
                gc.gridheight = 1;
                gc.weightx = 1.0;
                gc.fill = 0;
                gc.anchor = 17;
                gc.ipadx = 0;
                gc.ipady = 0;
                gc.gridx = 0;
                gc.gridy = 0;
                firstp.add((Component)this.getReactiveChkBox(), gc);
                gc.insets = new Insets(0, 1, 0, 0);
                gc.gridx = 1;
                firstp.add((Component)this.getActiveTimeField(), gc);
                gc.insets = new Insets(0, 2, 0, 0);
                gc.gridx = 2;
                firstp.add(this.getActiveTimeCmbBox(), gc);
                gc.insets = new Insets(0, 0, 0, 0);
                gc.gridx = 0;
                gc.gridy = 1;
                firstp.add((Component)this.getOnlyAllowChkBox(), gc);
                gc.gridx = 1;
                gc.insets = new Insets(0, 1, 0, 0);
                gc.gridwidth = 0;
                firstp.add((Component)this.getAllowTimesField(), gc);
                this.agentGUIPane.add((Component)firstp, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 23, 2, new Insets(0, 5, 0, 0), 0, 0));
            }
            this.getEnableBackTraceChkBox().setBorder(BorderFactory.createEmptyBorder(3, 8, 0, 0));
        }
        return this.agentGUIPane;
    }

    private JTextField getAllowTimesField() {
        if (this.allowTimesField == null) {
            this.allowTimesField = new JTextField(8);
            this.allowTimesField.setHorizontalAlignment(4);
            NumberPlainDocument doc = new NumberPlainDocument(1L, 9999L, true);
            this.allowTimesField.setDocument(doc);
        }
        return this.allowTimesField;
    }

    private JCheckBox getOnlyAllowChkBox() {
        if (this.onlyAllowChkBox == null) {
            this.onlyAllowChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.onlyAllowUserToClickDisableButton"));
            this.onlyAllowChkBox.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AgentGUIDlg.this.setAllowTimesStatus();
                }
            });
        }
        return this.onlyAllowChkBox;
    }

    private GridBagConstraints getSubAllowConstraints(int x, int y) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = x;
        cons.gridy = y;
        int left = 2;
        int right = 2;
        int top = 2;
        int bottom = 2;
        cons.anchor = 17;
        if (x == 0) {
            left = 20;
            if (y == 2) {
                left = 25;
            }
        }
        if (y == 0 && x == 1) {
            cons.gridwidth = 0;
            cons.weightx = 0.5;
        }
        if (y == 1) {
            if (x == 2) {
                cons.gridwidth = 0;
            } else if (x == 1) {
                cons.weightx = 0.5;
                cons.fill = 2;
            }
        }
        if (y == 2) {
            if (x == 0) {
                cons.gridwidth = 2;
                cons.anchor = 13;
            } else if (x == 2) {
                cons.weightx = 0.5;
                cons.fill = 2;
            }
        }
        cons.insets = new Insets(top, left, bottom, right);
        return cons;
    }

    private JCheckBox getIntrusionDetectChkBox() {
        if (this.intrusionDetectChkBox == null) {
            this.intrusionDetectChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.enableSecurityEventNotification"));
            this.intrusionDetectChkBox.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent event) {
                    AgentGUIDlg.this.setIntrusionStatus();
                }
            });
        }
        return this.intrusionDetectChkBox;
    }

    private JPanel getIntrusionPane() {
        if (this.intrusionPane == null) {
            this.intrusionPane = new JPanel();
            this.intrusionPane.setLayout(new GridBagLayout());
            this.intrusionPane.add((Component)this.getIntrusionDetectChkBox(), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        }
        return this.intrusionPane;
    }

    private JCheckBox getShowTestButtonChkBox() {
        if (this.showTestButtonChkBox == null) {
            this.showTestButtonChkBox = new JCheckBox();
            this.showTestButtonChkBox.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.showSecurityTestButton"));
        }
        return this.showTestButtonChkBox;
    }

    private JCheckBox getAllowDisableAgentChkBox() {
        if (this.allowDisableAgentChkBox == null) {
            this.allowDisableAgentChkBox = new JCheckBox();
            this.allowDisableAgentChkBox.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.showTheDisableButtonToAllow"));
            this.allowDisableAgentChkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AgentGUIDlg.this.setReactiveStatus();
                }
            });
        }
        return this.allowDisableAgentChkBox;
    }

    private JCheckBox getReactiveChkBox() {
        if (this.reactiveChkBox == null) {
            this.reactiveChkBox = new JCheckBox();
            this.reactiveChkBox.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.reenableTheProtectionAfter"));
            this.reactiveChkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AgentGUIDlg.this.setActiveTimeFieldStatus();
                }
            });
        }
        return this.reactiveChkBox;
    }

    private JComboBox<String> getActiveTimeCmbBox() {
        if (this.activeTimeCmbBox == null) {
            this.activeTimeCmbBox = new JComboBox();
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(TIME_UNIT);
            this.activeTimeCmbBox.setModel(model);
        }
        return this.activeTimeCmbBox;
    }

    private JCheckBox getEnableBackTraceChkBox() {
        if (this.enableBackTraceChkBox == null) {
            this.enableBackTraceChkBox = new JCheckBox();
            this.enableBackTraceChkBox.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.enableBackTraceButton"));
        }
        return this.enableBackTraceChkBox;
    }

    private JCheckBox getHideTrayIconChkBox() {
        if (this.hideTrayIconChkBox == null) {
            this.hideTrayIconChkBox = new JCheckBox();
            this.hideTrayIconChkBox.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.hideSystemTrayIcon"));
        }
        return this.hideTrayIconChkBox;
    }

    private JCheckBox getMetroNotificationChkBox() {
        if (this.enableMetroNotificationChkBox == null) {
            this.enableMetroNotificationChkBox = new JCheckBox();
            this.enableMetroNotificationChkBox.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.enableMetroNotification"));
        }
        return this.enableMetroNotificationChkBox;
    }

    private JRadioButton getRBAllowIPTraffic() {
        if (this.rbAllowIPTraffic == null) {
            this.rbAllowIPTraffic = new JRadioButton();
            this.rbAllowIPTraffic.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.rbAllowAllIpTraffic"));
            this.rbAllowIPTraffic.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    AgentGUIDlg.this.getRBAllowOnlyAppTraffic().setEnabled(AgentGUIDlg.this.rbAllowIPTraffic.isEnabled());
                    if (AgentGUIDlg.this.rbAllowIPTraffic.isSelected()) {
                        AgentGUIDlg.this.getCBPromptBeforeAllAppTraffic().setSelected(false);
                    }
                }
            });
        }
        return this.rbAllowIPTraffic;
    }

    private JRadioButton getRBAllowOnlyAppTraffic() {
        if (this.rbAllowOnlyAppTraffic == null) {
            this.rbAllowOnlyAppTraffic = new JRadioButton();
            this.rbAllowOnlyAppTraffic.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.rbAllowOnlyAppTraffic"));
            this.rbAllowOnlyAppTraffic.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    AgentGUIDlg.this.getCBPromptBeforeAllAppTraffic().setEnabled(AgentGUIDlg.this.rbAllowOnlyAppTraffic.isSelected() && AgentGUIDlg.this.rbAllowOnlyAppTraffic.isEnabled());
                }
            });
        }
        return this.rbAllowOnlyAppTraffic;
    }

    private JCheckBox getCBPromptBeforeAllAppTraffic() {
        if (this.cbPromptBeforeAllowAppTraffic == null) {
            this.cbPromptBeforeAllowAppTraffic = new JCheckBox();
            this.cbPromptBeforeAllowAppTraffic.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.cbPromptBeforeAllowAppTraffic"));
        }
        return this.cbPromptBeforeAllowAppTraffic;
    }

    private JPanel getShowOthersPane() {
        if (this.showOthersPane == null) {
            this.showOthersPane = new JPanel();
            this.showOthersPane.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.UnmatchedIPTrafficSettings")));
            GridBagLayout gridBag = new GridBagLayout();
            this.showOthersPane.setLayout(gridBag);
            this.showOthersPane.add((Component)this.getRBAllowIPTraffic(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.showOthersPane.add((Component)this.getRBAllowOnlyAppTraffic(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.showOthersPane.add((Component)this.getCBPromptBeforeAllAppTraffic(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 23, 0, 0), 0, 0));
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.getRBAllowIPTraffic());
            bg.add(this.getRBAllowOnlyAppTraffic());
        }
        return this.showOthersPane;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(new GridBagLayout());
            this.jPanel3.add((Component)this.getIntrusionPane(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.jPanel3.add((Component)this.getSoundNotificationChkBox(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 23, 0, 0), 0, 0));
            this.jPanel3.add((Component)this.getShowAgentNotificationPane(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 23, 0, 0), 0, 0));
        }
        return this.jPanel3;
    }

    private void updatePanel() {
        this.getShowAgentGuiChkBox().setSelected(this.uiObj.getShowAgentGui());
        this.getShowTestButtonChkBox().setSelected(this.uiObj.getShowTestButton());
        this.getAllowDisableAgentChkBox().setSelected(this.uiObj.getMasterSwitchButton());
        this.getAppDeviceChkBox().setSelected(this.uiObj.isAppDeviceCtrlEnabled());
        this.getMetroNotificationChkBox().setSelected(this.uiObj.isMetroNotificationEnabled());
        Integer allowType = this.uiObj.getProtectionType();
        if (allowType.equals(MasterSwitchButton.ALL_TRAFFIC)) {
            this.disableAllTraficRbtn.setSelected(true);
        } else {
            this.disableOutTraficRbtn.setSelected(true);
        }
        int activeTime = this.uiObj.getActiveTime();
        if (activeTime == 0) {
            this.getReactiveChkBox().setSelected(false);
            activeTime = 300;
        } else {
            this.getReactiveChkBox().setSelected(true);
        }
        if (activeTime % 60 != 0) {
            this.getActiveTimeField().setText(String.valueOf(activeTime));
            this.getActiveTimeCmbBox().setSelectedIndex(0);
        } else {
            int minitues = activeTime / 60;
            if (minitues % 60 != 0) {
                this.getActiveTimeField().setText(String.valueOf(minitues));
                this.getActiveTimeCmbBox().setSelectedIndex(1);
            } else {
                int hours = minitues / 60;
                this.getActiveTimeField().setText(String.valueOf(hours));
                this.getActiveTimeCmbBox().setSelectedIndex(2);
            }
        }
        int allowTimes = this.uiObj.getAllowTimes();
        if (allowTimes == 0) {
            this.getOnlyAllowChkBox().setSelected(false);
            allowTimes = 3;
            this.getAllowTimesField().setEnabled(false);
        } else {
            this.getOnlyAllowChkBox().setSelected(true);
        }
        this.getAllowTimesField().setText("" + allowTimes);
        this.getEnableBackTraceChkBox().setSelected(this.uiObj.getBackTraceButton());
        this.getHideTrayIconChkBox().setSelected(!this.uiObj.getHideTrayIcon());
        this.getSoundNotificationChkBox().setSelected(this.uiObj.getSoundNotification());
        if (this.uiObj.getNTPAllowOnlyAdmin()) {
            this.rbAllowOnlyWinAdmins.setSelected(true);
            this.rbAllowAllUsers.setSelected(false);
        } else {
            this.rbAllowOnlyWinAdmins.setSelected(false);
            this.rbAllowAllUsers.setSelected(true);
        }
        if (this.uiObj.getAllowAllIpTraffic()) {
            this.getRBAllowIPTraffic().setSelected(true);
            this.getRBAllowOnlyAppTraffic().setSelected(false);
        } else {
            this.getRBAllowIPTraffic().setSelected(false);
            this.getRBAllowOnlyAppTraffic().setSelected(true);
        }
        this.getCBPromptBeforeAllAppTraffic().setSelected(this.uiObj.getClientAskBeforeAllow());
        if (this.getRBAllowIPTraffic().isSelected()) {
            this.getCBPromptBeforeAllAppTraffic().setSelected(false);
        }
        this.getCBPromptBeforeAllAppTraffic().setEnabled(this.getRBAllowOnlyAppTraffic().isSelected() && this.getRBAllowOnlyAppTraffic().isEnabled());
        if (this.uiObj.getSecurityEventNotification() == null) {
            this.getIntrusionDetectChkBox().setSelected(true);
        } else {
            SecurityEventNotification secNotice = this.uiObj.getSecurityEventNotification();
            this.getIntrusionDetectChkBox().setSelected(secNotice.getOptEnable() == null ? true : secNotice.getOptEnable());
            this.setAdditionTextMessage();
        }
        this.setShowAgentGuiPanelStatus();
        this.setIntrusionStatus();
        this.setReactiveStatus();
        this.setActiveTimeFieldStatus();
    }

    private void setReactiveStatus() {
        boolean isMaster = this.getAllowDisableAgentChkBox().isSelected();
        boolean isServer = this.getAllowDisableAgentChkBox().isEnabled();
        this.clickLbl.setEnabled(isMaster && isServer);
        this.disableAllTraficRbtn.setEnabled(isMaster && isServer);
        this.disableOutTraficRbtn.setEnabled(isMaster && isServer);
        this.rbAllowAllUsers.setEnabled(isMaster && isServer);
        this.rbAllowOnlyWinAdmins.setEnabled(isMaster && isServer);
        this.whenFirewallIsDisabled.setEnabled(isMaster && isServer);
    }

    private void setActiveTimeFieldStatus() {
        boolean isActive = this.reactiveChkBox.isSelected();
        boolean isActiveServer = this.reactiveChkBox.isEnabled();
        this.activeTimeField.setEnabled(isActive && isActiveServer);
        UIUtilities.setContainerStatus(this.activeTimeCmbBox, isActive && isActiveServer);
        this.activeTimeCmbBox.setEnabled(isActive && isActiveServer);
        this.setAllowTimesStatus();
    }

    private void setAllowTimesStatus() {
        boolean isMasterEnabled = this.getOnlyAllowChkBox().isEnabled();
        boolean isSelected = this.getOnlyAllowChkBox().isSelected();
        this.getAllowTimesField().setEnabled(isMasterEnabled && isSelected);
    }

    private Component getReadOnlyPane(boolean isInherit) {
        if (this.readOnlyPanel == null) {
            String desc = isInherit ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.theAgentGUISettingsAreInheritedFromParentNoNotificationAllowed") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.readOnlyGroupNoNotificationAllowed");
            this.readOnlyPanel = new JPanel(new BorderLayout());
            DescriptionTextArea descArea = new DescriptionTextArea(true);
            descArea.setText(desc);
            this.readOnlyPanel.add(descArea);
            descArea.setBorder(BorderFactory.createEmptyBorder(3, 4, 5, 4));
        }
        return this.readOnlyPanel;
    }

    private void addNotificationMessage() {
        String desc;
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.title.enterAdditionalTextForTheMessageBox");
        AdditionalMsgDlg dlg = new AdditionalMsgDlg(title, desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.enterAdditionalTextForTheMessageBox"), this.additionalTextMessage, 64);
        if (dlg.isOk()) {
            this.additionalTextMessage = dlg.getMessage();
        }
        dlg.dispose();
    }

    private void setAdditionTextMessage() {
        SecurityEventNotification secNotice = this.uiObj.getSecurityEventNotification();
        this.additionalTextMessage = secNotice != null ? secNotice.getOptAdditionalText() : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.enterAdditionalTextForTheMessageBox");
    }

    private void setIntrusionStatus() {
        if (this.showNotificationPane != null) {
            this.addTextNotificationLbl.setEnabled(this.getIntrusionDetectChkBox().isEnabled() && this.getIntrusionDetectChkBox().isSelected());
            this.messageTextBtn.setEnabled(this.getIntrusionDetectChkBox().isEnabled() && this.getIntrusionDetectChkBox().isSelected());
            this.soundNotificationChkBox.setEnabled(this.getIntrusionDetectChkBox().isEnabled() && this.getIntrusionDetectChkBox().isSelected());
        }
    }

    private JLabel getAddTextNotificationLbl() {
        if (this.addTextNotificationLbl == null) {
            this.addTextNotificationLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.additionalTextNotfication"));
        }
        return this.addTextNotificationLbl;
    }

    private JButton getMessageTextBtn() {
        if (this.messageTextBtn == null) {
            this.messageTextBtn = new JButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.messageText"));
            this.messageTextBtn.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AgentGUIDlg.this.addNotificationMessage();
                }
            });
        }
        return this.messageTextBtn;
    }

    private void initializeCtrls() {
        Set<Integer> keys = this.agentGUIMap.keySet();
        Iterator<Integer> it = keys.iterator();
        while (it.hasNext()) {
            Component[] comp = this.agentGUIMap.get(it.next());
            for (int j = 0; j < comp.length; ++j) {
                comp[j].setEnabled(false);
            }
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setEnabledIndex(Vector<Object> indices) {
        this.enabledIndex = new Vector();
        for (int i = 0; i < indices.size(); ++i) {
            this.enabledIndex.add(indices.get(i));
        }
    }

    public JPanel getJPanel() {
        if (this.jPanel == null) {
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            panel.add((Component)this.getShowAgentPane(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
            int yIndex = 1;
            if (!this.myLicenseObj.isSNACOnlyProduct()) {
                if (AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x23")) {
                    panel.add((Component)this.getNetworkThreatPane(), new GridBagConstraints(0, yIndex++, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
                }
                if (AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x25")) {
                    panel.add((Component)this.getAppDevicePane(), new GridBagConstraints(0, yIndex++, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
                }
                if (AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x24")) {
                    panel.add((Component)this.getShowNotificationPane(), new GridBagConstraints(0, yIndex++, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
                }
            }
            JPanel showOthersPanel = this.getShowOthersPane();
            if (!this.myLicenseObj.isSNACOnlyProduct() && this.mode == 2 && AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x23")) {
                panel.add((Component)showOthersPanel, new GridBagConstraints(0, yIndex++, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
            }
            this.jPanel = new JPanel(new BorderLayout());
            this.jPanel.add((Component)panel, "North");
        }
        return this.jPanel;
    }

    public JCheckBox getShowAgentGuiChkBox() {
        if (this.showAgentGuiChkBox == null) {
            this.showAgentGuiChkBox = new JCheckBox();
            this.showAgentGuiChkBox.setAlignmentX(0.0f);
            this.showAgentGuiChkBox.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.showAgentGUI"));
            this.showAgentGuiChkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AgentGUIDlg.this.setShowAgentGuiPanelStatus();
                }
            });
        }
        return this.showAgentGuiChkBox;
    }

    public JTextField getActiveTimeField() {
        if (this.activeTimeField == null) {
            this.activeTimeField = new JTextField(8);
            this.activeTimeField.setHorizontalAlignment(4);
            NumberPlainDocument doc = new NumberPlainDocument(1L, 596523L, true);
            this.activeTimeField.setDocument(doc);
        }
        return this.activeTimeField;
    }

    public JCheckBox getSoundNotificationChkBox() {
        if (this.soundNotificationChkBox == null) {
            this.soundNotificationChkBox = new JCheckBox();
            this.soundNotificationChkBox.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AgentGUIDlg.useSoundInNotification"));
        }
        return this.soundNotificationChkBox;
    }

    @Override
    public void setObject(AbstractUIObject uiObj) {
        this.uiObj = (UserInterfaceObject)uiObj;
        this.updatePanel();
    }

    public void setShowAgentGuiPanelStatus() {
        if (this.mode == 2) {
            boolean securityTestButtonCtrl = false;
            boolean fwipsCtrl = false;
            boolean ipsNotificationsCtrl = false;
            String features = this.uiObj.getArbitrationFeature();
            IntegerSet set = new IntegerSet();
            if (features != null) {
                try {
                    set.init(features, 16);
                }
                catch (BadFormatException e) {
                    LoggerUtilities.logException((Throwable)e);
                }
            }
            if (set.contains(329472)) {
                securityTestButtonCtrl = true;
            }
            if (set.contains(329728)) {
                fwipsCtrl = true;
            }
            if (set.contains(330752)) {
                ipsNotificationsCtrl = true;
            }
            this.getShowTestButtonChkBox().setEnabled(securityTestButtonCtrl);
            this.getAllowDisableAgentChkBox().setEnabled(fwipsCtrl);
            this.getIntrusionDetectChkBox().setEnabled(ipsNotificationsCtrl);
        }
        this.setReactiveStatus();
    }

    @Override
    public void setReadOnly(boolean isInherit) {
        UIUtilities.setContainerStatus(this.getJPanel(), false);
        this.jContentPane.add(this.getReadOnlyPane(isInherit), "North");
        int dlgWidth = this.getSize().width;
        int dlgHeight = this.getSize().height;
        this.setSize(dlgWidth, dlgHeight + 40);
    }
}

