/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.logicobject.AddressObject;
import com.sygate.scm.console.ui.policy.common.HostGroupLinkPane;
import com.sygate.scm.console.ui.policy.common.ICMPHostNamePane;
import com.sygate.scm.console.ui.policy.common.IPPane;
import com.sygate.scm.console.ui.policy.common.IPv6Pane;
import com.sygate.scm.console.ui.policy.common.MacPane;
import com.sygate.scm.console.ui.policy.dialog.AddressTypeICMPPingComboBoxModel;
import com.sygate.scm.console.ui.policy.dialog.IPTypeComboBoxModel;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.IPv6RangePane;
import com.sygate.scm.console.ui.util.IPv6SubnetPane;
import com.sygate.scm.console.ui.util.IpRangePane;
import com.sygate.scm.console.ui.util.SubnetPane;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AddressDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_4 = 0;
    public static final int TYPE_3 = 1;
    public static final int TYPE_1 = 2;
    public static final int TYPE_ICMP_PING = 3;
    private static final String[] addressTypes_4 = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.IPAddress"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.IPRange"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.subnetAddress"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.HostGroup"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.MACAddress")};
    private static final String[] addressTypes_3 = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.IPAddress"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.IPRange"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.subnetAddress"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.HostGroup")};
    private int modeltype = 0;
    private Map<String, JPanel> typeTable = new HashMap<String, JPanel>();
    private AddressObject myObj;
    private Map<Integer, Integer> typeIndexMap = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> indexTypeMap = new HashMap<Integer, Integer>();
    JPanel contentPanel = new JPanel(new BorderLayout(10, 10));
    JPanel centerPanel = new JPanel();
    JPanel mainPane = new JPanel();
    JLabel addressLabel = new JLabel();
    JComboBox<String> typeCmbBox = new JComboBox<String>(addressTypes_4);
    JPanel ipPanel;
    JPanel ipRangePanel;
    JPanel subnetPanel;
    private static final String IPV_FOUR = "IPV4";
    private static final String IPV_SIX = "IPV6";
    private boolean isIpv6ComboRequired = true;
    IPPane ipPane = new IPPane();
    IPv6Pane ipv6Pane = new IPv6Pane();
    IpRangePane ipRange = new IpRangePane();
    IPv6RangePane ipv6Range = new IPv6RangePane();
    SubnetPane subnet = new SubnetPane();
    IPv6SubnetPane ipv6Subnet = new IPv6SubnetPane();
    MacPane macField = new MacPane();
    HostGroupLinkPane hostGroupLink = new HostGroupLinkPane();
    BorderLayout borderLayout1 = new BorderLayout();
    private ICMPHostNamePane hostNamePane = new ICMPHostNamePane();
    private IPTypeComboBoxModel ipVerComboModel = new IPTypeComboBoxModel();
    private JComboBox<?> ipVerCombo = new JComboBox<IPTypeComboBoxModel.IPTypeComboBoxItem>(this.ipVerComboModel);

    public AddressDlg(JFrame frame, String title, boolean modal) {
        this(frame, title, modal, true);
    }

    public AddressDlg(JFrame frame, String title, boolean modal, boolean isIpv6ComboRequired) {
        super(frame, title, modal);
        try {
            this.isIpv6ComboRequired = isIpv6ComboRequired;
            this.jbInit();
            this.pack();
            this.setResizable(false);
            UiUtilities.centerComponent((Component)this);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public void typeChanged() {
        String type = (String)this.typeCmbBox.getSelectedItem();
        CardLayout cd = (CardLayout)this.mainPane.getLayout();
        cd.show(this.mainPane, type);
        int index = this.typeCmbBox.getSelectedIndex();
        int addressType = 0;
        this.ipVerCombo.setVisible(true);
        if (this.modeltype == 3) {
            if (index == 1) {
                addressType = 6;
            } else if (index == 2) {
                addressType = 5;
            }
        } else {
            addressType = this.indexTypeMap.get(index);
        }
        switch (addressType) {
            case 0: {
                cd = (CardLayout)this.ipPanel.getLayout();
                if (this.ipVerComboModel.getSelectedType() == IPTypeComboBoxModel.IPTypeEnum.V4) {
                    cd.show(this.ipPanel, IPV_FOUR);
                    break;
                }
                cd.show(this.ipPanel, IPV_SIX);
                break;
            }
            case 1: {
                cd = (CardLayout)this.ipRangePanel.getLayout();
                if (this.ipVerComboModel.getSelectedType() == IPTypeComboBoxModel.IPTypeEnum.V4) {
                    cd.show(this.ipRangePanel, IPV_FOUR);
                    break;
                }
                cd.show(this.ipRangePanel, IPV_SIX);
                break;
            }
            case 2: {
                cd = (CardLayout)this.subnetPanel.getLayout();
                if (this.ipVerComboModel.getSelectedType() == IPTypeComboBoxModel.IPTypeEnum.V4) {
                    cd.show(this.subnetPanel, IPV_FOUR);
                    break;
                }
                cd.show(this.subnetPanel, IPV_SIX);
                break;
            }
            case 6: {
                this.ipVerCombo.setVisible(false);
                break;
            }
            case 5: {
                this.ipVerCombo.setVisible(false);
                break;
            }
            case 3: {
                this.ipVerCombo.setVisible(false);
                break;
            }
        }
        this.pack();
    }

    @Override
    protected boolean isValidate() {
        int index = this.typeCmbBox.getSelectedIndex();
        int addressType = this.indexTypeMap.get(index);
        String errorTitle = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.error");
        if (this.modeltype == 3 && index == 1) {
            addressType = 6;
        }
        if (this.modeltype == 3 && index == 2) {
            addressType = 5;
        }
        switch (addressType) {
            case 0: {
                if (this.ipVerComboModel.getSelectedType() == IPTypeComboBoxModel.IPTypeEnum.V4) {
                    if (this.ipPane.isValidValue()) break;
                    JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.wrongIPAddress"), errorTitle, 0);
                    this.ipPane.requestFocus();
                    return false;
                }
                if (this.ipv6Pane.isValidValue()) break;
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.wrongIPAddress"), errorTitle, 0);
                this.ipv6Pane.requestFocus();
                return false;
            }
            case 1: {
                if (this.ipVerComboModel.getSelectedType() == IPTypeComboBoxModel.IPTypeEnum.V4) {
                    if (this.ipRange.isValidValue()) break;
                    String errorMessage = this.ipRange.getErrorMessage();
                    JOptionPane.showMessageDialog(this, errorMessage, errorTitle, 0);
                    this.ipRange.requestFocus();
                    return false;
                }
                if (this.ipv6Range.isValidValue()) break;
                String errorMessage = this.ipv6Range.getErrorMessage();
                JOptionPane.showMessageDialog(this, errorMessage, errorTitle, 0);
                this.ipv6Range.requestFocus();
                return false;
            }
            case 2: {
                if (this.ipVerComboModel.getSelectedType() == IPTypeComboBoxModel.IPTypeEnum.V4) {
                    if (this.subnet.isValidValue()) break;
                    String errorMessage = this.subnet.getErrorMessage();
                    JOptionPane.showMessageDialog(this, errorMessage, errorTitle, 0);
                    this.subnet.requestFocus();
                    return false;
                }
                if (this.ipv6Subnet.isValidValue()) break;
                String errorMessage = this.ipv6Subnet.getErrorMessage();
                JOptionPane.showMessageDialog(this, errorMessage, errorTitle, 0);
                this.ipv6Subnet.requestFocus();
                return false;
            }
            case 5: {
                if (this.hostGroupLink.isValidValue()) break;
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.wrongHostGroup"));
                this.hostGroupLink.requestFocus();
                return false;
            }
            case 3: {
                if (this.macField.isValidValue()) break;
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.wrongMACAddress"), errorTitle, 0);
                this.macField.requestFocus();
                return false;
            }
            case 6: {
                if (this.hostNamePane.isValidValue()) break;
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.invalidHostName"), errorTitle, 0);
                this.hostNamePane.requestFocus();
                return false;
            }
        }
        return true;
    }

    @Override
    protected void commit() {
        int index = this.typeCmbBox.getSelectedIndex();
        int addressType = this.indexTypeMap.get(index);
        if (this.modeltype == 3 && index == 1) {
            addressType = 6;
        }
        if (this.modeltype == 3 && index == 2) {
            addressType = 5;
        }
        this.myObj.setType(addressType);
        switch (addressType) {
            case 0: {
                if (this.ipVerComboModel.getSelectedType() == IPTypeComboBoxModel.IPTypeEnum.V4) {
                    this.myObj.setIPAddress(this.ipPane.getText());
                    break;
                }
                this.myObj.setType(7);
                this.myObj.setIPAddress(this.ipv6Pane.getText());
                break;
            }
            case 1: {
                if (this.ipVerComboModel.getSelectedType() == IPTypeComboBoxModel.IPTypeEnum.V4) {
                    this.myObj.setStartIP(this.ipRange.getFromIP());
                    this.myObj.setEndIP(this.ipRange.getToIP());
                    break;
                }
                this.myObj.setType(8);
                this.myObj.setStartIP(this.ipv6Range.getFromIP());
                this.myObj.setEndIP(this.ipv6Range.getToIP());
                break;
            }
            case 2: {
                if (this.ipVerComboModel.getSelectedType() == IPTypeComboBoxModel.IPTypeEnum.V4) {
                    this.myObj.setNetAddr(this.subnet.getIPAddress());
                    this.myObj.setNetMask(this.subnet.getMaskAddress());
                    break;
                }
                this.myObj.setType(9);
                this.myObj.setNetAddr(this.ipv6Subnet.getText());
                break;
            }
            case 3: {
                this.myObj.setMACAddress(this.macField.getText());
                break;
            }
            case 5: {
                this.myObj.setHostGroup(this.hostGroupLink.getSelectedHostGroup().getHostGroup());
                break;
            }
            case 6: {
                this.myObj.setICMPHostName(this.hostNamePane.getText());
                break;
            }
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_computersnusers_policies_switch_location_edit_add_addaddr";
    }

    private void jbInit() {
        this.typeTable.put(addressTypes_4[0], this.getIpPanel());
        this.typeTable.put(addressTypes_4[1], this.getIpRangePanel());
        this.typeTable.put(addressTypes_4[2], this.getSubnetPanel());
        this.typeTable.put(addressTypes_4[3], this.hostGroupLink);
        this.typeTable.put(addressTypes_4[4], this.macField);
        this.typeTable.put(AddressTypeICMPPingComboBoxModel.addressType_ICMP_PING[1], this.hostNamePane);
        this.centerPanel.setLayout(this.borderLayout1);
        this.typeCmbBox.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ex) {
                AddressDlg.this.typeChanged();
            }
        });
        JPanel comboPanel = new JPanel();
        comboPanel.setLayout(new BorderLayout(20, 10));
        JLabel typeLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.label.Type"));
        comboPanel.add((Component)typeLabel, "West");
        comboPanel.add(this.typeCmbBox, "Center");
        this.ipVerCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AddressDlg.this.typeChanged();
            }
        });
        if (this.isIpv6ComboRequired) {
            comboPanel.add(this.ipVerCombo, "East");
        }
        this.centerPanel.add((Component)comboPanel, "North");
        this.mainPane.setLayout(new CardLayout());
        Set<Map.Entry<String, JPanel>> entrySet = this.typeTable.entrySet();
        for (Map.Entry<String, JPanel> entry : entrySet) {
            this.mainPane.add((Component)entry.getValue(), entry.getKey());
        }
        this.centerPanel.add((Component)this.mainPane, "Center");
        this.typeIndexMap.put(0, 0);
        this.typeIndexMap.put(7, 1);
        this.typeIndexMap.put(1, 2);
        this.typeIndexMap.put(8, 3);
        this.typeIndexMap.put(2, 4);
        this.typeIndexMap.put(9, 5);
        this.typeIndexMap.put(5, 6);
        this.typeIndexMap.put(3, 7);
        this.typeIndexMap.put(6, 8);
        this.indexTypeMap.put(0, 0);
        this.indexTypeMap.put(1, 1);
        this.indexTypeMap.put(2, 2);
        this.indexTypeMap.put(3, 5);
        this.indexTypeMap.put(4, 3);
        this.indexTypeMap.put(5, 6);
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 30));
        this.contentPanel.add((Component)this.centerPanel, "Center");
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
    }

    private JPanel getIpPanel() {
        if (this.ipPanel == null) {
            this.ipPanel = new JPanel();
            this.ipPanel.setLayout(new CardLayout());
            this.ipPanel.add((Component)this.ipPane, IPV_FOUR);
            this.ipPanel.add((Component)this.ipv6Pane, IPV_SIX);
        }
        return this.ipPanel;
    }

    private JPanel getIpRangePanel() {
        if (this.ipRangePanel == null) {
            this.ipRangePanel = new JPanel();
            this.ipRangePanel.setLayout(new CardLayout());
            this.ipRangePanel.add((Component)this.ipRange, IPV_FOUR);
            this.ipRangePanel.add((Component)this.ipv6Range, IPV_SIX);
        }
        return this.ipRangePanel;
    }

    private JPanel getSubnetPanel() {
        if (this.subnetPanel == null) {
            this.subnetPanel = new JPanel();
            this.subnetPanel.setLayout(new CardLayout());
            this.subnetPanel.add((Component)this.subnet, IPV_FOUR);
            this.subnetPanel.add((Component)this.ipv6Subnet, IPV_SIX);
        }
        return this.subnetPanel;
    }

    private void updatePanel() {
        if (this.myObj != null) {
            int type = this.myObj.getType();
            switch (type) {
                case 0: {
                    this.ipPane.setText(this.myObj.getIP());
                    this.typeCmbBox.setSelectedIndex(0);
                    this.ipVerComboModel.setSelectedType(IPTypeComboBoxModel.IPTypeEnum.V4);
                    break;
                }
                case 7: {
                    try {
                        this.ipv6Pane.setText(this.myObj.getIP());
                        this.typeCmbBox.setSelectedIndex(0);
                        this.ipVerComboModel.setSelectedType(IPTypeComboBoxModel.IPTypeEnum.V6);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break;
                }
                case 1: {
                    String fromIP = this.myObj.getStartIP();
                    String toIP = this.myObj.getEndIP();
                    this.ipRange.setFromIP(fromIP);
                    this.ipRange.setToIP(toIP);
                    this.typeCmbBox.setSelectedIndex(1);
                    this.ipVerComboModel.setSelectedType(IPTypeComboBoxModel.IPTypeEnum.V4);
                    break;
                }
                case 8: {
                    String ipv6FromIP = this.myObj.getStartIP();
                    String ipv6ToIP = this.myObj.getEndIP();
                    this.ipv6Range.setFromIP(ipv6FromIP);
                    this.ipv6Range.setToIP(ipv6ToIP);
                    this.typeCmbBox.setSelectedIndex(1);
                    this.ipVerComboModel.setSelectedType(IPTypeComboBoxModel.IPTypeEnum.V6);
                    break;
                }
                case 2: {
                    String ip = this.myObj.getNetAddr();
                    String mask = this.myObj.getNetMask();
                    this.subnet.setIPAddress(ip);
                    this.subnet.setMaskAddress(mask);
                    this.typeCmbBox.setSelectedIndex(2);
                    this.ipVerComboModel.setSelectedType(IPTypeComboBoxModel.IPTypeEnum.V4);
                    break;
                }
                case 9: {
                    this.ipv6Subnet.setText(this.myObj.getNetAddr());
                    this.typeCmbBox.setSelectedIndex(2);
                    this.ipVerComboModel.setSelectedType(IPTypeComboBoxModel.IPTypeEnum.V6);
                    break;
                }
                case 3: {
                    this.macField.setText(this.myObj.getMACAddress());
                    this.typeCmbBox.setSelectedIndex(4);
                    this.ipVerCombo.setVisible(false);
                    break;
                }
                case 5: {
                    this.hostGroupLink.setValue(this.myObj.getHostGroup());
                    this.typeCmbBox.setSelectedIndex(3);
                    this.ipVerCombo.setVisible(false);
                    break;
                }
                case 6: {
                    this.hostNamePane.setText(this.myObj.getICMPHostName());
                    this.typeCmbBox.setSelectedIndex(1);
                    this.ipVerCombo.setVisible(false);
                    break;
                }
            }
        } else {
            this.typeCmbBox.setSelectedIndex(0);
        }
    }

    public void setTypeModel(int type) {
        this.modeltype = type;
        if (type == 0) {
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(addressTypes_4);
            this.typeCmbBox.setModel(model);
        } else if (type == 3) {
            this.typeCmbBox.setModel(new AddressTypeICMPPingComboBoxModel());
        } else {
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(addressTypes_3);
            this.typeCmbBox.setModel(model);
        }
    }

    public void setObject(AddressObject newObj) {
        this.myObj = newObj;
        this.updatePanel();
    }
}

