/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class AdditionalTextDialog
extends DialogBase {
    private static final long serialVersionUID = -2846565543669889647L;
    private JTextArea jTAText = new JTextArea(15, 60);
    private int MAX_WORDWRAP_LENGTH = 80;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String DIALOG = "com.sygate.scm.console.ui.policy.dialog.policydialog";

    public AdditionalTextDialog(String title, String value) {
        this(title, value, 128);
    }

    public AdditionalTextDialog(String title, String value, int length) {
        this(title, value, new RestrictedPlainDocument(length));
    }

    public AdditionalTextDialog(String title, String value, RestrictedPlainDocument document) {
        super(Manager.getFrame(), title, true);
        this.initialize(value, document);
        if (this.isReadOnly()) {
            this.jTAText.setEditable(false);
            this.resetOKButton(false);
        }
        this.setDefaultCloseOperation(2);
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public String getAdditionalText() {
        return this.jTAText.getText().trim();
    }

    @Override
    protected boolean isHelpButtonShown() {
        return false;
    }

    @Override
    protected boolean isValidate() {
        boolean isValid = true;
        String aText = this.getAdditionalText();
        try {
            boolean isOverSize = false;
            String[] piece = aText.split("\\s");
            for (int i = 0; i < piece.length && !(isOverSize = this.checkCSBytesLength(piece[i])); ++i) {
            }
            if (isOverSize) {
                throw new GUICheckException(MSGRES.getString(DIALOG, "AdditionalTextDialog.error.OverMaxWordWrapLength"));
            }
        }
        catch (GUICheckException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString(DIALOG, "AdditionalTextDialog.title.error"), 0);
            isValid = false;
        }
        return isValid;
    }

    private void initialize(String value, RestrictedPlainDocument document) {
        this.getContentPane().add((Component)this.getTextPane(value, document), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    private JScrollPane getTextPane(String value, RestrictedPlainDocument document) {
        this.jTAText.setLineWrap(true);
        this.jTAText.setWrapStyleWord(true);
        this.jTAText.setDocument(document);
        this.jTAText.setText(value);
        JScrollPane pane = new JScrollPane(this.jTAText);
        pane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createEtchedBorder()));
        return pane;
    }

    private boolean checkCSBytesLength(String word) {
        boolean isOverSize = false;
        int count = 0;
        for (int i = 0; i < word.length(); ++i) {
            if (!this.isDoubleByte(word.charAt(i))) {
                if (++count <= this.MAX_WORDWRAP_LENGTH) continue;
                isOverSize = true;
                break;
            }
            count = 0;
        }
        return isOverSize;
    }

    private boolean isDoubleByte(char c) {
        return c >= '\u0100' && c <= '\uffff';
    }
}

