/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.AppliedPolicyObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.dialog.PolicyType;
import com.sygate.scm.console.ui.policy.dialog.WizardListener;
import com.sygate.scm.console.ui.policy.dialog.WizardPanel;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class AddMorePolicy_LocationPanel
extends JPanel
implements WizardPanel {
    private static final long serialVersionUID = 4098733945318977357L;
    public static final int FROM_LOCAL = 1;
    public static final int FROM_POOL = 2;
    public static final int FROM_FILE = 3;
    private PolicyType type;
    private AppliedPolicyObject apObj;
    private GroupPolicyObject gpObj;
    private WizardPanel previousPanel = null;
    private JTextArea titleArea = null;
    private JTextArea jTextArea2 = null;
    private JRadioButton useExistinglRdBtn = null;
    private JRadioButton addNewRdBtn = null;
    private JRadioButton importRdBtn = null;
    private JTextArea jTextArea = null;
    private JTextArea jTextArea1 = null;
    private JTextArea importTxtArea = null;

    public AddMorePolicy_LocationPanel() {
        this.initialize();
    }

    public int getSourceType() {
        if (this.addNewRdBtn.isSelected()) {
            return 1;
        }
        if (this.useExistinglRdBtn.isSelected()) {
            return 2;
        }
        return 3;
    }

    public PolicyType getPolicyType() {
        return this.type;
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.gettitleArea(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 20, 5, 5), 0, 0));
        this.add((Component)this.getJTextArea2(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 20, 5, 5), 0, 0));
        this.add((Component)this.getAddExistingRdBtn(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 25, 0, 5), 0, 0));
        this.add((Component)this.getJTextArea1(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 47, 5, 5), 0, 0));
        this.add((Component)this.getAddNewRdBtn(), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 25, 0, 5), 0, 0));
        this.add((Component)this.getJTextArea(), new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 47, 5, 5), 0, 0));
        this.add((Component)this.getImportRdBtn(), new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 25, 0, 5), 0, 0));
        this.add((Component)this.getImportTxtArea(), new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 47, 5, 5), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 8, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.finalInit();
    }

    private void finalInit() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.useExistinglRdBtn);
        group.add(this.addNewRdBtn);
        group.add(this.importRdBtn);
    }

    private JTextArea gettitleArea() {
        if (this.titleArea == null) {
            this.titleArea = new DescriptionTextArea();
            this.titleArea.setText("");
        }
        return this.titleArea;
    }

    private JTextArea getJTextArea2() {
        if (this.jTextArea2 == null) {
            this.jTextArea2 = new DescriptionTextArea();
            this.jTextArea2.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddMorePolicy_LocationPanel.getPolicy"));
        }
        return this.jTextArea2;
    }

    private JRadioButton getAddNewRdBtn() {
        if (this.addNewRdBtn == null) {
            this.addNewRdBtn = new JRadioButton();
            this.addNewRdBtn.setBounds(46, 91, 237, 22);
            this.addNewRdBtn.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddMorePolicy_LocationPanel.createNewPolicy"));
        }
        return this.addNewRdBtn;
    }

    private JRadioButton getAddExistingRdBtn() {
        if (this.useExistinglRdBtn == null) {
            this.useExistinglRdBtn = new JRadioButton();
            this.useExistinglRdBtn.setBounds(45, 150, 243, 22);
            this.useExistinglRdBtn.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddMorePolicy_LocationPanel.fromPolicyLibrary"));
        }
        return this.useExistinglRdBtn;
    }

    private JRadioButton getImportRdBtn() {
        if (this.importRdBtn == null) {
            this.importRdBtn = new JRadioButton();
            this.importRdBtn.setBounds(45, 225, 243, 22);
            this.importRdBtn.setText("<html>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddMorePolicy_LocationPanel.fromPreviouslyExportedPolicyFile") + "</html>");
        }
        return this.importRdBtn;
    }

    private JTextArea getImportTxtArea() {
        if (this.importTxtArea == null) {
            this.importTxtArea = new DescriptionTextArea();
            this.importTxtArea.setBounds(66, 252, 302, 50);
            this.importTxtArea.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddMorePolicy_LocationPanel.importAPolicyThatWasExported"));
        }
        return this.importTxtArea;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new DescriptionTextArea();
            this.jTextArea.setBounds(66, 117, 302, 22);
            this.jTextArea.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddMorePolicy_LocationPanel.createANewPoicy"));
        }
        return this.jTextArea;
    }

    private JTextArea getJTextArea1() {
        if (this.jTextArea1 == null) {
            this.jTextArea1 = new DescriptionTextArea();
            this.jTextArea1.setBounds(66, 177, 302, 50);
            this.jTextArea1.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddMorePolicy_LocationPanel.usesAnExistingPolicyInPolicyLibrary"));
        }
        return this.jTextArea1;
    }

    public void setObject(PolicyType type, AppliedPolicyObject apObj, GroupPolicyObject gpObj) {
        this.type = type;
        this.apObj = apObj;
        this.gpObj = gpObj;
        Object[] obj = new Object[]{type.getName()};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddMorePolicy_LocationPanel.youAreAboutToCreate");
        String desc = MessageFormat.format(str, obj);
        this.titleArea.setText(desc);
        this.useExistinglRdBtn.setSelected(true);
        if (this.libraryIsEmpty()) {
            this.useExistinglRdBtn.setEnabled(false);
            this.useExistinglRdBtn.setSelected(false);
            this.addNewRdBtn.setSelected(true);
            this.jTextArea1.setEnabled(false);
        } else {
            this.useExistinglRdBtn.setEnabled(true);
            this.useExistinglRdBtn.setSelected(true);
            this.jTextArea1.setEnabled(true);
        }
    }

    private boolean libraryIsEmpty() {
        int policyType = this.type.getPolicyTreeItem();
        try {
            int count = AppliablePolicyPool.getObjInfoHashMap(policyType).size();
            return count == 0;
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return true;
        }
    }

    @Override
    public WizardPanel getNextPanel() {
        boolean isLocal = true;
        if (this.useExistinglRdBtn.isSelected()) {
            isLocal = false;
        }
        return this.type.getEditor(isLocal, this.apObj.getLocName(), this.gpObj);
    }

    @Override
    public WizardPanel getPreviousPanel() {
        return this.previousPanel;
    }

    @Override
    public void setPreviousPanel(WizardPanel panel) {
        this.previousPanel = panel;
    }

    @Override
    public void addListener(WizardListener listener) {
    }

    @Override
    public void removeListener(WizardListener listener) {
    }

    @Override
    public Dimension getWizardPreferredSize() {
        return this.getPreferredSize();
    }

    public PolicyInt getImportedObject() throws ConsoleException {
        return this.type.getImportedObject();
    }
}

