/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.HTMLTemp.PolicyTemp;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AppliedPolicyObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.ui.policy.dialog.AddMorePolicy_LocationPanel;
import com.sygate.scm.console.ui.policy.dialog.PolicyType;
import com.sygate.scm.console.ui.policy.dialog.WizardListener;
import com.sygate.scm.console.ui.policy.dialog.WizardPanel;
import com.sygate.scm.console.ui.policy.lu.LuUtility;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.MultiLineMsgBox;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AddMorePolicyFirstPanel
extends JPanel
implements WizardPanel {
    private static final long serialVersionUID = 1L;
    private static final MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.ui.policy.dialog.policydialog");
    private List<PolicyType> policyTypeList = new ArrayList<PolicyType>();
    private List<PolicyType> quarantinePolicyList = new ArrayList<PolicyType>();
    private boolean isCloudEnrolled = CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId());
    private AppliedPolicyObject apObj;
    private GroupPolicyObject gpObj;
    private WizardPanel nextStepPanel = null;
    private JTextArea jLabel = null;
    private JPanel jPanel = null;
    private JScrollPane jScrollPane = null;
    private JList<PolicyType> policyList = null;
    private JTextArea descArea = null;
    public boolean isLicensed = true;
    public WizardListener listener = null;
    private int locControlMode;
    private DescriptionTextArea jTextArea = null;

    private void createPolicyList() {
        this.policyTypeList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.adaptivePolicy"), MSGRES.getString("AddMorePolicyFirstPanel.adaptivePolicyDesc"), 19));
        this.policyTypeList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.avPolicy"), MSGRES.getString("AddMorePolicyFirstPanel.avPolicyDesc"), 0));
        this.policyTypeList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.firewallPolicy"), MSGRES.getString("AddMorePolicyFirstPanel.firewallPoliciesProvideRules"), 1));
        this.policyTypeList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.ipsPolicy"), MSGRES.getString("AddMorePolicyFirstPanel.ipsPolicyDesc"), 6));
        this.policyTypeList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.OSProtectionPolicy"), MSGRES.getString("AddMorePolicyFirstPanel.OSProtectionPoliciesMonitorThe"), 3));
        this.policyTypeList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.hostIntegrityPolicy"), MSGRES.getString("AddMorePolicyFirstPanel.hostIntegrityPoliciesSpecify"), 2));
        this.policyTypeList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.liveUpdatePolicy"), MSGRES.getString("AddMorePolicyFirstPanel.liveUpdatePoliciesSpecify"), 5));
        this.policyTypeList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.memPolicy"), MSGRES.getString("AddMorePolicyFirstPanel.memPolicyDesc"), 14));
        this.policyTypeList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.ntrPolicy"), MSGRES.getString("AddMorePolicyFirstPanel.ntrPolicyDesc"), 15));
        this.policyTypeList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.overridePolicy"), MSGRES.getString("AddMorePolicyFirstPanel.overridePolicyDesc"), 4));
        this.policyTypeList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.upgradePolicy"), MSGRES.getString("AddMorePolicyFirstPanel.upgradePolicyDesc"), 17));
        this.quarantinePolicyList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.quarantineAdaptivePolicy"), MSGRES.getString("AddMorePolicyFirstPanel.quarantineAdaptivePolicyDesc"), 20));
        this.quarantinePolicyList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.quarantineAvPolilcy"), MSGRES.getString("AddMorePolicyFirstPanel.quarantineAvPolicyDesc"), 7));
        this.quarantinePolicyList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.quarantineFwPolilcy"), MSGRES.getString("AddMorePolicyFirstPanel.quarantineFwPolicyDesc"), 8));
        this.quarantinePolicyList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.quarantineIpsPolicy"), MSGRES.getString("AddMorePolicyFirstPanel.quarantineIpsPolicyDesc"), 12));
        this.quarantinePolicyList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.quarantineHdPolicy"), MSGRES.getString("AddMorePolicyFirstPanel.quarantineHdPolicyDesc"), 9));
        this.quarantinePolicyList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.quarantineLuPolicy"), MSGRES.getString("AddMorePolicyFirstPanel.quarantineLuPolicyDesc"), 11));
        if (!this.isCloudEnrolled) {
            this.quarantinePolicyList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.quarantineMemPolicy"), MSGRES.getString("AddMorePolicyFirstPanel.quarantineMemPolicyDesc"), 13));
        }
        this.quarantinePolicyList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.quarantineNtrPolicy"), MSGRES.getString("AddMorePolicyFirstPanel.quarantineNtrPolicyDesc"), 16));
        this.quarantinePolicyList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.quarantineCePolicy"), MSGRES.getString("AddMorePolicyFirstPanel.quarantineCePolicyDesc"), 10));
        this.quarantinePolicyList.add(new PolicyType(MSGRES.getString("AddMorePolicyFirstPanel.quarantineUpgradePolicy"), MSGRES.getString("AddMorePolicyFirstPanel.quarantineUpgradePolicyDesc"), 18));
    }

    public AddMorePolicyFirstPanel() {
        this.createPolicyList();
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJTextArea(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 5, 10), 0, 0));
        this.add((Component)this.getJLabel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.add((Component)this.getJPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 17, 1, new Insets(5, 10, 5, 10), 0, 0));
        this.add((Component)this.getDescArea(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.setSize(416, 393);
    }

    private DescriptionTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new DescriptionTextArea();
            this.jTextArea.setText(MSGRES.getString("AddMorePolicyFirstPanel.theLocationIsUnderClientControlMode"));
            this.jTextArea.setVisible(false);
        }
        return this.jTextArea;
    }

    private JTextArea getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JTextArea();
            this.jLabel.setLineWrap(true);
            this.jLabel.setEditable(false);
            this.jLabel.setOpaque(false);
            this.jLabel.setWrapStyleWord(true);
            this.jLabel.setText(MSGRES.getString("AddMorePolicyFirstPanel.toAddANewPolicySelect"));
        }
        return this.jLabel;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getJScrollPane(), "Center");
            this.jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), MSGRES.getString("AddMorePolicyFirstPanel.policies"), 0, 0, null, null));
        }
        return this.jPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getPolicyList());
        }
        return this.jScrollPane;
    }

    private JList<PolicyType> getPolicyList() {
        if (this.policyList == null) {
            this.policyList = new JList();
            this.policyList.getSelectionModel().setSelectionMode(0);
            this.policyList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent ev) {
                    AddMorePolicyFirstPanel.this.policySelectChanged();
                }
            });
        }
        return this.policyList;
    }

    private void policySelectChanged() {
        PolicyType type = this.policyList.getSelectedValue();
        if (this.listener != null) {
            this.listener.enableNextBtn(this.isLicensed(type));
        }
        String str = MSGRES.getString("AddMorePolicyFirstPanel.youHaveNoPoliciesYet");
        this.jLabel.setText(str + MSGRES.getString("AddMorePolicyFirstPanel.toAddANewPolicySelect"));
        this.descArea.setText(type.getDesc());
    }

    private JTextArea getDescArea() {
        if (this.descArea == null) {
            this.descArea = new DescriptionTextArea();
        }
        return this.descArea;
    }

    public void setObject(AppliedPolicyObject obj, GroupPolicyObject gpObj, int locControlMode, boolean isQuarantine) {
        this.apObj = obj;
        this.gpObj = gpObj;
        this.locControlMode = locControlMode;
        DefaultListModel<PolicyType> model = new DefaultListModel<PolicyType>();
        List<PolicyType> policyList = isQuarantine ? this.quarantinePolicyList : this.policyTypeList;
        for (int i = 0; i < policyList.size(); ++i) {
            PolicyType policyType = policyList.get(i);
            if (!PolicyType.isQualifiedPolicyType(policyType.getType()) || this.policyExists(this.apObj, policyType) || PolicyTemp.isCurrentAdminDisallowedPrivilege(policyType.getPolicyTargetName())) continue;
            model.addElement(policyType);
        }
        this.getPolicyList().setModel(model);
        this.updatePanel();
    }

    private boolean policyExists(AppliedPolicyObject apObj, PolicyType policyType) {
        if (apObj == null) {
            return false;
        }
        return apObj.existType(policyType.getPolicyTargetName());
    }

    private void updatePanel() {
        JList<PolicyType> policyList = this.getPolicyList();
        DefaultListModel model = (DefaultListModel)policyList.getModel();
        if (model.size() > 0) {
            policyList.setSelectedIndex(0);
        }
    }

    public boolean isLicensed(PolicyType type) {
        this.isLicensed = type.getName().indexOf(MSGRES.getString("AddMorePolicyFirstPanel.notLicensed")) == -1;
        if (type.getType() == 1 && this.locControlMode == 0) {
            this.jTextArea.setVisible(true);
            this.isLicensed = false;
        }
        return this.isLicensed;
    }

    @Override
    public WizardPanel getNextPanel() {
        try {
            PolicyType type = this.policyList.getSelectedValue();
            if (2 == type.getType() && !LuUtility.canApplyHIPolicy()) {
                String msg = MSGRES.getString("AddMorePolicyFirstPanel.addMorePoliciesTitle");
                Object[] obj = new Object[]{this.apObj.getLocName()};
                String fm = MessageFormat.format(msg, obj);
                MultiLineMsgBox optionPane = new MultiLineMsgBox(Manager.getFrame(), fm);
                optionPane.init(MessageFormat.format(MSGRES.getString("AddMorePolicyFirstPanel.cannotApplyHIPolicy"), this.apObj.getLocName()), 60, 0, -1);
                optionPane.show();
                return null;
            }
            if (this.apObj.existType(type.getPolicyTargetName())) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString("AddMorePolicyFirstPanel.theTypeOfPolicyYouChoseAlreadyExists"), MSGRES.getString("AddMorePolicyFirstPanel.error"), 0);
                return null;
            }
            switch (type.getType()) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 18: 
                case 20: {
                    if (this.apObj.hasHostIntegrityPolicy()) break;
                    JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString("AddMorePolicyFirstPanel.youMustApplyAHostIntegrityPolicyTo"), MSGRES.getString("AddMorePolicyFirstPanel.error"), 0);
                    return null;
                }
            }
            AddMorePolicy_LocationPanel nextPanel = (AddMorePolicy_LocationPanel)this.getNextStepPanel();
            nextPanel.setObject(type, this.apObj, this.gpObj);
            nextPanel.setPreviousPanel(this);
            return nextPanel;
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString("AddMorePolicyFirstPanel.consoleError"), 0);
            if (ex.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
            return null;
        }
    }

    private WizardPanel getNextStepPanel() {
        if (this.nextStepPanel == null) {
            this.nextStepPanel = new AddMorePolicy_LocationPanel();
        }
        return this.nextStepPanel;
    }

    @Override
    public WizardPanel getPreviousPanel() {
        return null;
    }

    @Override
    public void setPreviousPanel(WizardPanel panel) {
    }

    @Override
    public void addListener(WizardListener listener) {
        this.listener = listener;
    }

    @Override
    public void removeListener(WizardListener listener) {
    }

    @Override
    public Dimension getWizardPreferredSize() {
        return this.getPreferredSize();
    }

    public boolean hasMorePolicyType() {
        JList<PolicyType> policyList = this.getPolicyList();
        return policyList.getModel().getSize() > 0;
    }

    protected void setSelected(int index) {
        this.policyList.setSelectedIndex(index);
    }

    protected PolicyType getSelected() {
        return this.policyList.getSelectedValue();
    }
}

