/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.dialog;

import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.AppliedPolicyObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.ui.policy.common.ButtonPane;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.dialog.AbsPolicyEditorDlg;
import com.sygate.scm.console.ui.policy.dialog.AddMorePolicyFirstPanel;
import com.sygate.scm.console.ui.policy.dialog.AddMorePolicy_LocationPanel;
import com.sygate.scm.console.ui.policy.dialog.SelectDlg;
import com.sygate.scm.console.ui.policy.dialog.WizardListener;
import com.sygate.scm.console.ui.policy.dialog.WizardPanel;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;

public class AddMorePolicyDlg
extends JDialog {
    private static final long serialVersionUID = 1L;
    private AppliedPolicyObject apObj;
    private boolean isCancel = true;
    private WizardPanel currentOne;
    private JPanel jContentPane = null;
    private JPanel mainPane = null;
    private JButton okBtn;
    private JButton backBtn;
    private boolean hasMorePolicyType = true;

    public AddMorePolicyDlg(JFrame frame, String string, boolean b) {
        super(frame, string, b);
        this.initialize();
    }

    public AddMorePolicyDlg() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(444, 418);
        this.setContentPane(this.getJContentPane());
        UiUtilities.centerComponent((Component)this);
        this.setDefaultCloseOperation(2);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getMainPane(), "Center");
            this.jContentPane.add((Component)this.getBottomPane(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getMainPane() {
        if (this.mainPane == null) {
            this.mainPane = new JPanel();
            this.mainPane.setLayout(new BorderLayout());
        }
        return this.mainPane;
    }

    private JComponent getBottomPane() {
        JButton okButton = new JButton(UIText.get(3328));
        okButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AddMorePolicyDlg.this.nextAction();
            }
        });
        AbstractAction cancel = new AbstractAction(UIText.get(512)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AddMorePolicyDlg.this.this_cancelAction();
            }
        };
        AbstractAction back = new AbstractAction(UIText.get(256)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AddMorePolicyDlg.this.backAction();
            }
        };
        JButton[] buttons = new JButton[]{new JButton(back), okButton, new JButton(cancel)};
        ButtonPane panel = new ButtonPane(buttons, 4);
        this.backBtn = buttons[0];
        this.okBtn = buttons[1];
        UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)buttons[1]);
        return panel;
    }

    protected void backAction() {
        WizardPanel prePane = this.currentOne.getPreviousPanel();
        if (prePane != null) {
            if (prePane instanceof JPanel) {
                JPanel panel = (JPanel)((Object)prePane);
                this.mainPane.removeAll();
                this.mainPane.add(panel);
                boolean backEnable = prePane.getPreviousPanel() != null;
                this.backBtn.setEnabled(backEnable);
                this.currentOne = prePane;
                this.mainPane.updateUI();
            } else if (prePane instanceof JDialog) {
                this.dispose();
                JDialog dlg = (JDialog)((Object)prePane);
                dlg.setVisible(true);
            }
        }
    }

    void nextAction() {
        WizardPanel nextPane = this.currentOne.getNextPanel();
        if (nextPane != null) {
            if (nextPane instanceof JPanel) {
                JPanel panel = (JPanel)((Object)nextPane);
                this.mainPane.removeAll();
                this.mainPane.add(panel);
                boolean backEnable = nextPane.getPreviousPanel() != null;
                this.backBtn.setEnabled(backEnable);
                this.currentOne = nextPane;
                this.mainPane.updateUI();
            } else if (nextPane instanceof AbsPolicyEditorDlg) {
                this.dispose();
                AbsPolicyEditorDlg dlg = (AbsPolicyEditorDlg)nextPane;
                PolicyInt newPolicy = null;
                if (((AddMorePolicy_LocationPanel)this.currentOne).getSourceType() != 3) {
                    int policyType = ((AddMorePolicy_LocationPanel)this.currentOne).getPolicyType().getPolicyTreeItem();
                    try {
                        AppliablePolicyPool pool = AppliablePolicyPool.getPolicyPoolObject(policyType);
                        newPolicy = dlg.createNewPolicy(pool);
                        dlg.setVisible(true);
                        if (dlg.isOk()) {
                            this.apObj.addDefaultQuarantinePolicies(newPolicy);
                            this.apObj.addNewLocalPolicy(newPolicy);
                            this.apObj.setPhysicalFileObject(newPolicy.getPhysicalFileObject());
                            this.isCancel = false;
                        }
                    }
                    catch (ConsoleException ex) {
                        LoggerUtilities.logException((Throwable)ex);
                    }
                } else {
                    try {
                        newPolicy = ((AddMorePolicy_LocationPanel)this.currentOne).getImportedObject();
                        if (newPolicy != null && newPolicy.getSchemaObj() != null) {
                            this.apObj.addDefaultQuarantinePolicies(newPolicy);
                            this.apObj.addNewLocalPolicy(newPolicy);
                            this.apObj.setPhysicalFileObject(newPolicy.getPhysicalFileObject());
                            this.isCancel = false;
                        }
                    }
                    catch (ConsoleException e1) {
                        LoggerUtilities.logException((Throwable)e1);
                    }
                }
            } else if (nextPane instanceof SelectDlg) {
                this.dispose();
                SelectDlg dlg = (SelectDlg)((Object)nextPane);
                dlg.setVisible(true);
                if (dlg.isOk()) {
                    PolicyInt newPolicy = (PolicyInt)((Object)dlg.getSelectedObject());
                    this.apObj.addDefaultQuarantinePolicies(newPolicy);
                    this.apObj.addNewSharedPolicy(newPolicy);
                    this.isCancel = false;
                }
            }
        }
    }

    void this_cancelAction() {
        this.isCancel = true;
        this.dispose();
    }

    public void setObject(AppliedPolicyObject apObj, GroupPolicyObject gpObj, int locControlMode, boolean isQuaratine) {
        this.apObj = apObj;
        AddMorePolicyFirstPanel firstPanel = new AddMorePolicyFirstPanel();
        WizardListener listener = new WizardListener(){

            @Override
            public void enableNextBtn(boolean shouldEnable) {
                AddMorePolicyDlg.this.okBtn.setEnabled(shouldEnable);
            }

            @Override
            public void enablePreviousBtn(boolean shouldEnable) {
            }

            @Override
            public void enableCancelBtn(boolean shouldEnable) {
            }
        };
        firstPanel.addListener(listener);
        firstPanel.setObject(apObj, gpObj, locControlMode, isQuaratine);
        this.hasMorePolicyType = firstPanel.hasMorePolicyType();
        this.mainPane.add(firstPanel);
        this.currentOne = firstPanel;
        if (firstPanel.getPreviousPanel() == null) {
            this.backBtn.setEnabled(false);
        }
    }

    public boolean hasMorePolicyType() {
        return this.hasMorePolicyType;
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

