/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.common;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.util.SwingWorkerExecutor;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.renderer.CustomTreeCellRenderer;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.CancellationException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.RootPaneContainer;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class SelectGroupLocationDlg
extends JDialog {
    private static final long serialVersionUID = 1L;
    private BorderLayout borderLayout1 = new BorderLayout();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JPanel upPanel = new JPanel();
    private JPanel downPanel = new JPanel();
    private JTree tree = new JTree();
    private JButton okBtn = new JButton(UIText.get(3584));
    private JButton cancelBtn = new JButton(UIText.get(512));
    private boolean isCancelled = true;
    private JScrollPane resultsScrollPane = new JScrollPane();
    DefaultMutableTreeNode node = null;
    TreeModel treeModel = null;

    public SelectGroupLocationDlg(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.getGroupsAndLocations();
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private void getGroupsAndLocations() throws Exception {
        String text = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicyPanel.loadingMsg");
        this.treeModel = new DefaultTreeModel(new DefaultMutableTreeNode(text));
        SwingWorker<TreeModel, Void> swingWorkerGroups = new SwingWorker<TreeModel, Void>(){

            @Override
            protected TreeModel doInBackground() throws Exception {
                DefaultMutableTreeNode rootNode = PolicyHandler.getGroupLocationTree();
                DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
                return treeModel;
            }

            @Override
            protected void done() {
                try {
                    SelectGroupLocationDlg.this.treeModel = (TreeModel)this.get();
                    SelectGroupLocationDlg.this.tree.setModel(SelectGroupLocationDlg.this.treeModel);
                    SelectGroupLocationDlg.this.tree.setCellRenderer(new CustomTreeCellRenderer());
                }
                catch (InterruptedException ie) {
                    return;
                }
                catch (CancellationException ce) {
                    return;
                }
                catch (Exception e) {
                    LoggerUtilities.logException((Throwable)e);
                    String errorText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "HistoryPane.policyHistoryErrorMsg");
                    JOptionPane.showMessageDialog(Manager.getFrame(), errorText, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicyPanel.errorMsg"), 0);
                    return;
                }
                finally {
                    AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true, (int)0);
                }
            }
        };
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> ClientAgent.getCurrentInstance().setUpdateBrowserInterval(2));
        SwingWorkerExecutor.getInstance().execute(swingWorkerGroups);
    }

    private void jbInit() throws Exception {
        this.downPanel.setLayout(this.gridBagLayout1);
        this.tree.setModel(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.putClientProperty("enableTreePagination", "true");
        this.resultsScrollPane.getViewport().add(this.tree);
        this.resultsScrollPane.setPreferredSize(new Dimension(300, 352));
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectGroupLocationDlg.this.okBtnActionPerformed(e);
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectGroupLocationDlg.this.cancelBtnActionPerformed(e);
            }
        });
        this.upPanel.add(this.resultsScrollPane);
        this.downPanel.add((Component)this.okBtn, new GridBagConstraints(0, 0, 1, 0, 1.0, 0.0, 13, 0, new Insets(10, 10, 10, 5), 0, 0));
        this.downPanel.add((Component)this.cancelBtn, new GridBagConstraints(1, 0, 1, 0, 0.0, 0.0, 13, 0, new Insets(10, 5, 10, 10), 0, 0));
        this.getContentPane().setLayout(this.borderLayout1);
        this.getContentPane().add((Component)this.upPanel, "Center");
        this.getContentPane().add((Component)this.downPanel, "South");
        this.setSize(new Dimension(362, 440));
        this.setResizable(true);
        UIUtilities.fitJComponent(new JButton[]{this.okBtn, this.cancelBtn});
        UiUtilities.centerComponent((Component)this);
        UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)this.okBtn);
    }

    public DefaultMutableTreeNode getNode() {
        return this.node;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    private void okBtnActionPerformed(ActionEvent e) {
        this.node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (this.node == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.common.common", "SelectGroupLocationDlg.pleaseCheckOnTheNodeMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.common.common", "SelectGroupLocationDlg.informationMsg"), 1);
            return;
        }
        this.isCancelled = false;
        this.dispose();
    }

    private void cancelBtnActionPerformed(ActionEvent e) {
        this.dispose();
    }
}

